/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.subscribers;

import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.internal.util.BlockingHelper;
import io.confluent.shaded.io.reactivex.internal.util.ExceptionHelper;
import io.confluent.shaded.org.reactivestreams.Subscription;
import java.util.concurrent.CountDownLatch;

public abstract class BlockingBaseSubscriber<T>
extends CountDownLatch
implements FlowableSubscriber<T> {
    T value;
    Throwable error;
    Subscription upstream;
    volatile boolean cancelled;

    public BlockingBaseSubscriber() {
        super(1);
    }

    @Override
    public final void onSubscribe(Subscription s2) {
        if (SubscriptionHelper.validate(this.upstream, s2)) {
            this.upstream = s2;
            if (!this.cancelled) {
                s2.request(Long.MAX_VALUE);
                if (this.cancelled) {
                    this.upstream = SubscriptionHelper.CANCELLED;
                    s2.cancel();
                }
            }
        }
    }

    @Override
    public final void onComplete() {
        this.countDown();
    }

    public final T blockingGet() {
        Throwable e;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex) {
                Subscription s2 = this.upstream;
                this.upstream = SubscriptionHelper.CANCELLED;
                if (s2 != null) {
                    s2.cancel();
                }
                throw ExceptionHelper.wrapOrThrow(ex);
            }
        }
        if ((e = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(e);
        }
        return this.value;
    }
}

