/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.util;

import io.confluent.shaded.io.reactivex.internal.util.Pow2;

public final class OpenHashSet<T> {
    private static final int INT_PHI = -1640531527;
    final float loadFactor;
    int mask;
    int size;
    int maxSize;
    T[] keys;

    public OpenHashSet() {
        this(16, 0.75f);
    }

    public OpenHashSet(int capacity) {
        this(capacity, 0.75f);
    }

    public OpenHashSet(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        int c = Pow2.roundToPowerOfTwo(capacity);
        this.mask = c - 1;
        this.maxSize = (int)(loadFactor * (float)c);
        this.keys = new Object[c];
    }

    public boolean add(T value) {
        T[] a = this.keys;
        int m4 = this.mask;
        int pos = OpenHashSet.mix(value.hashCode()) & m4;
        T curr = a[pos];
        if (curr != null) {
            if (curr.equals(value)) {
                return false;
            }
            while ((curr = a[pos = pos + 1 & m4]) != null) {
                if (!curr.equals(value)) continue;
                return false;
            }
        }
        a[pos] = value;
        if (++this.size >= this.maxSize) {
            this.rehash();
        }
        return true;
    }

    public boolean remove(T value) {
        T[] a = this.keys;
        int m4 = this.mask;
        int pos = OpenHashSet.mix(value.hashCode()) & m4;
        T curr = a[pos];
        if (curr == null) {
            return false;
        }
        if (curr.equals(value)) {
            return this.removeEntry(pos, a, m4);
        }
        do {
            if ((curr = a[pos = pos + 1 & m4]) != null) continue;
            return false;
        } while (!curr.equals(value));
        return this.removeEntry(pos, a, m4);
    }

    boolean removeEntry(int pos, T[] a, int m4) {
        --this.size;
        while (true) {
            T curr;
            int last = pos;
            pos = pos + 1 & m4;
            while (true) {
                if ((curr = a[pos]) == null) {
                    a[last] = null;
                    return true;
                }
                int slot = OpenHashSet.mix(curr.hashCode()) & m4;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & m4;
            }
            a[last] = curr;
        }
    }

    void rehash() {
        T[] a = this.keys;
        int i = a.length;
        int newCap = i << 1;
        int m4 = newCap - 1;
        Object[] b = new Object[newCap];
        int j = this.size;
        while (j-- != 0) {
            while (a[--i] == null) {
            }
            int pos = OpenHashSet.mix(a[i].hashCode()) & m4;
            if (b[pos] != null) {
                while (b[pos = pos + 1 & m4] != null) {
                }
            }
            b[pos] = a[i];
        }
        this.mask = m4;
        this.maxSize = (int)((float)newCap * this.loadFactor);
        this.keys = b;
    }

    static int mix(int x) {
        int h2 = x * -1640531527;
        return h2 ^ h2 >>> 16;
    }

    public Object[] keys() {
        return this.keys;
    }

    public int size() {
        return this.size;
    }
}

