/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.observers;

import io.confluent.shaded.io.reactivex.CompletableObserver;
import io.confluent.shaded.io.reactivex.MaybeObserver;
import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.SingleObserver;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.functions.Consumer;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.fuseable.QueueDisposable;
import io.confluent.shaded.io.reactivex.internal.util.ExceptionHelper;
import io.confluent.shaded.io.reactivex.observers.BaseTestConsumer;
import java.util.concurrent.atomic.AtomicReference;

public class TestObserver<T>
extends BaseTestConsumer<T, TestObserver<T>>
implements Observer<T>,
Disposable,
MaybeObserver<T>,
SingleObserver<T>,
CompletableObserver {
    private final Observer<? super T> downstream;
    private final AtomicReference<Disposable> upstream = new AtomicReference();
    private QueueDisposable<T> qd;

    public static <T> TestObserver<T> create() {
        return new TestObserver<T>();
    }

    public static <T> TestObserver<T> create(Observer<? super T> delegate) {
        return new TestObserver<T>(delegate);
    }

    public TestObserver() {
        this(EmptyObserver.INSTANCE);
    }

    public TestObserver(Observer<? super T> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(Disposable d) {
        this.lastThread = Thread.currentThread();
        if (d == null) {
            this.errors.add(new NullPointerException("onSubscribe received a null Subscription"));
            return;
        }
        if (!this.upstream.compareAndSet(null, d)) {
            d.dispose();
            if (this.upstream.get() != DisposableHelper.DISPOSED) {
                this.errors.add(new IllegalStateException("onSubscribe received multiple subscriptions: " + d));
            }
            return;
        }
        if (this.initialFusionMode != 0 && d instanceof QueueDisposable) {
            int m4;
            this.qd = (QueueDisposable)d;
            this.establishedFusionMode = m4 = this.qd.requestFusion(this.initialFusionMode);
            if (m4 == 1) {
                this.checkSubscriptionOnce = true;
                this.lastThread = Thread.currentThread();
                try {
                    Object t2;
                    while ((t2 = this.qd.poll()) != null) {
                        this.values.add(t2);
                    }
                    ++this.completions;
                    this.upstream.lazySet(DisposableHelper.DISPOSED);
                }
                catch (Throwable ex) {
                    this.errors.add(ex);
                }
                return;
            }
        }
        this.downstream.onSubscribe(d);
    }

    @Override
    public void onNext(T t2) {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.upstream.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        this.lastThread = Thread.currentThread();
        if (this.establishedFusionMode == 2) {
            try {
                while ((t2 = this.qd.poll()) != null) {
                    this.values.add(t2);
                }
            }
            catch (Throwable ex) {
                this.errors.add(ex);
                this.qd.dispose();
            }
            return;
        }
        this.values.add(t2);
        if (t2 == null) {
            this.errors.add(new NullPointerException("onNext received a null value"));
        }
        this.downstream.onNext(t2);
    }

    @Override
    public void onError(Throwable t2) {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.upstream.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        try {
            this.lastThread = Thread.currentThread();
            if (t2 == null) {
                this.errors.add(new NullPointerException("onError received a null Throwable"));
            } else {
                this.errors.add(t2);
            }
            this.downstream.onError(t2);
        }
        finally {
            this.done.countDown();
        }
    }

    @Override
    public void onComplete() {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.upstream.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        try {
            this.lastThread = Thread.currentThread();
            ++this.completions;
            this.downstream.onComplete();
        }
        finally {
            this.done.countDown();
        }
    }

    public final boolean isCancelled() {
        return this.isDisposed();
    }

    public final void cancel() {
        this.dispose();
    }

    @Override
    public final void dispose() {
        DisposableHelper.dispose(this.upstream);
    }

    @Override
    public final boolean isDisposed() {
        return DisposableHelper.isDisposed(this.upstream.get());
    }

    public final boolean hasSubscription() {
        return this.upstream.get() != null;
    }

    @Override
    public final TestObserver<T> assertSubscribed() {
        if (this.upstream.get() == null) {
            throw this.fail("Not subscribed!");
        }
        return this;
    }

    @Override
    public final TestObserver<T> assertNotSubscribed() {
        if (this.upstream.get() != null) {
            throw this.fail("Subscribed!");
        }
        if (!this.errors.isEmpty()) {
            throw this.fail("Not subscribed but errors found");
        }
        return this;
    }

    public final TestObserver<T> assertOf(Consumer<? super TestObserver<T>> check) {
        try {
            check.accept(this);
        }
        catch (Throwable ex) {
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        return this;
    }

    final TestObserver<T> setInitialFusionMode(int mode) {
        this.initialFusionMode = mode;
        return this;
    }

    final TestObserver<T> assertFusionMode(int mode) {
        int m4 = this.establishedFusionMode;
        if (m4 != mode) {
            if (this.qd != null) {
                throw new AssertionError((Object)("Fusion mode different. Expected: " + TestObserver.fusionModeToString(mode) + ", actual: " + TestObserver.fusionModeToString(m4)));
            }
            throw this.fail("Upstream is not fuseable");
        }
        return this;
    }

    static String fusionModeToString(int mode) {
        switch (mode) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "SYNC";
            }
            case 2: {
                return "ASYNC";
            }
        }
        return "Unknown(" + mode + ")";
    }

    final TestObserver<T> assertFuseable() {
        if (this.qd == null) {
            throw new AssertionError((Object)"Upstream is not fuseable.");
        }
        return this;
    }

    final TestObserver<T> assertNotFuseable() {
        if (this.qd != null) {
            throw new AssertionError((Object)"Upstream is fuseable.");
        }
        return this;
    }

    @Override
    public void onSuccess(T value) {
        this.onNext(value);
        this.onComplete();
    }

    static enum EmptyObserver implements Observer<Object>
    {
        INSTANCE;


        @Override
        public void onSubscribe(Disposable d) {
        }

        @Override
        public void onNext(Object t2) {
        }

        @Override
        public void onError(Throwable t2) {
        }

        @Override
        public void onComplete() {
        }
    }
}

