/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.subjects;

import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.annotations.Nullable;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.internal.util.AppendOnlyLinkedArrayList;
import io.confluent.shaded.io.reactivex.internal.util.NotificationLite;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import io.confluent.shaded.io.reactivex.subjects.Subject;

final class SerializedSubject<T>
extends Subject<T>
implements AppendOnlyLinkedArrayList.NonThrowingPredicate<Object> {
    final Subject<T> actual;
    boolean emitting;
    AppendOnlyLinkedArrayList<Object> queue;
    volatile boolean done;

    SerializedSubject(Subject<T> actual) {
        this.actual = actual;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.actual.subscribe(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubscribe(Disposable d) {
        boolean cancel;
        if (!this.done) {
            SerializedSubject serializedSubject = this;
            synchronized (serializedSubject) {
                if (this.done) {
                    cancel = true;
                } else {
                    if (this.emitting) {
                        AppendOnlyLinkedArrayList<Object> q = this.queue;
                        if (q == null) {
                            this.queue = q = new AppendOnlyLinkedArrayList(4);
                        }
                        q.add(NotificationLite.disposable(d));
                        return;
                    }
                    this.emitting = true;
                    cancel = false;
                }
            }
        } else {
            cancel = true;
        }
        if (cancel) {
            d.dispose();
        } else {
            this.actual.onSubscribe(d);
            this.emitLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        SerializedSubject serializedSubject = this;
        synchronized (serializedSubject) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q = this.queue;
                if (q == null) {
                    this.queue = q = new AppendOnlyLinkedArrayList(4);
                }
                q.add(NotificationLite.next(t2));
                return;
            }
            this.emitting = true;
        }
        this.actual.onNext(t2);
        this.emitLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t2) {
        boolean reportError;
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        SerializedSubject serializedSubject = this;
        synchronized (serializedSubject) {
            if (this.done) {
                reportError = true;
            } else {
                this.done = true;
                if (this.emitting) {
                    AppendOnlyLinkedArrayList<Object> q = this.queue;
                    if (q == null) {
                        this.queue = q = new AppendOnlyLinkedArrayList(4);
                    }
                    q.setFirst(NotificationLite.error(t2));
                    return;
                }
                reportError = false;
                this.emitting = true;
            }
        }
        if (reportError) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.actual.onError(t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        SerializedSubject serializedSubject = this;
        synchronized (serializedSubject) {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q = this.queue;
                if (q == null) {
                    this.queue = q = new AppendOnlyLinkedArrayList(4);
                }
                q.add(NotificationLite.complete());
                return;
            }
            this.emitting = true;
        }
        this.actual.onComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emitLoop() {
        while (true) {
            AppendOnlyLinkedArrayList<Object> q;
            SerializedSubject serializedSubject = this;
            synchronized (serializedSubject) {
                q = this.queue;
                if (q == null) {
                    this.emitting = false;
                    return;
                }
                this.queue = null;
            }
            q.forEachWhile(this);
        }
    }

    @Override
    public boolean test(Object o) {
        return NotificationLite.acceptFull(o, this.actual);
    }

    @Override
    public boolean hasObservers() {
        return this.actual.hasObservers();
    }

    @Override
    public boolean hasThrowable() {
        return this.actual.hasThrowable();
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        return this.actual.getThrowable();
    }

    @Override
    public boolean hasComplete() {
        return this.actual.hasComplete();
    }
}

