/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.subscribers;

import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.internal.disposables.ListCompositeDisposable;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.internal.util.EndConsumerHelper;
import io.confluent.shaded.org.reactivestreams.Subscription;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ResourceSubscriber<T>
implements FlowableSubscriber<T>,
Disposable {
    private final AtomicReference<Subscription> upstream = new AtomicReference();
    private final ListCompositeDisposable resources = new ListCompositeDisposable();
    private final AtomicLong missedRequested = new AtomicLong();

    public final void add(Disposable resource) {
        ObjectHelper.requireNonNull(resource, "resource is null");
        this.resources.add(resource);
    }

    @Override
    public final void onSubscribe(Subscription s2) {
        if (EndConsumerHelper.setOnce(this.upstream, s2, this.getClass())) {
            long r = this.missedRequested.getAndSet(0L);
            if (r != 0L) {
                s2.request(r);
            }
            this.onStart();
        }
    }

    protected void onStart() {
        this.request(Long.MAX_VALUE);
    }

    protected final void request(long n) {
        SubscriptionHelper.deferredRequest(this.upstream, this.missedRequested, n);
    }

    @Override
    public final void dispose() {
        if (SubscriptionHelper.cancel(this.upstream)) {
            this.resources.dispose();
        }
    }

    @Override
    public final boolean isDisposed() {
        return this.upstream.get() == SubscriptionHelper.CANCELLED;
    }
}

