/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry;

import io.confluent.shaded.com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPropertyTranslater {
    private static final Logger log = LoggerFactory.getLogger(ConfigPropertyTranslater.class);
    private final Map<String, String> translations;
    private final Map<String, String> prefixTranslations;

    private ConfigPropertyTranslater(Builder builder) {
        this.translations = ImmutableMap.copyOf(builder.translations);
        this.prefixTranslations = ImmutableMap.copyOf(builder.prefixTranslations);
    }

    public <T> Map<String, T> translate(Map<String, T> originals) {
        HashMap result = new HashMap();
        originals.forEach((key, value) -> {
            String translatedKey = this.translateKey((String)key);
            if (translatedKey == null) {
                translatedKey = this.translateKeyViaPrefix((String)key);
            }
            if (translatedKey != null) {
                if (originals.containsKey(translatedKey)) {
                    log.warn("Deprecated key '{}' and it's new counterpart '{}' have both been specified. The value for the new key '{}' will be used. Please remove the deprecated key '{}' from your configuration.", new Object[]{key, translatedKey, translatedKey, key});
                    result.put(translatedKey, originals.get(translatedKey));
                } else {
                    log.warn("Configuration key '{}' is deprecated and may be removed in the future. Please update your configuration to use '{}' instead.", key, (Object)translatedKey);
                    result.put(translatedKey, value);
                }
            } else {
                result.put(key, value);
            }
        });
        return result;
    }

    private String translateKey(String key) {
        return this.translations.get(key);
    }

    private String translateKeyViaPrefix(String key) {
        return this.prefixTranslations.entrySet().stream().filter(entry -> key.startsWith((String)entry.getKey())).findFirst().map(entry -> {
            String oldPrefix = (String)entry.getKey();
            String newPrefix = (String)entry.getValue();
            return key.replace(oldPrefix, newPrefix);
        }).orElse(null);
    }

    public static class Builder {
        private final Map<String, String> translations = new HashMap<String, String>();
        private final Map<String, String> prefixTranslations = new LinkedHashMap<String, String>();

        public Builder withTranslation(String deprecatedProperty, String newProperty) {
            this.translations.put(deprecatedProperty, newProperty);
            return this;
        }

        public Builder withPrefixTranslation(String deprecatedPrefix, String newPrefix) {
            this.prefixTranslations.put(deprecatedPrefix, newPrefix);
            return this;
        }

        public ConfigPropertyTranslater build() {
            return new ConfigPropertyTranslater(this);
        }
    }
}

