/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry;

import io.confluent.shaded.com.google.common.annotations.VisibleForTesting;
import io.confluent.shaded.com.google.common.base.Joiner;
import io.confluent.shaded.com.google.common.collect.ImmutableMap;
import io.confluent.shaded.com.google.common.collect.ImmutableSet;
import io.confluent.shaded.com.google.common.collect.Maps;
import io.confluent.shaded.io.confluent.telemetry.config.FilterSetPredicate;
import io.confluent.shaded.io.confluent.telemetry.config.NamedFilter;
import io.confluent.shaded.io.confluent.telemetry.config.remote.RemoteConfigConfiguration;
import io.confluent.shaded.io.confluent.telemetry.config.remote.polling.PollingRemoteConfigurationConfig;
import io.confluent.shaded.io.confluent.telemetry.config.remote.polling.kubernetes.KubernetesConfigMapRemoteConfigurationConfig;
import io.confluent.telemetry.ExporterUtils;
import io.confluent.telemetry.RegexConfigDefValidator;
import io.confluent.telemetry.collector.VolumeMetricsCollector;
import io.confluent.telemetry.common.config.ConfigUtils;
import io.confluent.telemetry.exporter.ExporterConfig;
import io.confluent.telemetry.exporter.http.HttpExporterConfig;
import io.confluent.telemetry.exporter.kafka.KafkaExporterConfig;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentTelemetryConfig
extends AbstractConfig {
    private static final Logger log = LoggerFactory.getLogger(ConfluentTelemetryConfig.class);
    public static final String PREFIX = "confluent.telemetry.";
    public static final String PREFIX_LABELS = "confluent.telemetry.labels.";
    public static final String PREFIX_EXPORTER = "confluent.telemetry.exporter.";
    public static final String PREFIX_METRICS_COLLECTOR = "confluent.telemetry.metrics.collector.";
    public static final String COLLECT_INTERVAL_CONFIG = "confluent.telemetry.metrics.collector.interval.ms";
    public static final Long DEFAULT_COLLECT_INTERVAL = TimeUnit.MINUTES.toMillis(1L);
    public static final String COLLECT_INTERVAL_DOC = "The metrics reporter will collect new metrics from the system in intervals defined by this setting. This means that control center system health data lags by this duration, or that rebalancer may compute a plan based on broker data that is stale by this duration. The default is a reasonable value for production environments and it typically does not need to be changed.";
    public static final String METRICS_INCLUDE_CONFIG = "confluent.telemetry.metrics.collector.include";
    public static final String METRICS_INCLUDE_CONFIG_ALIAS = "confluent.telemetry.metrics.collector.whitelist";
    public static final String SLO_COLLECTOR_ENABLED = "confluent.telemetry.metrics.collector.slo.enabled";
    public static final Boolean DEFAULT_SLO_COLLECTOR_ENABLED = false;
    public static final String SLO_COLLECTOR_DOC = "Enable SLO metric collector";
    public static final String DEFAULT_SYSTEM_METRICS_INCLUDE_REGEX = "io.confluent.system/.*(process_cpu_load|max_file_descriptor_count|open_file_descriptor_count|system_cpu_load|system_load_average|free_physical_memory_size|total_physical_memory_size|disk_total_bytes|disk_usable_bytes|jvm/mem|jvm/gc)";
    public static final String METRICS_INCLUDE_DOC = "Regex matching the converted (snake_case) metric name to be published to the metrics topic.\n\nBy default this includes all the metrics required by Proactive Support and Self-balancing Clusters. This should typically never be modified unless requested by Confluent.";
    public static final String DEFAULT_METRICS_INCLUDE;
    public static final String CONFIG_EVENTS_ENABLE_CONFIG = "confluent.telemetry.events.enable";
    public static final String CONFIG_EVENTS_ENABLE_DOC = "Enable config events collection.Enabled by default for v7.0.";
    public static final Boolean CONFIG_EVENTS_ENABLE_DEFAULT;
    public static final String CONFIG_EVENTS_INCLUDE_CONFIG = "confluent.telemetry.events.collector.include";
    public static final String CONFIG_EVENTS_INCLUDE_DOC = "Regex matching the config names to be published to telemetry collector.This should typically never be modified unless requested by Confluent.";
    public static final String CONFIG_EVENTS_INCLUDE_DEFAULT;
    public static final List<String> CONFIG_EVENTS_INCLUDE;
    public static final String DEBUG_ENABLED = "confluent.telemetry.debug.enabled";
    public static final String DEBUG_ENABLED_DOC = "Enable debug metadata for metrics collection";
    public static final boolean DEFAULT_DEBUG_ENABLED = false;
    public static final String DEFAULT_NAMED_FILTER_NAME = "_default";
    public static final Set<String> DEFAULT_ACTIVE_FILTER_SET;
    public static final String CPU_METRIC;
    public static final String EXPORTER_LOCAL_NAME = "_local";
    public static final String EXPORTER_LOCAL_METRICS_INCLUDE;
    public static final Map<String, Object> EXPORTER_LOCAL_DEFAULTS;
    public static final String EXPORTER_CONFLUENT_NAME = "_confluent";
    public static final Map<String, Object> EXPORTER_CONFLUENT_DEFAULTS;
    public static final Map<String, Map<String, Object>> EXPORTER_DEFAULT_CONFIGS;
    public static final String PREFIX_REMOTE_CONFIG = "confluent.telemetry.remoteconfig.";
    private static final String REMOTE_CONFIG_CLOUD = "_cloud.";
    @VisibleForTesting
    public static final String REMOTE_CONFIG_CONFLUENT = "_confluent.";
    public static final String TELEMETRY_API_KEY = "confluent.telemetry.api.key";
    public static final String TELEMETRY_API_KEY_DOC = "The API key used to authenticate HTTP requests with the Confluent telemetry server";
    public static final String TELEMETRY_API_SECRET = "confluent.telemetry.api.secret";
    public static final String TELEMETRY_API_SECRET_DOC = "The API secret used to authenticate HTTP requests with the Confluent Telemetry server";
    public static final String TELEMETRY_ENABLED_CONFIG = "confluent.telemetry.enabled";
    public static final String TELEMETRY_ENABLED_DOC = "True if telemetry data can to be reported to Confluent Cloud";
    public static final boolean TELEMETRY_ENABLED_DEFAULT = false;
    public static final String TELEMETRY_PROXY_URL = "confluent.telemetry.proxy.url";
    public static final String TELEMETRY_PROXY_URL_DOC = "The URL for an explicit (i.e. not transparent) forward HTTP proxy to send Telemetry data to Confluent Cloud";
    public static final String TELEMETRY_PROXY_USERNAME = "confluent.telemetry.proxy.username";
    public static final String TELEMETRY_PROXY_USERNAME_DOC = "The username credential for the forward HTTP proxy to send Telemetry data to Confluent Cloud";
    public static final String TELEMETRY_PROXY_PASSWORD = "confluent.telemetry.proxy.password";
    public static final String TELEMETRY_PROXY_PASSWORD_DOC = "The password credential for the forward HTTP proxy to send Telemetry data to Confluent Cloud";
    public static final Set<String> RECONFIGURABLES;
    private static final ImmutableMap<String, String> RECONCILABLE_CONFIG_MAP;
    private static final ConfigDef CONFIG;
    private final VolumeMetricsCollector.VolumeMetricsCollectorConfig volumeMetricsCollectorConfig;
    private final Map<String, ExporterConfig> exporterConfigMap;
    private final Optional<RemoteConfigConfiguration> remoteConfigConfiguration;

    public static String joinIncludeRegexList(List<String> includeRegexList) {
        StringBuilder eventBuilder = new StringBuilder(".*");
        Joiner.on(".*|.*").appendTo(eventBuilder, (Iterable<? extends Object>)includeRegexList);
        eventBuilder.append(".*");
        return eventBuilder.toString();
    }

    public static String exporterPrefixForName(String name) {
        return PREFIX_EXPORTER + name + ".";
    }

    public ConfluentTelemetryConfig(Map<String, ?> originals) {
        this(originals, true);
    }

    public ConfluentTelemetryConfig(Map<String, ?> originals, boolean doLog) {
        super(CONFIG, ConfluentTelemetryConfig.reconcileConfigs(ConfigUtils.translateDeprecated(originals, new String[][]{{METRICS_INCLUDE_CONFIG, METRICS_INCLUDE_CONFIG_ALIAS}})), doLog);
        this.volumeMetricsCollectorConfig = new VolumeMetricsCollector.VolumeMetricsCollectorConfig(originals, doLog);
        this.exporterConfigMap = this.createExporterMap(doLog);
        if (this.enabledExporters().isEmpty()) {
            log.warn("no telemetry exporters are enabled");
        }
        this.remoteConfigConfiguration = this.parseRemoteConfigSourceConfiguration(doLog);
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toRst());
    }

    public Map<String, String> getLabels() {
        HashMap<String, String> labels = new HashMap<String, String>();
        for (Map.Entry entry : super.originals().entrySet()) {
            if (!((String)entry.getKey()).startsWith(PREFIX_LABELS)) continue;
            labels.put(((String)entry.getKey()).substring(PREFIX_LABELS.length()), (String)entry.getValue());
        }
        return labels;
    }

    public FilterSetPredicate getDefaultFilterSet() {
        return new FilterSetPredicate(new NamedFilter(DEFAULT_NAMED_FILTER_NAME, this.getString(METRICS_INCLUDE_CONFIG)));
    }

    public VolumeMetricsCollector.VolumeMetricsCollectorConfig getVolumeMetricsCollectorConfig() {
        return this.volumeMetricsCollectorConfig;
    }

    public Optional<RemoteConfigConfiguration> getRemoteConfigConfiguration() {
        return this.remoteConfigConfiguration;
    }

    public static Map<String, ?> reconcileConfigs(Map<String, ?> config) {
        Map<String, ?> tempConfig = config;
        for (String reconcilableHighLevelKey : RECONCILABLE_CONFIG_MAP.keySet()) {
            String lowLevelKey = RECONCILABLE_CONFIG_MAP.get(reconcilableHighLevelKey);
            if (!tempConfig.containsKey(reconcilableHighLevelKey) || tempConfig.containsKey(lowLevelKey)) continue;
            log.info("Applying value of {} flag for default '{}' http exporter as {} isn't passed", new Object[]{reconcilableHighLevelKey, EXPORTER_CONFLUENT_NAME, lowLevelKey});
            tempConfig.put(lowLevelKey, tempConfig.get(reconcilableHighLevelKey));
        }
        return tempConfig;
    }

    private Map<String, ExporterConfig> createExporterMap(boolean doLog) {
        String configPrefix = PREFIX_EXPORTER;
        HashMap<String, Map<String, Object>> exporters = Maps.newHashMap();
        for (Map.Entry<String, Map<String, Object>> entry : EXPORTER_DEFAULT_CONFIGS.entrySet()) {
            HashMap<String, Object> defaults = Maps.newHashMap(entry.getValue());
            exporters.put(entry.getKey(), defaults);
        }
        HashMap<String, Object> exporterConfigs = Maps.newHashMap();
        exporterConfigs.putAll(this.originalsWithPrefix(configPrefix));
        ExporterUtils.parseExporterConfigsByName(exporters, exporterConfigs);
        HashMap<String, ExporterConfig> exporterConfigMap = Maps.newHashMap();
        for (Map.Entry entry : exporters.entrySet()) {
            String exporterName = (String)entry.getKey();
            Boolean isEnabled = (Boolean)ConfigDef.parseType((String)"enabled", ((Map)entry.getValue()).get("enabled"), (ConfigDef.Type)ConfigDef.Type.BOOLEAN);
            Object exporterTypeConfig = ((Map)entry.getValue()).get("type");
            if (isEnabled == null) {
                log.warn("Skipping exporter config of '{}' exporter as '{}' config is not defined.", (Object)exporterName, (Object)"enabled");
                continue;
            }
            if (exporterTypeConfig == null && !isEnabled.booleanValue()) {
                log.warn("Skipping exporter config of '{}' exporter as it is disabled and its type is not defined.", (Object)exporterName);
                continue;
            }
            ExporterConfig.ExporterType exporterType = null;
            try {
                exporterType = ExporterConfig.parseType(exporterTypeConfig);
            }
            catch (ConfigException e) {
                throw new ConfigException(e.getMessage() + " for exporter " + exporterName);
            }
            ExporterConfig config = null;
            if (exporterType.equals((Object)ExporterConfig.ExporterType.kafka)) {
                config = new KafkaExporterConfig((Map)entry.getValue(), doLog);
            } else if (exporterType.equals((Object)ExporterConfig.ExporterType.http)) {
                config = new HttpExporterConfig((Map)entry.getValue(), doLog);
            } else {
                throw new RuntimeException("unexpected ExporterType value");
            }
            exporterConfigMap.put(exporterName, config);
        }
        return exporterConfigMap;
    }

    private Optional<RemoteConfigConfiguration> parseRemoteConfigSourceConfiguration(boolean doLog) {
        boolean cloudEnabled;
        Map remoteConfigSourceConfigs = this.originalsWithPrefix(PREFIX_REMOTE_CONFIG);
        Boolean confluentEnabledConfig = (Boolean)ConfigDef.parseType((String)"enabled", remoteConfigSourceConfigs.get("_confluent.enabled"), (ConfigDef.Type)ConfigDef.Type.BOOLEAN);
        Boolean cloudEnabledConfig = (Boolean)ConfigDef.parseType((String)"enabled", remoteConfigSourceConfigs.get("_cloud.enabled"), (ConfigDef.Type)ConfigDef.Type.BOOLEAN);
        boolean confluentEnabled = Objects.isNull(confluentEnabledConfig) || confluentEnabledConfig != false;
        boolean bl = cloudEnabled = !Objects.isNull(cloudEnabledConfig) && cloudEnabledConfig != false;
        if (confluentEnabled && cloudEnabled) {
            throw new ConfigException("Both _confluent and _cloud RemoteConfigSources are enabled. Please disable one");
        }
        if (confluentEnabled) {
            Map pollingRemoteConfigs = this.originalsWithPrefix("confluent.telemetry.remoteconfig._confluent.");
            pollingRemoteConfigs.put("enabled", true);
            return Optional.of(new PollingRemoteConfigurationConfig(pollingRemoteConfigs, doLog));
        }
        if (cloudEnabled) {
            return Optional.of(new KubernetesConfigMapRemoteConfigurationConfig(this.originalsWithPrefix("confluent.telemetry.remoteconfig._cloud."), doLog));
        }
        return Optional.empty();
    }

    public Map<String, ExporterConfig> allExporters() {
        return ConfluentTelemetryConfig.filterConfigMap(this.exporterConfigMap, null, null, null, ExporterConfig.class);
    }

    public Map<String, ExporterConfig> enabledExporters() {
        return ConfluentTelemetryConfig.filterConfigMap(this.exporterConfigMap, null, true, null, ExporterConfig.class);
    }

    public Map<String, ExporterConfig> allExportersWithNames(Set<String> names) {
        return ConfluentTelemetryConfig.filterConfigMap(this.exporterConfigMap, null, null, names, ExporterConfig.class);
    }

    public Map<String, HttpExporterConfig> allHttpExporters() {
        return ConfluentTelemetryConfig.filterConfigMap(this.exporterConfigMap, ExporterConfig.ExporterType.http, null, null, HttpExporterConfig.class);
    }

    private static <T> Map<String, T> filterConfigMap(Map<String, ExporterConfig> configNameMap, ExporterConfig.ExporterType type, Boolean isEnabled, Set<String> names, Class<T> castTo) {
        return configNameMap.entrySet().stream().filter(e -> type == null || ((ExporterConfig)((Object)((Object)e.getValue()))).getType().equals((Object)type)).filter(e -> isEnabled == null || isEnabled.booleanValue() == ((ExporterConfig)((Object)((Object)e.getValue()))).isEnabled() && isEnabled.booleanValue() == ((ExporterConfig)((Object)((Object)e.getValue()))).isMetricsEnabled()).filter(e -> names == null || names.contains(e.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> castTo.cast(e.getValue())));
    }

    static {
        CONFIG_EVENTS_ENABLE_DEFAULT = true;
        CONFIG_EVENTS_INCLUDE = Collections.unmodifiableList(Arrays.asList("transaction.remove.expired.transaction.cleanup.interval.ms", "transaction.state.log.load.buffer.size", "transaction.state.log.min.isr", "transaction.state.log.num.partitions", "transaction.state.log.replication.factor", "transaction.state.log.segment.bytes", "transactional.id.expiration.ms", "controlled.shutdown.enable", "controlled.shutdown.max.retries", "controlled.shutdown.retry.backoff.ms", "fetch.max.bytes", "fetch.purgatory.purge.interval.requests", "group.initial.rebalance.delay.ms", "group.max.session.timeout.ms", "group.max.size", "group.min.session.timeout.ms", "log.cleaner.backoff.ms", "log.cleaner.dedupe.buffer.size", "log.cleaner.delete.retention.ms", "log.cleaner.enable", "log.cleaner.io.buffer.load.factor", "log.cleaner.io.buffer.size", "log.cleaner.io.max.bytes.per.second", "log.cleaner.max.compaction.lag.ms", "log.cleaner.min.cleanable.ratio", "log.cleaner.min.compaction.lag.ms", "log.cleaner.threads", "log.cleanup.policy", "log.index.interval.bytes", "log.index.size.max.bytes", "log.message.downconversion.enable", "log.message.format.version", "log.message.timestamp.difference.max.ms", "log.message.timestamp.type", "max.connection.creation.rate", "max.connections", "max.connections.per.ip", "max.incremental.fetch.session.cache.slots", "replica.fetch.backoff.ms", "replica.fetch.max.bytes", "replica.fetch.min.bytes", "replica.fetch.response.max.bytes", "replica.fetch.wait.max.ms", "replica.high.watermark.checkpoint.interval.ms", "replica.lag.time.max.ms", "replica.selector.class", "replica.socket.receive.buffer.bytes", "replica.socket.timeout.ms", "alter.config.policy.class.name", "alter.log.dirs.replication.quota.window.num", "alter.log.dirs.replication.quota.window.size.seconds", "metrics.num.samples", "metrics.recording.level", "metrics.sample.window.ms", "quota.window.num", "quota.window.size.seconds", "replication.quota.window.num", "replication.quota.window.size.seconds", "confluent.balancer.enable", "confluent.balancer.throttle.bytes.per.second", "confluent.balancer.heal.uneven.load.trigger", "confluent.balancer.heal.broker.failure.threshold.ms", "confluent.balancer.disk.max.load", "confluent.balancer.exclude.topic.prefixes", "confluent.balancer.exclude.topic.names", "confluent.tier.local.hotset.bytes", "confluent.tier.local.hotset.ms", "confluent.tier.archiver.num.threads", "confluent.tier.backend", "confluent.tier.enable", "confluent.tier.feature", "confluent.tier.fetcher.num.threads", "confluent.tier.max.partition.fetch.bytes.override", "confluent.tier.metadata.replication.factor", "confluent.operator.managed", "confluent.ansible.managed", "confluent.license"));
        DEFAULT_METRICS_INCLUDE = ConfluentTelemetryConfig.joinIncludeRegexList(Collections.singletonList(DEFAULT_SYSTEM_METRICS_INCLUDE_REGEX));
        CONFIG_EVENTS_INCLUDE_DEFAULT = ConfluentTelemetryConfig.joinIncludeRegexList(CONFIG_EVENTS_INCLUDE);
        DEFAULT_ACTIVE_FILTER_SET = Collections.singleton(DEFAULT_NAMED_FILTER_NAME);
        String procRoot = "/proc";
        Path loadAvgPath = Paths.get(procRoot, "loadavg");
        Path statPath = Paths.get(procRoot, "stat");
        boolean isLinuxCpuCollectorUsable = loadAvgPath.toFile().exists() && statPath.toFile().exists();
        log.info("Linux CPU collector enabled: {}", (Object)isLinuxCpuCollectorUsable);
        CPU_METRIC = isLinuxCpuCollectorUsable ? "io\\.confluent\\.kafka\\.server/server/linux_system_cpu_utilization_1m" : "io\\.confluent\\.system/jvm/os/process_cpu_load";
        log.info("Using cpu metric: {}", (Object)CPU_METRIC);
        EXPORTER_LOCAL_METRICS_INCLUDE = "(io\\.confluent\\.kafka\\.server/broker_load/broker_load_percent|io\\.confluent\\.kafka\\.server/broker_topic/bytes_in/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/bytes_out/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/fetch_from_follower_bytes_out/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/messages_in/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/replication_bytes_in/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/replication_bytes_out/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/total_fetch_requests/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/total_follower_fetch_requests/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/total_fetch_from_follower_requests/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/total_produce_requests/rate/1_min|io\\.confluent\\.kafka\\.server/log/size|io\\.confluent\\.kafka\\.server/request/requests/rate/1_min|io\\.confluent\\.kafka\\.server/request_handler_pool/request_handler_avg_idle_percent/rate/1_min|" + CPU_METRIC + "|io\\.confluent\\.system/volume/disk_total_bytes)";
        EXPORTER_LOCAL_DEFAULTS = ImmutableMap.of("type", ExporterConfig.ExporterType.kafka.name(), "enabled", true, "metrics.include", EXPORTER_LOCAL_METRICS_INCLUDE, "producer.bootstrap.servers", "localhost:9092", "producer.client.id", "confluent-telemetry-reporter-local-producer");
        EXPORTER_CONFLUENT_DEFAULTS = ImmutableMap.of("type", ExporterConfig.ExporterType.http.name(), "enabled", false, "client.base.url", "https://collector.telemetry.confluent.cloud");
        EXPORTER_DEFAULT_CONFIGS = ImmutableMap.of(EXPORTER_CONFLUENT_NAME, EXPORTER_CONFLUENT_DEFAULTS);
        RECONFIGURABLES = ImmutableSet.of(METRICS_INCLUDE_CONFIG, TELEMETRY_ENABLED_CONFIG, TELEMETRY_API_KEY, TELEMETRY_API_SECRET, TELEMETRY_PROXY_URL, TELEMETRY_PROXY_USERNAME, new String[]{TELEMETRY_PROXY_PASSWORD, CONFIG_EVENTS_ENABLE_CONFIG});
        RECONCILABLE_CONFIG_MAP = ImmutableMap.builder().put(TELEMETRY_ENABLED_CONFIG, ConfluentTelemetryConfig.exporterPrefixForName(EXPORTER_CONFLUENT_NAME) + "enabled").put(TELEMETRY_API_KEY, ConfluentTelemetryConfig.exporterPrefixForName(EXPORTER_CONFLUENT_NAME) + "api.key").put(TELEMETRY_API_SECRET, ConfluentTelemetryConfig.exporterPrefixForName(EXPORTER_CONFLUENT_NAME) + "api.secret").put(TELEMETRY_PROXY_URL, ConfluentTelemetryConfig.exporterPrefixForName(EXPORTER_CONFLUENT_NAME) + "proxy.url").put(TELEMETRY_PROXY_USERNAME, ConfluentTelemetryConfig.exporterPrefixForName(EXPORTER_CONFLUENT_NAME) + "proxy.username").put(TELEMETRY_PROXY_PASSWORD, ConfluentTelemetryConfig.exporterPrefixForName(EXPORTER_CONFLUENT_NAME) + "proxy.password").build();
        CONFIG = new ConfigDef().define(COLLECT_INTERVAL_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_COLLECT_INTERVAL, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, COLLECT_INTERVAL_DOC).define(METRICS_INCLUDE_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_METRICS_INCLUDE, (ConfigDef.Validator)new RegexConfigDefValidator("Metrics filter for configuration"), ConfigDef.Importance.LOW, METRICS_INCLUDE_DOC).define(SLO_COLLECTOR_ENABLED, ConfigDef.Type.BOOLEAN, (Object)DEFAULT_SLO_COLLECTOR_ENABLED, ConfigDef.Importance.LOW, SLO_COLLECTOR_DOC).define(CONFIG_EVENTS_INCLUDE_CONFIG, ConfigDef.Type.STRING, (Object)CONFIG_EVENTS_INCLUDE_DEFAULT, (ConfigDef.Validator)new RegexConfigDefValidator("Events filter for configuration"), ConfigDef.Importance.LOW, CONFIG_EVENTS_INCLUDE_DOC).define(CONFIG_EVENTS_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)CONFIG_EVENTS_ENABLE_DEFAULT, ConfigDef.Importance.LOW, CONFIG_EVENTS_ENABLE_DOC).define(DEBUG_ENABLED, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, DEBUG_ENABLED_DOC).define(TELEMETRY_API_KEY, ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, TELEMETRY_API_KEY_DOC).define(TELEMETRY_API_SECRET, ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.HIGH, TELEMETRY_API_SECRET_DOC).define(TELEMETRY_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, TELEMETRY_ENABLED_DOC).define(TELEMETRY_PROXY_URL, ConfigDef.Type.STRING, null, (ConfigDef.Validator)new HttpExporterConfig.URIValidator(), ConfigDef.Importance.LOW, TELEMETRY_PROXY_URL_DOC).define(TELEMETRY_PROXY_USERNAME, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, TELEMETRY_PROXY_USERNAME_DOC).define(TELEMETRY_PROXY_PASSWORD, ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.LOW, TELEMETRY_PROXY_PASSWORD_DOC);
    }
}

