/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry;

import io.confluent.shaded.com.google.common.annotations.VisibleForTesting;
import io.confluent.shaded.io.opentelemetry.proto.metrics.v1.Metric;
import io.confluent.shaded.io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.confluent.shaded.io.opentelemetry.proto.metrics.v1.ScopeMetrics;
import io.confluent.shaded.io.opentelemetry.proto.resource.v1.Resource;

public class Context {
    private final Resource resource;
    private final boolean debugEnabled;
    private final String domain;

    @VisibleForTesting
    public Context(String domain) {
        this(Resource.getDefaultInstance(), domain);
    }

    public Context(Resource resource, String domain) {
        this(resource, domain, false);
    }

    public Context(Resource resource, String domain, boolean debugEnabled) {
        this.resource = resource;
        this.debugEnabled = debugEnabled;
        this.domain = domain;
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public String getDomain() {
        return this.domain;
    }

    public ResourceMetrics buildMetric(Metric metric) {
        return ResourceMetrics.newBuilder().setResource(this.resource).addScopeMetrics(ScopeMetrics.newBuilder().addMetrics(metric).build()).build();
    }
}

