/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry;

import io.confluent.shaded.com.google.common.base.Verify;
import io.confluent.telemetry.collector.MetricsCollector;
import io.confluent.telemetry.emitter.Emitter;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsCollectorTask {
    private static final Logger log = LoggerFactory.getLogger(MetricsCollectorTask.class);
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    private final Collection<MetricsCollector> collectors;
    private final long collectIntervalMs;
    private final Emitter emitter;

    public MetricsCollectorTask(Collection<MetricsCollector> collectors, long collectIntervalMs, Emitter emitter) {
        Verify.verify(collectIntervalMs > 0L, "collection interval cannot be less than 1", new Object[0]);
        this.collectors = Objects.requireNonNull(collectors);
        this.collectIntervalMs = collectIntervalMs;
        this.emitter = emitter;
        this.executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.executor.setThreadFactory(runnable -> {
            Thread thread = new Thread(runnable, "confluent-telemetry-metrics-collector-task-scheduler");
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((t2, e) -> log.error("Uncaught exception in thread '{}':", (Object)t2.getName(), (Object)e));
            return thread;
        });
    }

    public void start() {
        this.schedule();
    }

    private void schedule() {
        this.executor.scheduleAtFixedRate(this::collectAndExport, this.collectIntervalMs, this.collectIntervalMs, TimeUnit.MILLISECONDS);
    }

    private void collectAndExport() {
        this.collectors.forEach(this::collectAndExport);
    }

    private void collectAndExport(MetricsCollector collector) {
        try {
            collector.collect(this.emitter);
        }
        catch (Throwable t2) {
            log.error("Error while collecting metrics for collector = {})", (Object)collector, (Object)t2);
        }
    }

    public void close() {
        this.executor.shutdown();
    }
}

