/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry;

import io.confluent.shaded.io.opentelemetry.proto.common.v1.KeyValue;
import io.confluent.shaded.io.opentelemetry.proto.resource.v1.Resource;
import java.time.Clock;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class MetricsUtils {
    public static long toTimeUnixNanos(Instant t2) {
        return TimeUnit.SECONDS.toNanos(t2.getEpochSecond()) + (long)t2.getNano();
    }

    public static ZonedDateTime nowInUTC(Clock clock) {
        return Instant.now(clock).atZone(ZoneOffset.UTC);
    }

    public static OffsetDateTime nowInUTC() {
        return OffsetDateTime.now(Clock.systemUTC());
    }

    public static Map<String, String> attributesMap(Resource resource) {
        return MetricsUtils.attributesMap(resource.getAttributesList());
    }

    public static Map<String, String> attributesMap(List<KeyValue> attributes) {
        return attributes.stream().filter(attr -> attr.getValue().hasStringValue()).collect(Collectors.toMap(KeyValue::getKey, attr -> attr.getValue().getStringValue()));
    }
}

