/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.collector;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import io.confluent.shaded.com.google.common.annotations.VisibleForTesting;
import io.confluent.telemetry.MetricKey;
import io.confluent.telemetry.collector.MetricNamingStrategy;
import io.confluent.telemetry.collector.MetricsCollector;
import io.confluent.telemetry.emitter.Emitter;
import io.confluent.telemetry.metrics.SinglePointMetric;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import kafka.controller.PartitionSLOMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLOMetricsCollector
implements MetricsCollector {
    private static final Logger log = LoggerFactory.getLogger(SLOMetricsCollector.class);
    private static final String FIXED_RATE_SUFFIX = "fixed_rate";
    private static final List<String> SLO_METRICS = Arrays.asList(PartitionSLOMetrics.GlobalPartitionAvailabilityMetric(), PartitionSLOMetrics.GlobalUnderMinIsrPartitionCountMetric(), PartitionSLOMetrics.TenantPartitionAvailabilitySLOMetric());
    private static final Predicate<MetricName> SLO_METRICS_PREDICATE = metricName -> "KafkaController".equals(metricName.getType()) && SLO_METRICS.contains(metricName.getName());
    private static final int MAX_SIZE = 10000;
    private static final int POLLING_PERIOD_MS = 30000;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private final MetricsRegistry metricsRegistry;
    private final MetricNamingStrategy<MetricName> metricNamingStrategy;
    private final Clock clock;
    @VisibleForTesting
    final Queue<MetricAndTimestamp> polledMetrics = new ConcurrentLinkedQueue<MetricAndTimestamp>();
    @VisibleForTesting
    final AtomicInteger polledSize = new AtomicInteger(0);

    public SLOMetricsCollector(MetricsRegistry metricsRegistry, MetricNamingStrategy<MetricName> metricNamingStrategy) {
        this(metricsRegistry, metricNamingStrategy, Clock.systemUTC());
    }

    @VisibleForTesting
    SLOMetricsCollector(MetricsRegistry metricsRegistry, MetricNamingStrategy<MetricName> metricNamingStrategy, Clock clock) {
        this.metricsRegistry = metricsRegistry;
        this.metricNamingStrategy = metricNamingStrategy;
        this.clock = clock;
    }

    @Override
    public void start() {
        log.info("Begin polling SLO metrics every 30 seconds");
        this.executor.scheduleAtFixedRate(this::pollMetrics, 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        log.info("Shutting down SLO collector thread");
        this.executor.shutdown();
    }

    @Override
    public void collect(Emitter emitter) {
        if (this.polledSize.get() == 0) {
            return;
        }
        Instant maxTimestamp = Instant.now(this.clock).truncatedTo(ChronoUnit.MINUTES);
        LinkedHashMap<MetricKeyAndTimestamp, SinglePointMetric> evenRateMetrics = new LinkedHashMap<MetricKeyAndTimestamp, SinglePointMetric>(SLO_METRICS.size());
        Iterator it = this.polledMetrics.iterator();
        while (it.hasNext()) {
            MetricAndTimestamp metricAndTimestamp = (MetricAndTimestamp)it.next();
            if (!metricAndTimestamp.timestamp.isBefore(maxTimestamp)) continue;
            evenRateMetrics.put(new MetricKeyAndTimestamp(metricAndTimestamp.metric.key(), metricAndTimestamp.timestamp), metricAndTimestamp.metric);
            it.remove();
            this.polledSize.decrementAndGet();
        }
        evenRateMetrics.forEach((keyAndTimestamp, metric) -> {
            log.trace("Emit SLO metric {} for timestamp {}", (Object)keyAndTimestamp.metricKey, (Object)keyAndTimestamp.timestamp);
            emitter.emitMetric((SinglePointMetric)metric);
        });
    }

    @VisibleForTesting
    void pollMetrics() {
        Set metrics = this.metricsRegistry.allMetrics().entrySet();
        for (Map.Entry entry : metrics) {
            MetricName metricName = (MetricName)entry.getKey();
            Metric metric = (Metric)entry.getValue();
            if (!SLO_METRICS_PREDICATE.test(metricName)) continue;
            MetricKey baseMetricKey = this.metricNamingStrategy.metricKey(metricName);
            MetricKey metricKey = this.metricNamingStrategy.derivedMetricKey(baseMetricKey, FIXED_RATE_SUFFIX);
            if (metric instanceof Gauge) {
                Object gaugeValue = ((Gauge)metric).value();
                Instant now = this.clock.instant();
                Instant truncatedNow = now.truncatedTo(ChronoUnit.MINUTES);
                if (gaugeValue instanceof Number) {
                    this.enqueueMetric(new MetricAndTimestamp(SinglePointMetric.gauge(metricKey, (Number)gaugeValue, truncatedNow), truncatedNow));
                    continue;
                }
                if (gaugeValue instanceof Boolean) {
                    this.enqueueMetric(new MetricAndTimestamp(SinglePointMetric.gauge(metricKey, (Boolean)gaugeValue != false ? 1L : 0L, truncatedNow), truncatedNow));
                    continue;
                }
                log.debug("Ignoring {} value = {}", (Object)metricName, gaugeValue);
                continue;
            }
            log.debug("Ignoring {} metric = {}", (Object)metricName, (Object)metric);
        }
    }

    private void enqueueMetric(MetricAndTimestamp metric) {
        if (this.polledSize.incrementAndGet() < 10000) {
            this.polledMetrics.offer(metric);
        } else {
            log.warn("Dropping metric {}, queue is full!", (Object)metric);
        }
    }

    private static class MetricKeyAndTimestamp {
        final MetricKey metricKey;
        final Instant timestamp;

        MetricKeyAndTimestamp(MetricKey metricKey, Instant timestamp) {
            this.metricKey = metricKey;
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricKeyAndTimestamp that = (MetricKeyAndTimestamp)o;
            return this.metricKey.equals(that.metricKey) && this.timestamp.equals(that.timestamp);
        }

        public int hashCode() {
            return Objects.hash(this.metricKey, this.timestamp);
        }

        public String toString() {
            return "MetricKeyAndTimestamp{metricKey=" + this.metricKey + ", timestamp=" + this.timestamp + '}';
        }
    }

    private static class MetricAndTimestamp {
        final SinglePointMetric metric;
        final Instant timestamp;

        MetricAndTimestamp(SinglePointMetric metric, Instant timestamp) {
            this.metric = metric;
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricAndTimestamp that = (MetricAndTimestamp)o;
            return this.metric.equals(that.metric) && this.timestamp.equals(that.timestamp);
        }

        public int hashCode() {
            return Objects.hash(this.metric, this.timestamp);
        }

        public String toString() {
            return "MetricAndTimestamp{metric=" + this.metric + ", timestamp=" + this.timestamp + '}';
        }
    }
}

