/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter;

import io.confluent.shaded.com.google.common.base.Preconditions;
import io.confluent.telemetry.exporter.Exporter;
import io.confluent.telemetry.metrics.Keyed;
import io.confluent.telemetry.metrics.SerializedMetric;
import java.util.function.Predicate;

public abstract class AbstractExporter
implements Exporter {
    private volatile Predicate<Keyed> metricsPredicate;

    public AbstractExporter() {
        this(k -> true);
    }

    public AbstractExporter(Predicate<Keyed> metricsPredicate) {
        this.metricsPredicate = metricsPredicate;
    }

    @Override
    public Predicate<Keyed> getPredicate() {
        return this.metricsPredicate;
    }

    @Override
    public void reconfigurePredicate(Predicate<Keyed> metricsPredicate) {
        Preconditions.checkNotNull(metricsPredicate, "metricsPredicate can't be null");
        this.metricsPredicate = metricsPredicate;
    }

    public abstract void doEmit(SerializedMetric var1);

    @Override
    public final boolean emit(SerializedMetric metric) {
        if (this.shouldEmitMetric(metric)) {
            this.doEmit(metric);
            return true;
        }
        return false;
    }

    private boolean shouldEmitMetric(Keyed key) {
        return this.metricsPredicate.test(key);
    }
}

