/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter;

import io.confluent.shaded.com.google.common.collect.ImmutableSet;
import io.confluent.telemetry.PredicateUtils;
import io.confluent.telemetry.RegexConfigDefValidator;
import io.confluent.telemetry.metrics.Keyed;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public abstract class ExporterConfig
extends AbstractConfig {
    public static final String ENABLED_CONFIG = "enabled";
    public static final String ENABLED_CONFIG_DOC = "Boolean value. True if exporter should be enabled, false otherwise. This is a mandatory field that has to be set for every exporter.";
    public static final String TYPE_CONFIG = "type";
    public static final String TYPE_CONFIG_DOC = "The type of the exporter. Value must be one of " + Arrays.asList(ExporterType.values());
    public static final String METRICS_INCLUDE_CONFIG = "metrics.include";
    public static final String METRICS_INCLUDE_CONFIG_DOC = "Regex matching the converted (snake_case) metric name to be published from this particular exporter.\n\nBy default this includes all the metrics required by Proactive Support and Self-balancing Clusters. This should typically never be modified unless requested by Confluent.";
    public static final String METRICS_ENABLED_CONFIG = "metrics.enabled";
    public static final String METRICS_ENABLED_CONFIG_DOC = "Boolean value. True if telemetry metrics should be reported.";
    public static final boolean METRICS_ENABLED_CONFIG_DEFAULT = true;
    public static final String EVENTS_ENABLED_CONFIG = "events.enabled";
    public static final String EVENTS_ENABLED_CONFIG_DOC = "Boolean value. True if telemetry events should be reported.";
    public static final boolean EVENTS_ENABLED_CONFIG_DEFAULT = true;
    public static final Set<String> RECONFIGURABLES = ImmutableSet.of("enabled", "metrics.include");

    private static ConfigDef defineExporterConfigs(ConfigDef def) {
        return new ConfigDef(def).define(ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.LOW, ENABLED_CONFIG_DOC).define(TYPE_CONFIG, ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)ConfigDef.LambdaValidator.with((name, value) -> ExporterConfig.parseType(value), () -> Arrays.asList(ExporterType.values()).toString()), ConfigDef.Importance.LOW, TYPE_CONFIG_DOC).define(METRICS_INCLUDE_CONFIG, ConfigDef.Type.STRING, null, new ConfigDef.Validator(){
            private final ConfigDef.Validator regexValidator = new RegexConfigDefValidator("Metrics filter for configuration");

            public void ensureValid(String name, Object value) {
                if (value != null) {
                    this.regexValidator.ensureValid(name, value);
                }
            }
        }, ConfigDef.Importance.LOW, METRICS_INCLUDE_CONFIG_DOC).define(METRICS_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, METRICS_ENABLED_CONFIG_DOC).define(EVENTS_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, EVENTS_ENABLED_CONFIG_DOC);
    }

    public static ExporterType parseType(Object value) {
        if (value == null || value.toString().isEmpty()) {
            throw new ConfigException("'type' is a required config");
        }
        try {
            return ExporterType.valueOf(value.toString());
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException("'type' must be one of: " + Arrays.asList(ExporterType.values()) + " however we found '" + value.toString() + "'");
        }
    }

    public ExporterConfig(ConfigDef definition, Map<?, ?> originals) {
        this(definition, originals, true);
    }

    public ExporterConfig(ConfigDef definition, Map<?, ?> originals, boolean doLog) {
        super(ExporterConfig.defineExporterConfigs(definition), originals, doLog);
    }

    public ExporterType getType() {
        return ExporterConfig.parseType(this.getString(TYPE_CONFIG));
    }

    public boolean isEnabled() {
        return this.getBoolean(ENABLED_CONFIG);
    }

    public boolean isMetricsEnabled() {
        return this.getBoolean(METRICS_ENABLED_CONFIG);
    }

    public Optional<Predicate<Keyed>> buildMetricsPredicate() {
        String includeList = this.getString(METRICS_INCLUDE_CONFIG);
        if (includeList != null) {
            return Optional.of(PredicateUtils.buildCachingMetricsPredicate(includeList));
        }
        return Optional.empty();
    }

    public static enum ExporterType {
        http,
        kafka;

    }
}

