/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter.http;

import io.confluent.shaded.com.google.common.annotations.VisibleForTesting;
import io.confluent.shaded.io.confluent.telemetry.client.BufferingAsyncTelemetryHttpClient;
import io.confluent.shaded.io.confluent.telemetry.client.BufferingAsyncTelemetryHttpClientBatchResult;
import io.confluent.shaded.io.confluent.telemetry.client.BufferingAsyncTelemetryHttpClientStats;
import io.confluent.shaded.io.confluent.telemetry.client.Credentials;
import io.confluent.shaded.io.confluent.telemetry.client.ProxyConfig;
import io.confluent.shaded.io.confluent.telemetry.client.TelemetryHttpClient;
import io.confluent.shaded.io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.confluent.shaded.io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceResponse;
import io.confluent.shaded.io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.confluent.telemetry.exporter.AbstractExporter;
import io.confluent.telemetry.exporter.http.HttpExporterConfig;
import io.confluent.telemetry.metrics.SerializedMetric;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.common.metrics.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpExporter
extends AbstractExporter {
    public static final String SELF_METRICS_GROUP = "HttpExporter";
    private static final Logger log = LoggerFactory.getLogger(HttpExporter.class);
    private static final Function<Collection<ResourceMetrics>, ExportMetricsServiceRequest> REQUEST_CONVERTER = metrics -> ExportMetricsServiceRequest.newBuilder().addAllResourceMetrics((Iterable<? extends ResourceMetrics>)metrics).build();
    private BufferingAsyncTelemetryHttpClient<ResourceMetrics, ExportMetricsServiceRequest, ExportMetricsServiceResponse> bufferingClient;
    @VisibleForTesting
    volatile Credentials credentials;
    @VisibleForTesting
    volatile ProxyConfig proxyConfig;
    private final String name;

    public HttpExporter(String name, HttpExporterConfig config) {
        this.name = Objects.requireNonNull(name);
        this.bufferingClient = config.getBufferingAsyncClientBuilder().setClient(config.configureClientDefaults(new TelemetryHttpClient.Builder()).setRequestSerializer((outputStream, message) -> message.writeTo(outputStream)).setResponseDeserializer(ExportMetricsServiceResponse::parseFrom).setEndpoint("/v1/metrics").setCredentialsSupplier(() -> this.credentials).setProxyConfigSupplier(() -> this.proxyConfig).build()).setCreateRequestFn(REQUEST_CONVERTER).build();
        this.bufferingClient.getBatchResults().doOnNext(this::trackMetricResponses);
        this.setDynamicFields(config);
    }

    public void setDynamicFields(HttpExporterConfig config) {
        this.credentials = config.getCredentials();
        if (this.credentials == null) {
            log.error("API Key/Secret are missing for the exporter '{}'. The exporter will not be able to emit metrics.", (Object)this.name);
        }
        this.proxyConfig = config.getProxyConfig();
    }

    private void trackMetricResponses(BufferingAsyncTelemetryHttpClientBatchResult<ResourceMetrics, ExportMetricsServiceResponse> batchResult) {
        if (!batchResult.isSuccess()) {
            log.error("Confluent Telemetry Metrics Failure", batchResult.getThrowable());
        }
    }

    @VisibleForTesting
    BufferingAsyncTelemetryHttpClientStats stats() {
        return this.bufferingClient.stats();
    }

    @Override
    public void doEmit(SerializedMetric metric) {
        if (this.credentials == null) {
            return;
        }
        this.bufferingClient.submit(Collections.singleton(metric.metric()));
    }

    @Override
    public void close() throws IOException {
        this.bufferingClient.close();
    }

    @Override
    public void setMetricsRegistry(Metrics metrics) {
        Map<String, String> tags = Collections.singletonMap("exporterName", this.name);
        metrics.addMetric(metrics.metricName("items-total", SELF_METRICS_GROUP, tags), (config, now) -> this.bufferingClient.stats().getTotalItems());
        metrics.addMetric(metrics.metricName("items-failed", SELF_METRICS_GROUP, tags), (config, now) -> this.bufferingClient.stats().getTotalFailedItems());
        metrics.addMetric(metrics.metricName("items-succeeded", SELF_METRICS_GROUP, tags), (config, now) -> this.bufferingClient.stats().getTotalSuccessfulItems());
        metrics.addMetric(metrics.metricName("batches-total", SELF_METRICS_GROUP, tags), (config, now) -> this.bufferingClient.stats().getTotalBatches());
        metrics.addMetric(metrics.metricName("batches-dropped", SELF_METRICS_GROUP, tags), (config, now) -> this.bufferingClient.stats().getTotalDroppedBatches());
        metrics.addMetric(metrics.metricName("batches-failed", SELF_METRICS_GROUP, tags), (config, now) -> this.bufferingClient.stats().getTotalFailedBatches());
        metrics.addMetric(metrics.metricName("batches-succeeded", SELF_METRICS_GROUP, tags), (config, now) -> this.bufferingClient.stats().getTotalSuccessfulBatches());
        metrics.addMetric(metrics.metricName("send-time-total-millis", SELF_METRICS_GROUP, tags), (config, now) -> this.bufferingClient.stats().getTotalSendTimeMs());
    }
}

