/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter.http;

import io.confluent.shaded.com.google.common.base.Strings;
import io.confluent.shaded.io.confluent.telemetry.client.BufferingAsyncTelemetryHttpClient;
import io.confluent.shaded.io.confluent.telemetry.client.CompressionAlgorithm;
import io.confluent.shaded.io.confluent.telemetry.client.Credentials;
import io.confluent.shaded.io.confluent.telemetry.client.ProxyConfig;
import io.confluent.shaded.io.confluent.telemetry.client.TelemetryHttpClient;
import io.confluent.shaded.io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.confluent.shaded.io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceResponse;
import io.confluent.shaded.io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.confluent.telemetry.exporter.ExporterConfig;
import java.net.URI;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpExporterConfig
extends ExporterConfig {
    private static final Logger log = LoggerFactory.getLogger(HttpExporterConfig.class);
    public static final String PREFIX_BUFFER = "buffer.";
    public static final String PREFIX_CLIENT = "client.";
    public static final String PREFIX_PROXY = "proxy.";
    public static final String API_KEY = "api.key";
    public static final String API_KEY_DOC = "The API key used to authenticate the requests made by HttpExporter";
    public static final String API_SECRET = "api.secret";
    public static final String API_SECRET_DOC = "The API secret used to authenticate requests made by HttpExporter";
    public static final String BUFFER_MAX_BATCH_DURATION_MS = "buffer.batch.duration.max.ms";
    public static final String BUFFER_MAX_BATCH_DURATION_MS_DOC = "The maximum duration (in millis) to buffer items before sending them upstream";
    public static final String BUFFER_MAX_BATCH_SIZE = "buffer.batch.items.max";
    public static final String BUFFER_MAX_BATCH_SIZE_DOC = "The maximum number of items to buffer into a batch before sending them upstream";
    public static final String BUFFER_MAX_PENDING_BATCHES = "buffer.pending.batches.max";
    public static final String BUFFER_MAX_PENDING_BATCHES_DOC = "The maximum number of pending batches. If more than this number of batches are pending(i.e. there is backpressure) then the oldest batches will be dropped.";
    public static final String BUFFER_MAX_INFLIGHT_SUBMISSIONS = "buffer.inflight.submissions.max";
    public static final String BUFFER_MAX_INFLIGHT_SUBMISSIONS_DOC = "The maximum number of in-flight calls to the HTTP service";
    public static final String CLIENT_BASE_URL = "client.base.url";
    public static final String CLIENT_BASE_URL_DOC = "The base URL for the telemetry receiver (i.e. https://host:port)";
    public static final String CLIENT_REQUEST_TIMEOUT_MS = "client.request.timeout.ms";
    public static final String CLIENT_REQUEST_TIMEOUT_MS_DOCS = "The request timeout in milliseconds";
    public static final String CLIENT_CONNECT_TIMEOUT_MS = "client.connect.timeout.ms";
    public static final String CLIENT_CONNECT_TIMEOUT_MS_DOC = "The connect timeout in milliseconds";
    public static final String CLIENT_MAX_ATTEMPTS = "client.attempts.max";
    public static final String CLIENT_MAX_ATTEMPTS_DOC = "The maximum number of delivery attempts";
    public static final String CLIENT_RETRY_DELAY_SEC = "client.retry.delay.seconds";
    public static final String CLIENT_RETRY_DELAY_SEC_DOC = "The delay, in seconds, between retry attempts";
    public static final String CLIENT_COMPRESSION = "client.compression";
    public static final String CLIENT_COMPRESSION_DOC = "HTTP Compression algorithm to use. Either gzip, lz4, or zstd.";
    public static final String CLIENT_CONTENT_TYPE = "client.contentType";
    public static final String CLIENT_CONTENT_TYPE_DOC = "HTTP Content-Type header.";
    public static final String PROXY_URL = "proxy.url";
    public static final String PROXY_URL_DOC = "The URL for an explicit (i.e. not transparent) forward HTTP proxy";
    public static final String PROXY_USERNAME = "proxy.username";
    public static final String PROXY_USERNAME_DOC = "The username credential for the forward HTTP proxy";
    public static final String PROXY_PASSWORD = "proxy.password";
    public static final String PROXY_PASSWORD_DOC = "The password credential for the forward HTTP proxy";
    public static final Set<String> RECONFIGURABLE_CONFIGS = Utils.mkSet((Object[])new String[]{"api.key", "api.secret", "proxy.url", "proxy.username", "proxy.password"});
    private static final ConfigDef CONFIG = new ConfigDef().define("api.key", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "The API key used to authenticate the requests made by HttpExporter").define("api.secret", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.HIGH, "The API secret used to authenticate requests made by HttpExporter").define("buffer.batch.duration.max.ms", ConfigDef.Type.LONG, null, ConfigDef.Importance.LOW, "The maximum duration (in millis) to buffer items before sending them upstream").define("buffer.batch.items.max", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The maximum number of items to buffer into a batch before sending them upstream").define("buffer.pending.batches.max", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The maximum number of pending batches. If more than this number of batches are pending(i.e. there is backpressure) then the oldest batches will be dropped.").define("buffer.inflight.submissions.max", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The maximum number of in-flight calls to the HTTP service").define("client.base.url", ConfigDef.Type.STRING, null, (ConfigDef.Validator)new URIValidator(), ConfigDef.Importance.LOW, "The base URL for the telemetry receiver (i.e. https://host:port)").define("client.compression", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "HTTP Compression algorithm to use. Either gzip, lz4, or zstd.").define("client.contentType", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "HTTP Content-Type header.").define("client.request.timeout.ms", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The request timeout in milliseconds").define("client.connect.timeout.ms", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The connect timeout in milliseconds").define("client.attempts.max", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The maximum number of delivery attempts").define("client.retry.delay.seconds", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The delay, in seconds, between retry attempts").define("proxy.url", ConfigDef.Type.STRING, null, (ConfigDef.Validator)new URIValidator(), ConfigDef.Importance.LOW, "The URL for an explicit (i.e. not transparent) forward HTTP proxy").define("proxy.username", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "The username credential for the forward HTTP proxy").define("proxy.password", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.LOW, "The password credential for the forward HTTP proxy");

    public static void main(String[] args) {
        System.out.println(CONFIG.toRst());
    }

    public HttpExporterConfig(Map<String, ?> originals) {
        this(originals, true);
    }

    public HttpExporterConfig(Map<String, ?> originals, boolean doLog) {
        super(CONFIG, originals, doLog);
    }

    public Credentials getCredentials() {
        return HttpExporterConfig.createValidatedCredentials(this.getApiKey(), this.getApiSecret(), "Must specify both api.key and api.secret");
    }

    public ProxyConfig getProxyConfig() {
        String proxyUrl = this.getProxyUrl();
        if (Strings.isNullOrEmpty(proxyUrl)) {
            return null;
        }
        URI proxyUri = URI.create(proxyUrl);
        Credentials credentials = HttpExporterConfig.createValidatedCredentials(this.getProxyUsername(), this.getProxyPassword(), "Must specify both proxy.username and proxy.password");
        return new ProxyConfig(proxyUri, credentials);
    }

    public CompressionAlgorithm getCompressionAlgorithm(String key) {
        String compressionName = this.getString(key);
        if (compressionName == null) {
            return null;
        }
        try {
            return CompressionAlgorithm.valueOf(compressionName.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            log.warn("Unsupported compression algorithm specified for Telemetry Metrics Reporter Client: {}", (Object)compressionName);
            return null;
        }
    }

    public <T, S> TelemetryHttpClient.Builder<T, S> configureClientDefaults(TelemetryHttpClient.Builder<T, S> builder) {
        Optional.ofNullable(this.getString(CLIENT_BASE_URL)).map(URI::create).ifPresent(builder::setBaseUrl);
        Optional.ofNullable(this.getInt(CLIENT_REQUEST_TIMEOUT_MS)).ifPresent(builder::setRequestTimeout);
        Optional.ofNullable(this.getInt(CLIENT_CONNECT_TIMEOUT_MS)).ifPresent(builder::setConnectTimeout);
        Optional.ofNullable(this.getInt(CLIENT_MAX_ATTEMPTS)).ifPresent(builder::setMaxAttempts);
        Optional.ofNullable(this.getInt(CLIENT_RETRY_DELAY_SEC)).ifPresent(builder::setRetryDelay);
        Optional.ofNullable(this.getCompressionAlgorithm(CLIENT_COMPRESSION)).ifPresent(builder::setCompression);
        Optional.ofNullable(this.getString(CLIENT_CONTENT_TYPE)).ifPresent(builder::setContentType);
        return builder;
    }

    public BufferingAsyncTelemetryHttpClient.Builder<ResourceMetrics, ExportMetricsServiceRequest, ExportMetricsServiceResponse> getBufferingAsyncClientBuilder() {
        BufferingAsyncTelemetryHttpClient.Builder<ResourceMetrics, ExportMetricsServiceRequest, ExportMetricsServiceResponse> builder = BufferingAsyncTelemetryHttpClient.newBuilder();
        Optional.ofNullable(this.getLong(BUFFER_MAX_BATCH_DURATION_MS)).map(Duration::ofMillis).ifPresent(builder::setMaxBatchDuration);
        Optional.ofNullable(this.getInt(BUFFER_MAX_BATCH_SIZE)).ifPresent(builder::setMaxBatchSize);
        Optional.ofNullable(this.getInt(BUFFER_MAX_PENDING_BATCHES)).ifPresent(builder::setMaxPendingBatches);
        Optional.ofNullable(this.getInt(BUFFER_MAX_INFLIGHT_SUBMISSIONS)).ifPresent(builder::setMaxInflightSubmissions);
        return builder;
    }

    public Boolean canEmitMetrics() {
        String apiKey = this.getApiKey();
        String apiSecretKey = this.getApiSecret();
        if (!Strings.isNullOrEmpty(apiKey) && !Strings.isNullOrEmpty(apiSecretKey)) {
            return true;
        }
        return false;
    }

    private String getApiKey() {
        return this.getString(API_KEY);
    }

    private String getApiSecret() {
        return Optional.ofNullable(this.getPassword(API_SECRET)).map(Password::value).orElse(null);
    }

    private String getProxyUrl() {
        return this.getString(PROXY_URL);
    }

    private String getProxyUsername() {
        return this.getString(PROXY_USERNAME);
    }

    private String getProxyPassword() {
        return Optional.ofNullable(this.getPassword(PROXY_PASSWORD)).map(Password::value).orElse(null);
    }

    private static Credentials createValidatedCredentials(String username, String password, String errorMessage) {
        if (Strings.isNullOrEmpty(username) && Strings.isNullOrEmpty(password)) {
            return null;
        }
        if (!Strings.isNullOrEmpty(username) && !Strings.isNullOrEmpty(password)) {
            return new Credentials(username, password);
        }
        throw new ConfigException(errorMessage);
    }

    public static class URIValidator
    implements ConfigDef.Validator {
        public void ensureValid(String name, Object value) {
            if (value == null) {
                return;
            }
            if (!(value instanceof String)) {
                throw new ConfigException("Valid URI expected: " + name);
            }
            try {
                URI.create((String)value);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigException(String.format("Invalid URI for property: %s (value: %s)", name, value));
            }
        }
    }
}

