/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.provider;

import io.confluent.shaded.com.google.common.annotations.VisibleForTesting;
import io.confluent.shaded.com.google.common.collect.ImmutableList;
import io.confluent.shaded.io.confluent.telemetry.ResourceBuilderFacade;
import io.confluent.shaded.io.opentelemetry.proto.resource.v1.Resource;
import io.confluent.telemetry.ConfluentTelemetryConfig;
import io.confluent.telemetry.Context;
import io.confluent.telemetry.collector.JvmMetricsCollector;
import io.confluent.telemetry.collector.MetricsCollector;
import io.confluent.telemetry.provider.Provider;
import io.confluent.telemetry.provider.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.metrics.MetricsContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStreamsProvider
implements Provider {
    @VisibleForTesting
    public static final String DOMAIN = "io.confluent.kafka.streams";
    public static final String NAMESPACE = "kafka.streams";
    public static final String STREAMS_APPLICATION_ID = "application.id";
    private static final Logger log = LoggerFactory.getLogger(KafkaStreamsProvider.class);
    private Resource resource;
    private ConfluentTelemetryConfig config;

    public synchronized void configure(Map<String, ?> configs) {
        this.config = new ConfluentTelemetryConfig(configs);
    }

    @Override
    public boolean validate(MetricsContext metricsContext, Map<String, ?> config) {
        return Utils.notEmptyString(config, STREAMS_APPLICATION_ID) && Utils.validateRequiredLabels(metricsContext.contextLabels());
    }

    @Override
    public void contextChange(MetricsContext metricsContext) {
        String clusterId = (String)metricsContext.contextLabels().get("resource.cluster.id");
        String streamsApplicationId = (String)this.config.originals().get(STREAMS_APPLICATION_ID);
        ResourceBuilderFacade resourceBuilderFacade = Utils.buildResourceFromLabelsWithId(metricsContext, clusterId).withNamespacedLabel(STREAMS_APPLICATION_ID, streamsApplicationId);
        this.resource = resourceBuilderFacade.build();
    }

    @Override
    public List<String> metricsIncludeRegexDefault() {
        return Collections.singletonList("io.confluent.system/.*(process_cpu_load|max_file_descriptor_count|open_file_descriptor_count|system_cpu_load|system_load_average|free_physical_memory_size|total_physical_memory_size|disk_total_bytes|disk_usable_bytes|jvm/mem|jvm/gc)");
    }

    @Override
    public Resource resource() {
        return this.resource;
    }

    @Override
    public String domain() {
        return DOMAIN;
    }

    @Override
    public List<MetricsCollector> extraCollectors(Context ctx) {
        return ImmutableList.of(JvmMetricsCollector.newBuilder().setContext(ctx).build());
    }
}

