/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.reporter;

import io.confluent.shaded.com.google.common.annotations.VisibleForTesting;
import io.confluent.shaded.com.google.common.base.Preconditions;
import io.confluent.shaded.com.google.common.collect.ImmutableList;
import io.confluent.shaded.com.google.common.collect.ImmutableMap;
import io.confluent.shaded.com.google.common.collect.Maps;
import io.confluent.shaded.com.google.common.collect.Sets;
import io.confluent.shaded.io.confluent.telemetry.client.TelemetryHttpClient;
import io.confluent.shaded.io.confluent.telemetry.config.FilterSetPredicate;
import io.confluent.shaded.io.confluent.telemetry.config.remote.RemoteConfigConfiguration;
import io.confluent.shaded.io.confluent.telemetry.config.remote.RemoteConfigurationRequest;
import io.confluent.shaded.io.confluent.telemetry.config.remote.RemoteConfigurationResponse;
import io.confluent.shaded.io.confluent.telemetry.config.remote.RemoteConfigurationSource;
import io.confluent.shaded.io.confluent.telemetry.config.remote.polling.HttpRemoteConfigurationSource;
import io.confluent.shaded.io.confluent.telemetry.config.remote.polling.PollingRemoteConfigurationConfig;
import io.confluent.shaded.io.confluent.telemetry.config.remote.polling.kubernetes.KubernetesConfigMapRemoteConfigurationConfig;
import io.confluent.shaded.io.confluent.telemetry.config.remote.polling.kubernetes.KubernetesConfigMapRemoteConfigurationSource;
import io.confluent.shaded.io.confluent.telemetry.config.remote.v1.RemoteConfiguration;
import io.confluent.shaded.io.confluent.telemetry.events.EventEmitterConfig;
import io.confluent.shaded.io.confluent.telemetry.events.EventEmitterImpl;
import io.confluent.shaded.io.confluent.telemetry.events.EventLogger;
import io.confluent.shaded.io.confluent.telemetry.events.EventLoggerFactory;
import io.confluent.shaded.io.confluent.telemetry.events.exporter.http.EventHttpExporter;
import io.confluent.shaded.io.opentelemetry.proto.common.v1.AnyValue;
import io.confluent.shaded.io.opentelemetry.proto.resource.v1.Resource;
import io.confluent.telemetry.BrokerConfigUtils;
import io.confluent.telemetry.ConfluentTelemetryConfig;
import io.confluent.telemetry.Context;
import io.confluent.telemetry.MetricsCollectorTask;
import io.confluent.telemetry.MetricsUtils;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.api.events.EventEmitter;
import io.confluent.telemetry.api.events.EventEmitterProvider;
import io.confluent.telemetry.api.events.NoOpEventEmitter;
import io.confluent.telemetry.collector.ConfluentMetricNamingConvention;
import io.confluent.telemetry.collector.KafkaMetricsCollector;
import io.confluent.telemetry.collector.MetricsCollector;
import io.confluent.telemetry.emitter.Emitter;
import io.confluent.telemetry.emitter.TelemetryEmitter;
import io.confluent.telemetry.exporter.AbstractExporter;
import io.confluent.telemetry.exporter.Exporter;
import io.confluent.telemetry.exporter.ExporterConfig;
import io.confluent.telemetry.exporter.http.HttpExporter;
import io.confluent.telemetry.exporter.http.HttpExporterConfig;
import io.confluent.telemetry.exporter.kafka.KafkaExporter;
import io.confluent.telemetry.exporter.kafka.KafkaExporterConfig;
import io.confluent.telemetry.metrics.Keyed;
import io.confluent.telemetry.provider.KafkaServerProvider;
import io.confluent.telemetry.provider.Provider;
import io.confluent.telemetry.provider.ProviderRegistry;
import io.confluent.telemetry.provider.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryReporter
implements MetricsReporter,
ClusterResourceListener,
EventEmitterProvider {
    private static final Logger log = LoggerFactory.getLogger(TelemetryReporter.class);
    public static final String SELF_METRICS_DOMAIN = "io.confluent.telemetry";
    public static final String SELF_METRICS_NAMESPACE = "confluent.telemetry";
    public static final String TELEMETRY_REPORTER_ID_TAG = "telemetry-reporter-id";
    private Map<String, Object> rawOriginalConfig;
    private ConfluentTelemetryConfig originalConfig;
    private ConfluentTelemetryConfig config;
    private volatile Context ctx;
    private MetricsCollectorTask collectorTask;
    private final Map<String, Exporter> exporters = new ConcurrentHashMap<String, Exporter>();
    private final List<MetricsCollector> collectors = new CopyOnWriteArrayList<MetricsCollector>();
    private volatile KafkaMetricsCollector kafkaMetricsCollector;
    private volatile TelemetryEmitter emitter;
    private Provider activeProvider;
    private RemoteConfigurationSource remoteConfigSource;
    private final EventLoggerFactory eventLoggerFactory;
    @VisibleForTesting
    volatile EventLogger configEventLogger;
    private volatile Optional<EventEmitterImpl> eventEmitterOpt;
    private Metrics selfMetrics;
    private FilterSetPredicate metricFilters;
    private Set<String> activeFilters = Collections.singleton("_default");
    private final Uuid reporterId = Uuid.randomUuid();

    public TelemetryReporter() {
        this(config -> {
            EventLogger eventLogger = new EventLogger();
            eventLogger.configure(config);
            return eventLogger;
        });
    }

    @VisibleForTesting
    public TelemetryReporter(EventLoggerFactory eventLoggerFactory) {
        this.eventLoggerFactory = eventLoggerFactory;
    }

    public synchronized void configure(Map<String, ?> configs) {
        this.rawOriginalConfig = configs;
        this.eventEmitterOpt = this.createEventEmitter(configs);
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        this.createConfiguration(configs, false);
    }

    public synchronized void reconfigure(Map<String, ?> newRawConfig) {
        Preconditions.checkState(this.config != null && this.emitter != null, "contextChange() was not called before reconfigure()");
        ConfluentTelemetryConfig oldConfig = this.config;
        this.config = this.createConfiguration(newRawConfig, true);
        this.metricFilters = this.config.getDefaultFilterSet().union(this.metricFilters);
        this.reconfigureEventLogger(oldConfig, this.config);
        Event configEvent = Utils.configEvent(this.config.originals(), this.activeProvider.configInclude(), this.ctx.getResource(), this.activeProvider, this.activeProvider.domain() + "/config/dynamic");
        if (this.activeProvider != null) {
            if (this.configEventLogger != null) {
                this.configEventLogger.log(configEvent);
            }
            this.eventEmitterOpt.ifPresent(eventEmitter -> eventEmitter.emit(configEvent));
        }
        this.reconfigureRemoteConfigSource(this.config);
        this.reconfigureExporters(oldConfig, this.config);
        this.reconfigureEventEmitter(newRawConfig);
        this.updateEmitterPredicate();
    }

    private ConfluentTelemetryConfig createConfiguration(Map<String, ?> configs, boolean doLog) {
        configs = ConfluentTelemetryConfig.reconcileConfigs(configs);
        HashMap<String, ?> validateConfig = Maps.newHashMap(this.originalConfig.originals());
        validateConfig.putAll(this.onlyReconfigurables(configs));
        return new ConfluentTelemetryConfig(validateConfig, doLog);
    }

    private void initExporters(Map<String, ExporterConfig> toInit) {
        for (Map.Entry<String, ExporterConfig> entry : toInit.entrySet()) {
            ExporterConfig exporterConfig = entry.getValue();
            String exporterName = entry.getKey();
            log.info("Creating {} exporter named '{}'", (Object)exporterConfig.getType().name(), (Object)exporterName);
            AbstractExporter newExporter = null;
            if (exporterConfig instanceof KafkaExporterConfig) {
                newExporter = KafkaExporter.newBuilder((KafkaExporterConfig)exporterConfig).setName(exporterName).build();
            } else if (exporterConfig instanceof HttpExporterConfig) {
                newExporter = new HttpExporter(exporterName, (HttpExporterConfig)exporterConfig);
            } else {
                throw new IllegalStateException("Unexpected exporter config: " + ((Object)((Object)exporterConfig)).getClass());
            }
            this.configureExporterPredicate(exporterConfig, newExporter);
            newExporter.setMetricsRegistry(this.selfMetrics);
            this.exporters.put(exporterName, newExporter);
        }
    }

    private void configureExporterPredicate(ExporterConfig exporterConfig, Exporter exporter) {
        exporter.reconfigurePredicate(exporterConfig.buildMetricsPredicate().orElse(this.metricFilters.subset(this.activeFilters)));
    }

    private void updateExporters(Map<String, ExporterConfig> toReconfigure) {
        for (Map.Entry<String, ExporterConfig> entry : toReconfigure.entrySet()) {
            Exporter exporter = this.exporters.get(entry.getKey());
            ExporterConfig exporterConfig = entry.getValue();
            if (exporter instanceof HttpExporter) {
                ((HttpExporter)exporter).setDynamicFields((HttpExporterConfig)exporterConfig);
            }
            this.configureExporterPredicate(exporterConfig, exporter);
        }
    }

    private void closeExporters(Map<String, ExporterConfig> toClose) {
        for (Map.Entry<String, ExporterConfig> entry : toClose.entrySet()) {
            log.info("Closing {} exporter named '{}'", (Object)entry.getValue().getType().name(), (Object)entry.getKey());
            Exporter exporter = this.exporters.remove(entry.getKey());
            try {
                exporter.close();
            }
            catch (Exception e) {
                log.warn("exception closing {} exporter named '{}'", new Object[]{entry.getValue().getType(), entry.getKey(), e});
            }
        }
    }

    private void reconfigureExporters(ConfluentTelemetryConfig oldConfig, ConfluentTelemetryConfig newConfig) {
        Set<String> oldEnabled = oldConfig.enabledExporters().keySet();
        Set<String> newEnabled = newConfig.enabledExporters().keySet();
        this.closeExporters(newConfig.allExportersWithNames(Sets.difference(oldEnabled, newEnabled)));
        this.updateExporters(newConfig.allExportersWithNames(Sets.intersection(oldEnabled, newEnabled)));
        this.initExporters(newConfig.allExportersWithNames(Sets.difference(newEnabled, oldEnabled)));
    }

    private void reconfigureRemoteConfigSource(ConfluentTelemetryConfig config) {
        Optional<RemoteConfigConfiguration> enabledRemoteConfigConfiguration = config.getRemoteConfigConfiguration();
        if (enabledRemoteConfigConfiguration.isPresent()) {
            RemoteConfigConfiguration remoteConfigSourceConfiguration = enabledRemoteConfigConfiguration.get();
            if (this.remoteConfigSource instanceof HttpRemoteConfigurationSource) {
                HttpExporterConfig exporterConfig = config.allHttpExporters().get("_confluent");
                if (exporterConfig == null) {
                    throw new ConfigException("Exporter '_confluent' config to use the HttpRemoteConfigurationSource.");
                }
                ((HttpRemoteConfigurationSource)this.remoteConfigSource).setProxyConfig(exporterConfig.getProxyConfig());
                ((HttpRemoteConfigurationSource)this.remoteConfigSource).setCredentials(exporterConfig.getCredentials());
            }
        }
    }

    public Set<String> reconfigurableConfigs() {
        if (this.config == null) {
            throw new IllegalStateException("contextChange() was not called before reconfigurableConfigs()");
        }
        HashSet<String> reconfigurables = new HashSet<String>(ConfluentTelemetryConfig.RECONFIGURABLES);
        for (String name : this.config.allExporters().keySet()) {
            reconfigurables.addAll(ExporterConfig.RECONFIGURABLES.stream().map(c -> ConfluentTelemetryConfig.exporterPrefixForName(name) + c).collect(Collectors.toSet()));
        }
        for (String name : this.config.allHttpExporters().keySet()) {
            reconfigurables.addAll(HttpExporterConfig.RECONFIGURABLE_CONFIGS.stream().map(c -> ConfluentTelemetryConfig.exporterPrefixForName(name) + c).collect(Collectors.toSet()));
        }
        return reconfigurables;
    }

    public synchronized void contextChange(MetricsContext metricsContext) {
        Preconditions.checkState(this.rawOriginalConfig != null, "configure() was not called before contextChange()");
        log.debug("metricsContext {}", (Object)metricsContext.contextLabels());
        if (!metricsContext.contextLabels().containsKey("_namespace")) {
            log.error("_namespace not found in metrics context. Metrics collection is disabled");
            return;
        }
        this.collectors.forEach(MetricsCollector::stop);
        this.activeProvider = ProviderRegistry.getProvider((String)metricsContext.contextLabels().get("_namespace"));
        if (this.activeProvider == null) {
            log.error("No provider was detected for context {}. Available providers {}.", (Object)metricsContext.contextLabels(), ProviderRegistry.providers.keySet());
            return;
        }
        log.debug("provider {} is selected.", (Object)this.activeProvider.getClass().getCanonicalName());
        if (!this.activeProvider.validate(metricsContext, this.rawOriginalConfig)) {
            log.warn("Validation failed for {} context {}", this.activeProvider.getClass(), (Object)metricsContext.contextLabels());
            return;
        }
        if (this.collectorTask == null) {
            this.activeProvider.configure(this.rawOriginalConfig);
        }
        this.activeProvider.contextChange(metricsContext);
        if (this.collectorTask == null) {
            this.initConfig();
            this.initContext();
            try {
                this.initRemoteConfig();
            }
            catch (RuntimeException e) {
                log.error("Unable to start Remote Configuration");
            }
            this.initSelfMetrics();
            this.initCollectors();
            this.initExporters(this.config.enabledExporters());
            this.createEmitter();
            this.updateEmitterPredicate();
            this.startMetricCollectorTask();
        }
        Event configEvent = Utils.configEvent(this.config.originals(), this.activeProvider.configInclude(), this.ctx.getResource(), this.activeProvider, this.activeProvider.domain() + "/config/static");
        this.eventEmitterOpt.ifPresent(eventEmitter -> {
            eventEmitter.setEventLabels(TelemetryReporter.eventLabels(this.activeProvider.resource()));
            eventEmitter.emit(configEvent);
        });
        if (this.configEventLogger != null) {
            this.configEventLogger.log(configEvent);
        }
    }

    private static Map<String, String> eventLabels(Resource resource) {
        return MetricsUtils.attributesMap(resource).entrySet().stream().filter(e -> !((String)e.getKey()).equals("type")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void initConfig() {
        this.originalConfig = new ConfluentTelemetryConfig(TelemetryReporter.injectProviderConfigs(this.activeProvider, this.rawOriginalConfig));
        this.maybeInitEventLogger(this.originalConfig);
        this.config = this.originalConfig;
        this.metricFilters = this.config.getDefaultFilterSet();
    }

    private void initContext() {
        Resource.Builder builder = this.activeProvider.resource().toBuilder();
        this.config.getLabels().forEach((k, v) -> builder.addAttributesBuilder().setKey((String)k).setValue(AnyValue.newBuilder().setStringValue((String)v)));
        Resource resource = builder.build();
        this.ctx = new Context(resource, this.activeProvider.domain(), this.config.getBoolean("confluent.telemetry.debug.enabled"));
    }

    private Map<String, Object> toEventLoggerConfig(ConfluentTelemetryConfig config) {
        ExporterConfig defaultHttpExporterConfig = config.allExporters().get("_confluent");
        if (defaultHttpExporterConfig == null) {
            throw new ConfigException("Expected exporter '_confluent' to exist but it does not.");
        }
        Map eventConfig = defaultHttpExporterConfig.originals();
        eventConfig.put("event.logger.exporter.class", EventHttpExporter.class.getCanonicalName());
        return eventConfig;
    }

    private void maybeInitEventLogger(ConfluentTelemetryConfig config) {
        if (config.getBoolean("confluent.telemetry.events.enable").booleanValue()) {
            this.initEventLogger(config);
        }
    }

    private void reconfigureEventLogger(ConfluentTelemetryConfig oldConfig, ConfluentTelemetryConfig newConfig) {
        boolean eventLoggerWasEnabled = oldConfig.getBoolean("confluent.telemetry.events.enable");
        boolean eventLoggerIsEnabled = newConfig.getBoolean("confluent.telemetry.events.enable");
        if (!eventLoggerIsEnabled) {
            this.closeEventLogger();
        } else if (eventLoggerWasEnabled) {
            this.reconfigureEventLogger(this.config);
        } else {
            this.initEventLogger(this.config);
        }
    }

    private void initEventLogger(ConfluentTelemetryConfig config) {
        if (this.configEventLogger != null) {
            log.warn("Trying to initialize the event logger but it's already initialized! Will not initialize another one...");
            return;
        }
        log.info("Initializing the event logger");
        this.configEventLogger = this.eventLoggerFactory.create(this.toEventLoggerConfig(config));
    }

    private void reconfigureEventLogger(ConfluentTelemetryConfig config) {
        if (this.configEventLogger == null) {
            log.warn("Trying to reconfigure the event logger but it's not initialized!");
            return;
        }
        this.configEventLogger.reconfigure(this.toEventLoggerConfig(config));
    }

    private void closeEventLogger() {
        if (this.configEventLogger == null) {
            return;
        }
        log.info("Closing the event logger");
        try {
            this.configEventLogger.close();
            this.configEventLogger = null;
        }
        catch (Exception e) {
            log.warn("Exception closing event logger", (Throwable)e);
        }
    }

    private void startMetricCollectorTask() {
        long collectIntervalMs = this.config.getLong("confluent.telemetry.metrics.collector.interval.ms");
        log.info("Starting Confluent telemetry reporter with an interval of {} ms)", (Object)collectIntervalMs);
        log.debug("Telemetry reporter resource attributes: {}", this.ctx.getResource().getAttributesList());
        this.collectorTask = new MetricsCollectorTask(this.collectors, collectIntervalMs, this.emitter);
        this.collectors.forEach(MetricsCollector::start);
        this.collectorTask.start();
    }

    private void initSelfMetrics() {
        final KafkaMetricsCollector selfMetricsCollector = new KafkaMetricsCollector(ConfluentMetricNamingConvention.forKafkaMetrics(SELF_METRICS_DOMAIN, this.ctx.isDebugEnabled(), this.ctx.isDebugEnabled()));
        this.collectors.add(selfMetricsCollector);
        MetricConfig config = new MetricConfig().tags(ImmutableMap.of(TELEMETRY_REPORTER_ID_TAG, this.reporterId.toString()));
        this.selfMetrics = new Metrics(config, ImmutableList.of(new JmxReporter(), new MetricsReporter(){

            public void init(List<KafkaMetric> metrics) {
                selfMetricsCollector.init(metrics);
            }

            public void metricChange(KafkaMetric metric) {
                selfMetricsCollector.metricChange(metric);
            }

            public void metricRemoval(KafkaMetric metric) {
                selfMetricsCollector.metricRemoval(metric);
            }

            public void close() {
            }

            public void configure(Map<String, ?> configs) {
            }
        }), Time.SYSTEM, (MetricsContext)new KafkaMetricsContext(SELF_METRICS_NAMESPACE));
    }

    private void initCollectors() {
        this.kafkaMetricsCollector = new KafkaMetricsCollector(ConfluentMetricNamingConvention.forKafkaMetrics(this.ctx.getDomain(), this.ctx.isDebugEnabled(), this.ctx.isDebugEnabled()));
        this.collectors.add(this.kafkaMetricsCollector);
        this.collectors.addAll(this.activeProvider.extraCollectors(this.ctx));
    }

    @VisibleForTesting
    Map<String, Exporter> getExporters() {
        return this.exporters;
    }

    @VisibleForTesting
    public List<MetricsCollector> getCollectors() {
        return this.collectors;
    }

    @VisibleForTesting
    Metrics getSelfMetrics() {
        return this.selfMetrics;
    }

    @VisibleForTesting
    Uuid getReporterId() {
        return this.reporterId;
    }

    public void close() {
        log.info("Stopping TelemetryReporter collectorTask");
        if (this.collectorTask != null) {
            this.collectorTask.close();
        }
        this.collectors.forEach(MetricsCollector::stop);
        this.closeEventLogger();
        for (Exporter exporter : this.exporters.values()) {
            try {
                exporter.close();
            }
            catch (Exception e) {
                log.error("Error while closing {}", (Object)exporter, (Object)e);
            }
        }
        this.closeEventEmitter();
        if (this.remoteConfigSource != null) {
            log.info("Stopping TelemetryReporter remoteConfigTask");
            this.remoteConfigSource.stop();
        }
        if (this.selfMetrics != null) {
            this.selfMetrics.close();
        }
    }

    public synchronized void onUpdate(ClusterResource clusterResource) {
    }

    public void init(List<KafkaMetric> metrics) {
        if (this.kafkaMetricsCollector != null) {
            this.kafkaMetricsCollector.init(metrics);
        }
    }

    private void initRemoteConfig() throws RuntimeException {
        if (this.remoteConfigSource != null) {
            return;
        }
        this.config.getRemoteConfigConfiguration().ifPresent(remoteConfigSourceConfiguration -> {
            if (remoteConfigSourceConfiguration instanceof KubernetesConfigMapRemoteConfigurationConfig) {
                try {
                    KubernetesConfigMapRemoteConfigurationConfig config = (KubernetesConfigMapRemoteConfigurationConfig)((Object)remoteConfigSourceConfiguration);
                    this.remoteConfigSource = new KubernetesConfigMapRemoteConfigurationSource(config, this::onRemoteConfigurationReceived);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else if (remoteConfigSourceConfiguration instanceof PollingRemoteConfigurationConfig) {
                HttpExporterConfig exporterConfig = this.config.allHttpExporters().get("_confluent");
                if (exporterConfig == null) {
                    throw new ConfigException("Exporter '_confluent' config to use the HttpRemoteConfigurationSource.");
                }
                this.remoteConfigSource = TelemetryReporter.createHttpRemoteConfigurationSource(this.ctx.getResource(), (PollingRemoteConfigurationConfig)((Object)remoteConfigSourceConfiguration), exporterConfig, this::onRemoteConfigurationReceived);
            } else {
                throw new RuntimeException("Remote Configuration Config not supported");
            }
            this.remoteConfigSource.start();
        });
    }

    private static HttpRemoteConfigurationSource createHttpRemoteConfigurationSource(Resource resource, PollingRemoteConfigurationConfig remoteConfig, HttpExporterConfig exporterConfig, Consumer<RemoteConfiguration> callback) {
        TelemetryHttpClient.Builder<RemoteConfigurationRequest, RemoteConfigurationResponse> builder = new TelemetryHttpClient.Builder<RemoteConfigurationRequest, RemoteConfigurationResponse>();
        exporterConfig.configureClientDefaults(builder);
        HttpRemoteConfigurationSource configSource = new HttpRemoteConfigurationSource(builder, remoteConfig.getRefreshInterval(), callback, resource);
        configSource.setProxyConfig(exporterConfig.getProxyConfig());
        configSource.setCredentials(exporterConfig.getCredentials());
        return configSource;
    }

    public void onRemoteConfigurationReceived(RemoteConfiguration remoteConf) {
        FilterSetPredicate newMetricFilters = new FilterSetPredicate(remoteConf.getFilters());
        this.metricFilters = this.config.getDefaultFilterSet().union(newMetricFilters);
        this.activeFilters = remoteConf.getActiveFilters();
        this.updateExporters(this.config.enabledExporters());
        this.updateEmitterPredicate();
    }

    public void metricChange(KafkaMetric metric) {
        if (this.kafkaMetricsCollector != null) {
            this.kafkaMetricsCollector.metricChange(metric);
        }
    }

    public void metricRemoval(KafkaMetric metric) {
        if (this.kafkaMetricsCollector != null) {
            this.kafkaMetricsCollector.metricRemoval(metric);
        }
    }

    private Map<String, ?> onlyReconfigurables(Map<String, ?> originals) {
        return this.reconfigurableConfigs().stream().filter(c -> originals.get(c) != null).collect(Collectors.toMap(c -> c, c -> originals.get(c)));
    }

    private void updateEmitterPredicate() {
        Predicate<Keyed> unionPredicate = this.getExporters().values().stream().map(Exporter::getPredicate).reduce(Predicate::or).orElse(metricKey -> false);
        this.emitter.reconfigurePredicate(unionPredicate);
    }

    private static Map<String, Object> prefixedExporterConfigs(String prefix, Map<String, Object> configs) {
        String exporterPrefix = ConfluentTelemetryConfig.exporterPrefixForName(prefix);
        return configs.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> exporterPrefix + (String)e.getKey(), e -> e.getValue()));
    }

    protected static Map<String, Object> injectProviderConfigs(Provider provider, Map<String, Object> originals) {
        return TelemetryReporter.maybeInjectLocalExporter(provider, TelemetryReporter.maybeInjectProviderDefaultIncludeConfig(provider, originals));
    }

    private static Map<String, Object> maybeInjectProviderDefaultIncludeConfig(Provider provider, Map<String, Object> originals) {
        if (!originals.containsKey("confluent.telemetry.metrics.collector.include") && !originals.containsKey("confluent.telemetry.metrics.collector.whitelist")) {
            return TelemetryReporter.updateMetricsInclude(originals, provider.metricsIncludeRegexDefault());
        }
        return originals;
    }

    private static Map<String, Object> updateMetricsInclude(Map<String, Object> originals, List<String> includeList) {
        HashMap<String, Object> configs = new HashMap<String, Object>(originals);
        String selfMetricsIncludeRegex = "io.confluent.telemetry/.*";
        configs.put("confluent.telemetry.metrics.collector.include", ConfluentTelemetryConfig.joinIncludeRegexList((List<String>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(selfMetricsIncludeRegex)).addAll(includeList)).build())));
        return configs;
    }

    private static boolean isRunningInsideBroker(Provider provider, Map<String, Object> originals) {
        if (provider instanceof KafkaServerProvider) {
            Object processRoles = originals.getOrDefault("process.roles", "");
            String processRolesToString = processRoles.toString();
            boolean isKRaftRemoteController = processRolesToString.contains("controller") && !processRolesToString.contains("broker");
            return !isKRaftRemoteController;
        }
        return false;
    }

    private static Map<String, Object> maybeInjectLocalExporter(Provider provider, Map<String, Object> originals) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        if (TelemetryReporter.isRunningInsideBroker(provider, originals)) {
            configs.putAll(TelemetryReporter.prefixedExporterConfigs("_local", ConfluentTelemetryConfig.EXPORTER_LOCAL_DEFAULTS));
            configs.putAll(TelemetryReporter.prefixedExporterConfigs("_local", BrokerConfigUtils.deriveLocalProducerConfigs(originals)));
            String balanceReplicationFactor = BrokerConfigUtils.getBalanceReplicationFactor(originals);
            if (balanceReplicationFactor != null) {
                configs.putAll(TelemetryReporter.prefixedExporterConfigs("_local", ImmutableMap.of("topic.replicas", balanceReplicationFactor)));
            }
        }
        configs.putAll(originals);
        return configs;
    }

    @VisibleForTesting
    Context getContext() {
        return this.ctx;
    }

    public Emitter emitter() {
        if (this.emitter == null) {
            throw new IllegalStateException("emitter() was called before the Emitter was instantiated.");
        }
        return this.emitter;
    }

    private void createEmitter() {
        this.emitter = new TelemetryEmitter(this.ctx, this.exporters::values, this.selfMetrics);
    }

    @Override
    public EventEmitter eventEmitter() {
        return this.eventEmitterOpt.isPresent() ? (EventEmitter)this.eventEmitterOpt.get() : NoOpEventEmitter.INSTANCE;
    }

    private void closeEventEmitter() {
        this.eventEmitterOpt.ifPresent(eventEmitter -> {
            try {
                eventEmitter.close();
            }
            catch (Exception e) {
                log.error("Error while closing {}", eventEmitter, (Object)e);
            }
        });
    }

    private Optional<EventEmitterImpl> createEventEmitter(Map<String, ?> configs) {
        Optional<EventEmitterImpl> eventEmitterOpt = Optional.empty();
        if (this.maybeInitEventEmitter(configs)) {
            eventEmitterOpt = Optional.of(new EventEmitterImpl(configs));
        }
        return eventEmitterOpt;
    }

    private void reconfigureEventEmitter(Map<String, ?> configs) {
        this.closeEventEmitter();
        this.eventEmitterOpt = this.createEventEmitter(configs);
        this.eventEmitterOpt.ifPresent(eventEmitter -> eventEmitter.setEventLabels(TelemetryReporter.eventLabels(this.activeProvider.resource())));
    }

    private boolean maybeInitEventEmitter(Map<String, ?> configs) {
        EventEmitterConfig config = new EventEmitterConfig(configs);
        Map<String, Map<String, Object>> eventExporterConfigs = config.getEnabledExporterConfigs(EventEmitterConfig.EventType.events);
        if (eventExporterConfigs == null || eventExporterConfigs.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Map<String, Object>> entry : eventExporterConfigs.entrySet()) {
            if (!config.isKafkaExporter(entry.getValue())) continue;
            return true;
        }
        return false;
    }
}

