/*
 * Decompiled with CFR 0.152.
 */
package com.segment.analytics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.segment.analytics.AnalyticsRequestInterceptor;
import com.segment.analytics.Callback;
import com.segment.analytics.Log;
import com.segment.analytics.MessageInterceptor;
import com.segment.analytics.MessageTransformer;
import com.segment.analytics.Platform;
import com.segment.analytics.Plugin;
import com.segment.analytics.gson.AutoValueAdapterFactory;
import com.segment.analytics.gson.ISO8601DateAdapter;
import com.segment.analytics.http.SegmentService;
import com.segment.analytics.internal.AnalyticsClient;
import com.segment.analytics.internal.AnalyticsVersion;
import com.segment.analytics.messages.Message;
import com.segment.analytics.messages.MessageBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class Analytics {
    private final AnalyticsClient client;
    private final List<MessageTransformer> messageTransformers;
    private final List<MessageInterceptor> messageInterceptors;
    private final Log log;

    Analytics(AnalyticsClient client, List<MessageTransformer> messageTransformers, List<MessageInterceptor> messageInterceptors, Log log) {
        this.client = client;
        this.messageTransformers = messageTransformers;
        this.messageInterceptors = messageInterceptors;
        this.log = log;
    }

    public static Builder builder(String writeKey) {
        return new Builder(writeKey);
    }

    public void enqueue(MessageBuilder builder) {
        Message message = this.buildMessage(builder);
        if (message == null) {
            return;
        }
        this.client.enqueue(message);
    }

    public boolean offer(MessageBuilder builder) {
        Message message = this.buildMessage(builder);
        if (message == null) {
            return false;
        }
        return this.client.offer(message);
    }

    public void flush() {
        this.client.flush();
    }

    public void shutdown() {
        this.client.shutdown();
    }

    private Message buildMessage(MessageBuilder builder) {
        for (MessageTransformer messageTransformer : this.messageTransformers) {
            boolean shouldContinue = messageTransformer.transform(builder);
            if (shouldContinue) continue;
            this.log.print(Log.Level.VERBOSE, "Skipping message %s.", builder);
            return null;
        }
        Message message = builder.build();
        for (MessageInterceptor messageInterceptor : this.messageInterceptors) {
            message = messageInterceptor.intercept(message);
            if (message != null) continue;
            this.log.print(Log.Level.VERBOSE, "Skipping message %s.", builder);
            return null;
        }
        return message;
    }

    public static class Builder {
        private static final String DEFAULT_ENDPOINT = "https://api.segment.io";
        private static final String DEFAULT_PATH = "/v1/import/";
        private static final String DEFAULT_USER_AGENT = "analytics-java/" + AnalyticsVersion.get();
        private final String writeKey;
        private OkHttpClient client;
        private Log log;
        public HttpUrl endpoint;
        public HttpUrl uploadURL;
        private String userAgent = DEFAULT_USER_AGENT;
        private List<MessageTransformer> messageTransformers;
        private List<MessageInterceptor> messageInterceptors;
        private ExecutorService networkExecutor;
        private ThreadFactory threadFactory;
        private int flushQueueSize;
        private int maximumFlushAttempts;
        private long flushIntervalInMillis;
        private List<Callback> callbacks;
        private int queueCapacity;

        Builder(String writeKey) {
            if (writeKey == null || writeKey.trim().length() == 0) {
                throw new NullPointerException("writeKey cannot be null or empty.");
            }
            this.writeKey = writeKey;
        }

        public Builder client(OkHttpClient client) {
            if (client == null) {
                throw new NullPointerException("Null client");
            }
            this.client = client;
            return this;
        }

        public Builder log(Log log) {
            if (log == null) {
                throw new NullPointerException("Null log");
            }
            this.log = log;
            return this;
        }

        public Builder endpoint(String endpoint) {
            if (endpoint == null || endpoint.trim().length() == 0) {
                throw new NullPointerException("endpoint cannot be null or empty.");
            }
            this.endpoint = HttpUrl.parse((String)(endpoint + DEFAULT_PATH));
            return this;
        }

        public Builder setUploadURL(String uploadURL) {
            if (uploadURL == null || uploadURL.trim().length() == 0) {
                throw new NullPointerException("Upload URL cannot be null or empty.");
            }
            this.uploadURL = HttpUrl.parse((String)uploadURL);
            return this;
        }

        public Builder userAgent(String userAgent) {
            if (userAgent == null || userAgent.trim().length() == 0) {
                throw new NullPointerException("userAgent cannot be null or empty.");
            }
            this.userAgent = userAgent;
            return this;
        }

        public Builder messageTransformer(MessageTransformer transformer) {
            if (transformer == null) {
                throw new NullPointerException("Null transformer");
            }
            if (this.messageTransformers == null) {
                this.messageTransformers = new ArrayList<MessageTransformer>();
            }
            if (this.messageTransformers.contains(transformer)) {
                throw new IllegalStateException("MessageTransformer is already registered.");
            }
            this.messageTransformers.add(transformer);
            return this;
        }

        public Builder messageInterceptor(MessageInterceptor interceptor) {
            if (interceptor == null) {
                throw new NullPointerException("Null interceptor");
            }
            if (this.messageInterceptors == null) {
                this.messageInterceptors = new ArrayList<MessageInterceptor>();
            }
            if (this.messageInterceptors.contains(interceptor)) {
                throw new IllegalStateException("MessageInterceptor is already registered.");
            }
            this.messageInterceptors.add(interceptor);
            return this;
        }

        public Builder queueCapacity(int capacity) {
            if (capacity <= 0) {
                throw new IllegalArgumentException("capacity should be positive.");
            }
            this.queueCapacity = capacity;
            return this;
        }

        public Builder flushQueueSize(int flushQueueSize) {
            if (flushQueueSize < 1) {
                throw new IllegalArgumentException("flushQueueSize must not be less than 1.");
            }
            this.flushQueueSize = flushQueueSize;
            return this;
        }

        public Builder flushInterval(long flushInterval, TimeUnit unit) {
            long flushIntervalInMillis = unit.toMillis(flushInterval);
            if (flushIntervalInMillis < 1000L) {
                throw new IllegalArgumentException("flushInterval must not be less than 1 second.");
            }
            this.flushIntervalInMillis = flushIntervalInMillis;
            return this;
        }

        public Builder retries(int maximumRetries) {
            if (maximumRetries < 1) {
                throw new IllegalArgumentException("retries must be at least 1");
            }
            this.maximumFlushAttempts = maximumRetries;
            return this;
        }

        public Builder networkExecutor(ExecutorService networkExecutor) {
            if (networkExecutor == null) {
                throw new NullPointerException("Null networkExecutor");
            }
            this.networkExecutor = networkExecutor;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            if (threadFactory == null) {
                throw new NullPointerException("Null threadFactory");
            }
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder callback(Callback callback) {
            if (callback == null) {
                throw new NullPointerException("Null callback");
            }
            if (this.callbacks == null) {
                this.callbacks = new ArrayList<Callback>();
            }
            if (this.callbacks.contains(callback)) {
                throw new IllegalStateException("Callback is already registered.");
            }
            this.callbacks.add(callback);
            return this;
        }

        public Builder plugin(Plugin plugin) {
            if (plugin == null) {
                throw new NullPointerException("Null plugin");
            }
            plugin.configure(this);
            return this;
        }

        public Analytics build() {
            Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new AutoValueAdapterFactory()).registerTypeAdapter(Date.class, (Object)new ISO8601DateAdapter()).create();
            if (this.endpoint == null) {
                this.endpoint = HttpUrl.parse((String)"https://api.segment.io/v1/import/");
            }
            if (this.endpoint == null && this.uploadURL != null) {
                this.endpoint = this.uploadURL;
            }
            if (this.client == null) {
                this.client = Platform.get().defaultClient();
            }
            if (this.log == null) {
                this.log = Log.NONE;
            }
            if (this.flushIntervalInMillis == 0L) {
                this.flushIntervalInMillis = Platform.get().defaultFlushIntervalInMillis();
            }
            if (this.queueCapacity == 0) {
                this.queueCapacity = Integer.MAX_VALUE;
            }
            if (this.flushQueueSize == 0) {
                this.flushQueueSize = Platform.get().defaultFlushQueueSize();
            }
            this.messageTransformers = this.messageTransformers == null ? Collections.emptyList() : Collections.unmodifiableList(this.messageTransformers);
            this.messageInterceptors = this.messageInterceptors == null ? Collections.emptyList() : Collections.unmodifiableList(this.messageInterceptors);
            if (this.networkExecutor == null) {
                this.networkExecutor = Platform.get().defaultNetworkExecutor();
            }
            if (this.threadFactory == null) {
                this.threadFactory = Platform.get().defaultThreadFactory();
            }
            this.callbacks = this.callbacks == null ? Collections.emptyList() : Collections.unmodifiableList(this.callbacks);
            HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor(new HttpLoggingInterceptor.Logger(){

                public void log(String message) {
                    log.print(Log.Level.VERBOSE, "%s", message);
                }
            });
            interceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
            this.client = this.client.newBuilder().addInterceptor((Interceptor)new AnalyticsRequestInterceptor(this.writeKey, this.userAgent)).addInterceptor((Interceptor)interceptor).build();
            Retrofit restAdapter = new Retrofit.Builder().addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).baseUrl(this.endpoint).client(this.client).build();
            SegmentService segmentService = (SegmentService)restAdapter.create(SegmentService.class);
            AnalyticsClient analyticsClient = AnalyticsClient.create(segmentService, this.queueCapacity, this.flushQueueSize, this.flushIntervalInMillis, this.maximumFlushAttempts, this.log, this.threadFactory, this.networkExecutor, this.callbacks);
            return new Analytics(analyticsClient, this.messageTransformers, this.messageInterceptors, this.log);
        }
    }
}

