/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import com.typesafe.scalalogging.Logger;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.coordinator.quota.ComputedQuotasCacheEntry;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaCoordinatorConfig$;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntityCoordinatorEpoch;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.QuotaStateManager$;
import kafka.log.AbstractLog;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.tier.fetcher.TierFetchDataInfo;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AbstractFetchDataInfo;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011mr!B&M\u0011\u0003\u0019f!B+M\u0011\u00031\u0006\"B/\u0002\t\u0003q\u0006bB0\u0002\u0005\u0004%\t\u0001\u0019\u0005\u0007Y\u0006\u0001\u000b\u0011B1\t\u000f5\f!\u0019!C\u0001A\"1a.\u0001Q\u0001\n\u0005Dqa\\\u0001C\u0002\u0013\u0005\u0001\r\u0003\u0004q\u0003\u0001\u0006I!\u0019\u0005\u0006c\u0006!\tA\u001d\u0005\b\u0003\u0003\tA\u0011AA\u0002\u0011\u001d\t9\"\u0001C\u0001\u00033Aq!!\u000b\u0002\t\u0003\tYC\u0002\u0004\u00022\u0005\u0001\u00111\u0007\u0005\u0007;6!\t!a\u0016\t\u000f\u0005uS\u0002\"\u0001\u0002`!9\u00111R\u0001\u0005\u0002\u00055e!B+M\u0001\u0005\u0015\u0006BCAZ#\t\u0005\t\u0015!\u0003\u00026\"Q\u00111X\t\u0003\u0002\u0003\u0006I!!0\t\u0015\u00055\u0017C!A!\u0002\u0013\ty\r\u0003\u0006\u0002ZF\u0011\t\u0011)A\u0005\u00037D!\"!:\u0012\u0005\u0003\u0005\u000b\u0011BAt\u0011\u0019i\u0016\u0003\"\u0001\u0002r\"I\u0011q`\tC\u0002\u0013%!\u0011\u0001\u0005\t\u0005?\t\u0002\u0015!\u0003\u0003\u0004!I!\u0011E\tC\u0002\u0013%!1\u0005\u0005\t\u0005W\t\u0002\u0015!\u0003\u0003&!Y!QF\tA\u0002\u0003\u0007I\u0011\u0002B\u0018\u0011-\u0011\t$\u0005a\u0001\u0002\u0004%IAa\r\t\u0017\te\u0012\u00031A\u0001B\u0003&!1\u0003\u0005\n\u0005\u0007\n\"\u0019!C\u0005\u0005\u000bB\u0001B!\u0017\u0012A\u0003%!q\t\u0005\n\u00057\n\"\u0019!C\u0005\u0005;B\u0001B!\u001a\u0012A\u0003%!q\f\u0005\n\u0005O\n\"\u0019!C\u0005\u0005;B\u0001B!\u001b\u0012A\u0003%!q\f\u0005\n\u0005W\n\"\u0019!C\u0005\u0005;B\u0001B!\u001c\u0012A\u0003%!q\f\u0005\n\u0005_\n\"\u0019!C\u0005\u0005cB\u0001Ba \u0012A\u0003%!1\u000f\u0005\n\u0005\u0003\u000b\"\u0019!C\u0005\u0005\u0007C\u0001Ba%\u0012A\u0003%!Q\u0011\u0005\n\u0005+\u000b\"\u0019!C\u0005\u0005/C\u0001Ba(\u0012A\u0003%!\u0011\u0014\u0005\n\u0005C\u000b\"\u0019!C\u0005\u0005/C\u0001Ba)\u0012A\u0003%!\u0011\u0014\u0005\b\u0005K\u000bB\u0011\u0001BT\u0011\u001d\u0011Y,\u0005C\u0001\u0005{CqAa2\u0012\t\u0003\u0011I\rC\u0004\u0003NF!\tAa4\t\u000f\tM\u0017\u0003\"\u0001\u0003V\"9!\u0011\\\t\u0005\u0002\tm\u0007b\u0002Bs#\u0011%!q\u001d\u0005\t\u0005\u007f\fB\u0011\u0001'\u0004\u0002!A1qA\t\u0005\u00021\u001bI\u0001\u0003\u0005\u0004\u000eE!\t\u0001TB\b\u0011\u001d\u0019\u0019\"\u0005C\u0005\u0007+Aqaa\b\u0012\t\u0003\u0019\t\u0003C\u0004\u0004,E!Ia!\f\t\u000f\rM\u0012\u0003\"\u0001\u00046!I1QM\t\u0012\u0002\u0013\u00051q\r\u0005\b\u0007{\nB\u0011BB@\u0011\u001d\u0019))\u0005C\u0005\u0007\u000fCqa!2\u0012\t\u0013\u00199\rC\u0004\u0004RF!Iaa5\t\u000f\r\u001d\u0018\u0003\"\u0003\u0004j\"91Q_\t\u0005\n\r]\bb\u0002C\u0004#\u0011%A\u0011\u0002\u0005\b\t#\tB\u0011\u0002C\n\u0011\u001d!)\"\u0005C\u0005\t'Aq\u0001b\u0006\u0012\t\u0003!I\u0002C\u0004\u0005\u001eE!\t\u0001b\b\t\u000f\u0011E\u0012\u0003\"\u0001\u0005\u0014!9A1G\t\u0005\u0002\u0011U\u0012!E)v_R\f7\u000b^1uK6\u000bg.Y4fe*\u0011QJT\u0001\u0006cV|G/\u0019\u0006\u0003\u001fB\u000b1bY8pe\u0012Lg.\u0019;pe*\t\u0011+A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005Q\u000bQ\"\u0001'\u0003#E+x\u000e^1Ti\u0006$X-T1oC\u001e,'o\u0005\u0002\u0002/B\u0011\u0001lW\u0007\u00023*\t!,A\u0003tG\u0006d\u0017-\u0003\u0002]3\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A*\u0002\u00195+GO]5dg\u001e\u0013x.\u001e9\u0016\u0003\u0005\u0004\"AY5\u000f\u0005\r<\u0007C\u00013Z\u001b\u0005)'B\u00014S\u0003\u0019a$o\\8u}%\u0011\u0001.W\u0001\u0007!J,G-\u001a4\n\u0005)\\'AB*ue&twM\u0003\u0002i3\u0006iQ*\u001a;sS\u000e\u001cxI]8va\u0002\na\u0002T8bIRKW.Z*f]N|'/A\bM_\u0006$G+[7f'\u0016t7o\u001c:!\u0003Eau.\u00193GC&dWO]3TK:\u001cxN]\u0001\u0013\u0019>\fGMR1jYV\u0014XmU3og>\u0014\b%\u0001\bsK\u0006$W*Z:tC\u001e,7*Z=\u0015\u0005M4\bC\u0001+u\u0013\t)HJA\u0006Rk>$\u0018-\u00128uSRL\b\"B<\n\u0001\u0004A\u0018A\u00022vM\u001a,'\u000f\u0005\u0002z}6\t!P\u0003\u0002|y\u0006\u0019a.[8\u000b\u0003u\fAA[1wC&\u0011qP\u001f\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018\u0001\u0005:fC\u0012lUm]:bO\u00164\u0016\r\\;f)\u0019\t)!!\u0005\u0002\u0016A)\u0001,a\u0002\u0002\f%\u0019\u0011\u0011B-\u0003\r=\u0003H/[8o!\r!\u0016QB\u0005\u0004\u0003\u001fa%AC)v_R\fWI\u001c;ss\"1\u00111\u0003\u0006A\u0002M\f1\"];pi\u0006,e\u000e^5us\")qO\u0003a\u0001q\u0006i\u0011/^8uC\u0016sGO]=LKf$B!a\u0007\u0002(A)\u0001,!\b\u0002\"%\u0019\u0011qD-\u0003\u000b\u0005\u0013(/Y=\u0011\u0007a\u000b\u0019#C\u0002\u0002&e\u0013AAQ=uK\"1\u00111C\u0006A\u0002M\fq\"];pi\u0006,e\u000e\u001e:z-\u0006dW/\u001a\u000b\u0005\u00037\ti\u0003C\u0004\u000201\u0001\r!a\u0003\u0002\u0015E,x\u000e^1F]R\u0014\u0018P\u0001\u000eRk>$\u0018-\u00128ueflUm]:bO\u00164uN]7biR,'oE\u0003\u000e\u0003k\t\t\u0005\u0005\u0003\u00028\u0005uRBAA\u001d\u0015\r\tY\u0004`\u0001\u0005Y\u0006tw-\u0003\u0003\u0002@\u0005e\"AB(cU\u0016\u001cG\u000f\u0005\u0003\u0002D\u0005MSBAA#\u0015\u0011\t9%!\u0013\u0002\r\r|W.\\8o\u0015\r\t\u00161\n\u0006\u0005\u0003\u001b\ny%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003#\n1a\u001c:h\u0013\u0011\t)&!\u0012\u0003!5+7o]1hK\u001a{'/\\1ui\u0016\u0014HCAA-!\r\tY&D\u0007\u0002\u0003\u00059qO]5uKR{GCBA1\u0003O\nY\bE\u0002Y\u0003GJ1!!\u001aZ\u0005\u0011)f.\u001b;\t\u000f\u0005%t\u00021\u0001\u0002l\u0005q1m\u001c8tk6,'OU3d_J$\u0007\u0003CA7\u0003o\nY\"a\u0007\u000e\u0005\u0005=$\u0002BA9\u0003g\n\u0001bY8ogVlWM\u001d\u0006\u0005\u0003k\nI%A\u0004dY&,g\u000e^:\n\t\u0005e\u0014q\u000e\u0002\u000f\u0007>t7/^7feJ+7m\u001c:e\u0011\u001d\tih\u0004a\u0001\u0003\u007f\naa\\;uaV$\b\u0003BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u0015E0\u0001\u0002j_&!\u0011\u0011RAB\u0005-\u0001&/\u001b8u'R\u0014X-Y7\u0002/\u0019|'/\\1u%\u0016\u001cwN\u001d3LKf\fe\u000e\u001a,bYV,G\u0003BAH\u0003/\u0003r\u0001WAI\u0003+\u000b)*C\u0002\u0002\u0014f\u0013a\u0001V;qY\u0016\u0014\u0004\u0003\u0002-\u0002\b\u0005Dq!!'\u0011\u0001\u0004\tY*\u0001\u0004sK\u000e|'\u000f\u001a\t\u0005\u0003;\u000b\t+\u0004\u0002\u0002 *!\u0011\u0011TA#\u0013\u0011\t\u0019+a(\u0003\rI+7m\u001c:e'\u0011\tr+a*\u0011\t\u0005%\u0016qV\u0007\u0003\u0003WS1!!,Q\u0003\u0015)H/\u001b7t\u0013\u0011\t\t,a+\u0003\u000f1{wmZ5oO\u000611m\u001c8gS\u001e\u00042\u0001VA\\\u0013\r\tI\f\u0014\u0002\u0017#V|G/Y\"p_J$\u0017N\\1u_J\u001cuN\u001c4jO\u0006I1o\u00195fIVdWM\u001d\t\u0005\u0003\u007f\u000bI-\u0004\u0002\u0002B*!\u00111YAc\u0003\u0011)H/\u001b7\u000b\t\u0005\u001d\u0017\u0011J\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005-\u0017\u0011\u0019\u0002\n'\u000eDW\rZ;mKJ\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0003\u0002R\u0006UWBAAj\u0015\r\t9\rU\u0005\u0005\u0003/\f\u0019N\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u000f5,GO]5dgB!\u0011Q\\Aq\u001b\t\tyN\u0003\u0003\u0002Z\u0006\u0015\u0013\u0002BAr\u0003?\u0014q!T3ue&\u001c7/\u0001\u0003uS6,\u0007\u0003BAu\u0003[l!!a;\u000b\t\u00055\u0016QI\u0005\u0005\u0003_\fYO\u0001\u0003US6,G\u0003DAz\u0003k\f90!?\u0002|\u0006u\bC\u0001+\u0012\u0011\u001d\t\u0019l\u0006a\u0001\u0003kCq!a/\u0018\u0001\u0004\ti\fC\u0004\u0002N^\u0001\r!a4\t\u000f\u0005ew\u00031\u0001\u0002\\\"9\u0011Q]\fA\u0002\u0005\u001d\u0018aE2p[B,H/\u001a3Rk>$\u0018m]\"bG\",WC\u0001B\u0002!!\u0011)Aa\u0004\u0003\u0014\teQB\u0001B\u0004\u0015\u0011\u0011IAa\u0003\u0002\u000f5,H/\u00192mK*\u0019!QB-\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0012\t\u001d!aA'baB\u0019\u0001L!\u0006\n\u0007\t]\u0011LA\u0002J]R\u00042\u0001\u0016B\u000e\u0013\r\u0011i\u0002\u0014\u0002\u0019\u0007>l\u0007/\u001e;fIF+x\u000e^1t\u0007\u0006\u001c\u0007.Z#oiJL\u0018\u0001F2p[B,H/\u001a3Rk>$\u0018m]\"bG\",\u0007%A\bd_6\u0004(/Z:tS>tG+\u001f9f+\t\u0011)\u0003\u0005\u0003\u0002\u001e\n\u001d\u0012\u0002\u0002B\u0015\u0003?\u0013qbQ8naJ,7o]5p]RK\b/Z\u0001\u0011G>l\u0007O]3tg&|g\u000eV=qK\u0002\n\u0001$];pi\u0006$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u+\t\u0011\u0019\"\u0001\u000frk>$\u0018\rV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]R|F%Z9\u0015\t\u0005\u0005$Q\u0007\u0005\n\u0005oi\u0012\u0011!a\u0001\u0005'\t1\u0001\u001f\u00132\u0003e\tXo\u001c;b)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e\u001e\u0011)\u0007y\u0011i\u0004E\u0002Y\u0005\u007fI1A!\u0011Z\u0005!1x\u000e\\1uS2,\u0017A\u00059beRLG/[8o'R\fG/\u001a'pG.,\"Aa\u0012\u0011\t\t%#QK\u0007\u0003\u0005\u0017RAA!\u0014\u0003P\u0005)An\\2lg*!!\u0011\u000bB*\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003\u0007d\u0018\u0002\u0002B,\u0005\u0017\u0012aCU3f]R\u0014\u0018M\u001c;SK\u0006$wK]5uK2{7m[\u0001\u0014a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0019>\u001c7\u000eI\u0001\u0012Y>\fG-\u001b8h!\u0006\u0014H/\u001b;j_:\u001cXC\u0001B0!\u0019\u0011)A!\u0019\u0003\u0014%!!1\rB\u0004\u0005\r\u0019V\r^\u0001\u0013Y>\fG-\u001b8h!\u0006\u0014H/\u001b;j_:\u001c\b%A\bpo:,G\rU1si&$\u0018n\u001c8t\u0003AywO\\3e!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\tgC&dW\r\u001a)beRLG/[8og\u0006\tb-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u0019MDW\u000f\u001e;j]\u001e$un\u001e8\u0016\u0005\tM\u0004\u0003\u0002B;\u0005wj!Aa\u001e\u000b\t\te$qJ\u0001\u0007CR|W.[2\n\t\tu$q\u000f\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u001bMDW\u000f\u001e;j]\u001e$un\u001e8!\u0003M)\u0007o\\2i\r>\u0014\b+\u0019:uSRLwN\\%e+\t\u0011)\t\u0005\u0005\u0003\b\n%%1\u0003BG\u001b\t\u0011y%\u0003\u0003\u0003\f\n=#!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB!\u0011q\u0007BH\u0013\u0011\u0011\t*!\u000f\u0003\u000f%sG/Z4fe\u0006!R\r]8dQ\u001a{'\u000fU1si&$\u0018n\u001c8JI\u0002\n1\u0003]1si&$\u0018n\u001c8M_\u0006$7+\u001a8t_J,\"A!'\u0011\t\u0005u'1T\u0005\u0005\u0005;\u000byN\u0001\u0004TK:\u001cxN]\u0001\u0015a\u0006\u0014H/\u001b;j_:du.\u00193TK:\u001cxN\u001d\u0011\u00025A\f'\u000f^5uS>tGj\\1e\r\u0006LG.\u001e:f'\u0016t7o\u001c:\u00027A\f'\u000f^5uS>tGj\\1e\r\u0006LG.\u001e:f'\u0016t7o\u001c:!\u0003]\u0011XmY8naV$X\rZ)v_R\fWI\u001c;ji&,7\u000f\u0006\u0002\u0003*B)!1\u0016B[g:!!Q\u0016BY\u001d\r!'qV\u0005\u00025&\u0019!1W-\u0002\u000fA\f7m[1hK&!!q\u0017B]\u0005!IE/\u001a:bE2,'b\u0001BZ3\u0006yqn\u001e8t#V|G/Y#oi&$\u0018\u0010\u0006\u0003\u0003@\n\u0015\u0007c\u0001-\u0003B&\u0019!1Y-\u0003\u000f\t{w\u000e\\3b]\"1\u00111\u0003\u0019A\u0002M\fA#[:M_\u0006$\u0017N\\4Rk>$\u0018-\u00128uSRLH\u0003\u0002B`\u0005\u0017Da!a\u00052\u0001\u0004\u0019\u0018\u0001C4fiF+x\u000e^1\u0015\t\u0005\u0015!\u0011\u001b\u0005\u0007\u0003'\u0011\u0004\u0019A:\u0002'\u001d,G/\u00118e\u001b\u0006L(-\u001a)viF+x\u000e^1\u0015\t\u0005-!q\u001b\u0005\u0007\u0003'\u0019\u0004\u0019A:\u0002\u001d1|\u0017\rZ)v_R\f7\u000b^1uKR1\u0011\u0011\rBo\u0005CDqAa85\u0001\u0004\u0011\u0019\"A\u000brk>$\u0018\rV8qS\u000e\u0004\u0016M\u001d;ji&|g.\u00133\t\u000f\t\rH\u00071\u0001\u0003\u0014\u0005\u00012m\\8sI&t\u0017\r^8s\u000bB|7\r[\u0001\u000bY>\fG-U;pi\u0006\u001cH\u0003CA1\u0005S\u0014\u0019P!>\t\u000f\t-X\u00071\u0001\u0003n\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BA\"\u0005_LAA!=\u0002F\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007b\u0002Brk\u0001\u0007!1\u0003\u0005\b\u0005o,\u0004\u0019\u0001B}\u0003-\u0019H/\u0019:u)&lW-T:\u0011\t\u0005]\"1`\u0005\u0005\u0005{\fID\u0001\u0003M_:<\u0017aE1eI2{\u0017\rZ5oOB\u000b'\u000f^5uS>tG\u0003\u0002B`\u0007\u0007Aqa!\u00027\u0001\u0004\u0011\u0019\"A\u0005qCJ$\u0018\u000e^5p]\u0006\t\u0012\r\u001a3Po:,G\rU1si&$\u0018n\u001c8\u0015\t\u0005\u000541\u0002\u0005\b\u0007\u000b9\u0004\u0019\u0001B\n\u0003Q\u0011X-\\8wK>;h.\u001a3QCJ$\u0018\u000e^5p]R!\u0011\u0011MB\t\u0011\u001d\u0019)\u0001\u000fa\u0001\u0005'\tA\u0002Z8M_\u0006$\u0017+^8uCN$Baa\u0006\u0004\u001eA9\u0011\u0011VB\rg\u0006-\u0011\u0002BB\u000e\u0003W\u0013A\u0001U8pY\"9!1^\u001dA\u0002\t5\u0018\u0001E;oY>\fG-U;pi\u0006\u001cF/\u0019;f)\u0019\t\tga\t\u0004(!91Q\u0005\u001eA\u0002\tM\u0011AD9v_R\f\u0007+\u0019:uSRLwN\u001c\u0005\b\u0005GT\u0004\u0019AB\u0015!\u0015A\u0016q\u0001B\n\u0003A\u0011X-\\8wKF+x\u000e^1Ti\u0006$X\r\u0006\u0004\u0002b\r=2\u0011\u0007\u0005\b\u0005W\\\u0004\u0019\u0001Bw\u0011\u001d\u0011\u0019o\u000fa\u0001\u0007S\t1b\u001d;pe\u0016\fVo\u001c;bgRA\u0011\u0011MB\u001c\u0007\u0007\u001aY\u0006C\u0004\u0004:q\u0002\raa\u000f\u00021E,x\u000e^1F]R\u0014\u0018.Z:QKJ\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0005\u0004>\r}\"Q^B!\u001b\t\u0011Y!\u0003\u0003\u0003\u0012\t-\u0001C\u0002BV\u0005k\u000bY\u0001C\u0004\u0004Fq\u0002\raa\u0012\u0002!I,7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0007c\u0002-\u0004J\r5\u0013\u0011M\u0005\u0004\u0007\u0017J&!\u0003$v]\u000e$\u0018n\u001c82!!\u0019ida\u0010\u0003\u0014\r=\u0003\u0003BB)\u0007/j!aa\u0015\u000b\t\rU\u0013QI\u0001\taJ|Go\\2pY&!1\u0011LB*\u0005\u0019)%O]8sg\"I1Q\f\u001f\u0011\u0002\u0003\u00071qL\u0001\re\u0016\fX/Z:u\u0019>\u001c\u0017\r\u001c\t\u0005\u0003#\u001c\t'\u0003\u0003\u0004d\u0005M'\u0001\u0004*fcV,7\u000f\u001e'pG\u0006d\u0017!F:u_J,\u0017+^8uCN$C-\u001a4bk2$HeM\u000b\u0003\u0007SRCaa\u0018\u0004l-\u00121Q\u000e\t\u0005\u0007_\u001aI(\u0004\u0002\u0004r)!11OB;\u0003%)hn\u00195fG.,GMC\u0002\u0004xe\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0019Yh!\u001d\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0005hKRl\u0015mZ5d)\u0011\u0019\tia!\u0011\u000ba\u000b9!!\t\t\u000f\r\u0015a\b1\u0001\u0003\u0014\u0005\u0011\u0012\r\u001d9f]\u0012\fVo\u001c;b\u001b\u0016\u001c8/Y4f)!\t\tg!#\u0004\u0016\u000e]\u0005bBBF\u007f\u0001\u00071QR\u0001\be\u0016\u001cwN\u001d3t!!\u0019ida\u0010\u0003n\u000e=\u0005\u0003BAO\u0007#KAaa%\u0002 \niQ*Z7pef\u0014VmY8sINDqa!\u0018@\u0001\u0004\u0019y\u0006C\u0004\u0004\u001a~\u0002\raa'\u0002\u0011\r\fG\u000e\u001c2bG.\u0004r\u0001WB%\u0007;\u000b\t\u0007\u0005\u0005\u0004>\r}\"Q^BP!\u0011\u0019\tka0\u000f\t\r\r6\u0011\u0018\b\u0005\u0007K\u001b)L\u0004\u0003\u0004(\u000eMf\u0002BBU\u0007csAaa+\u00040:\u0019Am!,\n\u0005\u0005E\u0013\u0002BA'\u0003\u001fJ1!UA&\u0013\u0011\t9%!\u0013\n\t\r]\u0016QI\u0001\te\u0016\fX/Z:ug&!11XB_\u0003=\u0001&o\u001c3vG\u0016\u0014Vm\u001d9p]N,'\u0002BB\\\u0003\u000bJAa!1\u0004D\n\t\u0002+\u0019:uSRLwN\u001c*fgB|gn]3\u000b\t\rm6QX\u0001\u001c[\u0006L(-Z+qI\u0006$XmQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\u0015\r\t}6\u0011ZBg\u0011\u001d\u0019Y\r\u0011a\u0001\u0005'\t1\u0002]1si&$\u0018n\u001c8JI\"91q\u001a!A\u0002\r%\u0012\u0001C3q_\u000eDw\n\u001d;\u0002M]\u0014\u0018\u000e^3U_6\u00147\u000f^8oKN4uN]#ya&\u0014X\rZ)v_R\fWI\u001c;ji&,7\u000f\u0006\u0005\u0002b\rU7q[Br\u0011\u001d\u0019)#\u0011a\u0001\u0005[Dqa!7B\u0001\u0004\u0019Y.A\nfqBL'/\u001a3G_J\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0004\u0003,\nU6Q\u001c\t\u0004)\u000e}\u0017bABq\u0019\nY\u0012+^8uC\u0016sG/\u001b;z\u0007>|'\u000fZ5oCR|'/\u00129pG\"Dqa!:B\u0001\u0004\u0019y)\u0001\tu_6\u00147\u000f^8oKJ+7m\u001c:eg\u0006a1\u000f[8vY\u0012,\u0005\u0010]5sKR1!qXBv\u0007[Dq!a\fC\u0001\u0004\tY\u0001C\u0004\u0004p\n\u0003\ra!=\u0002\u001b\r,(O]3oiRKW.Z't!\rA61_\u0005\u0004\u0005{L\u0016!F7bs\n,\u0017\t\u001d9f]\u0012,\u0005\u0010]5sCRLwN\u001c\u000b\t\u0005\u007f\u001bIpa?\u0005\u0006!1\u00111C\"A\u0002MDqa!@D\u0001\u0004\u0019y0\u0001\bsK\u000e|'\u000fZ:Ck&dG-\u001a:\u0011\t\u0005uE\u0011A\u0005\u0005\t\u0007\tyJ\u0001\u000bNK6|'/\u001f*fG>\u0014Hm\u001d\"vS2$WM\u001d\u0005\b\u0007_\u001c\u0005\u0019ABy\u0003e\u0011X-\\8wK\u0016C\b/\u001b:fIF+x\u000e^1F]R\u0014\u0018.Z:\u0015\r\u0005\u0005D1\u0002C\u0007\u0011\u001d\u0019)\u0003\u0012a\u0001\u0005[Dq\u0001b\u0004E\u0001\u0004\u0011I\"\u0001\rd_6\u0004X\u000f^3e#V|G/Y:DC\u000eDW-\u00128uef\f1C]3n_Z,W\t\u001f9je\u0016$\u0017+^8uCN$\"!!\u0019\u0002/M\u001c\u0007.\u001a3vY\u0016\fVo\u001c;b\u000bb\u0004\u0018N]1uS>t\u0017\u0001\u00049beRLG/[8o\r>\u0014H\u0003\u0002B\n\t7Aa!a\u0005H\u0001\u0004\u0019\u0018aB:uCJ$X\u000f\u001d\u000b\u0007\u0003C\"\t\u0003b\u000b\t\u000f\u0011\r\u0002\n1\u0001\u0005&\u0005\u0001#/\u001a;sS\u00164X-U;pi\u0006$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u!\u0015AFq\u0005B\n\u0013\r!I#\u0017\u0002\n\rVt7\r^5p]BBq\u0001\"\fI\u0001\u0004!y#\u0001\tnCf\u0014Wm\u0011:fCR,Gk\u001c9jGB)\u0001\fb\n\u0002b\u0005A1\u000f[;uI><h.A\u0006sK\u000e|gNZ5hkJ,G\u0003BA1\toAq\u0001\"\u000fK\u0001\u0004\t),A\u0005oK^\u001cuN\u001c4jO\u0002")
public class QuotaStateManager
implements Logging {
    private final QuotaCoordinatorConfig config;
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final Metrics metrics;
    private final Time time;
    private final scala.collection.mutable.Map<Object, ComputedQuotasCacheEntry> computedQuotasCache;
    private final CompressionType compressionType;
    private volatile int quotaTopicPartitionCount;
    private final ReentrantReadWriteLock partitionStateLock;
    private final Set<Object> loadingPartitions;
    private final Set<Object> ownedPartitions;
    private final Set<Object> failedPartitions;
    private final AtomicBoolean shuttingDown;
    private final ConcurrentHashMap<Object, Integer> epochForPartitionId;
    private final Sensor partitionLoadSensor;
    private final Sensor partitionLoadFailureSensor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Tuple2<Option<String>, Option<String>> formatRecordKeyAndValue(Record record) {
        return QuotaStateManager$.MODULE$.formatRecordKeyAndValue(record);
    }

    public static byte[] quotaEntryValue(QuotaEntry quotaEntry) {
        return QuotaStateManager$.MODULE$.quotaEntryValue(quotaEntry);
    }

    public static byte[] quotaEntryKey(QuotaEntity quotaEntity) {
        return QuotaStateManager$.MODULE$.quotaEntryKey(quotaEntity);
    }

    public static Option<QuotaEntry> readMessageValue(QuotaEntity quotaEntity, ByteBuffer buffer) {
        return QuotaStateManager$.MODULE$.readMessageValue(quotaEntity, buffer);
    }

    public static QuotaEntity readMessageKey(ByteBuffer buffer) {
        return QuotaStateManager$.MODULE$.readMessageKey(buffer);
    }

    public static String LoadFailureSensor() {
        return QuotaStateManager$.MODULE$.LoadFailureSensor();
    }

    public static String LoadTimeSensor() {
        return QuotaStateManager$.MODULE$.LoadTimeSensor();
    }

    public static String MetricsGroup() {
        return QuotaStateManager$.MODULE$.MetricsGroup();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private scala.collection.mutable.Map<Object, ComputedQuotasCacheEntry> computedQuotasCache() {
        return this.computedQuotasCache;
    }

    private CompressionType compressionType() {
        return this.compressionType;
    }

    private int quotaTopicPartitionCount() {
        return this.quotaTopicPartitionCount;
    }

    private void quotaTopicPartitionCount_$eq(int x$1) {
        this.quotaTopicPartitionCount = x$1;
    }

    private ReentrantReadWriteLock partitionStateLock() {
        return this.partitionStateLock;
    }

    private Set<Object> loadingPartitions() {
        return this.loadingPartitions;
    }

    private Set<Object> ownedPartitions() {
        return this.ownedPartitions;
    }

    private Set<Object> failedPartitions() {
        return this.failedPartitions;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ConcurrentHashMap<Object, Integer> epochForPartitionId() {
        return this.epochForPartitionId;
    }

    private Sensor partitionLoadSensor() {
        return this.partitionLoadSensor;
    }

    private Sensor partitionLoadFailureSensor() {
        return this.partitionLoadFailureSensor;
    }

    public Iterable<QuotaEntity> recomputedQuotaEntities() {
        return (Iterable)this.computedQuotasCache().values().flatMap((Function1 & Serializable)x$2 -> x$2.computedQuotas().keys());
    }

    public boolean ownsQuotaEntity(QuotaEntity quotaEntity) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.partitionStateLock(), (JFunction0.mcZ.sp & Serializable)() -> this.ownedPartitions().contains((Object)BoxesRunTime.boxToInteger((int)this.partitionFor(quotaEntity)))));
    }

    public boolean isLoadingQuotaEntity(QuotaEntity quotaEntity) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.partitionStateLock(), (JFunction0.mcZ.sp & Serializable)() -> this.loadingPartitions().contains((Object)BoxesRunTime.boxToInteger((int)this.partitionFor(quotaEntity)))));
    }

    public Option<QuotaEntry> getQuota(QuotaEntity quotaEntity) {
        Option computedQuotasOpt = this.computedQuotasCache().get((Object)BoxesRunTime.boxToInteger((int)this.partitionFor(quotaEntity))).map((Function1 & Serializable)cacheEntry -> cacheEntry.computedQuotas());
        if (computedQuotasOpt instanceof Some) {
            Pool computedQuotas = (Pool)((Some)computedQuotasOpt).value();
            if (computedQuotas.contains(quotaEntity)) {
                return new Some(computedQuotas.get(quotaEntity));
            }
            return None$.MODULE$;
        }
        if (None$.MODULE$.equals(computedQuotasOpt)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)computedQuotasOpt);
    }

    public QuotaEntry getAndMaybePutQuota(QuotaEntity quotaEntity2) {
        int partition = this.partitionFor(quotaEntity2);
        Option option = this.computedQuotasCache().get((Object)BoxesRunTime.boxToInteger((int)partition));
        if (option instanceof Some) {
            ((ComputedQuotasCacheEntry)((Some)option).value()).computedQuotas().getAndMaybePut(quotaEntity2);
        } else if (None$.MODULE$.equals(option)) {
            Pool<QuotaEntity, QuotaEntry> computedQuotas = new Pool<QuotaEntity, QuotaEntry>((Option<Function1<QuotaEntity, QuotaEntry>>)new Some((Function1 & Serializable)quotaEntity -> new QuotaEntry((QuotaEntity)quotaEntity, $this.time.milliseconds())));
            this.computedQuotasCache().put((Object)BoxesRunTime.boxToInteger((int)partition), (Object)new ComputedQuotasCacheEntry(Predef$.MODULE$.Integer2int(this.epochForPartitionId().get(BoxesRunTime.boxToInteger((int)partition))), computedQuotas));
            computedQuotas.getAndMaybePut(quotaEntity2);
        } else {
            throw new MatchError((Object)option);
        }
        return ((ComputedQuotasCacheEntry)this.computedQuotasCache().apply((Object)BoxesRunTime.boxToInteger((int)partition))).computedQuotas().getAndMaybePut(quotaEntity2);
    }

    public void loadQuotaState(int quotaTopicPartitionId, int coordinatorEpoch) {
        TopicPartition topicPartition = new TopicPartition("_confluent-quotas", quotaTopicPartitionId);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Scheduling loading of quota state from ").append(topicPartition).append(" for epoch ").append(coordinatorEpoch).toString());
        long startTimeMs = this.time.milliseconds();
        this.scheduler.scheduleOnce(new StringBuilder(5).append("load-").append(topicPartition).toString(), () -> this.loadQuotas(topicPartition, coordinatorEpoch, Predef$.MODULE$.long2Long(startTimeMs)));
    }

    private void loadQuotas(TopicPartition topicPartition, int coordinatorEpoch, Long startTimeMs) {
        if (!this.maybeUpdateCoordinatorEpoch(topicPartition.partition(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch)))) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Not loading quota state for ").append(topicPartition).append(" ").append("in epoch ").append(coordinatorEpoch).append(" since current epoch is ").append(this.epochForPartitionId().get(BoxesRunTime.boxToInteger((int)topicPartition.partition()))).toString());
            return;
        }
        if (!this.addLoadingPartition(topicPartition.partition())) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Already loaded quota state from ").append(topicPartition).toString());
            return;
        }
        try {
            try {
                this.replicaManager.logManager().abortAndPauseCleaning(topicPartition);
                long schedulerTimeMs = this.time.milliseconds() - Predef$.MODULE$.Long2long(startTimeMs);
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Started loading quota state from ").append(topicPartition).append(" for epoch ").append(coordinatorEpoch).toString());
                Pool<QuotaEntity, QuotaEntry> quotaEntries = this.doLoadQuotas(topicPartition);
                long endTimeMs = this.time.milliseconds();
                long totalLoadingTimeMs = endTimeMs - Predef$.MODULE$.Long2long(startTimeMs);
                this.partitionLoadSensor().record((double)totalLoadingTimeMs, endTimeMs, false);
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(117).append("Finished loading ").append(quotaEntries.size()).append(" quota entries from ").append(topicPartition).append(" ").append("in ").append(totalLoadingTimeMs).append(" milliseconds for epoch ").append(coordinatorEpoch).append(", of which ").append(schedulerTimeMs).append(" milliseconds was spent in the scheduler.").toString());
                CoreUtils$.MODULE$.inWriteLock(this.partitionStateLock(), (Function0 & Serializable)() -> {
                    if (this.loadingPartitions().contains((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()))) {
                        this.computedQuotasCache().put((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new ComputedQuotasCacheEntry(coordinatorEpoch, quotaEntries)).foreach((Function1 & Serializable)previousComputedQuotasCacheEntry -> {
                            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Unloaded computed quotas ").append(previousComputedQuotasCacheEntry).append(" from ").append(topicPartition$2).append(" as part of ").append("loading metadata at epoch ").append(coordinatorEpoch$2).toString());
                            return BoxedUnit.UNIT;
                        });
                        this.ownedPartitions().add((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
                        return BoxesRunTime.boxToBoolean((boolean)this.loadingPartitions().remove((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
                    }
                    return BoxedUnit.UNIT;
                });
            }
            catch (UnsupportedVersionException e) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Failed loading quota state from ").append(topicPartition).append(" due to ").append(e.getMessage()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                this.partitionLoadFailureSensor().record();
                CoreUtils$.MODULE$.inWriteLock(this.partitionStateLock(), (JFunction0.mcZ.sp & Serializable)() -> {
                    this.ownedPartitions().add((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
                    return this.loadingPartitions().remove((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
                });
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Failed loading quota state from ").append(topicPartition).append(" due to ").append(t.getMessage()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                this.partitionLoadFailureSensor().record();
                CoreUtils$.MODULE$.inWriteLock(this.partitionStateLock(), (JFunction0.mcZ.sp & Serializable)() -> {
                    this.ownedPartitions().remove((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
                    this.failedPartitions().add((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
                    return this.loadingPartitions().remove((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
                });
            }
        }
        finally {
            this.replicaManager.logManager().resumeCleaning(topicPartition);
        }
    }

    public boolean addLoadingPartition(int partition) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.partitionStateLock(), (JFunction0.mcZ.sp & Serializable)() -> {
            if (this.ownedPartitions().contains((Object)BoxesRunTime.boxToInteger((int)partition))) {
                return false;
            }
            return this.loadingPartitions().add((Object)BoxesRunTime.boxToInteger((int)partition));
        }));
    }

    public void addOwnedPartition(int partition) {
        CoreUtils$.MODULE$.inWriteLock(this.partitionStateLock(), (JFunction0.mcZ.sp & Serializable)() -> this.ownedPartitions().add((Object)BoxesRunTime.boxToInteger((int)partition)));
    }

    public void removeOwnedPartition(int partition) {
        CoreUtils$.MODULE$.inWriteLock(this.partitionStateLock(), (JFunction0.mcZ.sp & Serializable)() -> this.ownedPartitions().remove((Object)BoxesRunTime.boxToInteger((int)partition)));
    }

    private Pool<QuotaEntity, QuotaEntry> doLoadQuotas(TopicPartition topicPartition) {
        BufferSupplier bufferSupplier = BufferSupplier.create();
        Pool<QuotaEntity, QuotaEntry> computedQuotas = new Pool<QuotaEntity, QuotaEntry>((Option<Function1<QuotaEntity, QuotaEntry>>)new Some((Function1 & Serializable)quotaEntity -> new QuotaEntry((QuotaEntity)quotaEntity, $this.time.milliseconds())));
        Option<AbstractLog> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Attempted to load quota state from ").append(topicPartition).append(", but found no log").toString());
        } else if (option instanceof Some) {
            AbstractLog log = (AbstractLog)((Some)option).value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            LongRef currOffset = LongRef.create((long)log.logStartOffset());
            boolean readAtLeastOneRecord = true;
            while (currOffset.elem < this.logEndOffset$1(topicPartition) && readAtLeastOneRecord && !this.shuttingDown().get()) {
                MemoryRecords memoryRecords;
                AbstractFetchDataInfo abstractFetchDataInfo = log.read(currOffset.elem, this.config.loadBufferSize(), FetchIsolation.LOG_END, true, false);
                if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
                    if (abstractFetchDataInfo instanceof TierFetchDataInfo) {
                        throw new IllegalStateException("Unexpected tiered segment for _confluent-quotas topic");
                    }
                    throw new IllegalStateException(new StringBuilder(52).append("Unexpected implementation of AbstractFetchDataInfo: ").append(abstractFetchDataInfo.getClass()).toString());
                }
                FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
                readAtLeastOneRecord = fetchDataInfo.records.sizeInBytes() > 0;
                Records records = fetchDataInfo.records;
                if (records instanceof MemoryRecords) {
                    memoryRecords = (MemoryRecords)records;
                } else if (records instanceof FileRecords) {
                    FileRecords fileRecords = (FileRecords)records;
                    int sizeInBytes = fileRecords.sizeInBytes();
                    int bytesNeeded = Math.max(this.config.loadBufferSize(), sizeInBytes);
                    if (buffer.capacity() < bytesNeeded) {
                        if (this.config.loadBufferSize() < bytesNeeded) {
                            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(106).append("Loaded quota state from ").append(topicPartition).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").append("configured quota.topic.load.buffer.size (").append($this.config.loadBufferSize()).append(" bytes)").toString());
                        }
                        buffer = ByteBuffer.allocate(bytesNeeded);
                    } else {
                        buffer.clear();
                    }
                    fileRecords.readInto(buffer, 0);
                    memoryRecords = new MemoryRecords(buffer);
                } else {
                    throw new MatchError((Object)records);
                }
                memoryRecords.batches().forEach(batch -> {
                    try (CloseableIterator iterator = batch.streamingIterator(bufferSupplier);){
                        CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)iterator).asScala().foreach((Function1 & Serializable)record -> {
                            Predef$.MODULE$.require(record.hasKey(), (Function0 & Serializable)() -> "Quota entry key should not be null");
                            QuotaEntity quotaEntity = QuotaStateManager$.MODULE$.readMessageKey(record.key());
                            Option<QuotaEntry> quotaEntryOpt = QuotaStateManager$.MODULE$.readMessageValue(quotaEntity, record.value());
                            if (quotaEntryOpt instanceof Some) {
                                QuotaEntry quotaEntry = (QuotaEntry)((Some)quotaEntryOpt).value();
                                return computedQuotas.put(quotaEntity, quotaEntry);
                            }
                            if (None$.MODULE$.equals(quotaEntryOpt)) {
                                return (QuotaEntry)computedQuotas.remove(quotaEntity);
                            }
                            throw new MatchError(quotaEntryOpt);
                        });
                    }
                    currOffset$1.elem = batch.nextOffset();
                });
            }
        } else {
            throw new MatchError(option);
        }
        return computedQuotas;
    }

    public void unloadQuotaState(int quotaPartition, Option<Object> coordinatorEpoch) {
        TopicPartition topicPartition = new TopicPartition("_confluent-quotas", quotaPartition);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Scheduling unloading of quota state from ").append(topicPartition).toString());
        this.scheduler.scheduleOnce(new StringBuilder(7).append("unload-").append(topicPartition).toString(), () -> this.removeQuotaState(topicPartition, coordinatorEpoch));
    }

    private void removeQuotaState(TopicPartition topicPartition, Option<Object> coordinatorEpoch) {
        int quotaPartition = topicPartition.partition();
        if (this.maybeUpdateCoordinatorEpoch(quotaPartition, coordinatorEpoch)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Started unloading quota state for ").append(topicPartition).append(" for ").append("coordinator epoch ").append(coordinatorEpoch).toString());
            CoreUtils$.MODULE$.inWriteLock(this.partitionStateLock(), (JFunction0.mcV.sp & Serializable)() -> {
                this.ownedPartitions().remove((Object)BoxesRunTime.boxToInteger((int)quotaPartition));
                this.loadingPartitions().remove((Object)BoxesRunTime.boxToInteger((int)quotaPartition));
                this.failedPartitions().remove((Object)BoxesRunTime.boxToInteger((int)quotaPartition));
                Option option = this.computedQuotasCache().remove((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
                if (option instanceof Some) {
                    ComputedQuotasCacheEntry computedQuotaCacheEntry = (ComputedQuotasCacheEntry)((Some)option).value();
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(79).append("Finished unloading ").append(topicPartition).append(" for coordinator epoch ").append(coordinatorEpoch).append(". ").append("Removed quotas for ").append(computedQuotaCacheEntry.computedQuotas().size()).append(" quota entities.").toString());
                    return;
                }
                if (None$.MODULE$.equals(option)) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("No quotas found for ").append(topicPartition).append(" during become-follower transition").toString());
                    return;
                }
                throw new MatchError((Object)option);
            });
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Not removing quota state for ").append(topicPartition).append(" ").append("in epoch ").append(coordinatorEpoch).append(" since current epoch is ").append(this.epochForPartitionId().get(BoxesRunTime.boxToInteger((int)topicPartition.partition()))).toString());
    }

    /*
     * WARNING - void declaration
     */
    public void storeQuotas(Map<TopicPartition, Iterable<QuotaEntry>> quotaEntriesPerPartition, Function1<Map<Object, Errors>, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        void appendQuotaMessage_callback;
        scala.collection.mutable.Map invalidPartitions = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map recordsPerPartition = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        quotaEntriesPerPartition.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                Iterable quotaEntries = (Iterable)x0$1._2();
                Option<Object> option = this.getMagic(tp.partition());
                if (option instanceof Some) {
                    void withRecords_records;
                    void withRecords_timestampType;
                    byte magicValue = BoxesRunTime.unboxToByte((Object)((Some)option).value());
                    IntRef recordCount = IntRef.create((int)0);
                    Iterable records = (Iterable)quotaEntries.map((Function1 & Serializable)quotaEntry -> {
                        long currentTimeMs = $this.time.milliseconds();
                        byte[] key = QuotaStateManager$.MODULE$.quotaEntryKey(quotaEntry.quotaEntity());
                        byte[] value = QuotaStateManager$.MODULE$.quotaEntryValue((QuotaEntry)quotaEntry);
                        ++recordCount$1.elem;
                        return new SimpleRecord(currentTimeMs, key, value);
                    });
                    SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
                    CompressionType withRecords_compressionType = this.compressionType();
                    TimestampType timestampType = TimestampType.CREATE_TIME;
                    long withRecords_initialOffset = 0L;
                    timestampType = null;
                    Object var10_11 = null;
                    simpleRecordArray = null;
                    recordsPerPartition.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)MemoryRecords.withRecords((byte)magicValue, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records)));
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Writing ").append(recordCount$1.elem).append(" quota entries to quotas partition ").append(tp).toString());
                    return BoxedUnit.UNIT;
                }
                if (None$.MODULE$.equals(option)) {
                    return invalidPartitions.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Errors.NOT_COORDINATOR));
                }
                throw new MatchError(option);
            }
            throw new MatchError(null);
        });
        Function1 & Serializable intersect = (Function1 & Serializable)responseStatus -> {
            this.appendCallback$1(responseStatus, responseCallback, invalidPartitions);
            return BoxedUnit.UNIT;
        };
        scala.collection.immutable.Map appendQuotaMessage_records = recordsPerPartition.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        long appendQuotaMessage_x$1 = this.config.quotasTopicAppendTimeoutMs();
        short appendQuotaMessage_x$2 = QuotaCoordinatorConfig$.MODULE$.RequiredAcks();
        Function0<BoxedUnit> appendQuotaMessage_x$8 = this.replicaManager.appendRecords$default$7();
        Option<Lock> appendQuotaMessage_x$9 = this.replicaManager.appendRecords$default$8();
        Function1<Map<TopicPartition, RecordConversionStats>, BoxedUnit> appendQuotaMessage_x$10 = this.replicaManager.appendRecords$default$9();
        this.replicaManager.appendRecords(appendQuotaMessage_x$1, appendQuotaMessage_x$2, true, AppendOrigin.COORDINATOR, (Map<TopicPartition, MemoryRecords>)appendQuotaMessage_records, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)appendQuotaMessage_callback, appendQuotaMessage_x$8, appendQuotaMessage_x$9, appendQuotaMessage_x$10, requestLocal);
    }

    public RequestLocal storeQuotas$default$3() {
        return RequestLocal$.MODULE$.NoCaching();
    }

    private Option<Object> getMagic(int partition) {
        return this.replicaManager.getMagic(new TopicPartition("_confluent-quotas", partition));
    }

    private void appendQuotaMessage(Map<TopicPartition, MemoryRecords> records, RequestLocal requestLocal, Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit> callback) {
        long x$1 = this.config.quotasTopicAppendTimeoutMs();
        short x$2 = QuotaCoordinatorConfig$.MODULE$.RequiredAcks();
        Function0<BoxedUnit> x$8 = this.replicaManager.appendRecords$default$7();
        Option<Lock> x$9 = this.replicaManager.appendRecords$default$8();
        Function1<Map<TopicPartition, RecordConversionStats>, BoxedUnit> x$10 = this.replicaManager.appendRecords$default$9();
        this.replicaManager.appendRecords(x$1, x$2, true, AppendOrigin.COORDINATOR, records, callback, x$8, x$9, x$10, requestLocal);
    }

    private boolean maybeUpdateCoordinatorEpoch(int partitionId, Option<Object> epochOpt) {
        Integer updatedEpoch = this.epochForPartitionId().compute(BoxesRunTime.boxToInteger((int)partitionId), (x$3, currentEpoch) -> QuotaStateManager.$anonfun$maybeUpdateCoordinatorEpoch$1(epochOpt, BoxesRunTime.unboxToInt((Object)x$3), currentEpoch));
        return epochOpt.forall((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)x$4), (Object)updatedEpoch));
    }

    private void writeTombstonesForExpiredQuotaEntities(TopicPartition quotaPartition, Iterable<QuotaEntityCoordinatorEpoch> expiredForPartition, MemoryRecords tombstoneRecords) {
        CoreUtils$.MODULE$.inReadLock(this.partitionStateLock(), (JFunction0.mcV.sp & Serializable)() -> {
            long x$1 = $this.config.quotasTopicAppendTimeoutMs();
            short x$2 = QuotaCoordinatorConfig$.MODULE$.RequiredAcks();
            Map x$5 = (Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaPartition), (Object)tombstoneRecords)}));
            Function1 & Serializable x$6 = (Function1 & Serializable)responses -> {
                this.removeFromCacheCallback$1(responses, expiredForPartition);
                return BoxedUnit.UNIT;
            };
            RequestLocal x$7 = RequestLocal$.MODULE$.NoCaching();
            Function0<BoxedUnit> x$8 = $this.replicaManager.appendRecords$default$7();
            Option<Lock> x$9 = $this.replicaManager.appendRecords$default$8();
            Function1<Map<TopicPartition, RecordConversionStats>, BoxedUnit> x$10 = $this.replicaManager.appendRecords$default$9();
            $this.replicaManager.appendRecords(x$1, x$2, true, AppendOrigin.COORDINATOR, (Map<TopicPartition, MemoryRecords>)x$5, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)x$6, x$8, x$9, x$10, x$7);
        });
    }

    private boolean shouldExpire(QuotaEntry quotaEntry, long currentTimeMs) {
        return this.config.quotasExpirationTimeMs() > 0 && quotaEntry.lastUpdatedTimestamp() <= currentTimeMs - (long)this.config.quotasExpirationTimeMs();
    }

    private boolean maybeAppendExpiration(QuotaEntity quotaEntity, MemoryRecordsBuilder recordsBuilder, long currentTimeMs) {
        byte[] keyBytes = QuotaStateManager$.MODULE$.quotaEntryKey(quotaEntity);
        if (recordsBuilder.hasRoomFor(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS)) {
            recordsBuilder.append(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS);
            return true;
        }
        return false;
    }

    private void removeExpiredQuotaEntries(TopicPartition quotaPartition, ComputedQuotasCacheEntry computedQuotasCacheEntry) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Checking partition ").append(quotaPartition).append(" for expired quota entries").toString());
        CoreUtils$.MODULE$.inReadLock(this.partitionStateLock(), (JFunction0.mcV.sp & Serializable)() -> {
            Option<LogConfig> option = $this.replicaManager.getLogConfig(quotaPartition);
            if (option instanceof Some) {
                LogConfig logConfig = (LogConfig)((Some)option).value();
                long currentTimeMs = $this.time.milliseconds();
                int maxBatchSize = logConfig.maxMessageSize();
                ListBuffer expired = ListBuffer$.MODULE$.empty();
                ObjectRef recordsBuilder = ObjectRef.create(null);
                BufferedIterator stateEntries = computedQuotasCacheEntry.computedQuotas().values().iterator().buffered();
                while (stateEntries.hasNext()) {
                    QuotaEntry quotaEntry = (QuotaEntry)stateEntries.head();
                    QuotaEntity quotaEntity = quotaEntry.quotaEntity();
                    BooleanRef fullBatch = BooleanRef.create((boolean)false);
                    quotaEntry.inLock((Function0 & Serializable)() -> {
                        if (this.shouldExpire(quotaEntry, currentTimeMs)) {
                            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Expiring quota entry for entity ").append(quotaEntry.quotaEntity()).toString());
                            if ((MemoryRecordsBuilder)recordsBuilder$1.elem == null) {
                                recordsBuilder$1.elem = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(16384, maxBatchSize)), (CompressionType)this.compressionType(), (TimestampType)TimestampType.CREATE_TIME, (long)0L, (int)maxBatchSize);
                            }
                            if (this.maybeAppendExpiration(quotaEntity, (MemoryRecordsBuilder)recordsBuilder$1.elem, currentTimeMs)) {
                                return expired.$plus$eq((Object)new QuotaEntityCoordinatorEpoch(quotaEntity, computedQuotasCacheEntry.coordinatorEpoch()));
                            }
                            fullBatch$1.elem = true;
                            return BoxedUnit.UNIT;
                        }
                        return BoxedUnit.UNIT;
                    });
                    if (fullBatch.elem) {
                        this.writeTombstonesForExpiredQuotaEntities(quotaPartition, (Iterable<QuotaEntityCoordinatorEpoch>)expired.toSeq(), ((MemoryRecordsBuilder)recordsBuilder.elem).build());
                        expired.clear();
                        recordsBuilder.elem = null;
                        continue;
                    }
                    stateEntries.next();
                }
                if (expired.nonEmpty()) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Found ").append(expired.size()).append(" expired quota entries").toString());
                    this.writeTombstonesForExpiredQuotaEntities(quotaPartition, (Iterable<QuotaEntityCoordinatorEpoch>)expired.toSeq(), ((MemoryRecordsBuilder)recordsBuilder.elem).build());
                    expired.clear();
                    recordsBuilder.elem = null;
                    return;
                }
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(150).append("Quota expiration for partition ").append(quotaPartition).append(" failed because the log ").append("config was not available, which likely means the partition is not online or is no longer local.").toString());
                return;
            }
            throw new MatchError(option);
        });
    }

    private void removeExpiredQuotas() {
        CoreUtils$.MODULE$.inReadLock(this.partitionStateLock(), (JFunction0.mcV.sp & Serializable)() -> this.computedQuotasCache().foreach((Function1 & Serializable)x0$1 -> {
            QuotaStateManager.$anonfun$removeExpiredQuotas$2(this, x0$1);
            return BoxedUnit.UNIT;
        }));
    }

    private void scheduleQuotaExpiration() {
        if (this.config.quotasExpirationIntervalMs() > 0) {
            this.scheduler.schedule("quota-expiration", () -> this.removeExpiredQuotas(), (long)this.config.quotasExpirationIntervalMs(), (long)this.config.quotasExpirationIntervalMs());
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Scheduled quota expiration thread with an interval of ").append($this.config.quotasExpirationIntervalMs()).append(" ms").toString());
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Not scheduling quota expiration because the expiration interval is ").append($this.config.quotasExpirationIntervalMs()).append(" ms").toString());
    }

    public int partitionFor(QuotaEntity quotaEntity) {
        return Utils.abs((int)quotaEntity.hashCode()) % this.quotaTopicPartitionCount();
    }

    public void startup(Function0<Object> retrieveQuotaTopicPartitionCount, Function0<BoxedUnit> maybeCreateTopic) {
        this.scheduler.scheduleOnce("_confluent-quotas-creation", () -> maybeCreateTopic.apply$mcV$sp());
        this.quotaTopicPartitionCount_$eq(retrieveQuotaTopicPartitionCount.apply$mcI$sp());
        this.scheduleQuotaExpiration();
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.scheduler.shutdown();
        this.loadingPartitions().clear();
        this.ownedPartitions().clear();
        this.computedQuotasCache().clear();
        this.metrics.removeSensor(QuotaStateManager$.MODULE$.LoadTimeSensor());
    }

    public void reconfigure(QuotaCoordinatorConfig newConfig) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Updating quota expiration time to ").append(newConfig.quotasExpirationTimeMs()).toString());
        this.config.quotasExpirationTimeMs_$eq(newConfig.quotasExpirationTimeMs());
    }

    private final long logEndOffset$1(TopicPartition topicPartition$3) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(topicPartition$3).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    private final void appendCallback$1(Map responseStatus, Function1 responseCallback$1, scala.collection.mutable.Map invalidPartitions$1) {
        Map partitionStatuses = (Map)responseStatus.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Errors errors;
                TopicPartition tp = (TopicPartition)x0$1._1();
                ProduceResponse.PartitionResponse status = (ProduceResponse.PartitionResponse)x0$1._2();
                Errors errors2 = status.error;
                Errors errors3 = Errors.NONE;
                if (!(errors2 != null ? !errors2.equals(errors3) : errors3 != null)) {
                    errors = Errors.NONE;
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Quota state for partition ").append(tp).append(" failed when appending to log ").append("due to ").append(status$1.error.exceptionName()).toString());
                    Errors errors4 = status.error;
                    if (Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(errors4) ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(errors4) ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(errors4) ? true : Errors.REQUEST_TIMED_OUT.equals(errors4)))) {
                        errors = Errors.COORDINATOR_NOT_AVAILABLE;
                    } else if (Errors.NOT_LEADER_OR_FOLLOWER.equals(errors4) ? true : Errors.KAFKA_STORAGE_ERROR.equals(errors4)) {
                        errors = Errors.NOT_COORDINATOR;
                    } else if (Errors.MESSAGE_TOO_LARGE.equals(errors4) ? true : (Errors.RECORD_LIST_TOO_LARGE.equals(errors4) ? true : Errors.INVALID_FETCH_SIZE.equals(errors4))) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(104).append("Appending quota state messages for partition ").append(tp).append(" failed due to ").append(status$1.error.exceptionName()).append(", returning UNKNOWN error code to the client").toString());
                        errors = Errors.UNKNOWN_SERVER_ERROR;
                    } else {
                        this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Appending quota state message for partition ").append(tp).append(" failed ").append("due to unexpected error: ").append(status$1.error.exceptionName()).toString());
                        errors = errors4;
                    }
                }
                Errors responseError = errors;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)responseError);
            }
            throw new MatchError(null);
        });
        responseCallback$1.apply((Object)partitionStatuses.$plus$plus((IterableOnce)invalidPartitions$1));
    }

    public static final /* synthetic */ Integer $anonfun$maybeUpdateCoordinatorEpoch$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$maybeUpdateCoordinatorEpoch$1(Option epochOpt$1, int x$3, Integer currentEpoch) {
        int epoch;
        if (currentEpoch == null) {
            return (Integer)epochOpt$1.map((Function1 & Serializable)x -> QuotaStateManager.$anonfun$maybeUpdateCoordinatorEpoch$2(BoxesRunTime.unboxToInt((Object)x))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        if (epochOpt$1 instanceof Some && (epoch = BoxesRunTime.unboxToInt((Object)((Some)epochOpt$1).value())) > Predef$.MODULE$.Integer2int(currentEpoch)) {
            return Predef$.MODULE$.int2Integer(epoch);
        }
        return currentEpoch;
    }

    private final void removeFromCacheCallback$1(Map responses, Iterable expiredForPartition$1) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, response) -> {
            CoreUtils$.MODULE$.inReadLock(this.partitionStateLock(), (JFunction0.mcV.sp & Serializable)() -> this.computedQuotasCache().get((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())).foreach((Function1 & Serializable)computedQuotasCacheEntry -> {
                expiredForPartition$1.foreach((Function1 & Serializable)entityAndEpoch -> {
                    QuotaEntity quotaEntity = entityAndEpoch.quotaEntity();
                    return computedQuotasCacheEntry.computedQuotas().get(quotaEntity).inLock((Function0 & Serializable)() -> {
                        if (computedQuotasCacheEntry.coordinatorEpoch() == entityAndEpoch.coordinatorEpoch()) {
                            Errors errors = response$1.error;
                            Errors errors2 = Errors.NONE;
                            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                                return computedQuotasCacheEntry.computedQuotas().remove(quotaEntity);
                            }
                        }
                        $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(130).append("Failed to remove expired quota entity: ").append(quotaEntity).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").append(" coordinatorEpoch: ").append(computedQuotasCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").append(entityAndEpoch.coordinatorEpoch()).toString());
                        return BoxedUnit.UNIT;
                    });
                });
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        };
        responses.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
    }

    private final void flushRecordsBuilder$1(TopicPartition quotaPartition$3, ListBuffer expired$1, ObjectRef recordsBuilder$1) {
        this.writeTombstonesForExpiredQuotaEntities(quotaPartition$3, (Iterable<QuotaEntityCoordinatorEpoch>)expired$1.toSeq(), ((MemoryRecordsBuilder)recordsBuilder$1.elem).build());
        expired$1.clear();
        recordsBuilder$1.elem = null;
    }

    public static final /* synthetic */ void $anonfun$removeExpiredQuotas$2(QuotaStateManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            int partitionId = x0$1._1$mcI$sp();
            ComputedQuotasCacheEntry computedQuotasCacheEntry = (ComputedQuotasCacheEntry)x0$1._2();
            TopicPartition quotasPartition = new TopicPartition("_confluent-quotas", partitionId);
            $this.removeExpiredQuotaEntries(quotasPartition, computedQuotasCacheEntry);
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public QuotaStateManager(QuotaCoordinatorConfig config, Scheduler scheduler, ReplicaManager replicaManager, Metrics metrics, Time time) {
        void add_stat;
        void add_metricName;
        void add_stat2;
        void add_metricName2;
        void add_stat3;
        void add_metricName3;
        this.config = config;
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.metrics = metrics;
        this.time = time;
        this.computedQuotasCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.compressionType = config.quotasTopicCompressionType();
        this.partitionStateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.ownedPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.failedPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.shuttingDown = new AtomicBoolean(false);
        this.epochForPartitionId = new ConcurrentHashMap();
        this.partitionLoadSensor = metrics.sensor(QuotaStateManager$.MODULE$.LoadTimeSensor());
        this.partitionLoadFailureSensor = metrics.sensor(QuotaStateManager$.MODULE$.LoadFailureSensor());
        Sensor sensor = this.partitionLoadSensor();
        Max max = new Max();
        MetricName metricName = metrics.metricName("partition-load-time-max", QuotaStateManager$.MODULE$.MetricsGroup(), "The max time it took to load the partitions in the last 30sec");
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName3, (MeasurableStat)add_stat3, null);
        metricName = null;
        max = null;
        Sensor sensor2 = this.partitionLoadSensor();
        Avg avg = new Avg();
        MetricName metricName2 = metrics.metricName("partition-load-time-avg", QuotaStateManager$.MODULE$.MetricsGroup(), "The avg time it took to load the partitions in the last 30sec");
        if (sensor2 == null) {
            throw null;
        }
        sensor2.add((MetricName)add_metricName2, (MeasurableStat)add_stat2, null);
        metricName2 = null;
        avg = null;
        Sensor sensor3 = this.partitionLoadFailureSensor();
        Rate rate = new Rate();
        MetricName metricName3 = metrics.metricName("partition-load-failure-count", QuotaStateManager$.MODULE$.MetricsGroup(), "The number of partitions that failed to load in the last 30sec");
        if (sensor3 == null) {
            throw null;
        }
        sensor3.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
    }

    public static class QuotaEntryMessageFormatter
    implements MessageFormatter {
        public void configure(java.util.Map<String, ?> x$1) {
            super.configure(x$1);
        }

        public void close() {
            super.close();
        }

        public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
            Option$.MODULE$.apply(consumerRecord.key()).map((Function1 & Serializable)key -> QuotaStateManager$.MODULE$.readMessageKey(ByteBuffer.wrap(key))).foreach((Function1 & Serializable)quotaEntity -> {
                QuotaEntryMessageFormatter.$anonfun$writeTo$2(consumerRecord, output, quotaEntity);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$writeTo$2(ConsumerRecord consumerRecord$1, PrintStream output$1, QuotaEntity quotaEntity) {
            byte[] value = (byte[])consumerRecord$1.value();
            Option<QuotaEntry> quotaEntry = value == null ? None$.MODULE$ : QuotaStateManager$.MODULE$.readMessageValue(quotaEntity, ByteBuffer.wrap(value));
            output$1.write(quotaEntity.toString().getBytes(StandardCharsets.UTF_8));
            output$1.write("::".getBytes(StandardCharsets.UTF_8));
            output$1.write(quotaEntry.getOrElse((Function0 & Serializable)() -> "NULL").toString().getBytes(StandardCharsets.UTF_8));
            output$1.write("\n".getBytes(StandardCharsets.UTF_8));
        }
    }
}

