/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherManager;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchConnectionsMode$Combined$;
import kafka.server.FetcherPool;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.LocalLeaderEndPoint;
import kafka.server.ReplicaAlterLogDirsThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00114A!\u0003\u0006\u0001\u001f!Aq\u0003\u0001B\u0001B\u0003%\u0001\u0004\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u0011!y\u0002A!A!\u0002\u0013\u0001\u0003\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\t\u000b\u001d\u0002A\u0011\u0001\u0015\t\u000b9\u0002A\u0011I\u0018\t\u000b\u0015\u0003A\u0011\u000b$\t\u000b\t\u0004A\u0011A2\u00035I+\u0007\u000f\\5dC\u0006cG/\u001a:M_\u001e$\u0015N]:NC:\fw-\u001a:\u000b\u0005-a\u0011AB:feZ,'OC\u0001\u000e\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0007E\u0011B#D\u0001\u000b\u0013\t\u0019\"B\u0001\fBEN$(/Y2u\r\u0016$8\r[3s\u001b\u0006t\u0017mZ3s!\t\tR#\u0003\u0002\u0017\u0015\tI\"+\u001a9mS\u000e\f\u0017\t\u001c;fe2{w\rR5sgRC'/Z1e\u00031\u0011'o\\6fe\u000e{gNZ5h!\t\t\u0012$\u0003\u0002\u001b\u0015\tY1*\u00194lC\u000e{gNZ5h\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"!E\u000f\n\u0005yQ!A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\rcV|G/Y'b]\u0006<WM\u001d\t\u0003#\u0005J!A\t\u0006\u0003/I+\u0007\u000f\\5dCRLwN\\)v_R\fW*\u00198bO\u0016\u0014\u0018\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t!\t\tR%\u0003\u0002'\u0015\t\u0001\"I]8lKJ$v\u000e]5d'R\fGo]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b%R3\u0006L\u0017\u0011\u0005E\u0001\u0001\"B\f\u0006\u0001\u0004A\u0002\"B\u000e\u0006\u0001\u0004a\u0002\"B\u0010\u0006\u0001\u0004\u0001\u0003\"B\u0012\u0006\u0001\u0004!\u0013aE2sK\u0006$XMR3uG\",'\u000f\u00165sK\u0006$G\u0003\u0002\u000b1q\u0001CQ!\r\u0004A\u0002I\n\u0011BZ3uG\",'/\u00133\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\u0007%sG\u000fC\u0003:\r\u0001\u0007!(\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0002<}5\tAH\u0003\u0002>\u0019\u000591\r\\;ti\u0016\u0014\u0018BA =\u00059\u0011%o\\6fe\u0016sG\rU8j]RDQ!\u0011\u0004A\u0002\t\u000b1BZ3uG\",'\u000fU8pYB\u0011\u0011cQ\u0005\u0003\t*\u00111BR3uG\",'\u000fU8pY\u0006a\u0012\r\u001a3QCJ$\u0018\u000e^5p]N$vNR3uG\",'\u000f\u00165sK\u0006$GcA$K\u0019B\u00111\u0007S\u0005\u0003\u0013R\u0012A!\u00168ji\")1j\u0002a\u0001)\u0005ia-\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012DQ!T\u0004A\u00029\u000ba#\u001b8ji&\fGn\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007n\u001d\t\u0005\u001fJ#v,D\u0001Q\u0015\t\tF'\u0001\u0006d_2dWm\u0019;j_:L!a\u0015)\u0003\u00075\u000b\u0007\u000f\u0005\u0002V;6\taK\u0003\u0002X1\u000611m\\7n_:T!!D-\u000b\u0005i[\u0016AB1qC\u000eDWMC\u0001]\u0003\ry'oZ\u0005\u0003=Z\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002\u0012A&\u0011\u0011M\u0003\u0002\u0012\u0013:LG/[1m\r\u0016$8\r[*uCR,\u0017\u0001C:ikR$wn\u001e8\u0015\u0003\u001d\u0003")
public class ReplicaAlterLogDirsManager
extends AbstractFetcherManager<ReplicaAlterLogDirsThread> {
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final ReplicationQuotaManager quotaManager;
    private final BrokerTopicStats brokerTopicStats;

    @Override
    public ReplicaAlterLogDirsThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
        String threadName = new StringBuilder(27).append("ReplicaAlterLogDirsThread-").append(fetcherId).append("-").append(fetcherPool.name()).toString();
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(sourceBroker, this.brokerConfig, this.replicaManager, this.quotaManager);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(this.brokerConfig.replicaFetchBackoffMs().longValue(), 2, this.brokerConfig.replicaFetchBackoffMaxMs().longValue(), 0.0);
        return new ReplicaAlterLogDirsThread(threadName, leader, this.failedPartitions(), exponentialBackoff, this.replicaManager, this.quotaManager, this.brokerTopicStats);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addPartitionsToFetcherThread(ReplicaAlterLogDirsThread fetcherThread, Map<TopicPartition, InitialFetchState> initialOffsetAndEpochs) {
        void var6_6;
        void var5_5;
        Set<TopicPartition> addedPartitions = fetcherThread.addPartitions(initialOffsetAndEpochs);
        Tuple2 tuple2 = initialOffsetAndEpochs.partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsManager.$anonfun$addPartitionsToFetcherThread$1(addedPartitions, x0$1)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map addedInitialOffsets = (Map)tuple2._1();
        Map notAddedInitialOffsets = (Map)tuple2._2();
        if (var5_5.nonEmpty()) {
            this.info((Function0<String>)((Function0 & Serializable)() -> ReplicaAlterLogDirsManager.$anonfun$addPartitionsToFetcherThread$2((Map)var5_5)));
        }
        if (var6_6.nonEmpty()) {
            this.info((Function0<String>)((Function0 & Serializable)() -> ReplicaAlterLogDirsManager.$anonfun$addPartitionsToFetcherThread$3((Map)var6_6)));
            return;
        }
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
        this.closeAllFetchers();
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutdown completed");
    }

    public static final /* synthetic */ boolean $anonfun$addPartitionsToFetcherThread$1(Set addedPartitions$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            return addedPartitions$1.contains((Object)tp);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ String $anonfun$addPartitionsToFetcherThread$2(Map addedInitialOffsets$1) {
        return new StringBuilder(58).append("Added log dir fetcher for partitions with initial offsets ").append(addedInitialOffsets$1).toString();
    }

    public static final /* synthetic */ String $anonfun$addPartitionsToFetcherThread$3(Map notAddedInitialOffsets$1) {
        return new StringBuilder(96).append("Failed to add log dir fetch for partitions ").append(notAddedInitialOffsets$1.keySet()).append(" ").append("since the log dir reassignment has already completed").toString();
    }

    public ReplicaAlterLogDirsManager(KafkaConfig brokerConfig, ReplicaManager replicaManager, ReplicationQuotaManager quotaManager, BrokerTopicStats brokerTopicStats) {
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.quotaManager = quotaManager;
        this.brokerTopicStats = brokerTopicStats;
        super(new StringBuilder(37).append("ReplicaAlterLogDirsManager on broker ").append(brokerConfig.brokerId()).toString(), "ReplicaAlterLogDirs", brokerConfig.getNumReplicaAlterLogDirsThreads(), FetchConnectionsMode$Combined$.MODULE$, (Option<Scheduler>)None$.MODULE$, (Map<String, String>)((Map)Map$.MODULE$.empty()));
    }
}

