/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.catalog.ZKMetadataCollector;
import kafka.controller.KafkaController;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.MetadataSupport;
import kafka.server.RaftSupport;
import kafka.server.ReplicaManager;
import kafka.server.ZkSupport;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadataManagerWithKRaftSupport;
import kafka.server.link.ClusterLinkMetadataManagerWithZkSupport;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.CreateClusterLinksResponse;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0011%d!\u0002.\\\u0003\u0003\u0011\u0007\u0002C8\u0001\u0005\u000b\u0007I\u0011\u00029\t\u0011U\u0004!\u0011!Q\u0001\nED\u0001B\u001e\u0001\u0003\u0006\u0004%Ia\u001e\u0005\ty\u0002\u0011\t\u0011)A\u0005q\"AQ\u0010\u0001BC\u0002\u0013\u0005a\u0010C\u0005\u0002\u0006\u0001\u0011\t\u0011)A\u0005\u007f\"Q\u0011q\u0001\u0001\u0003\u0006\u0004%\t!!\u0003\t\u0015\u0005E\u0001A!A!\u0002\u0013\tY\u0001\u0003\u0006\u0002\u0014\u0001\u0011\t\u0011)A\u0005\u0003+A!\"!\u000e\u0001\u0005\u0003\u0005\u000b\u0011BA\u001c\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000fB\u0011\"a\u0016\u0001\u0005\u0004%\t\"!\u0017\t\u0011\u0005E\u0004\u0001)A\u0005\u00037B1\"a\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0002v!Y\u0011q\u000f\u0001A\u0002\u0003\u0007I\u0011CA=\u0011-\t)\t\u0001a\u0001\u0002\u0003\u0006K!a\u0007\t\u0013\u0005\u001d\u0005A1A\u0005\n\u0005%\u0005\u0002CAN\u0001\u0001\u0006I!a#\t\u0013\u0005u\u0005A1A\u0005\n\u0005}\u0005\u0002CA\\\u0001\u0001\u0006I!!)\t\u0013\u0005e\u0006A1A\u0005\n\u0005m\u0006\u0002CAb\u0001\u0001\u0006I!!0\t\u0017\u0005\u0015\u0007\u00011AA\u0002\u0013%\u0011q\u0019\u0005\f\u0003\u0013\u0004\u0001\u0019!a\u0001\n\u0013\tY\rC\u0006\u0002P\u0002\u0001\r\u0011!Q!\n\u0005E\u0006\"CAi\u0001\u0001\u0007I\u0011BAj\u0011%\tY\u000e\u0001a\u0001\n\u0013\ti\u000e\u0003\u0005\u0002b\u0002\u0001\u000b\u0015BAk\u0011%\t\u0019\u000f\u0001a\u0001\n\u0013\t)\u000fC\u0005\u0002n\u0002\u0001\r\u0011\"\u0003\u0002p\"A\u00111\u001f\u0001!B\u0013\t9\u000fC\u0005\u0002v\u0002\u0001\r\u0011\"\u0003\u0002x\"I!Q\u0002\u0001A\u0002\u0013%!q\u0002\u0005\t\u0005'\u0001\u0001\u0015)\u0003\u0002z\"I!Q\u0003\u0001C\u0002\u0013E\u0011q\u0019\u0005\t\u0005/\u0001\u0001\u0015!\u0003\u00022\"9!\u0011\u0004\u0001\u0005\u0006\tm\u0001b\u0002B\u000f\u0001\u0011%!q\u0004\u0005\b\u0005K\u0001A\u0011\u0002B\u000e\u0011\u001d\u00119\u0003\u0001C\u0005\u0005SAqA!\r\u0001\t\u0013\u0011Y\u0002C\u0004\u00034\u0001!IA!\u000e\t\u000f\tm\u0002\u0001\"\u0003\u0003>!9!1\u000b\u0001\u0005\u0002\tU\u0003b\u0002B,\u0001\u0011%!\u0011\f\u0005\b\u0005?\u0002A\u0011\u0002B1\u0011\u001d\u0011i\u0007\u0001C\u0005\u0005_BqA!\u001e\u0001\t\u000b\u00119\bC\u0004\u0003\u0000\u0001!)A!!\t\u000f\t\u001d\u0005\u0001\"\u0003\u0003\n\"9!q\u0012\u0001\u0005\u0002\tE\u0005b\u0002BK\u0001\u0011\u0005!q\u0013\u0005\b\u0005s\u0003AQ\u0001B\u000e\u0011\u001d\u0011Y\f\u0001C\u0003\u0005{CqAa1\u0001\r\u0003\u0011)\rC\u0004\u0003Z\u00021\tAa7\t\u000f\t=\bA\"\u0001\u0003r\"9!q\u001e\u0001\u0007\u0002\tU\bb\u0002Bx\u0001\u0019\u00051\u0011\u0001\u0005\b\u0007\u0007\u0001a\u0011AB\u0003\u0011\u001d\u0019\u0019\u0001\u0001D\u0001\u0007\u0013Aqaa\u0001\u0001\r\u0003\u0019\t\u0001C\u0004\u0004\u000e\u00011\taa\u0004\t\u000f\rE\u0001\u0001\"\u0001\u0004\u0014!91q\u0003\u0001\u0005\u0002\re\u0001bBB\u0014\u0001\u0011\u00051\u0011\u0006\u0005\b\u0007[\u0001a\u0011AB\u0018\u0011\u001d\u0019\u0019\u0004\u0001D\u0001\u0007kAqa!\u000f\u0001\r\u0003\u0019Y\u0004C\u0004\u0004@\u00011\ta!\u0011\t\u000f\r}\u0002A\"\u0001\u0004H!911\n\u0001\u0007\u0002\r5\u0003bBB,\u0001\u0019\u00051\u0011\f\u0005\b\u0007;\u0002a\u0011AB0\u0011\u001d\u0019\u0019\b\u0001D\u0001\u0007kBqaa!\u0001\r\u0003\u0019)\tC\u0004\u0004\u0010\u00021\ta!%\t\u000f\rU\u0005A\"\u0001\u0004\u0018\"911\u0016\u0001\u0007\u0002\r5\u0006\"CBa\u0001E\u0005I\u0011ABb\u0011\u001d\u0019I\u000e\u0001D\u0001\u00077Dq\u0001\"\u0002\u0001\r\u0003!9\u0001C\u0004\u0005\f\u0001!)\u0001\"\u0004\t\u000f\u0011M\u0001A\"\u0001\u0005\u0016!9A1\u0006\u0001\u0007\u0002\u0005Mwa\u0002C\u00177\"\u0005Aq\u0006\u0004\u00075nC\t\u0001\"\r\t\u000f\u0005\u0015s\u000b\"\u0001\u00054!9AQG,\u0005\u0002\u0011]\"AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014(B\u0001/^\u0003\u0011a\u0017N\\6\u000b\u0005y{\u0016AB:feZ,'OC\u0001a\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A2j!\t!w-D\u0001f\u0015\u00051\u0017!B:dC2\f\u0017B\u00015f\u0005\u0019\te.\u001f*fMB\u0011!.\\\u0007\u0002W*\u0011AnX\u0001\u0006kRLGn]\u0005\u0003].\u0014q\u0001T8hO&tw-\u0001\u0007ce>\\WM]\"p]\u001aLw-F\u0001r!\t\u00118/D\u0001^\u0013\t!XLA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!\u00042s_.,'oQ8oM&<\u0007%A\u0005tG\",G-\u001e7feV\t\u0001\u0010\u0005\u0002zu6\t1,\u0003\u0002|7\n!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u00035iW\r^1eCR\f7)Y2iKV\tq\u0010E\u0002s\u0003\u0003I1!a\u0001^\u00055iU\r^1eCR\f7)Y2iK\u0006qQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\u0013\u0001G2p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4feV\u0011\u00111\u0002\t\u0004e\u00065\u0011bAA\b;\n\u0001#I]8lKJ$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003e\u0019wN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM\u001d\u0011\u0002#1|7-\u00197BI6LgNR1di>\u0014\u0018\u0010E\u0003e\u0003/\tY\"C\u0002\u0002\u001a\u0015\u0014\u0011BR;oGRLwN\u001c\u0019\u0011\t\u0005u\u0011\u0011G\u0007\u0003\u0003?QA!!\t\u0002$\u0005)\u0011\rZ7j]*!\u0011QEA\u0014\u0003\u001d\u0019G.[3oiNT1\u0001YA\u0015\u0015\u0011\tY#!\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ty#A\u0002pe\u001eLA!a\r\u0002 \t)\u0011\tZ7j]\u0006Q1/\u001a:wKJLeNZ8\u0011\t\u0005e\u0012\u0011I\u0007\u0003\u0003wQA!!\u0010\u0002@\u0005Q\u0011-\u001e;i_JL'0\u001a:\u000b\u0007y\u000b9#\u0003\u0003\u0002D\u0005m\"\u0001F!vi\"|'/\u001b>feN+'O^3s\u0013:4w.\u0001\u0004=S:LGO\u0010\u000b\u000f\u0003\u0013\nY%!\u0014\u0002P\u0005E\u00131KA+!\tI\b\u0001C\u0003p\u0017\u0001\u0007\u0011\u000fC\u0003w\u0017\u0001\u0007\u0001\u0010C\u0003~\u0017\u0001\u0007q\u0010C\u0004\u0002\b-\u0001\r!a\u0003\t\u000f\u0005M1\u00021\u0001\u0002\u0016!9\u0011QG\u0006A\u0002\u0005]\u0012!D7fi\u0006$\u0017\r^1U_BL7-\u0006\u0002\u0002\\A!\u0011QLA6\u001d\u0011\ty&a\u001a\u0011\u0007\u0005\u0005T-\u0004\u0002\u0002d)\u0019\u0011QM1\u0002\rq\u0012xn\u001c;?\u0013\r\tI'Z\u0001\u0007!J,G-\u001a4\n\t\u00055\u0014q\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%T-\u0001\bnKR\fG-\u0019;b)>\u0004\u0018n\u0019\u0011\u0002\u0013\u0011,7\u000f^!e[&tWCAA\u000e\u00035!Wm\u001d;BI6Lgn\u0018\u0013fcR!\u00111PAA!\r!\u0017QP\u0005\u0004\u0003\u007f*'\u0001B+oSRD\u0011\"a!\u0010\u0003\u0003\u0005\r!a\u0007\u0002\u0007a$\u0013'\u0001\u0006eKN$\u0018\tZ7j]\u0002\nA\u0001\\8dWV\u0011\u00111\u0012\t\u0005\u0003\u001b\u000b9*\u0004\u0002\u0002\u0010*!\u0011\u0011SAJ\u0003\u0011a\u0017M\\4\u000b\u0005\u0005U\u0015\u0001\u00026bm\u0006LA!!'\u0002\u0010\n1qJ\u00196fGR\fQ\u0001\\8dW\u0002\nqb\\<oK\u0012\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003C\u0003b!a)\u0002.\u0006EVBAAS\u0015\u0011\t9+!+\u0002\u000f5,H/\u00192mK*\u0019\u00111V3\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00020\u0006\u0015&aA*fiB\u0019A-a-\n\u0007\u0005UVMA\u0002J]R\f\u0001c\\<oK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002'A\f'\u000f^5uS>tGk\\#q_\u000eDW*\u00199\u0016\u0005\u0005u\u0006\u0003CAR\u0003\u007f\u000b\t,!-\n\t\u0005\u0005\u0017Q\u0015\u0002\u0004\u001b\u0006\u0004\u0018\u0001\u00069beRLG/[8o)>,\u0005o\\2i\u001b\u0006\u0004\b%A\u000bok6lU\r^1eCR\f\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005E\u0016!\u00078v[6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|gn]0%KF$B!a\u001f\u0002N\"I\u00111\u0011\r\u0002\u0002\u0003\u0007\u0011\u0011W\u0001\u0017]VlW*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8tA\u0005Y\u0011N\\5uS\u0006d\u0017N_3e+\t\t)\u000eE\u0002e\u0003/L1!!7f\u0005\u001d\u0011un\u001c7fC:\fq\"\u001b8ji&\fG.\u001b>fI~#S-\u001d\u000b\u0005\u0003w\ny\u000eC\u0005\u0002\u0004n\t\t\u00111\u0001\u0002V\u0006a\u0011N\\5uS\u0006d\u0017N_3eA\u0005Qa.^7SKR\u0014\u0018.Z:\u0016\u0005\u0005\u001d\bc\u00013\u0002j&\u0019\u00111^3\u0003\t1{gnZ\u0001\u000f]Vl'+\u001a;sS\u0016\u001cx\fJ3r)\u0011\tY(!=\t\u0013\u0005\re$!AA\u0002\u0005\u001d\u0018a\u00038v[J+GO]5fg\u0002\na#\\3uC\u0012\fG/Y%nC\u001e,G*[:uK:,'o]\u000b\u0003\u0003s\u0004b!a)\u0002|\u0006}\u0018\u0002BA\u007f\u0003K\u0013aAQ;gM\u0016\u0014\b\u0003\u0002B\u0001\u0005\u000fq1!\u001fB\u0002\u0013\r\u0011)aW\u0001\u0013\u00072,8\u000f^3s\u0019&t7NR1di>\u0014\u00180\u0003\u0003\u0003\n\t-!a\u0006'j].\u001cun\u001c:eS:\fGo\u001c:MSN$XM\\3s\u0015\r\u0011)aW\u0001\u001b[\u0016$\u0018\rZ1uC&k\u0017mZ3MSN$XM\\3sg~#S-\u001d\u000b\u0005\u0003w\u0012\t\u0002C\u0005\u0002\u0004\u0006\n\t\u00111\u0001\u0002z\u00069R.\u001a;bI\u0006$\u0018-S7bO\u0016d\u0015n\u001d;f]\u0016\u00148\u000fI\u0001\u0011e\u0016\fX/Z:u)&lWm\\;u\u001bN\f\u0011C]3rk\u0016\u001cH\u000fV5nK>,H/T:!\u0003\u001d\u0019H/\u0019:ukB$\"!a\u001f\u0002\u001fM$\u0018M\u001d;va&sG/\u001a:oC2$B!a\u001f\u0003\"!9!1\u0005\u0014A\u0002\u0005\u001d\u0018a\u00023fY\u0006LXj]\u0001\"Y>|7.\u001e9B]\u0012l\u0015-\u001f2f\u0007J,\u0017\r^3NKR\fG-\u0019;b)>\u0004\u0018nY\u0001\u001fO\u0016$X*\u001a;bI\u0006$\u0018\rV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]R,\"Aa\u000b\u0011\u000b\u0011\u0014i#!-\n\u0007\t=RM\u0001\u0004PaRLwN\\\u0001\u0014GJ,\u0017\r^3NKR\fG-\u0019;b)>\u0004\u0018nY\u0001\u001aS:LG/[1mSj,W*\u001a;bI\u0006$\u0018-T1oC\u001e,'\u000f\u0006\u0003\u0002|\t]\u0002b\u0002B\u001dU\u0001\u0007\u0011\u0011W\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u\u0003u9W\r^\"mkN$XM\u001d'j].\u001chi\u001c:QCJ$\u0018\u000e^5p]&#G\u0003\u0002B \u0005\u001f\u0002b!!\u0018\u0003B\t\r\u0013\u0002BAX\u0003_\u0002BA!\u0012\u0003L5\u0011!q\t\u0006\u0004\u0005\u0013z\u0016A\u0001>l\u0013\u0011\u0011iEa\u0012\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006DqA!\u0015,\u0001\u0004\t\t,A\u0006qCJ$\u0018\u000e^5p]&#\u0017aJ4fi\u000ecWo\u001d;fe2Kgn[:XSRDwj\u001e8fI2Kgn[\"p_J$\u0017N\\1u_J$\"Aa\u0010\u0002+1Lgn\u001b(b[\u0016$v\u000eU1si&$\u0018n\u001c8JIR!\u0011\u0011\u0017B.\u0011\u001d\u0011i&\fa\u0001\u00037\n\u0001\u0002\\5oW:\u000bW.Z\u0001\u0014[\u0016$\u0018\rZ1uCR{\u0007/[2D_:4\u0017nZ\u000b\u0003\u0005G\u0002\u0002B!\u001a\u0003l\u0005m\u00131L\u0007\u0003\u0005ORAA!\u001b\u0002\u0014\u0006!Q\u000f^5m\u0013\u0011\t\tMa\u001a\u0002%1|w-\u0012:s_J\u001cxJ\u001c$bS2,(/\u001a\u000b\u0005\u0003w\u0012\t\bC\u0004\u0003t=\u0002\r!a\u0017\u0002\u0007M$(/\u0001\u0006p]\u0016cWm\u0019;j_:$b!a\u001f\u0003z\tm\u0004b\u0002B)a\u0001\u0007\u0011\u0011\u0017\u0005\b\u0005{\u0002\u0004\u0019AAY\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0002\u001b=t'+Z:jO:\fG/[8o)\u0019\tYHa!\u0003\u0006\"9!\u0011K\u0019A\u0002\u0005E\u0006b\u0002B?c\u0001\u0007!1F\u0001\u001a[\u0006L(-Z+qI\u0006$X\rU1si&$\u0018n\u001c8Fa>\u001c\u0007\u000e\u0006\u0004\u0002V\n-%Q\u0012\u0005\b\u0005#\u0012\u0004\u0019AAY\u0011\u001d\u0011iH\ra\u0001\u0005W\t\u0011#[:MS:\\7i\\8sI&t\u0017\r^8s)\u0011\t)Na%\t\u000f\tu3\u00071\u0001\u0002\\\u0005yA.\u001b8l\u0007>|'\u000fZ5oCR|'\u000f\u0006\u0004\u0003\u001a\n\u001d&\u0011\u0016\t\u0006I\n5\"1\u0014\t\u0005\u0005;\u0013\u0019+\u0004\u0002\u0003 *!!\u0011UA\u0014\u0003\u0019\u0019w.\\7p]&!!Q\u0015BP\u0005\u0011qu\u000eZ3\t\u000f\tuC\u00071\u0001\u0002\\!9!1\u0016\u001bA\u0002\t5\u0016\u0001\u00047jgR,g.\u001a:OC6,\u0007\u0003\u0002BX\u0005kk!A!-\u000b\t\tM&qT\u0001\b]\u0016$xo\u001c:l\u0013\u0011\u00119L!-\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0002\u0011MDW\u000f\u001e3po:\f\u0001B]3hSN$XM\u001d\u000b\u0005\u0003w\u0012y\fC\u0004\u0003BZ\u0002\r!a@\u0002\u00111L7\u000f^3oKJ\f1\"\\5se>\u0014Hk\u001c9jGR!!q\u0019Bk!\u0015!'Q\u0006Be!\u0011\u0011YM!5\u000e\u0005\t5'\u0002\u0002Bh\u0003O\t\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0005'\u0014iMA\u0006NSJ\u0014xN\u001d+pa&\u001c\u0007b\u0002Blo\u0001\u0007\u00111L\u0001\u0006i>\u0004\u0018nY\u0001#[&\u0014(o\u001c:U_BL7m\u0015;bi\u0016\u001chI]8n\u001b\u0016$\u0018\rZ1uCN#xN]3\u0015\t\tu'\u0011\u001e\t\t\u0005?\u0014\t/a\u0017\u0003d6\u0011\u0011\u0011V\u0005\u0005\u0003\u0003\fI\u000bE\u0002z\u0005KL1Aa:\\\u0005U\u0019E.^:uKJd\u0015N\\6U_BL7m\u0015;bi\u0016DqAa;9\u0001\u0004\u0011i/\u0001\u0004u_BL7m\u001d\t\u0007\u0003;\u0012\t%a\u0017\u0002E5L'O]8s)>\u0004\u0018nY*uCR,7O\u0012:p[6+G/\u00193bi\u0006\u001c\u0015m\u00195f)\u0011\u0011iNa=\t\u000f\t-\u0018\b1\u0001\u0003nR!!Q\u001cB|\u0011\u001d\u0011IP\u000fa\u0001\u0005w\fa\u0001\\5oW&#\u0007\u0003\u0002BO\u0005{LAAa@\u0003 \n!Q+^5e)\t\u0011i.\u0001\u0014nSJ\u0014xN\u001d+pa&\u001c7\u000b^1uKN4%o\\7D_:$(o\u001c7mKJ\u001cuN\u001c;fqR$BA!8\u0004\b!9!1\u001e\u001fA\u0002\t5H\u0003\u0002Bo\u0007\u0017AqA!?>\u0001\u0004\u0011Y0A\u000bhKR\fE\u000e\u001c+pa&\u001c7/\u00138DYV\u001cH/\u001a:\u0015\u0005\t5\u0018!\u00048v[B\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0003,\rU\u0001b\u0002Bl\u0001\u0002\u0007\u00111L\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogR!11DB\u0012!\u0019\tiF!\u0011\u0004\u001eA!!QTB\u0010\u0013\u0011\u0019\tCa(\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"91QE!A\u0002\u0005m\u0013!\u0003;pa&\u001cg*Y7f\u0003!A\u0017m\u001d+pa&\u001cG\u0003BAk\u0007WAqAa6C\u0001\u0004\tY&\u0001\u000ejgR{\u0007/[2Rk\u0016,X\rZ+q\r>\u0014H)\u001a7fi&|g\u000e\u0006\u0003\u0002V\u000eE\u0002b\u0002Bl\u0007\u0002\u0007\u00111L\u0001\u0018K:\u001cXO]3DYV\u001cH/\u001a:MS:\\W\t_5tiN$B!a\u001f\u00048!9!\u0011 #A\u0002\tm\u0018!E2mkN$XM\u001d'j].,\u00050[:ugR!\u0011Q[B\u001f\u0011\u001d\u0011I0\u0012a\u0001\u0005w\f!cZ3u\u00072,8\u000f^3s\u0019&t7\u000eR1uCR!11IB#!\u0015!'Q\u0006B\"\u0011\u001d\u0011IP\u0012a\u0001\u0005w$Baa\u0011\u0004J!9!QL$A\u0002\u0005m\u0013!G4fi\u000ecWo\u001d;fe2Kgn[\"p]\u001aLw\r\u0015:paN$Baa\u0014\u0004VA!!QMB)\u0013\u0011\u0019\u0019Fa\u001a\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u0003z\"\u0003\rAa?\u0002\u001d\u001d,G\u000fV8qS\u000e\u001cuN\u001c4jOR!1qJB.\u0011\u001d\u00119.\u0013a\u0001\u00037\n1$\u00197uKJ\u001cE.^:uKJd\u0015N\\6D_:4\u0017n\u001a.O_\u0012,GCCA>\u0007C\u001a\u0019g!\u001a\u0004j!9!\u0011 &A\u0002\tm\bb\u0002B/\u0015\u0002\u0007\u00111\f\u0005\b\u0007OR\u0005\u0019AB(\u0003=\u0001XM]:jgR,g\u000e\u001e)s_B\u001c\bbBB6\u0015\u0002\u00071QN\u0001\u000bY&t7nQ8oM&<\u0007cA=\u0004p%\u00191\u0011O.\u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw-\u0001\u0011nCf\u0014WMU3f]\u000e\u0014\u0018\u0010\u001d;DYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\u001cH\u0003BA>\u0007oBqa!\u001fL\u0001\u0004\u0019Y(A\td_:4\u0017n\u001a+sC:\u001chm\u001c:nKJ\u0004r\u0001ZB?\u0007\u001f\u001a\t)C\u0002\u0004\u0000\u0015\u0014\u0011BR;oGRLwN\\\u0019\u0011\u000b\u0011\u0014ica\u0014\u0002-\r\u0014X-\u0019;f\u00072,8\u000f^3s\u0019&t7N\u0017(pI\u0016$b!a\u001f\u0004\b\u000e-\u0005bBBE\u0019\u0002\u0007!1I\u0001\u0010G2,8\u000f^3s\u0019&t7\u000eR1uC\"91Q\u0012'A\u0002\r=\u0013!\u00029s_B\u001c\u0018aE:fi\u000ecWo\u001d;fe2Kgn\u001b.O_\u0012,G\u0003BA>\u0007'Cqa!#N\u0001\u0004\u0011\u0019%A\fhKR\fE\u000e\u001c'j].\u001chI]8n\u001b\u0016$\u0018\rZ1uCR\u00111\u0011\u0014\t\u0007\u00077\u001b)Ka\u0011\u000f\t\ru5\u0011\u0015\b\u0005\u0003C\u001ay*C\u0001g\u0013\r\u0019\u0019+Z\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u00199k!+\u0003\u0007M+\u0017OC\u0002\u0004$\u0016\fQ#\u00197uKJl\u0015N\u001d:peR{\u0007/[2Ti\u0006$X\r\u0006\u0006\u0002|\r=6\u0011WB]\u0007{CqAa6P\u0001\u0004\tY\u0006C\u0004\u00044>\u0003\ra!.\u0002\u0019M$\u0018\r^3Va\u0012\fG/\u001a:\u0011\u000f\u0011\u001ciHa9\u00048B)AM!\f\u0003d\"911X(A\u0002\u0005U\u0017\u0001\u0004<bY&$\u0017\r^3P]2L\b\"CB`\u001fB\u0005\t\u0019AAk\u0003=1\u0017-\u001b7JM:{G/T5se>\u0014\u0018aH1mi\u0016\u0014X*\u001b:s_J$v\u000e]5d'R\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u00111Q\u0019\u0016\u0005\u0003+\u001c9m\u000b\u0002\u0004JB!11ZBk\u001b\t\u0019iM\u0003\u0003\u0004P\u000eE\u0017!C;oG\",7m[3e\u0015\r\u0019\u0019.Z\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BBl\u0007\u001b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003I\u0019'/Z1uK\u000ecWo\u001d;fe2Kgn[:\u0015\t\ru7Q\u001f\t\u0007\u0007?\u001c)o!;\u000e\u0005\r\u0005(\u0002BBr\u0005O\n!bY8oGV\u0014(/\u001a8u\u0013\u0011\u00199o!9\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0003\u0004l\u000eEXBABw\u0015\u0011\u0019yOa(\u0002\u0011I,\u0017/^3tiNLAaa=\u0004n\nQ2I]3bi\u0016\u001cE.^:uKJd\u0015N\\6t%\u0016\u001c\bo\u001c8tK\"91q_)A\u0002\re\u0018!H2sK\u0006$Xm\u00117vgR,'\u000fT5oWN\u0014V-];fgR$\u0015\r^1\u0011\t\rmH\u0011A\u0007\u0003\u0007{TAaa@\u0003 \u00069Q.Z:tC\u001e,\u0017\u0002\u0002C\u0002\u0007{\u0014Qd\u0011:fCR,7\t\\;ti\u0016\u0014H*\u001b8lgJ+\u0017/^3ti\u0012\u000bG/Y\u0001\u0017I\u0016dW\r^3DYV\u001cH/\u001a:MS:\\'LT8eKR!\u00111\u0010C\u0005\u0011\u001d\u0011IP\u0015a\u0001\u0005w\fa\"[:Ce>\\WM](oY&tW\r\u0006\u0003\u0002V\u0012=\u0001b\u0002C\t'\u0002\u0007\u0011\u0011W\u0001\tEJ|7.\u001a:JI\u0006y1\u000f^8q\u001b&\u0014(o\u001c:U_BL7\r\u0006\u0004\u0005\u0018\u0011\rBQ\u0005\t\u0007\u0005;#I\u0002\"\b\n\t\u0011m!q\u0014\u0002\f\u0017\u000647.\u0019$viV\u0014X\r\u0005\u0003\u0002\u000e\u0012}\u0011\u0002\u0002C\u0011\u0003\u001f\u0013AAV8jI\"9!q\u001b+A\u0002\u0005m\u0003b\u0002C\u0014)\u0002\u0007A\u0011F\u0001\u000eY><WI\u001c3PM\u001a\u001cX\r^:\u0011\r\rm5QUAt\u0003aI7\u000fT5oW\u000e{wN\u001d3j]\u0006$xN]#oC\ndW\rZ\u0001\u001b\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y'b]\u0006<WM\u001d\t\u0003s^\u001b\"aV2\u0015\u0005\u0011=\u0012\u0001I2sK\u0006$Xm\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ$\"#!\u0013\u0005:\u0011mBQ\bC$\t\u0013\"Y\u0005\"\u0014\u0005X!)q.\u0017a\u0001c\")a/\u0017a\u0001q\"9AqH-A\u0002\u0011\u0005\u0013aD7fi\u0006$\u0017\r^1TkB\u0004xN\u001d;\u0011\u0007I$\u0019%C\u0002\u0005Fu\u0013q\"T3uC\u0012\fG/Y*vaB|'\u000f\u001e\u0005\b\u0003\u000fI\u0006\u0019AA\u0006\u0011\u001d\t\u0019\"\u0017a\u0001\u0003+Aq!!\u000eZ\u0001\u0004\t9\u0004C\u0004\u0005Pe\u0003\r\u0001\"\u0015\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0019!\u000fb\u0015\n\u0007\u0011USL\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u000f\u0011e\u0013\f1\u0001\u0005\\\u0005\u0019\"p['fi\u0006$\u0017\r^1D_2dWm\u0019;peB)AM!\f\u0005^A!Aq\fC3\u001b\t!\tGC\u0002\u0005d}\u000bqaY1uC2|w-\u0003\u0003\u0005h\u0011\u0005$a\u0005.L\u001b\u0016$\u0018\rZ1uC\u000e{G\u000e\\3di>\u0014\b")
public abstract class ClusterLinkMetadataManager
implements Logging {
    private final KafkaConfig brokerConfig;
    private final ClusterLinkScheduler scheduler;
    private final MetadataCache metadataCache;
    private final BrokerToControllerChannelManager controllerChannelManager;
    private final Function0<Admin> localAdminFactory;
    private final String metadataTopic;
    private Admin destAdmin;
    private final Object lock;
    private final Set<Object> ownedPartitions;
    private final scala.collection.mutable.Map<Object, Object> partitionToEpochMap;
    private int numMetadataPartitions;
    private boolean initialized;
    private long numRetries;
    private Buffer<ClusterLinkFactory.LinkCoordinatorListener> metadataImageListeners;
    private final int requestTimeoutMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static ClusterLinkMetadataManager createClusterLinkMetadataManager(KafkaConfig brokerConfig, ClusterLinkScheduler scheduler, MetadataSupport metadataSupport, BrokerToControllerChannelManager controllerChannelManager, Function0<Admin> localAdminFactory, AuthorizerServerInfo serverInfo, ReplicaManager replicaManager, Option<ZKMetadataCollector> zkMetadataCollector) {
        if (metadataSupport instanceof ZkSupport) {
            ZkSupport zkSupport = (ZkSupport)metadataSupport;
            KafkaController createClusterLinkMetadataManager_controller = zkSupport.controller();
            KafkaZkClient createClusterLinkMetadataManager_zkClient = zkSupport.zkClient();
            ZkMetadataCache createClusterLinkMetadataManager_metadataCache = zkSupport.metadataCache();
            return new ClusterLinkMetadataManagerWithZkSupport(brokerConfig, scheduler, createClusterLinkMetadataManager_metadataCache, controllerChannelManager, createClusterLinkMetadataManager_controller, createClusterLinkMetadataManager_zkClient, localAdminFactory, replicaManager, serverInfo, zkMetadataCollector);
        }
        if (metadataSupport instanceof RaftSupport) {
            KRaftMetadataCache createClusterLinkMetadataManager_metadataCache = ((RaftSupport)metadataSupport).metadataCache();
            return new ClusterLinkMetadataManagerWithKRaftSupport(brokerConfig, scheduler, createClusterLinkMetadataManager_metadataCache, controllerChannelManager, localAdminFactory, serverInfo);
        }
        throw new MatchError((Object)metadataSupport);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public BrokerToControllerChannelManager controllerChannelManager() {
        return this.controllerChannelManager;
    }

    public String metadataTopic() {
        return this.metadataTopic;
    }

    public Admin destAdmin() {
        return this.destAdmin;
    }

    public void destAdmin_$eq(Admin x$1) {
        this.destAdmin = x$1;
    }

    private Object lock() {
        return this.lock;
    }

    private Set<Object> ownedPartitions() {
        return this.ownedPartitions;
    }

    private scala.collection.mutable.Map<Object, Object> partitionToEpochMap() {
        return this.partitionToEpochMap;
    }

    private int numMetadataPartitions() {
        return this.numMetadataPartitions;
    }

    private void numMetadataPartitions_$eq(int x$1) {
        this.numMetadataPartitions = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private long numRetries() {
        return this.numRetries;
    }

    private void numRetries_$eq(long x$1) {
        this.numRetries = x$1;
    }

    private Buffer<ClusterLinkFactory.LinkCoordinatorListener> metadataImageListeners() {
        return this.metadataImageListeners;
    }

    private void metadataImageListeners_$eq(Buffer<ClusterLinkFactory.LinkCoordinatorListener> x$1) {
        this.metadataImageListeners = x$1;
    }

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public final void startup() {
        if (Predef$.MODULE$.Boolean2boolean(this.brokerConfig().clusterLinkMetadataTopicEnable()) || this.metadataCache() instanceof KRaftMetadataCache) {
            this.startupInternal(0L);
            return;
        }
    }

    private void startupInternal(long delayMs) {
        if (this.destAdmin() == null) {
            this.destAdmin_$eq((Admin)this.localAdminFactory.apply());
        }
        this.scheduler().scheduleOnce("lookupClusterLinkMetadataTopic", () -> this.lookupAndMaybeCreateMetadataTopic(), delayMs);
    }

    private void lookupAndMaybeCreateMetadataTopic() {
        Option<Object> numPartitions = this.getMetadataTopicPartitionCount();
        if (numPartitions.nonEmpty()) {
            if (!BoxesRunTime.equals((Object)numPartitions.get(), (Object)this.brokerConfig().clusterLinkMetadataTopicPartitions())) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("Found internal metadata topic with different number of partitions(").append(numPartitions.get()).append(") than in the config(").append(this.brokerConfig().clusterLinkMetadataTopicPartitions()).toString());
            }
            this.initializeMetadataManager(BoxesRunTime.unboxToInt((Object)numPartitions.get()));
            return;
        }
        this.createMetadataTopic();
    }

    private Option<Object> getMetadataTopicPartitionCount() {
        return this.metadataCache().numPartitions(this.metadataTopic());
    }

    private void createMetadataTopic() {
        NewTopic topic = new NewTopic(this.metadataTopic(), Predef$.MODULE$.Integer2int(this.brokerConfig().clusterLinkMetadataTopicPartitions()), Predef$.MODULE$.Short2short(this.brokerConfig().clusterLinkMetadataTopicReplicationFactor()));
        topic.configs(this.metadataTopicConfig());
        CreateTopicsResult createResult = this.destAdmin().createTopics(Collections.singletonList(topic));
        this.scheduler().scheduleWhenComplete("createClusterLinkMetadataTopicResponse", createResult.all(), () -> {
            Long retryDelayMs = this.brokerConfig().clusterLinkMetadataTopicCreateRetryDelayMs();
            try {
                this.initializeMetadataManager(Predef$.MODULE$.Integer2int((Integer)createResult.numPartitions(this.metadataTopic()).get()));
                this.numRetries_$eq(0L);
                return;
            }
            catch (ExecutionException ex) {
                Throwable throwable = ex.getCause();
                if (throwable instanceof TopicExistsException) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Cluster link metadata topic creation failed as it is already created.");
                    retryDelayMs = Predef$.MODULE$.long2Long(0L);
                } else if (throwable instanceof TopicAuthorizationException) {
                    TopicAuthorizationException topicAuthorizationException = (TopicAuthorizationException)throwable;
                    this.logErrorsOnFailure(new StringBuilder(54).append("Unable to create cluster link metadata topic due to ").append(topicAuthorizationException).append(": ").append(ex.getMessage()).toString());
                } else if (throwable != null) {
                    this.logErrorsOnFailure(new StringBuilder(45).append("Cluster link metadata topic creation failed: ").append(throwable).toString());
                } else {
                    throw new MatchError(null);
                }
                this.startupInternal(Predef$.MODULE$.Long2long(retryDelayMs));
                return;
            }
            catch (Throwable e) {
                this.logErrorsOnFailure(new StringBuilder(45).append("Cluster link metadata topic creation failed: ").append(e).toString());
                this.startupInternal(Predef$.MODULE$.Long2long(retryDelayMs));
                return;
            }
        });
    }

    private void initializeMetadataManager(int partitionCount) {
        Object object = this.lock();
        synchronized (object) {
            this.numMetadataPartitions_$eq(partitionCount);
            this.initialized_$eq(true);
        }
        scala.collection.immutable.Set<ClusterLinkData> links = this.getClusterLinksWithOwnedLinkCoordinator();
        this.metadataImageListeners().foreach((Function1 & Serializable)x$3 -> {
            x$3.onClusterLinkCoordinatorElection((scala.collection.immutable.Set<ClusterLinkData>)links);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Set<ClusterLinkData> getClusterLinksForPartitionId(int partitionId) {
        block8: {
            Object object = this.lock();
            synchronized (object) {
                scala.collection.immutable.Set set;
                block7: {
                    if (!this.initialized()) {
                        set = Predef$.MODULE$.Set().empty();
                        break block7;
                    }
                    break block8;
                }
                return set;
            }
        }
        Seq<ClusterLinkData> links = this.getAllLinksFromMetadata();
        Object object = this.lock();
        synchronized (object) {
            scala.collection.immutable.Set set = ((IterableOnceOps)links.filter((Function1 & Serializable)cld -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManager.$anonfun$getClusterLinksForPartitionId$1(this, partitionId, cld)))).toSet();
            return set;
        }
    }

    public scala.collection.immutable.Set<ClusterLinkData> getClusterLinksWithOwnedLinkCoordinator() {
        return ((IterableOnceOps)this.getAllLinksFromMetadata().filter((Function1 & Serializable)cld -> BoxesRunTime.boxToBoolean((boolean)this.isLinkCoordinator(cld.linkName())))).toSet();
    }

    private int linkNameToPartitionId(String linkName) {
        if (!this.initialized()) {
            return -1;
        }
        return (Utils.murmur2((byte[])linkName.getBytes()) & Integer.MAX_VALUE) % this.numMetadataPartitions();
    }

    private java.util.Map<String, String> metadataTopicConfig() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cleanup.policy", "compact");
        props.put("min.insync.replicas", this.brokerConfig().clusterLinkMetadataTopicMinInSyncReplicas().toString());
        return props;
    }

    private void logErrorsOnFailure(String str) {
        this.numRetries_$eq(this.numRetries() + 1L);
        if (this.numRetries() <= 10L) {
            this.error((Function0<String>)(Function0 & Serializable)() -> str);
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> str);
    }

    public final void onElection(int partitionId, int leaderEpoch) {
        boolean bl;
        Object object = this.lock();
        synchronized (object) {
            boolean bl2;
            if (this.maybeUpdatePartitionEpoch(partitionId, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)))) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Elected as link coordinator for links with metadata topic partition ").append(partitionId).append(" at").append(" epoch ").append(leaderEpoch).toString());
                bl2 = this.ownedPartitions().add((Object)BoxesRunTime.boxToInteger((int)partitionId));
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        scala.collection.immutable.Set links = bl ? this.getClusterLinksForPartitionId(partitionId) : Predef$.MODULE$.Set().empty();
        this.metadataImageListeners().foreach((Function1 & Serializable)x$4 -> {
            x$4.onClusterLinkCoordinatorElection((scala.collection.immutable.Set<ClusterLinkData>)links);
            return BoxedUnit.UNIT;
        });
    }

    public final void onResignation(int partitionId, Option<Object> leaderEpoch) {
        boolean bl;
        Object object = this.lock();
        synchronized (object) {
            boolean bl2;
            if (this.maybeUpdatePartitionEpoch(partitionId, leaderEpoch)) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(79).append("Resigned as link coordinator for links with metadata topic partition ").append(partitionId).append(" ").append("at epoch ").append(leaderEpoch).toString());
                bl2 = this.ownedPartitions().remove((Object)BoxesRunTime.boxToInteger((int)partitionId));
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        scala.collection.immutable.Set linkIds = bl ? (scala.collection.immutable.Set)this.getClusterLinksForPartitionId(partitionId).map((Function1 & Serializable)x$5 -> x$5.linkId()) : Predef$.MODULE$.Set().empty();
        this.metadataImageListeners().foreach((Function1 & Serializable)x$6 -> {
            x$6.onClusterLinkCoordinatorResignation((scala.collection.immutable.Set<Uuid>)linkIds);
            return BoxedUnit.UNIT;
        });
    }

    private boolean maybeUpdatePartitionEpoch(int partitionId, Option<Object> leaderEpoch) {
        if (leaderEpoch.isEmpty()) {
            return true;
        }
        int newLeaderEpoch = BoxesRunTime.unboxToInt((Object)leaderEpoch.get());
        boolean bl = false;
        Option option = this.partitionToEpochMap().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
        if (option instanceof Some) {
            bl = true;
            int epoch = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            if (newLeaderEpoch > epoch) {
                this.partitionToEpochMap().put((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)BoxesRunTime.boxToInteger((int)newLeaderEpoch));
                return true;
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.partitionToEpochMap().put((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)BoxesRunTime.boxToInteger((int)newLeaderEpoch));
            return true;
        }
        if (bl) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    public boolean isLinkCoordinator(String linkName) {
        Object object = this.lock();
        synchronized (object) {
            boolean bl;
            block4: {
                if (!this.initialized()) {
                    bl = false;
                    break block4;
                }
                boolean bl2 = this.ownedPartitions().contains((Object)BoxesRunTime.boxToInteger((int)this.linkNameToPartitionId(linkName)));
                return bl2;
            }
            return bl;
        }
    }

    public Option<Node> linkCoordinator(String linkName, ListenerName listenerName) {
        Object object = this.lock();
        synchronized (object) {
            None$ none$;
            block4: {
                if (!this.initialized()) {
                    none$ = None$.MODULE$;
                    break block4;
                }
                Option<Node> option = this.metadataCache().getPartitionLeaderEndpoint(this.metadataTopic(), this.linkNameToPartitionId(linkName), listenerName);
                return option;
            }
            return none$;
        }
    }

    public final void shutdown() {
        Object object = this.lock();
        synchronized (object) {
            this.initialized_$eq(false);
            this.partitionToEpochMap().clear();
            this.ownedPartitions().clear();
            this.numMetadataPartitions_$eq(-1);
            return;
        }
    }

    public final void register(ClusterLinkFactory.LinkCoordinatorListener listener) {
        this.metadataImageListeners_$eq((Buffer<ClusterLinkFactory.LinkCoordinatorListener>)((Buffer)this.metadataImageListeners().$plus$eq((Object)listener)));
    }

    public abstract Option<MirrorTopic> mirrorTopic(String var1);

    public abstract Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataStore(scala.collection.immutable.Set<String> var1);

    public abstract Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache(scala.collection.immutable.Set<String> var1);

    public abstract Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache(Uuid var1);

    public abstract Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache();

    public abstract Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext(scala.collection.immutable.Set<String> var1);

    public abstract Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext(Uuid var1);

    public abstract Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext();

    public abstract scala.collection.immutable.Set<String> getAllTopicsInCluster();

    public Option<Object> numPartitions(String topic) {
        return this.metadataCache().numPartitions(topic);
    }

    public scala.collection.immutable.Set<TopicPartition> topicPartitions(String topicName) {
        return this.metadataCache().getTopicPartitions(topicName).toSet();
    }

    public boolean hasTopic(String topic) {
        return this.metadataCache().contains(topic);
    }

    public abstract boolean isTopicQueuedUpForDeletion(String var1);

    public abstract void ensureClusterLinkExists(Uuid var1);

    public abstract boolean clusterLinkExists(Uuid var1);

    public abstract Option<ClusterLinkData> getClusterLinkData(Uuid var1);

    public abstract Option<ClusterLinkData> getClusterLinkData(String var1);

    public abstract Properties getClusterLinkConfigProps(Uuid var1);

    public abstract Properties getTopicConfig(String var1);

    public abstract void alterClusterLinkConfigZNode(Uuid var1, String var2, Properties var3, ClusterLinkConfig var4);

    public abstract void maybeReencryptClusterLinkConfigs(Function1<Properties, Option<Properties>> var1);

    public abstract void createClusterLinkZNode(ClusterLinkData var1, Properties var2);

    public abstract void setClusterLinkZNode(ClusterLinkData var1);

    public abstract Seq<ClusterLinkData> getAllLinksFromMetadata();

    public abstract void alterMirrorTopicState(String var1, Function1<ClusterLinkTopicState, Option<ClusterLinkTopicState>> var2, boolean var3, boolean var4);

    public boolean alterMirrorTopicState$default$4() {
        return true;
    }

    public abstract CompletableFuture<CreateClusterLinksResponse> createClusterLinks(CreateClusterLinksRequestData var1);

    public abstract void deleteClusterLinkZNode(Uuid var1);

    public final boolean isBrokerOnline(int brokerId) {
        return this.metadataCache().hasAliveBroker(brokerId);
    }

    public abstract KafkaFuture<Void> stopMirrorTopic(String var1, Seq<Object> var2);

    public abstract boolean isLinkCoordinatorEnabled();

    public static final /* synthetic */ boolean $anonfun$getClusterLinksForPartitionId$1(ClusterLinkMetadataManager $this, int partitionId$1, ClusterLinkData cld) {
        return $this.linkNameToPartitionId(cld.linkName()) == partitionId$1;
    }

    public ClusterLinkMetadataManager(KafkaConfig brokerConfig, ClusterLinkScheduler scheduler, MetadataCache metadataCache, BrokerToControllerChannelManager controllerChannelManager, Function0<Admin> localAdminFactory, AuthorizerServerInfo serverInfo) {
        this.brokerConfig = brokerConfig;
        this.scheduler = scheduler;
        this.metadataCache = metadataCache;
        this.controllerChannelManager = controllerChannelManager;
        this.localAdminFactory = localAdminFactory;
        this.logIdent_$eq(new StringBuilder(37).append("[ClusterLinkMetadataManager-broker-").append(brokerConfig.brokerId()).append("] ").toString());
        this.metadataTopic = "_confluent-link-metadata";
        this.lock = new Object();
        this.ownedPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionToEpochMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.initialized = false;
        this.numRetries = 0L;
        this.metadataImageListeners = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.requestTimeoutMs = Predef$.MODULE$.Integer2int(new AdminClientConfig(ConfluentConfigs.clientConfigsForEndpoint((AbstractConfig)brokerConfig, (Endpoint)serverInfo.interBrokerEndpoint())).getInt("request.timeout.ms"));
    }
}

