/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import io.confluent.kafka.availability.FilesWrapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import kafka.log.MergedLog;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.utils.checksum.Algorithm;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.MultiChecksumTypeException;
import org.apache.kafka.common.errors.OtherChecksumTypeException;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumUtils {
    private static final Logger log = LoggerFactory.getLogger(ChecksumUtils.class);

    public static void maybeMigrateChecksumFormat(Algorithm checksumAlgorithm, short checksumSuperBlockLength, Path path) throws IOException {
        try {
            CheckedFileIO.verifyOnlyValidFileExists(checksumAlgorithm, path);
            log.debug("No migration performed for path: " + path + " as file already in " + checksumAlgorithm.suffix + " format");
        }
        catch (OtherChecksumTypeException e) {
            log.info("Other format file found for path: " + path + " " + e.getMessage());
            CheckedFileIO.migrateFile(ChecksumUtils.previousFormatPath(path), path, checksumSuperBlockLength);
        }
        catch (MultiChecksumTypeException e) {
            log.warn("Multiple format files found for path: " + path + " " + e.getMessage());
            Path oldPath = ChecksumUtils.previousFormatPath(path);
            if (ChecksumUtils.compareTierStateFiles(oldPath, path)) {
                log.warn("Deleting " + oldPath + " format file as it has an older tier epoch / offset than " + path);
                FilesWrapper.delete((Path)oldPath);
            } else {
                log.warn("Deleting " + path + " format file as it has an older tier epoch / offset than " + oldPath);
                FilesWrapper.delete((Path)path);
                CheckedFileIO.migrateFile(oldPath, path, checksumSuperBlockLength);
            }
        }
        catch (FileNotFoundException e) {
            log.debug("File not found during migration for path: " + path + " " + e.getMessage());
        }
    }

    public static Path previousFormatPath(Path path) {
        Path prvPath = CheckedFileIO.isValidPath(Algorithm.ADLER, path) ? CheckedFileIO.validPath(Algorithm.NO_CHECKSUM, path) : CheckedFileIO.validPath(Algorithm.ADLER, path);
        return prvPath;
    }

    public static void maybeRemovePreviousFormatPath(Path path) throws IOException {
        Path prvPath = ChecksumUtils.previousFormatPath(path);
        FilesWrapper.deleteIfExists((Path)prvPath);
    }

    static boolean compareTierStateFiles(Path oldPath, Path newPath) throws IOException {
        CheckedFileIO oldChannel = CheckedFileIO.open(oldPath, true, StandardOpenOption.READ);
        Optional<Header> oldHeaderOpt = FileTierPartitionState.readHeader(oldChannel);
        CheckedFileIO newChannel = CheckedFileIO.open(newPath, true, StandardOpenOption.READ);
        Optional<Header> newHeaderOpt = FileTierPartitionState.readHeader(newChannel);
        if (oldHeaderOpt.isPresent() && newHeaderOpt.isPresent()) {
            Header oldHeader = oldHeaderOpt.get();
            Header newHeader = newHeaderOpt.get();
            if (oldHeader.tierEpoch() != newHeader.tierEpoch()) {
                return newHeader.tierEpoch() > oldHeader.tierEpoch();
            }
            return newHeader.endOffset() >= oldHeader.endOffset();
        }
        if (newHeaderOpt.isPresent()) {
            return true;
        }
        if (oldHeaderOpt.isPresent()) {
            return false;
        }
        throw new KafkaStorageException("Failed to compare tier files oldPath: " + oldPath + " newPath: " + newPath + " as both files do not have a valid header present");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean verifyAlgorithm(ByteBuffer state, Algorithm algo) throws IOException {
        Path tmpPath = FilesWrapper.createTempFile((String)"tmp", (String)algo.suffix, (FileAttribute[])new FileAttribute[0]);
        FileChannel channel = FileChannel.open(tmpPath, StandardOpenOption.READ, StandardOpenOption.WRITE);
        Utils.writeFully((FileChannel)channel, (ByteBuffer)state);
        channel.close();
        try {
            boolean bl;
            Throwable throwable;
            CheckedFileIO cfIO;
            block17: {
                block18: {
                    cfIO = CheckedFileIO.open(tmpPath, StandardOpenOption.READ);
                    throwable = null;
                    cfIO.validate();
                    FileTierPartitionState.readHeader(cfIO);
                    bl = true;
                    if (cfIO == null) break block17;
                    if (throwable == null) break block18;
                    try {
                        cfIO.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block17;
                }
                cfIO.close();
            }
            return bl;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (cfIO != null) {
                            if (throwable != null) {
                                try {
                                    cfIO.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                cfIO.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    log.info("Target input FTPS failed to verify checksum algorithm: " + (Object)((Object)algo) + ". This maybe expected during materialization of version=0 TierPartitionForceRestore events ", (Throwable)e);
                    boolean bl2 = false;
                    return bl2;
                }
            }
        }
        finally {
            FilesWrapper.delete((Path)tmpPath);
        }
    }

    static Algorithm inferAlgorithm(ByteBuffer state) throws IOException {
        if (ChecksumUtils.verifyAlgorithm(state.duplicate(), Algorithm.ADLER)) {
            return Algorithm.ADLER;
        }
        if (ChecksumUtils.verifyAlgorithm(state.duplicate(), Algorithm.NO_CHECKSUM)) {
            return Algorithm.NO_CHECKSUM;
        }
        throw new KafkaStorageException("Failed to infer checksum algorithm for FTPS file");
    }

    public static Algorithm tierStateFileAlgorithm(Path path) {
        if (MergedLog.isTierStateFile(path.toFile())) {
            if (CheckedFileIO.isValidPath(Algorithm.ADLER, path)) {
                return Algorithm.ADLER;
            }
            if (CheckedFileIO.isValidPath(Algorithm.NO_CHECKSUM, path)) {
                return Algorithm.NO_CHECKSUM;
            }
        }
        throw new IllegalArgumentException("Incorrect file format for tier state file, provided file path: ${file.toPath}");
    }
}

