/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.log.AbstractLog;
import kafka.log.TierLogSegment;
import kafka.tier.state.CompactStats;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.store.TierObjectStoreLinearRetry;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.compaction.TierLogCleanerManager$;
import kafka.tier.tasks.compaction.TierLogToClean;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class CompactionTask$
implements Logging {
    public static final CompactionTask$ MODULE$ = new CompactionTask$();
    private static final int DefaultMaxRetryCount = 3;
    private static final int DefaultRetryIntervalInMs = 1000;
    private static final TierObjectStoreLinearRetry DefaultRetryPolicy = new TierObjectStoreLinearRetry(MODULE$.DefaultMaxRetryCount(), MODULE$.DefaultRetryIntervalInMs());
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return CompactionTask.class.getName();
    }

    public int DefaultMaxRetryCount() {
        return DefaultMaxRetryCount;
    }

    public int DefaultRetryIntervalInMs() {
        return DefaultRetryIntervalInMs;
    }

    public TierObjectStoreLinearRetry DefaultRetryPolicy() {
        return DefaultRetryPolicy;
    }

    /*
     * WARNING - void declaration
     */
    public TierLogToClean getTierLogToClean(AbstractLog log, Time time, long now) {
        try {
            CompactStats lastCompactStats;
            void var14_10;
            void var9_7;
            void var7_6;
            OffsetAndEpoch startingTierOffsetAndEpoch = log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch();
            Tuple2<Object, Object> tuple2 = this.dirtyRange(log, now);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            long firstDirtyOffset = tuple2._1$mcJ$sp();
            long firstUncleanableDirtyOffset = tuple2._2$mcJ$sp();
            long cleanBytes = BoxesRunTime.unboxToLong((Object)log.tieredLogSegments(log.logStartOffset(), (long)var7_6).takeWhile(arg_0 -> CompactionTask$.$anonfun$getTierLogToClean$1$adapted((long)var7_6, arg_0)).toList().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.size())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            Tuple2<Object, Object> tuple22 = TierLogCleanerManager$.MODULE$.calculateCleanableDirtyBytes(log, (long)var7_6, (long)var9_7);
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            long cleanableBytes = tuple22._2$mcJ$sp();
            long totalBytes = cleanBytes + var14_10;
            long uncleanableBytes = log.size() - totalBytes;
            double cleanableRatio = totalBytes == 0L ? 0.0 : (double)var14_10 / (double)totalBytes;
            Iterator firstBatchTimes = log.tieredLogSegments((long)var7_6, Long.MAX_VALUE).map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.firstBatchTimestamp())).filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$10 -> x$10 > 0L);
            long earliestDirtyTimestamp = firstBatchTimes.nonEmpty() ? BoxesRunTime.unboxToLong((Object)firstBatchTimes.min((Ordering)Ordering.Long$.MODULE$)) : Long.MAX_VALUE;
            CompactStats compactStats = lastCompactStats = log.tierPartitionState().lastCompactStats();
            CompactStats compactStats2 = CompactStats.EMPTY;
            double expectedCompactionEfficiency = (!(compactStats != null ? !((Object)compactStats).equals(compactStats2) : compactStats2 != null) ? 0.0 : lastCompactStats.reduceRatio()) * cleanableRatio;
            TierLogToClean ltc = new TierLogToClean(log.topicIdPartition(), log, time, earliestDirtyTimestamp, (long)var7_6, (long)var9_7, uncleanableBytes, (long)var14_10, cleanBytes, totalBytes, cleanableRatio, expectedCompactionEfficiency, startingTierOffsetAndEpoch);
            if (this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = ltc.toString();
                Object var31_20 = null;
                this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return ltc;
        }
        catch (Throwable e) {
            throw new Exception(new StringBuilder(53).append("Failed to calculate log cleaning stats for partition ").append(log.topicIdPartition()).toString(), e);
        }
    }

    private Tuple2<Object, Object> dirtyRange(AbstractLog log, long now) {
        long firstUncleanableDirtyOffset;
        long l;
        long firstDirtyOffset;
        long l2;
        long checkpointDirtyOffset = log.tierPartitionState().compactDirtyStartOffset();
        long logStartOffset = log.logStartOffset();
        if (checkpointDirtyOffset < 0L) {
            l2 = logStartOffset;
        } else if (checkpointDirtyOffset < logStartOffset) {
            if (!TierLogCleanerManager$.MODULE$.isCompactAndDelete(log) && this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = CompactionTask$.$anonfun$dirtyRange$1(log, logStartOffset, checkpointDirtyOffset);
                Object var14_5 = null;
                this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            l2 = logStartOffset;
        } else if (checkpointDirtyOffset > log.tierPartitionState().endOffset() + 1L) {
            if (this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = CompactionTask$.$anonfun$dirtyRange$2(log, checkpointDirtyOffset, logStartOffset);
                Object var15_6 = null;
                this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            l2 = logStartOffset;
        } else {
            l2 = firstDirtyOffset = checkpointDirtyOffset;
        }
        if (log.config().compactionLagMs() <= 0L) {
            l = log.tierPartitionState().endOffset() + 1L;
        } else {
            long cleanBeforeTime = now - log.config().compactionLagMs();
            l = firstUncleanableDirtyOffset = BoxesRunTime.unboxToLong((Object)log.tieredLogSegments(firstDirtyOffset, log.tierPartitionState().endOffset() + 1L).find((Function1 & Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)CompactionTask$.$anonfun$dirtyRange$3(cleanBeforeTime, segment))).map((Function1 & Serializable)segment -> BoxesRunTime.boxToLong((long)segment.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> log.tierPartitionState().endOffset() + 1L));
        }
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = CompactionTask$.$anonfun$dirtyRange$6(log, checkpointDirtyOffset, now, firstDirtyOffset, firstUncleanableDirtyOffset);
            Object var16_10 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        return new Tuple2.mcJJ.sp(firstDirtyOffset, package$.MODULE$.max(firstDirtyOffset, firstUncleanableDirtyOffset));
    }

    public static final /* synthetic */ boolean $anonfun$getTierLogToClean$1(long firstDirtyOffset$1, TierLogSegment x$7) {
        return x$7.endOffset() < firstDirtyOffset$1;
    }

    public static final /* synthetic */ String $anonfun$getTierLogToClean$5(TierLogToClean ltc$1) {
        return ltc$1.toString();
    }

    public static final /* synthetic */ String $anonfun$dirtyRange$1(AbstractLog log$3, long logStartOffset$1, long checkpointDirtyOffset$1) {
        return new StringBuilder(96).append("Resetting first dirty offset of ").append(log$3.name()).append(" to log start offset ").append(logStartOffset$1).append(" ").append("since the checkpointed offset ").append(checkpointDirtyOffset$1).append(" is invalid.").toString();
    }

    public static final /* synthetic */ String $anonfun$dirtyRange$2(AbstractLog log$3, long checkpointDirtyOffset$1, long logStartOffset$1) {
        return new StringBuilder(130).append("The last checkpoint dirty offset for partition ").append(log$3.name()).append(" is ").append(checkpointDirtyOffset$1).append(", ").append("which is larger than the log end offset ").append(log$3.logEndOffset()).append(". Resetting to the log start offset ").append(logStartOffset$1).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$dirtyRange$3(long cleanBeforeTime$1, TierLogSegment segment) {
        return segment.maxTimestamp() > cleanBeforeTime$1;
    }

    public static final /* synthetic */ String $anonfun$dirtyRange$6(AbstractLog log$3, long checkpointDirtyOffset$1, long now$1, long firstDirtyOffset$2, long firstUncleanableDirtyOffset$1) {
        return new StringBuilder(151).append("Finding range of cleanable offsets for log=").append(log$3.name()).append(". checkpointDirtyOffset=").append(checkpointDirtyOffset$1).append(" ").append("now=").append(now$1).append(" => firstDirtyOffset=").append(firstDirtyOffset$2).append(" firstUncleanableOffset=").append(firstUncleanableDirtyOffset$1).append(" ").append("log.tierPartitionState.endOffset=").append(log$3.tierPartitionState().endOffset()).toString();
    }

    private CompactionTask$() {
    }

    public static final /* synthetic */ Object $anonfun$getTierLogToClean$1$adapted(long firstDirtyOffset$1, TierLogSegment x$7) {
        return BoxesRunTime.boxToBoolean((boolean)CompactionTask$.$anonfun$getTierLogToClean$1(firstDirtyOffset$1, x$7));
    }
}

