/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.log.MergedLog;
import kafka.restore.ResetTierPartitionState;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.common.FenceEventInfo;
import kafka.tier.tools.common.RestoreInfo;
import kafka.utils.checksum.Algorithm;
import kafka.utils.checksum.CheckedFileIO;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.common.TopicPartition;

public class TierPartitionStateRestoreRawInputGenerator {
    public static final String GENERATOR_OUTPUT_JSON_FILE = "output.json";
    public static final String GENERATOR_OUTPUT_JSON_FILE_DOC = "The path to an output file where the raw input for tier state restoration will be emitted in JSON format.";

    public static void main(String[] args) throws Exception {
        block2: {
            ArgumentParser parser = TierPartitionStateRestoreRawInputGenerator.createArgParser();
            try {
                TierPartitionStateRestoreRawInputGenerator.run(parser.parseArgs(args));
            }
            catch (ArgumentParserException e) {
                parser.handleError(e);
                if (e instanceof HelpScreenException) break block2;
                throw e;
            }
        }
    }

    private static ArgumentParser createArgParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)TierPartitionStateRestoreRawInputGenerator.class.getName()).defaultHelp(true).description("Provides a command to generate the raw input for tier state restoration, using (1) the output of the fencing command and (2) a root directory containing the tier partition state files to be restored.");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument("fence.json")}).dest("fence.json").type(String.class).required(true).help("The path to a JSON file containing the output of the successful fencing command.");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument("restore.tier.state.root.dir")}).dest("restore.tier.state.root.dir").type(String.class).required(true).help("The path to the root directory containing the tier partition state files to be restored. The files should be organized under the root directory as: /path/to/ftps_root_dir/<TOPIC>-<PARTITION>/<TIER-STATE-FILE>. There should be exactly one <TIER-STATE-FILE> under each <TOPIC-PARTITION> sub directory.");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(GENERATOR_OUTPUT_JSON_FILE)}).dest(GENERATOR_OUTPUT_JSON_FILE).type(String.class).required(true).help(GENERATOR_OUTPUT_JSON_FILE_DOC);
        return parser;
    }

    private static void run(Namespace args) throws Exception {
        String generatorOutputJsonPath = TierPartitionStateRestoreRawInputGenerator.getOutputFilePath(args);
        List<RestoreInfo.RestoreRawInput> restoreInputs = TierPartitionStateRestoreRawInputGenerator.generateRestoreRawInput(args);
        try (FileOutputStream fos = new FileOutputStream(generatorOutputJsonPath);){
            RestoreInfo.RestoreRawInput.writeJsonToFile(restoreInputs, fos);
        }
    }

    public static List<RestoreInfo.RestoreRawInput> generateRestoreRawInput(Namespace args) throws IOException {
        List<FenceEventInfo> fencingEvents = TierPartitionStateRestoreRawInputGenerator.getFencingEvents(args);
        Path restoreTierStateRootDir = TierPartitionStateRestoreRawInputGenerator.getRestoreTierStateRootDir(args);
        return TierPartitionStateRestoreRawInputGenerator.generateRestoreRawInput(fencingEvents, restoreTierStateRootDir);
    }

    private static File[] listOrThrow(Path dir, FileFilter filter) throws IOException {
        File[] files = dir.toFile().listFiles(filter);
        if (files == null) {
            throw new IOException("Could not list items under the directory: " + dir);
        }
        return files;
    }

    private static Set<String> getValidTierStateFiles(Path topicPartitionDir) {
        HashSet<String> validTierStateFiles = new HashSet<String>();
        Path validTierStateFileBase = MergedLog.tierStateFile(topicPartitionDir.toFile(), 0L, "").toPath();
        for (Algorithm algorithm : Algorithm.values()) {
            String validTierStateFile = CheckedFileIO.validPath(algorithm, validTierStateFileBase).toString();
            validTierStateFiles.add(validTierStateFile);
            validTierStateFiles.add(ResetTierPartitionState.outputFilePath(validTierStateFile));
        }
        return validTierStateFiles;
    }

    static List<RestoreInfo.RestoreRawInput> generateRestoreRawInput(List<FenceEventInfo> fencingEvents, Path restoreTierStateRootDir) throws IOException {
        File[] files;
        HashSet<String> restoreTopicPartitionDirs = new HashSet<String>();
        for (File dir : files = TierPartitionStateRestoreRawInputGenerator.listOrThrow(restoreTierStateRootDir, File::isDirectory)) {
            restoreTopicPartitionDirs.add(dir.getName());
        }
        InvalidInputException exception = new InvalidInputException(restoreTierStateRootDir.toString());
        ArrayList<RestoreInfo.RestoreRawInput> restoreInputs = new ArrayList<RestoreInfo.RestoreRawInput>();
        for (FenceEventInfo event : fencingEvents) {
            TopicPartition fencedTopicPartition = new TopicPartition(event.topic, event.partition);
            Path fencedTopicPartitionDir = Paths.get(restoreTierStateRootDir.toString(), MergedLog.logDirName(fencedTopicPartition));
            String fencedTopicPartitionDirName = fencedTopicPartitionDir.toFile().getName();
            if (restoreTopicPartitionDirs.contains(fencedTopicPartitionDirName)) {
                File[] tierStateFilesOnDisk = TierPartitionStateRestoreRawInputGenerator.listOrThrow(fencedTopicPartitionDir, File::isFile);
                Set<String> validTierStateFiles = TierPartitionStateRestoreRawInputGenerator.getValidTierStateFiles(fencedTopicPartitionDir);
                int numValidFilesOnDisk = 0;
                File chosenTierStateFileOnDisk = null;
                for (File fileOnDisk : tierStateFilesOnDisk) {
                    if (!validTierStateFiles.contains(fileOnDisk.getAbsolutePath())) continue;
                    chosenTierStateFileOnDisk = fileOnDisk;
                    ++numValidFilesOnDisk;
                }
                if (numValidFilesOnDisk == 1 && chosenTierStateFileOnDisk.length() > 0L) {
                    restoreInputs.add(new RestoreInfo.RestoreRawInput(event, chosenTierStateFileOnDisk.toPath()));
                    continue;
                }
                if (numValidFilesOnDisk == 0) {
                    System.err.println("ERROR! Found no valid tier state file under: " + fencedTopicPartitionDir);
                } else if (numValidFilesOnDisk > 1) {
                    System.err.println("ERROR! Found more than 1 valid tier state file under: " + fencedTopicPartitionDir);
                } else if (chosenTierStateFileOnDisk.length() == 0L) {
                    System.err.println("ERROR! Found empty tier state file: " + chosenTierStateFileOnDisk.getAbsolutePath());
                }
                exception.partitionsWithIncorrectTierStateFiles.add(fencedTopicPartition);
                continue;
            }
            System.err.println("ERROR! Missing sub-directory: " + fencedTopicPartitionDir);
            exception.partitionsWithMissingDirs.add(fencedTopicPartition);
        }
        if (!exception.isEmpty()) {
            throw new IllegalArgumentException("Invalid input provided.", exception);
        }
        return restoreInputs;
    }

    private static Path getRestoreTierStateRootDir(Namespace args) {
        String restoreTierStateRootDirPath = args.getString("restore.tier.state.root.dir");
        Path restoreTierStateRootDir = Paths.get(restoreTierStateRootDirPath, new String[0]);
        if (!restoreTierStateRootDir.toFile().exists()) {
            throw new IllegalArgumentException("Restore tier state root dir does not exist: " + restoreTierStateRootDirPath);
        }
        return restoreTierStateRootDir;
    }

    private static String getOutputFilePath(Namespace args) throws IOException {
        String outputFilePath = args.getString(GENERATOR_OUTPUT_JSON_FILE);
        File outputFile = new File(outputFilePath);
        if (outputFile.exists() && !outputFile.delete()) {
            throw new IOException("Cannot overwrite existing file at " + outputFilePath);
        }
        if (!outputFile.createNewFile()) {
            throw new IOException("Could not create output file at path " + outputFilePath);
        }
        return outputFilePath;
    }

    private static List<FenceEventInfo> getFencingEvents(Namespace args) {
        String fencingOutputJsonPathStr = args.getString("fence.json");
        Path fencingOutputJsonPath = Paths.get(fencingOutputJsonPathStr, new String[0]);
        if (Files.notExists(fencingOutputJsonPath, new LinkOption[0]) || !Files.isRegularFile(fencingOutputJsonPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Fencing output file does not exist: " + fencingOutputJsonPath);
        }
        try {
            return FenceEventInfo.readJsonFromFile(fencingOutputJsonPath);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Couldn't parse provided input JSON from: " + fencingOutputJsonPath, e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Incorrect JSON file provided: " + fencingOutputJsonPath, e);
        }
    }

    public static class InvalidInputException
    extends RuntimeException {
        private final String restoreTierStateRootDir;
        public final List<TopicPartition> partitionsWithMissingDirs = new ArrayList<TopicPartition>();
        public final List<TopicPartition> partitionsWithIncorrectTierStateFiles = new ArrayList<TopicPartition>();

        public InvalidInputException(String restoreTierStateRootDir) {
            this.restoreTierStateRootDir = restoreTierStateRootDir;
        }

        public boolean isEmpty() {
            return this.partitionsWithMissingDirs.isEmpty() && this.partitionsWithIncorrectTierStateFiles.isEmpty();
        }

        @Override
        public String toString() {
            String newLine = System.lineSeparator();
            StringBuilder errorMsg = new StringBuilder("The following errors were encountered:");
            errorMsg.append(newLine);
            errorMsg.append(newLine);
            if (!this.partitionsWithMissingDirs.isEmpty()) {
                String partitionsWithMissingDirsStr = this.partitionsWithMissingDirs.stream().map(TopicPartition::toString).collect(Collectors.joining(", "));
                errorMsg.append(String.format("Sub-directories for the following topic partitions are missing under %s: %s", this.restoreTierStateRootDir, partitionsWithMissingDirsStr));
            }
            if (!this.partitionsWithIncorrectTierStateFiles.isEmpty()) {
                if (!this.partitionsWithMissingDirs.isEmpty()) {
                    errorMsg.append(newLine);
                    errorMsg.append(newLine);
                }
                String partitionsWithIncorrectTierStateFilesStr = this.partitionsWithIncorrectTierStateFiles.stream().map(TopicPartition::toString).collect(Collectors.joining(", "));
                errorMsg.append(String.format("Restore tier state file for the following topic partitions are either missing or incorrect: %s", partitionsWithIncorrectTierStateFilesStr));
            }
            return errorMsg.toString();
        }
    }
}

