/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;

public final class BlobsQueryHeaders {
    private LeaseStatusType xMsLeaseStatus;
    private String contentRange;
    private LeaseStateType xMsLeaseState;
    private DateTimeRfc1123 lastModified;
    private String xMsEncryptionKeySha256;
    private BlobType xMsBlobType;
    private String contentEncoding;
    private String xMsCopyStatusDescription;
    private LeaseDurationType xMsLeaseDuration;
    private Long contentLength;
    private String xMsRequestId;
    private String contentType;
    private String xMsVersion;
    private String xMsCopyId;
    private String xMsCopySource;
    private byte[] xMsContentCrc64;
    private Long xMsBlobSequenceNumber;
    private String xMsCopyProgress;
    private Integer xMsBlobCommittedBlockCount;
    private byte[] xMsBlobContentMd5;
    private Map<String, String> xMsMeta;
    private DateTimeRfc1123 date;
    private byte[] contentMD5;
    private DateTimeRfc1123 xMsCopyCompletionTime;
    private String acceptRanges;
    private Boolean xMsServerEncrypted;
    private String cacheControl;
    private String eTag;
    private String contentDisposition;
    private CopyStatusType xMsCopyStatus;
    private String contentLanguage;
    private String xMsClientRequestId;
    private String xMsEncryptionScope;
    private static final HttpHeaderName X_MS_LEASE_STATUS = HttpHeaderName.fromString((String)"x-ms-lease-status");
    private static final HttpHeaderName X_MS_LEASE_STATE = HttpHeaderName.fromString((String)"x-ms-lease-state");
    private static final HttpHeaderName X_MS_ENCRYPTION_KEY_SHA256 = HttpHeaderName.fromString((String)"x-ms-encryption-key-sha256");
    private static final HttpHeaderName X_MS_BLOB_TYPE = HttpHeaderName.fromString((String)"x-ms-blob-type");
    private static final HttpHeaderName X_MS_COPY_STATUS_DESCRIPTION = HttpHeaderName.fromString((String)"x-ms-copy-status-description");
    private static final HttpHeaderName X_MS_LEASE_DURATION = HttpHeaderName.fromString((String)"x-ms-lease-duration");
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_COPY_ID = HttpHeaderName.fromString((String)"x-ms-copy-id");
    private static final HttpHeaderName X_MS_COPY_SOURCE = HttpHeaderName.fromString((String)"x-ms-copy-source");
    private static final HttpHeaderName X_MS_CONTENT_CRC64 = HttpHeaderName.fromString((String)"x-ms-content-crc64");
    private static final HttpHeaderName X_MS_BLOB_SEQUENCE_NUMBER = HttpHeaderName.fromString((String)"x-ms-blob-sequence-number");
    private static final HttpHeaderName X_MS_COPY_PROGRESS = HttpHeaderName.fromString((String)"x-ms-copy-progress");
    private static final HttpHeaderName X_MS_BLOB_COMMITTED_BLOCK_COUNT = HttpHeaderName.fromString((String)"x-ms-blob-committed-block-count");
    private static final HttpHeaderName X_MS_BLOB_CONTENT_MD5 = HttpHeaderName.fromString((String)"x-ms-blob-content-md5");
    private static final HttpHeaderName X_MS_COPY_COMPLETION_TIME = HttpHeaderName.fromString((String)"x-ms-copy-completion-time");
    private static final HttpHeaderName X_MS_SERVER_ENCRYPTED = HttpHeaderName.fromString((String)"x-ms-server-encrypted");
    private static final HttpHeaderName X_MS_COPY_STATUS = HttpHeaderName.fromString((String)"x-ms-copy-status");
    private static final HttpHeaderName X_MS_ENCRYPTION_SCOPE = HttpHeaderName.fromString((String)"x-ms-encryption-scope");

    public BlobsQueryHeaders(HttpHeaders rawHeaders) {
        String xMsCopyCompletionTime;
        String contentMD5;
        String date;
        String xMsBlobContentMd5;
        String xMsBlobSequenceNumber;
        String contentLength;
        String lastModified;
        String xMsLeaseStatus = rawHeaders.getValue(X_MS_LEASE_STATUS);
        if (xMsLeaseStatus != null) {
            this.xMsLeaseStatus = LeaseStatusType.fromString(xMsLeaseStatus);
        }
        this.contentRange = rawHeaders.getValue(HttpHeaderName.CONTENT_RANGE);
        String xMsLeaseState = rawHeaders.getValue(X_MS_LEASE_STATE);
        if (xMsLeaseState != null) {
            this.xMsLeaseState = LeaseStateType.fromString(xMsLeaseState);
        }
        if ((lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED)) != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        this.xMsEncryptionKeySha256 = rawHeaders.getValue(X_MS_ENCRYPTION_KEY_SHA256);
        String xMsBlobType = rawHeaders.getValue(X_MS_BLOB_TYPE);
        if (xMsBlobType != null) {
            this.xMsBlobType = BlobType.fromString(xMsBlobType);
        }
        this.contentEncoding = rawHeaders.getValue(HttpHeaderName.CONTENT_ENCODING);
        this.xMsCopyStatusDescription = rawHeaders.getValue(X_MS_COPY_STATUS_DESCRIPTION);
        String xMsLeaseDuration = rawHeaders.getValue(X_MS_LEASE_DURATION);
        if (xMsLeaseDuration != null) {
            this.xMsLeaseDuration = LeaseDurationType.fromString(xMsLeaseDuration);
        }
        if ((contentLength = rawHeaders.getValue(HttpHeaderName.CONTENT_LENGTH)) != null) {
            this.contentLength = Long.parseLong(contentLength);
        }
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        this.contentType = rawHeaders.getValue(HttpHeaderName.CONTENT_TYPE);
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.xMsCopyId = rawHeaders.getValue(X_MS_COPY_ID);
        this.xMsCopySource = rawHeaders.getValue(X_MS_COPY_SOURCE);
        String xMsContentCrc64 = rawHeaders.getValue(X_MS_CONTENT_CRC64);
        if (xMsContentCrc64 != null) {
            this.xMsContentCrc64 = Base64.getDecoder().decode(xMsContentCrc64);
        }
        if ((xMsBlobSequenceNumber = rawHeaders.getValue(X_MS_BLOB_SEQUENCE_NUMBER)) != null) {
            this.xMsBlobSequenceNumber = Long.parseLong(xMsBlobSequenceNumber);
        }
        this.xMsCopyProgress = rawHeaders.getValue(X_MS_COPY_PROGRESS);
        String xMsBlobCommittedBlockCount = rawHeaders.getValue(X_MS_BLOB_COMMITTED_BLOCK_COUNT);
        if (xMsBlobCommittedBlockCount != null) {
            this.xMsBlobCommittedBlockCount = Integer.parseInt(xMsBlobCommittedBlockCount);
        }
        if ((xMsBlobContentMd5 = rawHeaders.getValue(X_MS_BLOB_CONTENT_MD5)) != null) {
            this.xMsBlobContentMd5 = Base64.getDecoder().decode(xMsBlobContentMd5);
        }
        if ((date = rawHeaders.getValue(HttpHeaderName.DATE)) != null) {
            this.date = new DateTimeRfc1123(date);
        }
        if ((contentMD5 = rawHeaders.getValue(HttpHeaderName.CONTENT_MD5)) != null) {
            this.contentMD5 = Base64.getDecoder().decode(contentMD5);
        }
        if ((xMsCopyCompletionTime = rawHeaders.getValue(X_MS_COPY_COMPLETION_TIME)) != null) {
            this.xMsCopyCompletionTime = new DateTimeRfc1123(xMsCopyCompletionTime);
        }
        this.acceptRanges = rawHeaders.getValue(HttpHeaderName.ACCEPT_RANGES);
        String xMsServerEncrypted = rawHeaders.getValue(X_MS_SERVER_ENCRYPTED);
        if (xMsServerEncrypted != null) {
            this.xMsServerEncrypted = Boolean.parseBoolean(xMsServerEncrypted);
        }
        this.cacheControl = rawHeaders.getValue(HttpHeaderName.CACHE_CONTROL);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        this.contentDisposition = rawHeaders.getValue(HttpHeaderName.CONTENT_DISPOSITION);
        String xMsCopyStatus = rawHeaders.getValue(X_MS_COPY_STATUS);
        if (xMsCopyStatus != null) {
            this.xMsCopyStatus = CopyStatusType.fromString(xMsCopyStatus);
        }
        this.contentLanguage = rawHeaders.getValue(HttpHeaderName.CONTENT_LANGUAGE);
        this.xMsClientRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
        this.xMsEncryptionScope = rawHeaders.getValue(X_MS_ENCRYPTION_SCOPE);
        LinkedHashMap<String, String> xMsMetaHeaderCollection = new LinkedHashMap<String, String>();
        for (HttpHeader header : rawHeaders) {
            String headerName = header.getName();
            if (!headerName.startsWith("x-ms-meta-")) continue;
            xMsMetaHeaderCollection.put(headerName.substring(10), header.getValue());
        }
        this.xMsMeta = xMsMetaHeaderCollection;
    }

    public LeaseStatusType getXMsLeaseStatus() {
        return this.xMsLeaseStatus;
    }

    public BlobsQueryHeaders setXMsLeaseStatus(LeaseStatusType xMsLeaseStatus) {
        this.xMsLeaseStatus = xMsLeaseStatus;
        return this;
    }

    public String getContentRange() {
        return this.contentRange;
    }

    public BlobsQueryHeaders setContentRange(String contentRange) {
        this.contentRange = contentRange;
        return this;
    }

    public LeaseStateType getXMsLeaseState() {
        return this.xMsLeaseState;
    }

    public BlobsQueryHeaders setXMsLeaseState(LeaseStateType xMsLeaseState) {
        this.xMsLeaseState = xMsLeaseState;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public BlobsQueryHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getXMsEncryptionKeySha256() {
        return this.xMsEncryptionKeySha256;
    }

    public BlobsQueryHeaders setXMsEncryptionKeySha256(String xMsEncryptionKeySha256) {
        this.xMsEncryptionKeySha256 = xMsEncryptionKeySha256;
        return this;
    }

    public BlobType getXMsBlobType() {
        return this.xMsBlobType;
    }

    public BlobsQueryHeaders setXMsBlobType(BlobType xMsBlobType) {
        this.xMsBlobType = xMsBlobType;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public BlobsQueryHeaders setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getXMsCopyStatusDescription() {
        return this.xMsCopyStatusDescription;
    }

    public BlobsQueryHeaders setXMsCopyStatusDescription(String xMsCopyStatusDescription) {
        this.xMsCopyStatusDescription = xMsCopyStatusDescription;
        return this;
    }

    public LeaseDurationType getXMsLeaseDuration() {
        return this.xMsLeaseDuration;
    }

    public BlobsQueryHeaders setXMsLeaseDuration(LeaseDurationType xMsLeaseDuration) {
        this.xMsLeaseDuration = xMsLeaseDuration;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public BlobsQueryHeaders setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public BlobsQueryHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public BlobsQueryHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public BlobsQueryHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getXMsCopyId() {
        return this.xMsCopyId;
    }

    public BlobsQueryHeaders setXMsCopyId(String xMsCopyId) {
        this.xMsCopyId = xMsCopyId;
        return this;
    }

    public String getXMsCopySource() {
        return this.xMsCopySource;
    }

    public BlobsQueryHeaders setXMsCopySource(String xMsCopySource) {
        this.xMsCopySource = xMsCopySource;
        return this;
    }

    public byte[] getXMsContentCrc64() {
        return CoreUtils.clone((byte[])this.xMsContentCrc64);
    }

    public BlobsQueryHeaders setXMsContentCrc64(byte[] xMsContentCrc64) {
        this.xMsContentCrc64 = CoreUtils.clone((byte[])xMsContentCrc64);
        return this;
    }

    public Long getXMsBlobSequenceNumber() {
        return this.xMsBlobSequenceNumber;
    }

    public BlobsQueryHeaders setXMsBlobSequenceNumber(Long xMsBlobSequenceNumber) {
        this.xMsBlobSequenceNumber = xMsBlobSequenceNumber;
        return this;
    }

    public String getXMsCopyProgress() {
        return this.xMsCopyProgress;
    }

    public BlobsQueryHeaders setXMsCopyProgress(String xMsCopyProgress) {
        this.xMsCopyProgress = xMsCopyProgress;
        return this;
    }

    public Integer getXMsBlobCommittedBlockCount() {
        return this.xMsBlobCommittedBlockCount;
    }

    public BlobsQueryHeaders setXMsBlobCommittedBlockCount(Integer xMsBlobCommittedBlockCount) {
        this.xMsBlobCommittedBlockCount = xMsBlobCommittedBlockCount;
        return this;
    }

    public byte[] getXMsBlobContentMd5() {
        return CoreUtils.clone((byte[])this.xMsBlobContentMd5);
    }

    public BlobsQueryHeaders setXMsBlobContentMd5(byte[] xMsBlobContentMd5) {
        this.xMsBlobContentMd5 = CoreUtils.clone((byte[])xMsBlobContentMd5);
        return this;
    }

    public Map<String, String> getXMsMeta() {
        return this.xMsMeta;
    }

    public BlobsQueryHeaders setXMsMeta(Map<String, String> xMsMeta) {
        this.xMsMeta = xMsMeta;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public BlobsQueryHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public byte[] getContentMD5() {
        return CoreUtils.clone((byte[])this.contentMD5);
    }

    public BlobsQueryHeaders setContentMD5(byte[] contentMD5) {
        this.contentMD5 = CoreUtils.clone((byte[])contentMD5);
        return this;
    }

    public OffsetDateTime getXMsCopyCompletionTime() {
        if (this.xMsCopyCompletionTime == null) {
            return null;
        }
        return this.xMsCopyCompletionTime.getDateTime();
    }

    public BlobsQueryHeaders setXMsCopyCompletionTime(OffsetDateTime xMsCopyCompletionTime) {
        this.xMsCopyCompletionTime = xMsCopyCompletionTime == null ? null : new DateTimeRfc1123(xMsCopyCompletionTime);
        return this;
    }

    public String getAcceptRanges() {
        return this.acceptRanges;
    }

    public BlobsQueryHeaders setAcceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    public Boolean isXMsServerEncrypted() {
        return this.xMsServerEncrypted;
    }

    public BlobsQueryHeaders setXMsServerEncrypted(Boolean xMsServerEncrypted) {
        this.xMsServerEncrypted = xMsServerEncrypted;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public BlobsQueryHeaders setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public BlobsQueryHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public BlobsQueryHeaders setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public CopyStatusType getXMsCopyStatus() {
        return this.xMsCopyStatus;
    }

    public BlobsQueryHeaders setXMsCopyStatus(CopyStatusType xMsCopyStatus) {
        this.xMsCopyStatus = xMsCopyStatus;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public BlobsQueryHeaders setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public BlobsQueryHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public String getXMsEncryptionScope() {
        return this.xMsEncryptionScope;
    }

    public BlobsQueryHeaders setXMsEncryptionScope(String xMsEncryptionScope) {
        this.xMsEncryptionScope = xMsEncryptionScope;
        return this;
    }
}

