/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.credentials;

import com.google.common.collect.ImmutableMap;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.common.security.sasl.ConfluentOAuthConfigs;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public interface ExtractedCredentials {
    public Map<String, String> toClientCredentialProperties();

    public String remoteHost();

    public KafkaPrincipal kafkaPrincipal();

    public static class NoCredentials
    implements ExtractedCredentials {
        private final String remoteHost;

        public NoCredentials(String remoteHost) {
            this.remoteHost = remoteHost;
        }

        @Override
        public Map<String, String> toClientCredentialProperties() {
            return Collections.emptyMap();
        }

        @Override
        public String remoteHost() {
            return this.remoteHost;
        }

        @Override
        public KafkaPrincipal kafkaPrincipal() {
            return KafkaPrincipal.ANONYMOUS;
        }
    }

    public static class JwtCredentials
    implements ExtractedCredentials {
        private final JwtPrincipal principal;
        private final String metadataServerUrl;
        private final String remoteHost;

        public JwtCredentials(JwtPrincipal principal, String metadataServerUrl, String remoteHost) {
            this.remoteHost = remoteHost;
            this.metadataServerUrl = metadataServerUrl;
            this.principal = principal;
        }

        @Override
        public Map<String, String> toClientCredentialProperties() {
            return ImmutableMap.builder().put((Object)"sasl.mechanism", (Object)"OAUTHBEARER").put((Object)"sasl.login.callback.handler.class", (Object)"io.confluent.kafka.clients.plugins.auth.token.TokenBearerLoginCallbackHandler").put((Object)"sasl.jaas.config", (Object)ConfluentOAuthConfigs.getOAuthBearerLoginModuleJaasConfig((JwtPrincipal)this.principal, (String)this.metadataServerUrl)).build();
        }

        @Override
        public String remoteHost() {
            return this.remoteHost;
        }

        @Override
        public KafkaPrincipal kafkaPrincipal() {
            KafkaPrincipal result = new KafkaPrincipal("User", this.principal.getName());
            result.tokenAuthenticated(true);
            return result;
        }
    }
}

