/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.auto.value.AutoValue;
import io.confluent.auditlogapi.entities.AutoValue_AuditLogConfigDefaultTopics;
import io.confluent.auditlogapi.entities.Validations;
import javax.annotation.Nonnull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"allowed", "denied"})
@JsonSerialize(as=AuditLogConfigDefaultTopics.class)
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class AuditLogConfigDefaultTopics {
    @JsonProperty(value="allowed")
    public abstract String getAllowed();

    @JsonProperty(value="denied")
    public abstract String getDenied();

    @Nonnull
    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_AuditLogConfigDefaultTopics.Builder();
        }

        @JsonProperty(value="allowed")
        public abstract Builder allowed(String var1);

        @JsonProperty(value="denied")
        public abstract Builder denied(String var1);

        abstract AuditLogConfigDefaultTopics autoBuild();

        public AuditLogConfigDefaultTopics build() {
            AuditLogConfigDefaultTopics built = this.autoBuild();
            Validations.requireNonNull(built.getAllowed(), "allowed");
            Validations.requireNonNull(built.getDenied(), "denied");
            Validations.requireValidAuditLogTopicName(built.getAllowed(), "allowed");
            Validations.requireValidAuditLogTopicName(built.getDenied(), "denied");
            return built;
        }
    }
}

