/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.entities;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import io.confluent.auditlogapi.entities.AuditLogConfigDestinationConfig;
import io.confluent.auditlogapi.entities.AuditLogConfigDestinations;
import java.util.Collection;
import java.util.Map;

final class AutoValue_AuditLogConfigDestinations
extends AuditLogConfigDestinations {
    private final ImmutableList<String> bootstrapServers;
    private final ImmutableSortedMap<String, AuditLogConfigDestinationConfig> topics;

    private AutoValue_AuditLogConfigDestinations(ImmutableList<String> bootstrapServers, ImmutableSortedMap<String, AuditLogConfigDestinationConfig> topics) {
        this.bootstrapServers = bootstrapServers;
        this.topics = topics;
    }

    @Override
    @JsonProperty(value="bootstrap_servers")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ImmutableList<String> getBootstrapServers() {
        return this.bootstrapServers;
    }

    @Override
    @JsonProperty(value="topics")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ImmutableSortedMap<String, AuditLogConfigDestinationConfig> getTopics() {
        return this.topics;
    }

    public String toString() {
        return "AuditLogConfigDestinations{bootstrapServers=" + this.bootstrapServers + ", topics=" + this.topics + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AuditLogConfigDestinations) {
            AuditLogConfigDestinations that = (AuditLogConfigDestinations)o;
            return this.bootstrapServers.equals(that.getBootstrapServers()) && this.topics.equals(that.getTopics());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.bootstrapServers.hashCode();
        h$ *= 1000003;
        return h$ ^= this.topics.hashCode();
    }

    @Override
    public AuditLogConfigDestinations.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AuditLogConfigDestinations.Builder {
        private ImmutableList.Builder<String> bootstrapServersBuilder$;
        private ImmutableList<String> bootstrapServers;
        private ImmutableSortedMap.Builder<String, AuditLogConfigDestinationConfig> topicsBuilder$;
        private ImmutableSortedMap<String, AuditLogConfigDestinationConfig> topics;

        Builder() {
        }

        private Builder(AuditLogConfigDestinations source) {
            this.bootstrapServers = source.getBootstrapServers();
            this.topics = source.getTopics();
        }

        @Override
        public AuditLogConfigDestinations.Builder bootstrapServers(Collection<String> bootstrapServers) {
            if (this.bootstrapServersBuilder$ != null) {
                throw new IllegalStateException("Cannot set bootstrapServers after calling bootstrapServersBuilder()");
            }
            this.bootstrapServers = ImmutableList.copyOf(bootstrapServers);
            return this;
        }

        @Override
        ImmutableList.Builder<String> bootstrapServersBuilder() {
            if (this.bootstrapServersBuilder$ == null) {
                if (this.bootstrapServers == null) {
                    this.bootstrapServersBuilder$ = ImmutableList.builder();
                } else {
                    this.bootstrapServersBuilder$ = ImmutableList.builder();
                    this.bootstrapServersBuilder$.addAll(this.bootstrapServers);
                    this.bootstrapServers = null;
                }
            }
            return this.bootstrapServersBuilder$;
        }

        @Override
        public AuditLogConfigDestinations.Builder topics(Map<String, AuditLogConfigDestinationConfig> topics) {
            if (this.topicsBuilder$ != null) {
                throw new IllegalStateException("Cannot set topics after calling topicsBuilder()");
            }
            this.topics = ImmutableSortedMap.copyOf(topics);
            return this;
        }

        @Override
        ImmutableSortedMap.Builder<String, AuditLogConfigDestinationConfig> topicsBuilder() {
            if (this.topicsBuilder$ == null) {
                if (this.topics == null) {
                    this.topicsBuilder$ = ImmutableSortedMap.naturalOrder();
                } else {
                    this.topicsBuilder$ = ImmutableSortedMap.naturalOrder();
                    this.topicsBuilder$.putAll(this.topics);
                    this.topics = null;
                }
            }
            return this.topicsBuilder$;
        }

        @Override
        AuditLogConfigDestinations autoBuild() {
            if (this.bootstrapServersBuilder$ != null) {
                this.bootstrapServers = this.bootstrapServersBuilder$.build();
            } else if (this.bootstrapServers == null) {
                this.bootstrapServers = ImmutableList.of();
            }
            if (this.topicsBuilder$ != null) {
                this.topics = this.topicsBuilder$.build();
            } else if (this.topics == null) {
                this.topics = ImmutableSortedMap.of();
            }
            return new AutoValue_AuditLogConfigDestinations(this.bootstrapServers, this.topics);
        }
    }
}

