/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.entities;

import io.confluent.crn.ConfluentResourceName;
import io.confluent.crn.CrnSyntaxException;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Validations {
    public static final Pattern VALID_TOPIC_NAME_PATTERN = Pattern.compile("\\A[-_a-zA-Z0-9]*\\z");
    private static final Pattern VALID_USER_PRINCIPAL_PATTERN = Pattern.compile("\\AUser:.*\\z");
    private static final Pattern VALID_HOST_AND_PORT_PATTERN = Pattern.compile("\\A([-.a-zA-Z0-9]{1,253}):([0-9]{1,5})\\z");

    private Validations() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static String requireValidAuditLogTopicName(String topicName, String paramName) throws IllegalArgumentException {
        if (topicName == null) {
            return null;
        }
        if (topicName.isEmpty()) {
            return topicName;
        }
        if (topicName.length() > 249) {
            throw new IllegalArgumentException(String.format("%s topic name (\"%s\") must be less than 250 characters", paramName, topicName));
        }
        if (!topicName.startsWith("confluent-audit-log-events")) {
            throw new IllegalArgumentException(String.format("%s topic name (\"%s\") must start with \"%s\"", paramName, topicName, "confluent-audit-log-events"));
        }
        if (!VALID_TOPIC_NAME_PATTERN.matcher(topicName).matches()) {
            throw new IllegalArgumentException(String.format("%s topic name (\"%s\") must be underscore, hyphen, and alpha-numeric characters", paramName, topicName));
        }
        return topicName;
    }

    public static <T> T requireNonNull(T param, String paramName) throws NullPointerException {
        if (param == null) {
            throw new NullPointerException(paramName + " cannot be null");
        }
        return param;
    }

    public static String requireValidCrnPattern(String pattern, String paramName) throws NullPointerException, IllegalArgumentException {
        Validations.requireNonNull(pattern, paramName);
        try {
            ConfluentResourceName.fromString((String)pattern);
        }
        catch (CrnSyntaxException e) {
            throw new IllegalArgumentException(String.format("%s CRN pattern (\"%s\") must be a valid CRN", paramName, paramName), e);
        }
        return pattern;
    }

    public static String requireNonEmpty(String value, String paramName) throws NullPointerException, IllegalArgumentException {
        Validations.requireNonNull(value, paramName);
        if (value.isEmpty()) {
            throw new IllegalArgumentException(paramName + " cannot be empty");
        }
        return value;
    }

    public static <E, C extends Collection<E>> C requireNonEmpty(C collection, String paramName) throws NullPointerException, IllegalArgumentException {
        Validations.requireNonNull(collection, paramName);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(paramName + " cannot be empty");
        }
        return collection;
    }

    public static String requireValidUserPrincipal(String principal, String paramName) throws NullPointerException, IllegalArgumentException {
        Validations.requireNonEmpty(principal, paramName);
        if (VALID_USER_PRINCIPAL_PATTERN.matcher(principal).matches()) {
            return principal;
        }
        throw new IllegalArgumentException(paramName + " must start with User:");
    }

    public static String requireValidHostAndPort(String hostAndPort, String paramName) throws NullPointerException, IllegalArgumentException {
        Validations.requireNonNull(hostAndPort, paramName);
        Matcher matcher = VALID_HOST_AND_PORT_PATTERN.matcher(hostAndPort);
        if (matcher.matches() && Integer.parseInt(matcher.group(2)) < 65535) {
            return hostAndPort;
        }
        throw new IllegalArgumentException(paramName + " must be a valid host:port address");
    }
}

