/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.metadataapi.resources;

import io.confluent.metadataapi.entities.ClusterId;
import io.confluent.metadataapi.entities.ErrorMessage;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.kafka.server.license.LicenseTrackingInfoHolder;

@Path(value="/")
@Produces(value={"application/json"})
public class MetadataResource {
    private final String clusterId;
    private final List<String> schemaRegistryUrls;
    private final LicenseTrackingInfoHolder licenseTrackingInfoHolder;

    public MetadataResource(String clusterId, String schemaRegistryUrls, LicenseTrackingInfoHolder licenseTrackingInfoHolder) {
        this.clusterId = clusterId;
        this.schemaRegistryUrls = schemaRegistryUrls == null || schemaRegistryUrls.isEmpty() ? Collections.emptyList() : Arrays.asList(schemaRegistryUrls.trim().split("\\s*,\\s*"));
        this.licenseTrackingInfoHolder = licenseTrackingInfoHolder;
    }

    @GET
    @Path(value="/id")
    @PerformanceMetric(value="v1.metadata.id")
    public Response id() {
        return Response.ok().entity((Object)new ClusterId(this.clusterId)).build();
    }

    @GET
    @Path(value="/schemaRegistryUrls")
    @PerformanceMetric(value="v1.schemaregistry.urls.get")
    public Response schemaRegistryUrls() {
        if (this.schemaRegistryUrls.isEmpty()) {
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)new ErrorMessage(status.getStatusCode(), "Schema registry not configured")).build();
        }
        return Response.ok().entity(this.schemaRegistryUrls).build();
    }

    @GET
    @Path(value="/analyticsId")
    @PerformanceMetric(value="v1.analytics.id")
    public Response analyticsId() {
        if (this.licenseTrackingInfoHolder != null) {
            Map analyticsId = this.licenseTrackingInfoHolder.getTrackingId();
            return Response.ok().entity((Object)analyticsId).build();
        }
        return Response.noContent().build();
    }
}

