/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.app;

import io.confluent.rbacapi.app.RbacApiAppConfig;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.kafka.common.config.ConfigDef;

public class CPRbacApiAppConfig
extends RbacApiAppConfig {
    public CPRbacApiAppConfig() {
        super(CPRbacApiAppConfig.getConfigDef());
    }

    public CPRbacApiAppConfig(Map<?, ?> props) {
        super(CPRbacApiAppConfig.getConfigDef(), props);
    }

    public CPRbacApiAppConfig(ConfigDef definition) {
        super(definition, new TreeMap());
    }

    public CPRbacApiAppConfig(ConfigDef definition, Map<?, ?> props) {
        super(definition, props);
    }

    public static CPRbacApiAppConfig scoped(Map<String, ?> originals) {
        Map<String, Object> scoped = originals.entrySet().stream().map(e -> CPRbacApiAppConfig.getPrefixType((String)((String)e.getKey())).strategy.apply((Map.Entry<String, ?>)e)).filter(e -> Objects.nonNull(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new CPRbacApiAppConfig(scoped);
    }

    private static PrefixType getPrefixType(String key) {
        if (CPRbacApiAppConfig.keyStartsWithPrefixAndLongEnough(key, "confluent.security.")) {
            return PrefixType.AUDIT;
        }
        if (CPRbacApiAppConfig.keyStartsWithPrefixAndLongEnough(key, "confluent.metadata.server.")) {
            return PrefixType.MDS;
        }
        if (CPRbacApiAppConfig.keyStartsWithPrefixAndLongEnough(key, "confluent.oidc")) {
            return PrefixType.OIDC;
        }
        return PrefixType.OTHERS;
    }

    private static boolean keyStartsWithPrefixAndLongEnough(String key, String prefix) {
        return key.startsWith(prefix) && key.length() > prefix.length();
    }

    private static enum PrefixType {
        AUDIT(e -> ImmutablePair.of(e.getKey(), e.getValue())),
        MDS(e -> ImmutablePair.of((Object)((String)e.getKey()).substring("confluent.metadata.server.".length()), e.getValue())),
        OIDC(e -> ImmutablePair.of(e.getKey(), e.getValue())),
        OTHERS(e -> ImmutablePair.nullPair());

        public final Function<Map.Entry<String, ?>, Map.Entry<String, ?>> strategy;

        private PrefixType(Function<Map.Entry<String, ?>, Map.Entry<String, ?>> strategy) {
            this.strategy = strategy;
        }
    }
}

