/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.converters;

import io.confluent.rbacapi.converters.MdsScopeConverter;
import io.confluent.rbacapi.entities.MdsScope;
import io.confluent.rbacapi.services.ClusterRegistryService;
import io.confluent.rbacapi.validation.base.ValidationUtil;
import io.confluent.security.authorizer.Scope;
import javax.ws.rs.NotFoundException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class V1MdsScopeConverter
implements MdsScopeConverter {
    private final ClusterRegistryService clusterRegistryService;
    private final ValidationUtil validationUtil;

    public V1MdsScopeConverter(ClusterRegistryService clusterRegistryService, ValidationUtil validationUtil) {
        this.clusterRegistryService = clusterRegistryService;
        this.validationUtil = validationUtil;
    }

    public Scope getScope(MdsScope mdsScope, KafkaPrincipal principal) {
        this.validationUtil.verifyMdsScope(mdsScope);
        if (mdsScope.scope() != null) {
            return mdsScope.scope();
        }
        if (mdsScope.clusterName() != null && this.clusterRegistryService != null) {
            Scope scope = this.clusterRegistryService.lookupScopeByClusterName(mdsScope.clusterName(), principal);
            if (scope == null) {
                throw new NotFoundException("Failed to get cluster scope as " + mdsScope.clusterName() + " does not exist in cluster registry.");
            }
            return scope;
        }
        return null;
    }

    public MdsScope getMdsScope(KafkaPrincipal principal, Scope scope) {
        String clusterName = null;
        if (scope != null && this.clusterRegistryService != null) {
            clusterName = this.clusterRegistryService.lookupClusterNameByScope(scope, principal);
        }
        return new MdsScope(clusterName, scope);
    }

    public String getClusterName(KafkaPrincipal principal, Scope scope) {
        String clusterName = null;
        if (scope != null && this.clusterRegistryService != null) {
            clusterName = this.clusterRegistryService.lookupClusterNameByScope(scope, principal);
        }
        return clusterName;
    }
}

