/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.v1;

import io.confluent.rbacapi.authorizer.SecurityMetadataAuthorizer;
import io.confluent.rbacapi.comparators.ScopeComparator;
import io.confluent.rbacapi.converters.MdsScopeConverter;
import io.confluent.rbacapi.converters.V1MdsScopeConverter;
import io.confluent.rbacapi.entities.ClusterAccessInfo;
import io.confluent.rbacapi.entities.ManagedRoleBindings;
import io.confluent.rbacapi.entities.MdsScope;
import io.confluent.rbacapi.entities.ScopeRoleBindingMapping;
import io.confluent.rbacapi.entities.VisibilityRequest;
import io.confluent.rbacapi.entities.VisibilityResponse;
import io.confluent.rbacapi.resources.base.LookupResource;
import io.confluent.rbacapi.services.ClusterAccessProcessor;
import io.confluent.rbacapi.services.ClusterRegistryService;
import io.confluent.rbacapi.services.ManagedRoleBindingsBuilder;
import io.confluent.rbacapi.utils.ClusterType;
import io.confluent.rbacapi.utils.RoleAccessUtils;
import io.confluent.rbacapi.utils.RoleUtils;
import io.confluent.rbacapi.utils.ScopeUtils;
import io.confluent.rbacapi.validation.base.ValidationUtil;
import io.confluent.rbacapi.validation.common.ValidPrincipal;
import io.confluent.rbacapi.validation.common.ValidResourceType;
import io.confluent.rbacapi.validation.common.ValidRole;
import io.confluent.rbacapi.validation.v1.V1ValidMdsScope;
import io.confluent.rbacapi.validation.v1.V1ValidationUtil;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.RoleBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;

@Path(value="/1.0/lookup")
@Produces(value={"application/json"})
public class V1LookupResource {
    private final LookupResource delegate;
    private final ClusterAccessProcessor clusterAccessProcessor;
    private final MdsScopeConverter mdsScopeConverter;
    private final SecurityMetadataAuthorizer metadataAuthorizer;
    private final AuthCache authCache;

    public V1LookupResource(AuthCache authCache, SecurityMetadataAuthorizer metadataAuthorizer, ClusterRegistryService clusterRegistryService) {
        this.clusterAccessProcessor = new ClusterAccessProcessor(authCache);
        this.mdsScopeConverter = new V1MdsScopeConverter(clusterRegistryService, (ValidationUtil)new V1ValidationUtil());
        this.metadataAuthorizer = metadataAuthorizer;
        this.authCache = authCache;
        this.delegate = new LookupResource(authCache, metadataAuthorizer, this.mdsScopeConverter);
    }

    @POST
    @Path(value="role/{roleName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v1.lookup.principals.with.role")
    public List<String> lookupPrincipalsWithRole(@Context SecurityContext context, @PathParam(value="roleName") String roleName, @V1ValidMdsScope MdsScope mdsScope) {
        return this.delegate.lookupPrincipalsWithRole(context, roleName, mdsScope);
    }

    @POST
    @Path(value="role/{roleName}/resource/{resourceType}/name/{resourceName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v1.lookup.principals.with.role.on.resource")
    public List<String> lookupPrincipalsWithRoleOnResource(@Context SecurityContext context, @PathParam(value="roleName") @ValidRole String roleName, @PathParam(value="resourceType") @ValidResourceType String resourceType, @PathParam(value="resourceName") String resourceName, @V1ValidMdsScope MdsScope mdsScope) {
        return this.delegate.lookupPrincipalsWithRoleOnResource(context, roleName, resourceType, resourceName, mdsScope);
    }

    @POST
    @Path(value="principals/{principal:.*}/roleNames")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v1.get.scoped.role.names")
    public List<String> getScopedRoleNames(@Context SecurityContext context, @PathParam(value="principal") @ValidPrincipal String principalStr, @V1ValidMdsScope MdsScope mdsScope) {
        KafkaPrincipal principal = this.getTargetPrincipal(context, principalStr);
        return this.delegate.getScopedRoleNames(context, principal, mdsScope);
    }

    @POST
    @Path(value="principals/{principal:.*}/visibility")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v1.get.user.visibility")
    public List<VisibilityResponse> getUserVisibility(@Context SecurityContext context, @PathParam(value="principal") @ValidPrincipal String principalStr, List<VisibilityRequest> visibilityRequestList) {
        return this.getUserVisibilityHelper(context, principalStr, visibilityRequestList);
    }

    @POST
    @Path(value="principal/{principal:.*}/resources")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v1.lookup.resources.for.principal")
    public Map<String, Map<String, List<ResourcePattern>>> lookupResourcesForPrincipal(@Context SecurityContext context, @PathParam(value="principal") @ValidPrincipal String principalStr, @V1ValidMdsScope MdsScope mdsScope) {
        KafkaPrincipal principal = this.getTargetPrincipal(context, principalStr);
        return this.delegate.lookupResourcesForPrincipal(context, principal, mdsScope);
    }

    @GET
    @Path(value="rolebindings/principal/{principal:.*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v1.role.bindings.for.all.known.clusters")
    public List<ScopeRoleBindingMapping> rolebindingsForAllKnownClusters(@Context SecurityContext context, @PathParam(value="principal") @ValidPrincipal String principalStr, @QueryParam(value="clusterType") ClusterType clusterType) {
        KafkaPrincipal principal = this.getTargetPrincipal(context, principalStr);
        return this.delegate.rolebindingsForAllKnownClusters(context, principal, clusterType);
    }

    @POST
    @Path(value="rolebindings/principal/{principal:.*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v1.rolebindings.for.principal.in.scope")
    public ScopeRoleBindingMapping rolebindingsForPrincipalInScope(@Context SecurityContext context, @PathParam(value="principal") @ValidPrincipal String principalStr, @V1ValidMdsScope MdsScope mdsScope) {
        KafkaPrincipal principal = this.getTargetPrincipal(context, principalStr);
        List<ScopeRoleBindingMapping> mappings = this.rolebindingsForPrincipalWithinScope(context, principal, mdsScope);
        if (mappings.isEmpty()) {
            return new ScopeRoleBindingMapping(Scope.ROOT_SCOPE);
        }
        return mappings.get(0);
    }

    @GET
    @Path(value="managed/clusters/principal/{principal:.*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v1.list.managed.clusters.for.principal.for.clustertype")
    public List<MdsScope> listManagedClustersForPrincipal(@Context SecurityContext context, @PathParam(value="principal") @ValidPrincipal String principalStr, @QueryParam(value="clusterType") ClusterType clusterType) {
        KafkaPrincipal principal = this.getTargetPrincipal(context, principalStr);
        return this.listManagedClustersForPrincipalByClusterType(context, principal, clusterType);
    }

    @POST
    @Path(value="managed/clusters/principal/{principal:.*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v1.list.managed.clusters.for.principal")
    public ClusterAccessInfo listManagedClustersForPrincipal(@Context SecurityContext context, @PathParam(value="principal") @ValidPrincipal String principalStr, @V1ValidMdsScope MdsScope mdsScope) {
        KafkaPrincipal principal = this.getTargetPrincipal(context, principalStr);
        return this.listManagedClustersForPrincipalByMdsScope(context, principal, mdsScope);
    }

    @POST
    @Path(value="managed/rolebindings/principal/{principal:.*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v1.managed.rolebindings.for.principal")
    public ManagedRoleBindings managedRoleBindingsForPrincipal(@Context SecurityContext context, @PathParam(value="principal") @ValidPrincipal String principalStr, @QueryParam(value="resourceType") String resourceTypeStr, @V1ValidMdsScope MdsScope mdsScope) {
        KafkaPrincipal principal = this.getTargetPrincipal(context, principalStr);
        return this.managedRoleBindingsForPrincipalHelper(context, principal, resourceTypeStr, mdsScope);
    }

    public ClusterAccessInfo listManagedClustersForPrincipalByMdsScope(SecurityContext context, KafkaPrincipal principal, MdsScope mdsScope) {
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(context);
        Scope scope = this.mdsScopeConverter.getScope(mdsScope, callingPrincipal);
        this.metadataAuthorizer.authorizeSecurityMetadataAccessAllowDescribeSelf(context, principal, SecurityMetadataAuthorizer.DESCRIBE);
        return this.clusterAccessProcessor.process(principal, scope);
    }

    public List<MdsScope> listManagedClustersForPrincipalByClusterType(SecurityContext context, KafkaPrincipal principal, ClusterType clusterType) {
        Set roleBindings;
        this.metadataAuthorizer.authorizeSecurityMetadataAccessAllowDescribeSelf(context, principal, SecurityMetadataAuthorizer.DESCRIBE);
        Set scopes = this.authCache.knownScopes();
        if (clusterType != null) {
            scopes = scopes.stream().filter(ClusterType.filterScopeBy((ClusterType)clusterType)).collect(Collectors.toSet());
        }
        if ((roleBindings = this.authCache.rbacRoleBindings(principal, scopes)).isEmpty()) {
            return Collections.emptyList();
        }
        Set managementRoles = RoleUtils.mapRolesByName((Collection)this.authCache.rbacRoles().roles(), (Predicate)RoleAccessUtils.filterByDescribeAccess()).keySet();
        List scopeList = roleBindings.stream().filter(roleBinding -> managementRoles.contains(roleBinding.role())).map(RoleBinding::scope).distinct().sorted((Comparator<Scope>)ScopeComparator.getInstance()).collect(Collectors.toList());
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(context);
        return scopeList.stream().map(scope -> this.mdsScopeConverter.getMdsScope(callingPrincipal, scope)).collect(Collectors.toList());
    }

    public List<VisibilityResponse> getUserVisibilityHelper(SecurityContext context, String principalStr, List<VisibilityRequest> visibilityRequestList) {
        KafkaPrincipal targetPrincipal = this.getTargetPrincipal(context, principalStr);
        this.metadataAuthorizer.authorizeSecurityMetadataAccessAllowDescribeSelf(context, targetPrincipal, SecurityMetadataAuthorizer.DESCRIBE);
        Set scopesToLookup = visibilityRequestList.stream().map(vr -> this.visibilityRequestToScopeList((VisibilityRequest)vr)).flatMap(scopes -> scopes.stream()).collect(Collectors.toSet());
        Set roleAssignments = this.authCache.rbacRoleBindings(targetPrincipal, scopesToLookup);
        Set visibleScopes = roleAssignments.stream().map(roleBinding -> roleBinding.scope()).collect(Collectors.toSet());
        List<VisibilityResponse> visibilityResponses = visibilityRequestList.stream().map(vr -> this.getVisibilityResponse((VisibilityRequest)vr, visibleScopes, targetPrincipal)).collect(Collectors.toList());
        return visibilityResponses;
    }

    private KafkaPrincipal getTargetPrincipal(SecurityContext context, String principalStr) {
        KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)principalStr);
        if (this.metadataAuthorizer.isCallingPrincipalSameAsTargetPrincipal(context.getUserPrincipal(), principal)) {
            return this.metadataAuthorizer.userPrincipal(context);
        }
        return principal;
    }

    private List<Scope> visibilityRequestToScopeList(VisibilityRequest visibilityRequest) {
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        scopes.add(Scope.kafkaClusterScope((String)visibilityRequest.kafkaClusterId));
        scopes.addAll(visibilityRequest.connectClusterIds.stream().map(clusterId -> new Scope.Builder(new String[0]).withKafkaCluster(visibilityRequest.kafkaClusterId).withCluster("connect-cluster", clusterId).build()).collect(Collectors.toList()));
        scopes.addAll(visibilityRequest.schemaRegistryClusterIds.stream().map(clusterId -> new Scope.Builder(new String[0]).withKafkaCluster(visibilityRequest.kafkaClusterId).withCluster("schema-registry-cluster", clusterId).build()).collect(Collectors.toList()));
        scopes.addAll(visibilityRequest.ksqlClusterIds.stream().map(clusterId -> new Scope.Builder(new String[0]).withKafkaCluster(visibilityRequest.kafkaClusterId).withCluster("ksql-cluster", clusterId).build()).collect(Collectors.toList()));
        return scopes;
    }

    private VisibilityResponse getVisibilityResponse(VisibilityRequest vr, Set<Scope> scopes, KafkaPrincipal targetPrincipal) {
        Scope kafkaScope = Scope.kafkaClusterScope((String)vr.kafkaClusterId);
        VisibilityResponse.ClusterVisibility kakfaVisibility = new VisibilityResponse.ClusterVisibility(vr.kafkaClusterId, scopes.contains(kafkaScope), this.mdsScopeConverter.getClusterName(targetPrincipal, kafkaScope));
        List<VisibilityResponse.ClusterVisibility> connectVisibility = this.subClusterVisibility("connect-cluster", vr.connectClusterIds, vr.kafkaClusterId, scopes, targetPrincipal);
        List<VisibilityResponse.ClusterVisibility> srVisibility = this.subClusterVisibility("schema-registry-cluster", vr.schemaRegistryClusterIds, vr.kafkaClusterId, scopes, targetPrincipal);
        List<VisibilityResponse.ClusterVisibility> ksqlVisibility = this.subClusterVisibility("ksql-cluster", vr.ksqlClusterIds, vr.kafkaClusterId, scopes, targetPrincipal);
        return new VisibilityResponse(kakfaVisibility, connectVisibility, srVisibility, ksqlVisibility);
    }

    private List<VisibilityResponse.ClusterVisibility> subClusterVisibility(String subClusterName, List<String> subClusterIds, String kafkaClusterId, Set<Scope> visibleScopes, KafkaPrincipal principal) {
        return subClusterIds.stream().map(id -> new VisibilityResponse.ClusterVisibility(id, visibleScopes.contains(new Scope.Builder(new String[0]).withKafkaCluster(kafkaClusterId).withCluster(subClusterName, id).build()), this.mdsScopeConverter.getClusterName(principal, new Scope.Builder(new String[0]).withKafkaCluster(kafkaClusterId).withCluster(subClusterName, id).build()))).collect(Collectors.toList());
    }

    public List<ScopeRoleBindingMapping> rolebindingsForPrincipalWithinScope(SecurityContext context, KafkaPrincipal targetPrincipal, MdsScope mdsScope) {
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(context);
        Scope targetScope = this.mdsScopeConverter.getScope(mdsScope, callingPrincipal);
        Set containedScopes = ScopeUtils.knownContainedScopes((Scope)targetScope, (AuthCache)this.authCache);
        Set authorizedScopes = ScopeUtils.securityMetadataAuthorizedScopesAllowDescribeSelf((Set)containedScopes, (KafkaPrincipal)targetPrincipal, (SecurityContext)context, (Operation)SecurityMetadataAuthorizer.DESCRIBE, (SecurityMetadataAuthorizer)this.metadataAuthorizer);
        Set targetRoleBindings = this.authCache.rbacRoleBindings(targetPrincipal, authorizedScopes);
        if (targetRoleBindings.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<Scope, ScopeRoleBindingMapping> byScope = new HashMap<Scope, ScopeRoleBindingMapping>();
        for (RoleBinding roleBinding : targetRoleBindings) {
            ScopeRoleBindingMapping mapping = byScope.computeIfAbsent(roleBinding.scope(), ScopeRoleBindingMapping::new);
            mapping.addRoleBinding(roleBinding);
        }
        return byScope.values().stream().sorted((a, b) -> ScopeComparator.getInstance().compare(a.scope().scope(), b.scope().scope())).collect(Collectors.toList());
    }

    private ManagedRoleBindings managedRoleBindingsForPrincipalHelper(SecurityContext context, KafkaPrincipal principal, String resourceTypeStr, MdsScope mdsScope) {
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(context);
        Scope scope = this.mdsScopeConverter.getScope(mdsScope, callingPrincipal);
        this.metadataAuthorizer.authorizeSecurityMetadataAccessAllowDescribeSelf(context, principal, SecurityMetadataAuthorizer.DESCRIBE);
        ResourceType resourceType = resourceTypeStr != null ? new ResourceType(resourceTypeStr) : ResourceType.ALL;
        ManagedRoleBindingsBuilder processor = new ManagedRoleBindingsBuilder(this.authCache);
        return processor.build(scope, principal, resourceType);
    }
}

