/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.v1;

import io.confluent.oidc.resources.OidcTokenResource;
import io.confluent.oidc.services.OidcTokenService;
import io.confluent.rbacapi.validation.v1.V1ValidOidcCaller;
import io.confluent.rest.annotations.PerformanceMetric;
import java.net.URI;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/1.0/oidc")
@Produces(value={"application/json"})
public class V1OidcResource {
    private final OidcTokenResource delegate;

    public V1OidcResource(OidcTokenService oidcTokenService) {
        this.delegate = new OidcTokenResource(oidcTokenService);
    }

    @GET
    @Path(value="/authenticate")
    @PerformanceMetric(value="v1.oidc.authenticate")
    public Response getIdpAuthUri(@Context UriInfo uriInfo, @QueryParam(value="caller") @V1ValidOidcCaller URI caller) {
        return this.delegate.getIdpAuthUri(uriInfo, caller);
    }

    @GET
    @Path(value="/authorization-code/callback")
    @PerformanceMetric(value="v1.oidc.callback")
    public Response handleCallback(@CookieParam(value="o2state") Cookie encryptedStateCookie, @QueryParam(value="state") String state, @QueryParam(value="code") String code, @QueryParam(value="error") String error, @QueryParam(value="error_description") String errorDescription) {
        return this.delegate.handleCallback(encryptedStateCookie, state, code, error, errorDescription);
    }

    @GET
    @Path(value="/check-session")
    @PerformanceMetric(value="v1.oidc.check-session")
    public Response checkSession(@Context SecurityContext securityContext, @CookieParam(value="auth_token") Cookie authTokenCookie) {
        return this.delegate.checkSessionAndRefreshToken(securityContext, authTokenCookie);
    }

    @POST
    @Path(value="/logout")
    @PerformanceMetric(value="v1.oidc.logout")
    public Response clearToken(@Context SecurityContext securityContext) {
        return this.delegate.clearToken(securityContext);
    }
}

