/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.confluent.rbacapi.rest.LeaderAwareApplication;
import java.io.IOException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.proxy.AsyncProxyServlet;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdsWriterProxyServlet
extends AsyncProxyServlet {
    private static final Logger log = LoggerFactory.getLogger(MdsWriterProxyServlet.class);
    private final LeaderAwareApplication application;
    private SslContextFactory sslContextFactory = new SslContextFactory.Client();

    public MdsWriterProxyServlet(LeaderAwareApplication application) {
        this.application = application;
    }

    @NotNull
    public void setSslContextFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = (SslContextFactory)Preconditions.checkNotNull((Object)sslContextFactory);
    }

    protected HttpClient newHttpClient() {
        int selectors = Math.max(1, ProcessorUtils.availableProcessors() / 2);
        String value = this.getServletConfig().getInitParameter("selectors");
        if (value != null) {
            selectors = Integer.parseInt(value);
        }
        HttpClient client = new HttpClient((HttpClientTransport)new HttpClientTransportOverHTTP(selectors), this.sslContextFactory);
        client.setRequestBufferSize(8192);
        return client;
    }

    @VisibleForTesting
    public String rewriteTarget(HttpServletRequest clientRequest) {
        return this.extractProxyUri(clientRequest);
    }

    private String extractProxyUri(HttpServletRequest clientRequest) {
        int index;
        String path = clientRequest.getRequestURI();
        String contextPath = clientRequest.getContextPath();
        String servletPath = clientRequest.getServletPath();
        if (contextPath != null && !contextPath.isEmpty() && path.contains(contextPath)) {
            index = path.indexOf(contextPath);
            path = path.substring(0, index) + path.substring(index + contextPath.length());
        }
        if (servletPath != null && !servletPath.isEmpty() && path.contains(servletPath)) {
            index = path.indexOf(servletPath);
            path = path.substring(0, index) + path.substring(index + servletPath.length());
        }
        if (path == null || !path.startsWith("/")) {
            return null;
        }
        URL leader = this.getLeader(clientRequest.getScheme());
        if (leader == null) {
            try {
                HttpServletResponse response = (HttpServletResponse)clientRequest.getAttribute("javax.servlet.error.response");
                response.sendError(500, "Unable to determine leader. Try again later.");
                log.error("Unable to determine leader.");
            }
            catch (IOException e) {
                log.error(String.valueOf(e));
            }
            return null;
        }
        log.debug(String.format("Forwarding request for path %s to leader %s", path, leader));
        return UriBuilder.fromUri((String)leader.toString()).path(path).replaceQuery(clientRequest.getQueryString()).build(new Object[0]).toString();
    }

    private URL getLeader(String protocol) {
        return this.application.getLeader(protocol);
    }
}

