/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.tokenapi.resources.v1;

import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.tokenapi.entities.RefreshTokenRequest;
import io.confluent.tokenapi.entities.SanitizeTokenRequest;
import io.confluent.tokenapi.resources.base.TokenResource;
import io.confluent.tokenapi.services.TokenService;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/1.0/")
@Produces(value={"application/json"})
public class V1TokenResource {
    private final TokenResource delegate;

    public V1TokenResource(TokenService tokenService) {
        this.delegate = new TokenResource(tokenService);
    }

    @GET
    @Path(value="authenticate")
    @PerformanceMetric(value="v1.authenticate")
    public Response issueToken(@Context SecurityContext auth, @Context HttpHeaders headers, @QueryParam(value="audience") List<String> aud) {
        return this.delegate.issueToken(auth, headers.getRequestHeaders(), aud);
    }

    @GET
    @Path(value="/token/clear")
    @PerformanceMetric(value="v1.token.clear")
    public Response clearToken() {
        return this.delegate.clearToken();
    }

    @POST
    @Path(value="token/refresh")
    @PerformanceMetric(value="v1.token.refresh")
    public Response refreshToken(@Context SecurityContext auth, RefreshTokenRequest refreshRequest) {
        return this.delegate.refreshToken(auth, refreshRequest);
    }

    @POST
    @Path(value="token/sanitize")
    @PerformanceMetric(value="v1.token.sanitize")
    public Response sanitizeToken(@Context SecurityContext auth, SanitizeTokenRequest sanitizeTokenRequest) {
        return this.delegate.sanitizeToken(auth, sanitizeTokenRequest);
    }
}

