/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrenttrees.radix.node.concrete.bytearray;

import com.googlecode.concurrenttrees.radix.node.Node;
import com.googlecode.concurrenttrees.radix.node.concrete.bytearray.ByteArrayCharSequence;
import com.googlecode.concurrenttrees.radix.node.util.AtomicReferenceArrayListAdapter;
import com.googlecode.concurrenttrees.radix.node.util.NodeCharacterComparator;
import com.googlecode.concurrenttrees.radix.node.util.NodeUtil;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class ByteArrayNodeDefault
implements Node {
    private final byte[] incomingEdgeCharArray;
    private final AtomicReferenceArray<Node> outgoingEdges;
    private final List<Node> outgoingEdgesAsList;
    private final Object value;

    public ByteArrayNodeDefault(CharSequence edgeCharSequence, Object value, List<Node> outgoingEdges) {
        Node[] childNodeArray = outgoingEdges.toArray(new Node[outgoingEdges.size()]);
        Arrays.sort(childNodeArray, new NodeCharacterComparator());
        this.outgoingEdges = new AtomicReferenceArray<Node>(childNodeArray);
        this.incomingEdgeCharArray = ByteArrayCharSequence.toSingleByteUtf8Encoding(edgeCharSequence);
        this.value = value;
        this.outgoingEdgesAsList = new AtomicReferenceArrayListAdapter<Node>(this.outgoingEdges);
    }

    @Override
    public CharSequence getIncomingEdge() {
        return new ByteArrayCharSequence(this.incomingEdgeCharArray, 0, this.incomingEdgeCharArray.length);
    }

    @Override
    public Character getIncomingEdgeFirstCharacter() {
        return Character.valueOf((char)(this.incomingEdgeCharArray[0] & 0xFF));
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Node getOutgoingEdge(Character edgeFirstCharacter) {
        int index = NodeUtil.binarySearchForEdge(this.outgoingEdges, edgeFirstCharacter);
        if (index < 0) {
            return null;
        }
        return this.outgoingEdges.get(index);
    }

    @Override
    public void updateOutgoingEdge(Node childNode) {
        int index = NodeUtil.binarySearchForEdge(this.outgoingEdges, childNode.getIncomingEdgeFirstCharacter());
        if (index < 0) {
            throw new IllegalStateException("Cannot update the reference to the following child node for the edge starting with '" + childNode.getIncomingEdgeFirstCharacter() + "', no such edge already exists: " + childNode);
        }
        this.outgoingEdges.set(index, childNode);
    }

    @Override
    public List<Node> getOutgoingEdges() {
        return this.outgoingEdgesAsList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node{");
        sb.append("edge=").append(this.getIncomingEdge());
        sb.append(", value=").append(this.value);
        sb.append(", edges=").append(this.getOutgoingEdges());
        sb.append("}");
        return sb.toString();
    }
}

