/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.cli.Cli;
import io.confluent.ksql.cli.Options;
import io.confluent.ksql.cli.console.OutputFormat;
import io.confluent.ksql.properties.PropertiesUtil;
import io.confluent.ksql.rest.client.BasicCredentials;
import io.confluent.ksql.rest.client.KsqlRestClient;
import io.confluent.ksql.util.ErrorMessageUtil;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Ksql {
    private static final Logger LOGGER = LoggerFactory.getLogger(Ksql.class);
    private static final Predicate<String> NOT_CLIENT_SIDE_CONFIG = key -> !key.startsWith("ssl.") && !key.equals("security.protocol") && !key.startsWith("sasl.");
    private final Options options;
    private final KsqlClientBuilder clientBuilder;
    private final Properties systemProps;
    private final CliBuilder cliBuilder;

    @VisibleForTesting
    Ksql(Options options, Properties systemProps, KsqlClientBuilder clientBuilder, CliBuilder cliBuilder) {
        this.options = Objects.requireNonNull(options, "options");
        this.systemProps = Objects.requireNonNull(systemProps, "systemProps");
        this.clientBuilder = Objects.requireNonNull(clientBuilder, "clientBuilder");
        this.cliBuilder = Objects.requireNonNull(cliBuilder, "cliBuilder");
    }

    public static void main(String[] args) throws IOException {
        Options options = Options.parse(args);
        if (options == null) {
            System.exit(-1);
        }
        if (options.requiresPassword()) {
            options.setPassword(Ksql.readPassword());
        }
        int errorCode = 0;
        try {
            errorCode = new Ksql(options, System.getProperties(), KsqlRestClient::create, Cli::build).run();
        }
        catch (Exception e) {
            String msg = ErrorMessageUtil.buildErrorMessage((Throwable)e);
            LOGGER.error(msg);
            System.err.println(msg);
            System.exit(-1);
        }
        System.exit(errorCode);
    }

    private static String readPassword() {
        Console console = System.console();
        if (console == null) {
            System.err.println("Could not get console for enter password; use -p option instead.");
            System.exit(-1);
        }
        String password = "";
        while (password.isEmpty()) {
            password = new String(console.readPassword("Enter password: ", new Object[0]));
            if (!password.isEmpty()) continue;
            console.writer().println("Error: password can not be empty");
        }
        return password;
    }

    /*
     * Exception decompiling
     */
    int run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private KsqlRestClient buildClient(Map<String, String> configProps) {
        Map<String, String> localProps = Ksql.stripClientSideProperties(configProps);
        Map clientProps = PropertiesUtil.applyOverrides(configProps, (Properties)this.systemProps);
        String server = this.options.getServer();
        Optional<BasicCredentials> creds = this.options.getUserNameAndPassword();
        Optional<BasicCredentials> ccloudApiKey = this.options.getCCloudApiKey();
        return this.clientBuilder.build(server, localProps, clientProps, creds, ccloudApiKey);
    }

    private static Map<String, String> stripClientSideProperties(Map<String, String> props) {
        return PropertiesUtil.filterByKey(props, NOT_CLIENT_SIDE_CONFIG);
    }

    private static Map<String, String> loadProperties(String propertiesFile) {
        return PropertiesUtil.loadProperties((File)new File(propertiesFile));
    }

    static interface CliBuilder {
        public Cli build(Long var1, Long var2, OutputFormat var3, KsqlRestClient var4);
    }

    static interface KsqlClientBuilder {
        public KsqlRestClient build(String var1, Map<String, ?> var2, Map<String, String> var3, Optional<BasicCredentials> var4, Optional<BasicCredentials> var5);
    }
}

