/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import io.confluent.ksql.cli.console.CliConfig;
import io.confluent.ksql.cli.console.JLineTerminal;
import io.confluent.ksql.cli.console.KsqlTerminal;
import io.confluent.ksql.cli.console.OutputFormat;
import io.confluent.ksql.cli.console.cmd.CliSpecificCommand;
import io.confluent.ksql.cli.console.table.Table;
import io.confluent.ksql.cli.console.table.builder.CommandStatusTableBuilder;
import io.confluent.ksql.cli.console.table.builder.ConnectorInfoTableBuilder;
import io.confluent.ksql.cli.console.table.builder.ConnectorListTableBuilder;
import io.confluent.ksql.cli.console.table.builder.ConnectorPluginsListTableBuilder;
import io.confluent.ksql.cli.console.table.builder.DropConnectorTableBuilder;
import io.confluent.ksql.cli.console.table.builder.ExecutionPlanTableBuilder;
import io.confluent.ksql.cli.console.table.builder.FunctionNameListTableBuilder;
import io.confluent.ksql.cli.console.table.builder.KafkaTopicsListTableBuilder;
import io.confluent.ksql.cli.console.table.builder.ListVariablesTableBuilder;
import io.confluent.ksql.cli.console.table.builder.PropertiesListTableBuilder;
import io.confluent.ksql.cli.console.table.builder.QueriesTableBuilder;
import io.confluent.ksql.cli.console.table.builder.StreamsListTableBuilder;
import io.confluent.ksql.cli.console.table.builder.TableBuilder;
import io.confluent.ksql.cli.console.table.builder.TablesListTableBuilder;
import io.confluent.ksql.cli.console.table.builder.TerminateQueryTableBuilder;
import io.confluent.ksql.cli.console.table.builder.TopicDescriptionTableBuilder;
import io.confluent.ksql.cli.console.table.builder.TypeListTableBuilder;
import io.confluent.ksql.cli.console.table.builder.WarningEntityTableBuilder;
import io.confluent.ksql.metrics.TopicSensors;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.query.QueryError;
import io.confluent.ksql.rest.ApiJsonMapper;
import io.confluent.ksql.rest.entity.ArgumentInfo;
import io.confluent.ksql.rest.entity.AssertSchemaEntity;
import io.confluent.ksql.rest.entity.AssertTopicEntity;
import io.confluent.ksql.rest.entity.CommandStatusEntity;
import io.confluent.ksql.rest.entity.ConnectorDescription;
import io.confluent.ksql.rest.entity.ConnectorList;
import io.confluent.ksql.rest.entity.ConnectorPluginsList;
import io.confluent.ksql.rest.entity.ConnectorStateInfo;
import io.confluent.ksql.rest.entity.CreateConnectorEntity;
import io.confluent.ksql.rest.entity.DropConnectorEntity;
import io.confluent.ksql.rest.entity.ExecutionPlan;
import io.confluent.ksql.rest.entity.FieldInfo;
import io.confluent.ksql.rest.entity.FunctionDescriptionList;
import io.confluent.ksql.rest.entity.FunctionNameList;
import io.confluent.ksql.rest.entity.KafkaTopicsList;
import io.confluent.ksql.rest.entity.KafkaTopicsListExtended;
import io.confluent.ksql.rest.entity.KsqlEntity;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.KsqlStatementErrorMessage;
import io.confluent.ksql.rest.entity.KsqlWarning;
import io.confluent.ksql.rest.entity.PropertiesList;
import io.confluent.ksql.rest.entity.Queries;
import io.confluent.ksql.rest.entity.QueryDescription;
import io.confluent.ksql.rest.entity.QueryDescriptionEntity;
import io.confluent.ksql.rest.entity.QueryDescriptionList;
import io.confluent.ksql.rest.entity.QueryHostStat;
import io.confluent.ksql.rest.entity.QueryOffsetSummary;
import io.confluent.ksql.rest.entity.QueryTopicOffsetSummary;
import io.confluent.ksql.rest.entity.RunningQuery;
import io.confluent.ksql.rest.entity.SourceDescription;
import io.confluent.ksql.rest.entity.SourceDescriptionEntity;
import io.confluent.ksql.rest.entity.SourceDescriptionList;
import io.confluent.ksql.rest.entity.StreamedRow;
import io.confluent.ksql.rest.entity.StreamsList;
import io.confluent.ksql.rest.entity.TablesList;
import io.confluent.ksql.rest.entity.TerminateQueryEntity;
import io.confluent.ksql.rest.entity.TopicDescription;
import io.confluent.ksql.rest.entity.TypeList;
import io.confluent.ksql.rest.entity.VariablesList;
import io.confluent.ksql.rest.entity.WarningEntity;
import io.confluent.ksql.util.CmdLineUtil;
import io.confluent.ksql.util.HandlerMaps;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.TabularRow;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.config.ConfigException;
import org.jline.terminal.Terminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Console.class);
    private static final ObjectMapper OBJECT_MAPPER = ApiJsonMapper.INSTANCE.get();
    private static final HandlerMaps.ClassHandlerMap1<KsqlEntity, Console> PRINT_HANDLERS = HandlerMaps.forClass(KsqlEntity.class).withArgType(Console.class).put(CommandStatusEntity.class, Console.tablePrinter(CommandStatusEntity.class, CommandStatusTableBuilder::new)).put(PropertiesList.class, Console.tablePrinter(PropertiesList.class, PropertiesListTableBuilder::new)).put(Queries.class, Console.tablePrinter(Queries.class, QueriesTableBuilder::new)).put(SourceDescriptionEntity.class, (console, entity) -> console.printSourceDescription(entity.getSourceDescription())).put(SourceDescriptionList.class, Console::printSourceDescriptionList).put(QueryDescriptionEntity.class, (console, entity) -> console.printQueryDescription(entity.getQueryDescription())).put(QueryDescriptionList.class, Console::printQueryDescriptionList).put(TopicDescription.class, Console.tablePrinter(TopicDescription.class, TopicDescriptionTableBuilder::new)).put(StreamsList.class, Console.tablePrinter(StreamsList.class, StreamsListTableBuilder::new)).put(TablesList.class, Console.tablePrinter(TablesList.class, TablesListTableBuilder::new)).put(KafkaTopicsList.class, Console.tablePrinter(KafkaTopicsList.class, KafkaTopicsListTableBuilder.SimpleBuilder::new)).put(KafkaTopicsListExtended.class, Console.tablePrinter(KafkaTopicsListExtended.class, KafkaTopicsListTableBuilder.ExtendedBuilder::new)).put(ExecutionPlan.class, Console.tablePrinter(ExecutionPlan.class, ExecutionPlanTableBuilder::new)).put(FunctionNameList.class, Console.tablePrinter(FunctionNameList.class, FunctionNameListTableBuilder::new)).put(FunctionDescriptionList.class, Console::printFunctionDescription).put(CreateConnectorEntity.class, Console.tablePrinter(CreateConnectorEntity.class, ConnectorInfoTableBuilder::new)).put(DropConnectorEntity.class, Console.tablePrinter(DropConnectorEntity.class, DropConnectorTableBuilder::new)).put(ConnectorList.class, Console.tablePrinter(ConnectorList.class, ConnectorListTableBuilder::new)).put(ConnectorPluginsList.class, Console.tablePrinter(ConnectorPluginsList.class, ConnectorPluginsListTableBuilder::new)).put(ConnectorDescription.class, Console::printConnectorDescription).put(TypeList.class, Console.tablePrinter(TypeList.class, TypeListTableBuilder::new)).put(WarningEntity.class, Console.tablePrinter(WarningEntity.class, WarningEntityTableBuilder::new)).put(VariablesList.class, Console.tablePrinter(VariablesList.class, ListVariablesTableBuilder::new)).put(TerminateQueryEntity.class, Console.tablePrinter(TerminateQueryEntity.class, TerminateQueryTableBuilder::new)).put(AssertTopicEntity.class, Console::printAssertTopic).put(AssertSchemaEntity.class, Console::printAssertSchema).build();
    private final Map<String, CliSpecificCommand> cliSpecificCommands;
    private final KsqlTerminal terminal;
    private final RowCaptor rowCaptor;
    private OutputFormat outputFormat;
    private Optional<File> spoolFile = Optional.empty();
    private CliConfig config;

    private static <T extends KsqlEntity> HandlerMaps.Handler1<KsqlEntity, Console> tablePrinter(Class<T> entityType, Supplier<? extends TableBuilder<T>> tableBuilderType) {
        try {
            TableBuilder tableBuilder = tableBuilderType.get();
            return (console, type) -> {
                Table table = tableBuilder.buildTable((KsqlEntity)entityType.cast(type));
                table.print((Console)console);
            };
        }
        catch (Exception e) {
            throw new IllegalStateException("Error instantiating tableBuilder: " + tableBuilderType);
        }
    }

    public static Console build(OutputFormat outputFormat) {
        AtomicReference<Console> consoleRef = new AtomicReference<Console>();
        Predicate<String> isCliCommand = line -> {
            Console theConsole = (Console)consoleRef.get();
            return theConsole != null && theConsole.getCliCommand((String)line).isPresent();
        };
        Path historyFilePath = Paths.get(System.getProperty("history-file", System.getProperty("user.home") + "/.ksql-history"), new String[0]).toAbsolutePath();
        JLineTerminal terminal = new JLineTerminal(isCliCommand, historyFilePath);
        Console console = new Console(outputFormat, terminal, new NoOpRowCaptor());
        consoleRef.set(console);
        return console;
    }

    public Console(OutputFormat outputFormat, KsqlTerminal terminal, RowCaptor rowCaptor) {
        this.outputFormat = Objects.requireNonNull(outputFormat, "outputFormat");
        this.terminal = Objects.requireNonNull(terminal, "terminal");
        this.rowCaptor = Objects.requireNonNull(rowCaptor, "rowCaptor");
        this.cliSpecificCommands = Maps.newLinkedHashMap();
        this.config = new CliConfig((Map<?, ?>)ImmutableMap.of());
    }

    public PrintWriter writer() {
        return this.terminal.writer();
    }

    public void flush() {
        this.terminal.flush();
    }

    public void setSpool(File file) {
        try {
            this.terminal.setSpool(new PrintWriter(file, Charset.defaultCharset().name()));
            this.spoolFile = Optional.of(file);
            this.terminal.writer().println("Session will be spooled to " + file.getAbsolutePath());
            this.terminal.writer().println("Enter SPOOL OFF to disable");
        }
        catch (IOException e) {
            throw new KsqlException("Cannot SPOOL to file: " + file, (Throwable)e);
        }
    }

    public void unsetSpool() {
        this.terminal.unsetSpool();
        this.spoolFile.ifPresent(f -> this.terminal.writer().println("Spool written to " + f.getAbsolutePath()));
        this.spoolFile = Optional.empty();
    }

    public int getWidth() {
        return this.terminal.getWidth();
    }

    public void clearScreen() {
        this.terminal.clearScreen();
    }

    public KsqlTerminal.StatusClosable setStatusMessage(String message) {
        return this.terminal.setStatusMessage(message);
    }

    public void handle(Terminal.Signal signal, Terminal.SignalHandler signalHandler) {
        this.terminal.handle(signal, signalHandler);
    }

    public void setCliProperty(String name, Object value) {
        try {
            this.config = this.config.with(name, value);
        }
        catch (ConfigException e) {
            this.terminal.writer().println(e.getMessage());
        }
    }

    @Override
    public void close() {
        this.terminal.close();
    }

    public void addResult(List<List<String>> rowValues) {
        this.rowCaptor.addRows(rowValues);
    }

    public Map<String, CliSpecificCommand> getCliSpecificCommands() {
        return new HashMap<String, CliSpecificCommand>(this.cliSpecificCommands);
    }

    public String nextNonCliCommand() {
        String line;
        while (this.maybeHandleCliSpecificCommands(line = this.terminal.readLine())) {
        }
        return line;
    }

    public List<KsqlTerminal.HistoryEntry> getHistory() {
        return Collections.unmodifiableList(this.terminal.getHistory());
    }

    public void printErrorMessage(KsqlErrorMessage errorMessage) {
        if (errorMessage instanceof KsqlStatementErrorMessage) {
            this.printKsqlEntityList((List<KsqlEntity>)((KsqlStatementErrorMessage)errorMessage).getEntities());
        }
        this.printError(errorMessage.getMessage(), errorMessage.toString());
    }

    public void printError(String shortMsg, String fullMsg) {
        log.error(fullMsg);
        this.terminal.printError(shortMsg);
    }

    public void printStreamedRow(StreamedRow row) {
        row.getErrorMessage().ifPresent(this::printErrorMessage);
        row.getFinalMessage().ifPresent(finalMsg -> this.writer().println((String)finalMsg));
        row.getHeader().ifPresent(this::printRowHeader);
        if (row.getRow().isPresent()) {
            switch (this.outputFormat) {
                case JSON: {
                    this.printAsJson(row.getRow().get());
                    break;
                }
                case TABULAR: {
                    this.printAsTable((StreamedRow.DataRow)row.getRow().get());
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Unexpected output format: '%s'", this.outputFormat.name()));
                }
            }
        }
    }

    public void printKsqlEntityList(List<KsqlEntity> entityList) {
        switch (this.outputFormat) {
            case JSON: {
                this.printAsJson(entityList);
                break;
            }
            case TABULAR: {
                boolean showStatements = entityList.size() > 1;
                for (KsqlEntity ksqlEntity : entityList) {
                    this.writer().println();
                    if (showStatements) {
                        this.writer().println(ksqlEntity.getStatementText());
                    }
                    this.printAsTable(ksqlEntity);
                }
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unexpected output format: '%s'", this.outputFormat.name()));
            }
        }
    }

    private void printRowHeader(StreamedRow.Header header) {
        switch (this.outputFormat) {
            case JSON: {
                this.printAsJson(header);
                break;
            }
            case TABULAR: {
                this.writer().println(TabularRow.createHeader((int)this.getWidth(), (List)header.getSchema().columns(), (boolean)this.config.getString("WRAP").equalsIgnoreCase(CliConfig.OnOff.ON.toString()), (int)this.config.getInt("COLUMN-WIDTH")));
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unexpected output format: '%s'", this.outputFormat.name()));
            }
        }
    }

    public void registerCliSpecificCommand(CliSpecificCommand cliSpecificCommand) {
        this.cliSpecificCommands.put(cliSpecificCommand.getName().toLowerCase(), cliSpecificCommand);
    }

    public void setOutputFormat(String newFormat) {
        try {
            this.outputFormat = OutputFormat.get(newFormat);
            this.writer().printf("Output format set to %s%n", this.outputFormat.name());
        }
        catch (IllegalArgumentException exception) {
            this.writer().printf("Invalid output format: '%s' (valid formats: %s)%n", newFormat, OutputFormat.VALID_FORMATS);
        }
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    private Optional<CliCmdExecutor> getCliCommand(String line) {
        List<String> parts = CmdLineUtil.splitByUnquotedWhitespace(StringUtils.stripEnd((String)line.trim(), (String)";"));
        if (parts.isEmpty()) {
            return Optional.empty();
        }
        String command = String.join((CharSequence)" ", parts);
        return this.cliSpecificCommands.values().stream().filter(cliSpecificCommand -> cliSpecificCommand.matches(command)).map(cliSpecificCommand -> CliCmdExecutor.of(cliSpecificCommand, parts)).findFirst();
    }

    private void printAsTable(StreamedRow.DataRow row) {
        this.rowCaptor.addRow(row);
        boolean tombstone = row.getTombstone().orElse(false);
        List columns = tombstone ? row.getColumns().stream().map(val -> val == null ? "<TOMBSTONE>" : val).collect(Collectors.toList()) : row.getColumns();
        this.writer().println(TabularRow.createRow((int)this.getWidth(), columns, (boolean)this.config.getString("WRAP").equalsIgnoreCase(CliConfig.OnOff.ON.toString()), (int)this.config.getInt("COLUMN-WIDTH")));
        this.flush();
    }

    private void printAsTable(KsqlEntity entity) {
        HandlerMaps.Handler1 handler = PRINT_HANDLERS.get(entity.getClass());
        if (handler == null) {
            throw new RuntimeException(String.format("Unexpected KsqlEntity class: '%s'", entity.getClass().getCanonicalName()));
        }
        handler.handle((Object)this, (Object)entity);
        this.printWarnings(entity);
    }

    private void printWarnings(KsqlEntity entity) {
        for (KsqlWarning warning : entity.getWarnings()) {
            this.writer().println("WARNING: " + warning.getMessage());
        }
    }

    private static String formatFieldType(FieldInfo field, Optional<WindowType> windowType, boolean isTable) {
        FieldInfo.FieldType possibleFieldType = field.getType().orElse(null);
        if (possibleFieldType == FieldInfo.FieldType.HEADER) {
            String headerType = field.getHeaderKey().map(k -> "(header('" + k + "'))").orElse("(headers)");
            return String.format("%-16s %s", field.getSchema().toTypeString(), headerType);
        }
        if (possibleFieldType == FieldInfo.FieldType.KEY) {
            String wt = windowType.map(v -> " (Window type: " + v + ")").orElse("");
            String keyType = isTable ? "(primary key)" : "(key)";
            return String.format("%-16s %s%s", field.getSchema().toTypeString(), keyType, wt);
        }
        return field.getSchema().toTypeString();
    }

    private void printSchema(Optional<WindowType> windowType, List<FieldInfo> fields, boolean isTable) {
        Table.Builder tableBuilder = new Table.Builder();
        if (!fields.isEmpty()) {
            tableBuilder.withColumnHeaders("Field", "Type");
            fields.forEach(f -> tableBuilder.withRow(f.getName(), Console.formatFieldType(f, windowType, isTable)));
            tableBuilder.build().print(this);
        }
    }

    private void printTopicInfo(SourceDescription source) {
        String timestamp = source.getTimestamp().isEmpty() ? "Not set - using <ROWTIME>" : source.getTimestamp();
        this.writer().println(String.format("%-20s : %s", "Timestamp field", timestamp));
        this.writer().println(String.format("%-20s : %s", "Key format", source.getKeyFormat()));
        this.writer().println(String.format("%-20s : %s", "Value format", source.getValueFormat()));
        if (!source.getTopic().isEmpty()) {
            String topicInformation = String.format("%-20s : %s", "Kafka topic", source.getTopic());
            if (source.getPartitions() != 0) {
                topicInformation = topicInformation.concat(String.format(" (partitions: %d, replication: %d)", source.getPartitions(), source.getReplication()));
            }
            this.writer().println(topicInformation);
        }
    }

    private void printSourceConstraints(List<String> sourceConstraints) {
        if (!sourceConstraints.isEmpty()) {
            this.writer().println(String.format("%n%-20s%n%-20s", "Sources that have a DROP constraint on this source", "--------------------------------------------------"));
            sourceConstraints.forEach(sourceName -> this.writer().println((String)sourceName));
        }
    }

    private void printQueries(List<RunningQuery> queries, String type, String operation) {
        if (!queries.isEmpty()) {
            this.writer().println(String.format("%n%-20s%n%-20s", "Queries that " + operation + " from this " + type, "-----------------------------------"));
            for (RunningQuery writeQuery : queries) {
                this.writer().println(writeQuery.getId() + " (" + writeQuery.getState().orElse("N/A") + ") : " + writeQuery.getQuerySingleLine());
            }
            this.writer().println("\nFor query topology and execution plan please run: EXPLAIN <QueryId>");
        }
    }

    private void printExecutionPlan(QueryDescription queryDescription) {
        if (!queryDescription.getExecutionPlan().isEmpty()) {
            this.writer().println(String.format("%n%-20s%n%-20s%n%s", "Execution plan", "--------------", queryDescription.getExecutionPlan()));
        }
    }

    private void printTopology(QueryDescription queryDescription) {
        if (!queryDescription.getTopology().isEmpty()) {
            this.writer().println(String.format("%n%-20s%n%-20s%n%s", "Processing topology", "-------------------", queryDescription.getTopology()));
        }
    }

    private void printOverriddenProperties(QueryDescription queryDescription) {
        Map overriddenProperties = queryDescription.getOverriddenProperties();
        if (overriddenProperties.isEmpty()) {
            return;
        }
        List<List<String>> rows = overriddenProperties.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(prop -> Arrays.asList((String)prop.getKey(), Objects.toString(prop.getValue()))).collect(Collectors.toList());
        new Table.Builder().withColumnHeaders("Property", "Value").withRows(rows).withHeaderLine(String.format("%n%-20s%n%-20s", "Overridden Properties", "---------------------")).build().print(this);
    }

    private void printQueryError(QueryDescription query) {
        this.writer().println();
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss,SSS (z)");
        for (QueryError error : query.getQueryErrors()) {
            Instant ts = Instant.ofEpochMilli(error.getTimestamp());
            String errorDate = ts.atZone(ZoneId.systemDefault()).format(dateFormatter);
            this.writer().println(String.format("%-20s : %s", "Error Date", errorDate));
            this.writer().println(String.format("%-20s : %s", "Error Details", error.getErrorMessage()));
            this.writer().println(String.format("%-20s : %s", "Error Type", error.getType()));
        }
    }

    private void printStatistics(SourceDescription source) {
        List statistics = source.getClusterStatistics();
        List errors = source.getClusterErrorStats();
        if (statistics.isEmpty() && errors.isEmpty()) {
            this.writer().println(String.format("%n%-20s%n%s", "Local runtime statistics", "------------------------"));
            this.writer().println(source.getStatistics());
            this.writer().println(source.getErrorStats());
            return;
        }
        ImmutableList headers = ImmutableList.of((Object)"Host", (Object)"Metric", (Object)"Value", (Object)"Last Message");
        Stream rows = Streams.concat((Stream[])new Stream[]{statistics.stream(), errors.stream()});
        this.writer().println(String.format("%n%-20s%n%s", "Runtime statistics by host", "-------------------------"));
        Table statsTable = new Table.Builder().withColumnHeaders((List<String>)headers).withRows(rows.sorted(Comparator.comparing(QueryHostStat::host).thenComparing(TopicSensors.Stat::name)).map(metric -> {
            String hostCell = metric.host().toString();
            String formattedValue = String.format("%10.0f", metric.getValue());
            return ImmutableList.of((Object)hostCell, (Object)metric.name(), (Object)formattedValue, (Object)metric.timestamp());
        })).build();
        statsTable.print(this);
    }

    private void printSourceDescription(SourceDescription source) {
        boolean isTable = source.getType().equalsIgnoreCase("TABLE");
        this.writer().println(String.format("%-20s : %s", "Name", source.getName()));
        if (!source.isExtended()) {
            this.printSchema(source.getWindowType(), source.getFields(), isTable);
            this.writer().println("For runtime statistics and query details run: DESCRIBE <Stream,Table> EXTENDED;");
            return;
        }
        this.writer().println(String.format("%-20s : %s", "Type", source.getType()));
        this.printTopicInfo(source);
        this.writer().println(String.format("%-20s : %s", "Statement", source.getStatement()));
        this.writer().println("");
        this.printSchema(source.getWindowType(), source.getFields(), isTable);
        this.printSourceConstraints(source.getSourceConstraints());
        this.printQueries(source.getReadQueries(), source.getType(), "read");
        this.printQueries(source.getWriteQueries(), source.getType(), "write");
        this.printStatistics(source);
        this.writer().println(String.format("(%s)", "Statistics of the local KSQL server interaction with the Kafka topic " + source.getTopic()));
        if (!source.getQueryOffsetSummaries().isEmpty()) {
            this.writer().println();
            this.writer().println("Consumer Groups summary:");
            for (QueryOffsetSummary entry : source.getQueryOffsetSummaries()) {
                this.writer().println();
                this.writer().println(String.format("%-20s : %s", "Consumer Group", entry.getGroupId()));
                if (entry.getTopicSummaries().isEmpty()) {
                    this.writer().println("<no offsets committed by this group yet>");
                }
                for (QueryTopicOffsetSummary topicSummary : entry.getTopicSummaries()) {
                    this.writer().println();
                    this.writer().println(String.format("%-20s : %s", "Kafka topic", topicSummary.getKafkaTopic()));
                    this.writer().println(String.format("%-20s : %s", "Max lag", topicSummary.getOffsets().stream().mapToLong(s -> s.getLogEndOffset() - s.getConsumerOffset()).max().orElse(0L)));
                    this.writer().println("");
                    Table taskTable = new Table.Builder().withColumnHeaders((List<String>)ImmutableList.of((Object)"Partition", (Object)"Start Offset", (Object)"End Offset", (Object)"Offset", (Object)"Lag")).withRows(topicSummary.getOffsets().stream().map(offset -> ImmutableList.of((Object)String.valueOf(offset.getPartition()), (Object)String.valueOf(offset.getLogStartOffset()), (Object)String.valueOf(offset.getLogEndOffset()), (Object)String.valueOf(offset.getConsumerOffset()), (Object)String.valueOf(offset.getLogEndOffset() - offset.getConsumerOffset())))).build();
                    taskTable.print(this);
                }
            }
        }
    }

    private void printSourceDescriptionList(SourceDescriptionList sourceDescriptionList) {
        sourceDescriptionList.getSourceDescriptions().forEach(sourceDescription -> {
            this.printSourceDescription((SourceDescription)sourceDescription);
            this.writer().println();
        });
    }

    private void printQuerySources(QueryDescription query) {
        if (!query.getSources().isEmpty()) {
            this.writer().println(String.format("%n%-20s%n%-20s", "Sources that this query reads from: ", "-----------------------------------"));
            for (String sources : query.getSources()) {
                this.writer().println(sources);
            }
            this.writer().println("\nFor source description please run: DESCRIBE [EXTENDED] <SourceId>");
        }
    }

    private void printQuerySinks(QueryDescription query) {
        if (!query.getSinks().isEmpty()) {
            this.writer().println(String.format("%n%-20s%n%-20s", "Sinks that this query writes to: ", "-----------------------------------"));
            for (String sinks : query.getSinks()) {
                this.writer().println(sinks);
            }
            this.writer().println("\nFor sink description please run: DESCRIBE [EXTENDED] <SinkId>");
        }
    }

    private void printQueryDescription(QueryDescription query) {
        this.writer().println(String.format("%-20s : %s", "ID", query.getId()));
        this.writer().println(String.format("%-20s : %s", "Query Type", query.getQueryType()));
        if (query.getStatementText().length() > 0) {
            this.writer().println(String.format("%-20s : %s", "SQL", query.getStatementText()));
        }
        if (!query.getKsqlHostQueryStatus().isEmpty()) {
            this.writer().println(String.format("%-20s : %s", "Host Query Status", query.getKsqlHostQueryStatus()));
        }
        this.writer().println();
        this.printSchema(query.getWindowType(), query.getFields(), false);
        this.printQuerySources(query);
        this.printQuerySinks(query);
        this.printExecutionPlan(query);
        this.printTopology(query);
        this.printOverriddenProperties(query);
        this.printQueryError(query);
    }

    private void printConnectorDescription(ConnectorDescription description) {
        ConnectorStateInfo status = description.getStatus();
        this.writer().println(String.format("%-20s : %s", "Name", status.name()));
        this.writer().println(String.format("%-20s : %s", "Class", description.getConnectorClass()));
        this.writer().println(String.format("%-20s : %s", "Type", description.getStatus().type()));
        this.writer().println(String.format("%-20s : %s", "State", status.connector().state()));
        this.writer().println(String.format("%-20s : %s", "WorkerId", status.connector().workerId()));
        if (!((String)ObjectUtils.defaultIfNull((Object)status.connector().trace(), (Object)"")).isEmpty()) {
            this.writer().println(String.format("%-20s : %s", "Trace", status.connector().trace()));
        }
        if (!status.tasks().isEmpty()) {
            this.writer().println();
            Table taskTable = new Table.Builder().withColumnHeaders((List<String>)ImmutableList.of((Object)"Task ID", (Object)"State", (Object)"Error Trace")).withRows(status.tasks().stream().map(task -> ImmutableList.of((Object)String.valueOf(task.id()), (Object)task.state(), (Object)ObjectUtils.defaultIfNull((Object)task.trace(), (Object)"")))).build();
            taskTable.print(this);
        }
        if (!description.getSources().isEmpty()) {
            this.writer().println();
            Table sourceTable = new Table.Builder().withColumnHeaders("KSQL Source Name", "Kafka Topic", "Type").withRows(description.getSources().stream().map(source -> ImmutableList.of((Object)source.getName(), (Object)source.getTopic(), (Object)source.getType()))).build();
            sourceTable.print(this);
        }
        if (!description.getTopics().isEmpty()) {
            this.writer().println();
            Table topicTable = new Table.Builder().withColumnHeaders("Related Topics").withRows(description.getTopics().stream().map(ImmutableList::of)).build();
            topicTable.print(this);
        }
    }

    private void printQueryDescriptionList(QueryDescriptionList queryDescriptionList) {
        queryDescriptionList.getQueryDescriptions().forEach(queryDescription -> {
            this.printQueryDescription((QueryDescription)queryDescription);
            this.writer().println();
        });
    }

    private void printFunctionDescription(FunctionDescriptionList describeFunction) {
        String functionName = describeFunction.getName().toUpperCase();
        String baseFormat = "%-12s: %s%n";
        String subFormat = "\t%-12s: %s%n";
        this.writer().printf("%-12s: %s%n", "Name", functionName);
        if (!describeFunction.getAuthor().trim().isEmpty()) {
            this.writer().printf("%-12s: %s%n", "Author", describeFunction.getAuthor());
        }
        if (!describeFunction.getVersion().trim().isEmpty()) {
            this.writer().printf("%-12s: %s%n", "Version", describeFunction.getVersion());
        }
        this.printDescription("%-12s: %s%n", "Overview", describeFunction.getDescription());
        this.writer().printf("%-12s: %s%n", "Type", describeFunction.getType().name());
        this.writer().printf("%-12s: %s%n", "Jar", describeFunction.getPath());
        this.writer().printf("%-12s: %s%n", "Variations", "");
        Collection functions = describeFunction.getFunctions();
        functions.forEach(functionInfo -> {
            String arguments = functionInfo.getArguments().stream().map(Console::argToString).collect(Collectors.joining(", "));
            this.writer().printf("%n\t%-12s: %s(%s)%n", "Variation", functionName, arguments);
            this.writer().printf("\t%-12s: %s%n", "Returns", functionInfo.getReturnType());
            this.printDescription("\t%-12s: %s%n", "Description", functionInfo.getDescription());
            functionInfo.getArguments().forEach(a -> this.printDescription("\t%-12s: %s%n", a.getName(), a.getDescription()));
        });
    }

    private void printAssertTopic(AssertTopicEntity assertTopic) {
        String existence = assertTopic.getExists() ? " exists" : " does not exist";
        this.writer().printf("Topic " + assertTopic.getTopicName() + existence + ".\n", new Object[0]);
    }

    private void printAssertSchema(AssertSchemaEntity assertSchema) {
        if (!assertSchema.getId().isPresent() && !assertSchema.getSubject().isPresent()) {
            throw new RuntimeException("No subject or id found in AssertSchema response.");
        }
        String existence = assertSchema.getExists() ? " exists" : " does not exist";
        String subject = assertSchema.getSubject().isPresent() ? " subject " + (String)assertSchema.getSubject().get() : "";
        String id = assertSchema.getId().isPresent() ? " id " + assertSchema.getId().get() : "";
        this.writer().printf("Schema with" + subject + id + existence + ".\n", new Object[0]);
    }

    private static String argToString(ArgumentInfo arg) {
        String type = arg.getType() + (arg.getIsVariadic() != false ? "[]" : "");
        return arg.getName().isEmpty() ? type : arg.getName() + " " + type;
    }

    private void printDescription(String format, String name, String description) {
        String trimmed = description.trim();
        if (trimmed.isEmpty()) {
            return;
        }
        int labelLen = String.format(format.replace("%n", ""), name, "").replace("\t", "  ").length();
        int width = Math.max(this.getWidth(), 80) - labelLen;
        String fixedWidth = Console.splitLongLine(trimmed, width);
        String indent = String.format("%-" + labelLen + "s", "");
        String result = fixedWidth.replace(System.lineSeparator(), System.lineSeparator() + indent);
        this.writer().printf(format, name, result);
    }

    private static String splitLongLine(String input, int maxLineLength) {
        StringTokenizer spaceTok = new StringTokenizer(input, " \n", true);
        StringBuilder output = new StringBuilder(input.length());
        int lineLen = 0;
        while (spaceTok.hasMoreTokens()) {
            String word = spaceTok.nextToken();
            boolean isNewLineChar = word.equals("\n");
            if (isNewLineChar || lineLen + word.length() > maxLineLength) {
                output.append(System.lineSeparator());
                lineLen = 0;
                if (isNewLineChar) continue;
            }
            output.append(word);
            lineLen += word.length();
        }
        return output.toString();
    }

    private void printAsJson(Object o) {
        try {
            OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValue((Writer)this.writer(), o);
            this.writer().println();
            this.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to console", e);
        }
    }

    public boolean maybeHandleCliSpecificCommands(String line) {
        if (line == null) {
            return false;
        }
        return this.getCliCommand(line).map(cmd -> {
            cmd.execute(this.writer());
            this.flush();
            return true;
        }).orElse(false);
    }

    private static final class CliCmdExecutor {
        private final CliSpecificCommand cmd;
        private final List<String> args;

        private static CliCmdExecutor of(CliSpecificCommand cmd, List<String> lineParts) {
            String[] nameParts = cmd.getName().split("\\s+");
            List<String> argList = lineParts.subList(nameParts.length, lineParts.size()).stream().map(CmdLineUtil::removeMatchedSingleQuotes).collect(Collectors.toList());
            return new CliCmdExecutor(cmd, argList);
        }

        private CliCmdExecutor(CliSpecificCommand cmd, List<String> args) {
            this.cmd = Objects.requireNonNull(cmd, "cmd");
            this.args = ImmutableList.copyOf((Collection)Objects.requireNonNull(args, "args"));
        }

        public void execute(PrintWriter terminal) {
            this.cmd.execute(this.args, terminal);
        }
    }

    static class NoOpRowCaptor
    implements RowCaptor {
        NoOpRowCaptor() {
        }

        @Override
        public void addRow(StreamedRow.DataRow row) {
        }

        @Override
        public void addRows(List<List<String>> fields) {
        }
    }

    public static interface RowCaptor {
        public void addRow(StreamedRow.DataRow var1);

        public void addRows(List<List<String>> var1);
    }
}

