/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console;

import io.confluent.ksql.cli.console.CommentStripper;
import io.confluent.ksql.cli.console.UnclosedQuoteChecker;
import java.util.Objects;
import java.util.function.Predicate;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;

final class KsqlLineParser
implements Parser {
    private static final String TERMINATION_CHAR = ";";
    private final Parser delegate;
    private final Predicate<String> cliCmdPredicate;

    KsqlLineParser(Parser delegate, Predicate<String> cliCmdPredicate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.cliCmdPredicate = Objects.requireNonNull(cliCmdPredicate, "cliCmdPredicate");
    }

    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) {
        ParsedLine parsed = this.delegate.parse(line, cursor, context);
        if (context != Parser.ParseContext.ACCEPT_LINE) {
            return parsed;
        }
        if (UnclosedQuoteChecker.isUnclosedQuote(line)) {
            throw new EOFError(-1, -1, "Missing end quote", "end quote char");
        }
        String bare = CommentStripper.strip(parsed.line());
        if (bare.isEmpty()) {
            return parsed;
        }
        if (this.cliCmdPredicate.test(bare)) {
            return parsed;
        }
        if (!bare.endsWith(TERMINATION_CHAR)) {
            throw new EOFError(-1, -1, "Missing termination char", "termination char");
        }
        return parsed;
    }
}

