/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console;

import java.io.Closeable;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import org.jline.terminal.Terminal;

public interface KsqlTerminal {
    public int getWidth();

    public PrintWriter writer();

    public String readLine();

    public void flush();

    public void clearScreen();

    public List<HistoryEntry> getHistory();

    public void handle(Terminal.Signal var1, Terminal.SignalHandler var2);

    public void setSpool(Writer var1);

    public void unsetSpool();

    public StatusClosable setStatusMessage(String var1);

    public void printError(String var1);

    public void close();

    public static class HistoryEntry {
        private final long index;
        private final String line;

        private HistoryEntry(long index, String line) {
            this.index = index;
            this.line = Objects.requireNonNull(line, "line");
            if (index < 1L) {
                throw new IllegalArgumentException("index < 1. index=" + index);
            }
        }

        public long getIndex() {
            return this.index;
        }

        public String getLine() {
            return this.line;
        }

        static HistoryEntry of(long index, String line) {
            return new HistoryEntry(index, line);
        }
    }

    @FunctionalInterface
    public static interface StatusClosable
    extends Closeable {
        @Override
        public void close();
    }
}

