/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.cmd;

import io.confluent.ksql.cli.KsqlRequestExecutor;
import io.confluent.ksql.cli.console.Console;
import io.confluent.ksql.cli.console.cmd.Clear;
import io.confluent.ksql.cli.console.cmd.Exit;
import io.confluent.ksql.cli.console.cmd.Help;
import io.confluent.ksql.cli.console.cmd.History;
import io.confluent.ksql.cli.console.cmd.Output;
import io.confluent.ksql.cli.console.cmd.RemoteServerSpecificCommand;
import io.confluent.ksql.cli.console.cmd.RequestPipeliningCommand;
import io.confluent.ksql.cli.console.cmd.RunScript;
import io.confluent.ksql.cli.console.cmd.SetCliProperty;
import io.confluent.ksql.cli.console.cmd.Spool;
import io.confluent.ksql.cli.console.cmd.Version;
import io.confluent.ksql.rest.client.KsqlRestClient;
import io.confluent.ksql.util.Event;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class CliCommandRegisterUtil {
    private CliCommandRegisterUtil() {
    }

    public static void registerDefaultCommands(KsqlRequestExecutor requestExecutor, Console console, Supplier<String> versionSuppler, KsqlRestClient restClient, Event resetCliForNewServer, Supplier<Boolean> requestPipeliningSupplier, Consumer<Boolean> requestPipeliningConsumer) {
        console.registerCliSpecificCommand(Help.create(() -> console.getCliSpecificCommands().values()));
        console.registerCliSpecificCommand(Clear.create(console::clearScreen));
        console.registerCliSpecificCommand(Output.create(console::getOutputFormat, console::setOutputFormat));
        console.registerCliSpecificCommand(History.create(console::getHistory));
        console.registerCliSpecificCommand(Version.create(versionSuppler));
        console.registerCliSpecificCommand(Exit.create());
        console.registerCliSpecificCommand(RunScript.create(requestExecutor));
        console.registerCliSpecificCommand(RemoteServerSpecificCommand.create(restClient, resetCliForNewServer));
        console.registerCliSpecificCommand(RequestPipeliningCommand.create(requestPipeliningSupplier, requestPipeliningConsumer));
        console.registerCliSpecificCommand(Spool.create(console::setSpool, console::unsetSpool));
        console.registerCliSpecificCommand(SetCliProperty.create(console::setCliProperty));
    }
}

