/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.cmd;

import io.confluent.ksql.cli.console.OutputFormat;
import io.confluent.ksql.cli.console.cmd.CliCmdUtil;
import io.confluent.ksql.cli.console.cmd.CliSpecificCommand;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class Output
implements CliSpecificCommand {
    private static final String HELP = "output:" + System.lineSeparator() + "\tView the current output format." + System.lineSeparator() + System.lineSeparator() + "output <format>;" + System.lineSeparator() + System.lineSeparator() + "\tSet the output format to <format> (valid formats: " + OutputFormat.VALID_FORMATS + ")" + System.lineSeparator() + System.lineSeparator() + "\tFor example: \"output JSON;\"" + System.lineSeparator();
    private final Supplier<OutputFormat> getter;
    private final Consumer<String> setter;

    private Output(Supplier<OutputFormat> getter, Consumer<String> setter) {
        this.getter = Objects.requireNonNull(getter, "getter");
        this.setter = Objects.requireNonNull(setter, "setter");
    }

    static Output create(Supplier<OutputFormat> getter, Consumer<String> setter) {
        return new Output(getter, setter);
    }

    @Override
    public String getName() {
        return "output";
    }

    @Override
    public String getHelpMessage() {
        return HELP;
    }

    @Override
    public void execute(List<String> args, PrintWriter terminal) {
        CliCmdUtil.ensureArgCountBounds(args, 0, 1, HELP);
        if (args.isEmpty()) {
            terminal.printf("Current output format: %s%n", this.getter.get().name());
            return;
        }
        String newFormat = args.get(0).toUpperCase();
        this.setter.accept(newFormat);
    }
}

