/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.cmd;

import io.confluent.ksql.cli.console.cmd.CliCmdUtil;
import io.confluent.ksql.cli.console.cmd.CliSpecificCommand;
import java.io.File;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class Spool
implements CliSpecificCommand {
    private static final String HELP = "spool [<path_to_file>|OFF]: " + System.lineSeparator() + "\tStores issued commands and their results into a file. Only one spool may " + System.lineSeparator() + "\tbe active at a time and can be closed by issuing ``SPOOL OFF``. Commands are " + System.lineSeparator() + "\t prefixed with ``ksql> `` to differentiate from output.";
    private static final String OFF = "OFF";
    private final Runnable unsetSpool;
    private final Consumer<File> setSpool;

    private Spool(Consumer<File> setSpool, Runnable unsetSpool) {
        this.setSpool = Objects.requireNonNull(setSpool, "setSpool");
        this.unsetSpool = Objects.requireNonNull(unsetSpool, "unsetSpool");
    }

    public static Spool create(Consumer<File> setSpool, Runnable unsetSpool) {
        return new Spool(setSpool, unsetSpool);
    }

    @Override
    public String getName() {
        return "spool";
    }

    @Override
    public String getHelpMessage() {
        return HELP;
    }

    @Override
    public void execute(List<String> args, PrintWriter terminal) {
        CliCmdUtil.ensureArgCountBounds(args, 1, 1, HELP);
        String filePathOrOff = args.get(0);
        if (filePathOrOff.equalsIgnoreCase(OFF)) {
            this.unsetSpool.run();
        } else {
            this.setSpool.accept(new File(Spool.cleanQuotes(filePathOrOff)));
        }
    }

    private static String cleanQuotes(String stringWithQuotes) {
        if (!stringWithQuotes.startsWith("'") || !stringWithQuotes.endsWith("'")) {
            return stringWithQuotes;
        }
        return stringWithQuotes.substring(1, stringWithQuotes.length() - 1).replaceAll("''", "'");
    }
}

