/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.table.builder;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.cli.console.table.Table;
import io.confluent.ksql.cli.console.table.builder.TableBuilder;
import io.confluent.ksql.rest.entity.PropertiesList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PropertiesListTableBuilder
implements TableBuilder<PropertiesList> {
    private static final List<String> HEADERS = ImmutableList.of((Object)"Property", (Object)"Scope", (Object)"Default override", (Object)"Effective Value");

    @Override
    public Table buildTable(PropertiesList entity) {
        return new Table.Builder().withColumnHeaders(HEADERS).withRows(PropertiesListTableBuilder.defRowValues(PropertiesListTableBuilder.propertiesListWithOverrides(entity))).build();
    }

    private static List<List<String>> defRowValues(List<PropertyDef> properties) {
        return properties.stream().sorted(Comparator.comparing(propertyDef -> ((PropertyDef)propertyDef).propertyName)).map(def -> ImmutableList.of((Object)((PropertyDef)def).propertyName, (Object)((PropertyDef)def).scope, (Object)((PropertyDef)def).overrideType, (Object)((PropertyDef)def).effectiveValue)).collect(Collectors.toList());
    }

    private static List<PropertyDef> propertiesListWithOverrides(PropertiesList properties) {
        Function<PropertiesList.Property, PropertyDef> toPropertyDef = property -> {
            String value = property.getValue() == null ? "NULL" : property.getValue();
            String name = property.getName();
            String scope = property.getScope();
            if (properties.getOverwrittenProperties().contains(name)) {
                return new PropertyDef(name, scope, "SESSION", value);
            }
            if (properties.getDefaultProperties().contains(name)) {
                return new PropertyDef(name, scope, "", value);
            }
            return new PropertyDef(name, scope, "SERVER", value);
        };
        return properties.getProperties().stream().map(toPropertyDef).collect(Collectors.toList());
    }

    private static class PropertyDef {
        private final String propertyName;
        private final String scope;
        private final String overrideType;
        private final String effectiveValue;

        PropertyDef(String propertyName, String scope, String overrideType, String effectiveValue) {
            this.propertyName = Objects.requireNonNull(propertyName, "propertyName");
            this.scope = Objects.requireNonNull(scope, "scope");
            this.overrideType = Objects.requireNonNull(overrideType, "overrideType");
            this.effectiveValue = Objects.requireNonNull(effectiveValue, "effectiveValue");
        }
    }
}

