/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.table.builder;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.cli.console.table.Table;
import io.confluent.ksql.cli.console.table.builder.TableBuilder;
import io.confluent.ksql.rest.entity.TopicDescription;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.SerdeFeature;
import java.util.ArrayList;
import java.util.List;

public class TopicDescriptionTableBuilder
implements TableBuilder<TopicDescription> {
    private static final List<String> NON_SCHEMA_HEADERS = ImmutableList.of((Object)"Table Name", (Object)"Kafka Topic", (Object)"Type");
    private static final List<String> SCHEMA_HEADERS = ImmutableList.of((Object)"Table Name", (Object)"Kafka Topic", (Object)"Type", (Object)"Schema");

    @Override
    public Table buildTable(TopicDescription topicDescription) {
        String format = topicDescription.getFormat();
        boolean supportsSchema = FormatFactory.fromName((String)format).supportsFeature(SerdeFeature.SCHEMA_INFERENCE);
        List<String> headings = supportsSchema ? SCHEMA_HEADERS : NON_SCHEMA_HEADERS;
        ArrayList<String> row = new ArrayList<String>(4);
        row.add(topicDescription.getName());
        row.add(topicDescription.getKafkaTopic());
        row.add(format);
        if (supportsSchema) {
            row.add(topicDescription.getSchemaString());
        }
        return new Table.Builder().withColumnHeaders(headings).withRow(row).build();
    }
}

