/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Properties;
import kafka.server.ConfigAdminManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDisabled$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ZkConfigRepository;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.LogLevelConfig;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.metadata.ClusterLink;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t]e\u0001\u0002\u000f\u001e\u0001\tB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005@\u0001\t\u0015\r\u0011\"\u0001A\u0011!Y\u0005A!A!\u0002\u0013\t\u0005\"\u0002'\u0001\t\u0003i\u0005\"B*\u0001\t\u0003!\u0006\"CA\"\u0001E\u0005I\u0011AA#\u0011\u001d\tY\u0006\u0001C\u0001\u0003;Bq!a\u0017\u0001\t\u0003\t9\b\u0003\u0004T\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u00037\u0002A\u0011AAO\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003KCq!a+\u0001\t\u0003\ti\u000bC\u0004\u0002@\u0002!\t!!1\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\"9\u0011q\u001a\u0001\u0005\u0002\u0005EwaBAs;!\u0005\u0011q\u001d\u0004\u00079uA\t!!;\t\r1\u001bB\u0011AAv\u0011%\tio\u0005b\u0001\n\u0003\ty\u000f\u0003\u0005\u0002~N\u0001\u000b\u0011BAy\u0011\u001d\typ\u0005C\u0001\u0005\u0003AqAa\u0002\u0014\t\u0003\u0011I\u0001C\u0004\u0003\u0018M!\tA!\u0007\t\u000f\t%3\u0003\"\u0001\u0003L!9!qL\n\u0005\u0002\t\u0005$AE\"p]\u001aLw-\u00113nS:l\u0015M\\1hKJT!AH\u0010\u0002\rM,'O^3s\u0015\u0005\u0001\u0013!B6bM.\f7\u0001A\n\u0004\u0001\rJ\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#AB!osJ+g\r\u0005\u0002+[5\t1F\u0003\u0002-?\u0005)Q\u000f^5mg&\u0011af\u000b\u0002\b\u0019><w-\u001b8h\u0003\u0019qw\u000eZ3JIB\u0011A%M\u0005\u0003e\u0015\u00121!\u00138u\u0003\u0011\u0019wN\u001c4\u0011\u0005U2T\"A\u000f\n\u0005]j\"aC&bM.\f7i\u001c8gS\u001e\f\u0001cY8oM&<'+\u001a9pg&$xN]=\u0011\u0005ijT\"A\u001e\u000b\u0005qj\u0012\u0001C7fi\u0006$\u0017\r^1\n\u0005yZ$\u0001E\"p]\u001aLwMU3q_NLGo\u001c:z\u0003I\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0016\u0003\u0005\u0003\"A\u0011%\u000f\u0005\r3U\"\u0001#\u000b\u0005\u0015k\u0012\u0001\u00027j].L!a\u0012#\u0002%\rcWo\u001d;fe2Kgn\u001b$bGR|'/_\u0005\u0003\u0013*\u00131\u0002T5oW6\u000bg.Y4fe*\u0011q\tR\u0001\u0014G2,8\u000f^3s\u0019&t7.T1oC\u001e,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b9{\u0005+\u0015*\u0011\u0005U\u0002\u0001\"B\u0018\u0007\u0001\u0004\u0001\u0004\"B\u001a\u0007\u0001\u0004!\u0004\"\u0002\u001d\u0007\u0001\u0004I\u0004\"B \u0007\u0001\u0004\t\u0015A\u00039sKB\u0014xnY3tgR9Q+!\u0001\u0002\u000e\u0005e\u0002\u0003\u0002,\\;jl\u0011a\u0016\u0006\u00031f\u000bA!\u001e;jY*\t!,\u0001\u0003kCZ\f\u0017B\u0001/X\u0005=IE-\u001a8uSRL\b*Y:i\u001b\u0006\u0004\bC\u00010x\u001d\tyFO\u0004\u0002ac:\u0011\u0011M\u001c\b\u0003E2t!aY5\u000f\u0005\u0011<W\"A3\u000b\u0005\u0019\f\u0013A\u0002\u001fs_>$h(C\u0001i\u0003\ry'oZ\u0005\u0003U.\fa!\u00199bG\",'\"\u00015\n\u0005\u0001j'B\u00016l\u0013\ty\u0007/\u0001\u0004d_6lwN\u001c\u0006\u0003A5L!A]:\u0002\u000f5,7o]1hK*\u0011q\u000e]\u0005\u0003kZ\f!%\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:D_:4\u0017nZ:SKF,Xm\u001d;ECR\f'B\u0001:t\u0013\tA\u0018P\u0001\u000bBYR,'oQ8oM&<7OU3t_V\u00148-\u001a\u0006\u0003kZ\u0004\"a\u001f@\u000e\u0003qT!!`:\u0002\u0011I,\u0017/^3tiNL!a ?\u0003\u0011\u0005\u0003\u0018.\u0012:s_JDq!a\u0001\b\u0001\u0004\t)!A\u0004sKF,Xm\u001d;\u0011\t\u0005\u001d\u0011\u0011B\u0007\u0002m&\u0019\u00111\u0002<\u0003E%s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z9vKN$H)\u0019;b\u0011\u001d\tya\u0002a\u0001\u0003#\t\u0011\"Y;uQ>\u0014\u0018N_3\u0011\u0013\u0011\n\u0019\"a\u0006\u0002$\u0005M\u0012bAA\u000bK\tIa)\u001e8di&|gN\r\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011QD:\u0002\u0011I,7o\\;sG\u0016LA!!\t\u0002\u001c\ta!+Z:pkJ\u001cW\rV=qKB!\u0011QEA\u0017\u001d\u0011\t9#!\u000b\u0011\u0005\u0011,\u0013bAA\u0016K\u00051\u0001K]3eK\u001aLA!a\f\u00022\t11\u000b\u001e:j]\u001eT1!a\u000b&!\r!\u0013QG\u0005\u0004\u0003o)#a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003w9\u0001\u0013!a\u0001\u0003{\tA%Y;uQ>\u0014\u0018N_3NSJ\u0014xN\u001d+pa&\u001c7i\u001c8gS\u001e4\u0016\r\\5eCRLwN\u001c\t\u0006I\u0005}\u00121G\u0005\u0004\u0003\u0003*#!\u0003$v]\u000e$\u0018n\u001c81\u0003Q\u0001(/\u001a9s_\u000e,7o\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\t\u0016\u0005\u0003{\tIe\u000b\u0002\u0002LA!\u0011QJA,\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013!C;oG\",7m[3e\u0015\r\t)&J\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA-\u0003\u001f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003i1\u0018\r\\5eCR,'I]8lKJ\u001cuN\u001c4jO\u000eC\u0017M\\4f)\u0019\ty&!\u001a\u0002hA\u0019A%!\u0019\n\u0007\u0005\rTE\u0001\u0003V]&$\bBBA\u000f\u0013\u0001\u0007Q\fC\u0004\u0002j%\u0001\r!a\u001b\u0002\u001d\r|gNZ5h%\u0016\u001cx.\u001e:dKB!\u0011QNA:\u001b\t\tyGC\u0002\u0002rM\faaY8oM&<\u0017\u0002BA;\u0003_\u0012abQ8oM&<'+Z:pkJ\u001cW\r\u0006\u0004\u0002`\u0005e\u00141\u0011\u0005\b\u0003wR\u0001\u0019AA?\u0003\u0015\u0001(o\u001c9t!\r1\u0016qP\u0005\u0004\u0003\u0003;&A\u0003)s_B,'\u000f^5fg\"9\u0011\u0011\u000e\u0006A\u0002\u0005-D\u0003BAD\u0003+\u0003RAV.\u0002\nj\u0004B!a#\u0002\u0012:\u0019q,!$\n\u0007\u0005=e/A\fBYR,'oQ8oM&<7OU3rk\u0016\u001cH\u000fR1uC&\u0019\u00010a%\u000b\u0007\u0005=e\u000fC\u0004\u0002\u0004-\u0001\r!a&\u0011\t\u0005\u001d\u0011\u0011T\u0005\u0004\u000373(aF!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z9vKN$H)\u0019;b)\u0019\ty&a(\u0002\"\"9\u0011Q\u0004\u0007A\u0002\u0005%\u0005bBA5\u0019\u0001\u0007\u00111N\u0001$m\u0006d\u0017\u000eZ1uKJ+7o\\;sG\u0016t\u0015-\\3Jg\u000e+(O]3oi:{G-Z%e)\u0011\ty&a*\t\u000f\u0005%V\u00021\u0001\u0002$\u0005!a.Y7f\u0003]1\u0018\r\\5eCR,Gj\\4MKZ,GnQ8oM&<7\u000f\u0006\u0003\u0002`\u0005=\u0006bBAY\u001d\u0001\u0007\u00111W\u0001\u0004_B\u001c\b#\u0002,\u00026\u0006e\u0016bAA\\/\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u0007y\u000bY,C\u0002\u0002>f\u0014q\"\u00117uKJ\f'\r\\3D_:4\u0017nZ\u0001\u0015C2$XM\u001d'pO2+g/\u001a7D_:4\u0017nZ:\u0015\t\u0005}\u00131\u0019\u0005\b\u0003c{\u0001\u0019AAZ\u0003!j\u0017-\u001f2f\u001b>$\u0017NZ=J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5h%\u0016\fX/Z:u)\u0019\t)!!3\u0002L\"9\u00111\u0001\tA\u0002\u0005\u0015\u0001BBAg!\u0001\u0007Q+A\u0005qe>\u001cWm]:fI\u0006i\"/Z1tg\u0016l'\r\\3J]\u000e\u0014X-\\3oi\u0006d'+Z:q_:\u001cX\r\u0006\u0005\u0002T\u0006e\u0017Q\\Aq!\u0011\t9!!6\n\u0007\u0005]gOA\u0012J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5hgJ+7\u000f]8og\u0016$\u0015\r^1\t\u000f\u0005m\u0017\u00031\u0001\u0002\u0006\u0005AqN]5hS:\fG\u000e\u0003\u0004\u0002`F\u0001\r!V\u0001\u0017aJ,\u0007O]8dKN\u001c\u0018N\\4SKN\u0004xN\\:fg\"9\u00111]\tA\u0002\u0005M\u0017a\u00059feNL7\u000f^3oiJ+7\u000f]8og\u0016\u001c\u0018AE\"p]\u001aLw-\u00113nS:l\u0015M\\1hKJ\u0004\"!N\n\u0014\u0005M\u0019CCAAt\u0003\rawnZ\u000b\u0003\u0003c\u0004B!a=\u0002z6\u0011\u0011Q\u001f\u0006\u0004\u0003o\\\u0017!B:mMRR\u0017\u0002BA~\u0003k\u0014a\u0001T8hO\u0016\u0014\u0018\u0001\u00027pO\u0002\nqcY8qs^KG\u000f[8viB\u0013X\r\u001d:pG\u0016\u001c8/\u001a3\u0015\r\u0005]%1\u0001B\u0003\u0011\u001d\t\u0019a\u0006a\u0001\u0003/Cq!!4\u0018\u0001\u0004\t9)\u0001\rsK\u0006\u001c8/Z7cY\u0016dUmZ1dsJ+7\u000f]8og\u0016$\u0002Ba\u0003\u0003\u0012\tM!Q\u0003\t\u0005\u0003\u000f\u0011i!C\u0002\u0003\u0010Y\u0014\u0001$\u00117uKJ\u001cuN\u001c4jON\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u001d\tY\u000e\u0007a\u0001\u0003/Cq!a8\u0019\u0001\u0004\t9\tC\u0004\u0002db\u0001\rAa\u0003\u0002%\r|g\u000e^1j]N$U\u000f\u001d7jG\u0006$Xm]\u000b\u0005\u00057\u00119\u0004\u0006\u0003\u00024\tu\u0001b\u0002B\u00103\u0001\u0007!\u0011E\u0001\tSR,'/\u00192mKB1!1\u0005B\u0017\u0005gqAA!\n\u0003*9\u0019AMa\n\n\u0003\u0019J1Aa\u000b&\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\f\u00032\tA\u0011\n^3sC\ndWMC\u0002\u0003,\u0015\u0002BA!\u000e\u000381\u0001Aa\u0002B\u001d3\t\u0007!1\b\u0002\u0002)F!!Q\bB\"!\r!#qH\u0005\u0004\u0005\u0003*#a\u0002(pi\"Lgn\u001a\t\u0004I\t\u0015\u0013b\u0001B$K\t\u0019\u0011I\\=\u0002\u001fQ|Gj\\4hC\ndW\r\u0015:paN$bA!\u0014\u0003Z\tm\u0003\u0003\u0003B(\u0005+\n\u0019#a\t\u000e\u0005\tE#b\u0001B*K\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t]#\u0011\u000b\u0002\u0004\u001b\u0006\u0004\bbBA\u000f5\u0001\u0007\u00111\u000e\u0005\b\u0005;R\u0002\u0019AA?\u0003-\u0019wN\u001c4jOB\u0013x\u000e]:\u00023A\u0014X\r]1sK&s7M]3nK:$\u0018\r\\\"p]\u001aLwm\u001d\u000b\t\u0003?\u0012\u0019G! \u0003\u0000!9!QM\u000eA\u0002\t\u001d\u0014AD1mi\u0016\u00148i\u001c8gS\u001e|\u0005o\u001d\t\u0007\u0005\u001f\u0012IG!\u001c\n\t\t-$\u0011\u000b\u0002\u0004'\u0016\f\b\u0003\u0002B8\u0005sj!A!\u001d\u000b\t\tM$QO\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0004\u0005o\u0002\u0018aB2mS\u0016tGo]\u0005\u0005\u0005w\u0012\tHA\u0007BYR,'oQ8oM&<w\n\u001d\u0005\b\u0005;Z\u0002\u0019AA?\u0011\u001d\u0011\ti\u0007a\u0001\u0005\u0007\u000b!bY8oM&<7*Z=t!!\u0011yE!\u0016\u0002$\t\u0015\u0005\u0003\u0002BD\u0005#sAA!#\u0003\u000e:\u0019\u0001Ma#\n\u0007\u0005E4/\u0003\u0003\u0003\u0010\u0006=\u0014!C\"p]\u001aLw\rR3g\u0013\u0011\u0011\u0019J!&\u0003\u0013\r{gNZ5h\u0017\u0016L(\u0002\u0002BH\u0003_\u0002")
public class ConfigAdminManager
implements Logging {
    private final int nodeId;
    private final KafkaConfig conf;
    private final ConfigRepository configRepository;
    private final ClusterLinkFactory.LinkManager clusterLinkManager;
    private com.typesafe.scalalogging.Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void prepareIncrementalConfigs(Seq<AlterConfigOp> alterConfigOps, Properties configProps, Map<String, ConfigDef.ConfigKey> configKeys) {
        ConfigAdminManager$.MODULE$.prepareIncrementalConfigs(alterConfigOps, configProps, configKeys);
    }

    public static Map<String, String> toLoggableProps(ConfigResource resource, Properties configProps) {
        return ConfigAdminManager$.MODULE$.toLoggableProps(resource, configProps);
    }

    public static <T> boolean containsDuplicates(Iterable<T> iterable) {
        return ConfigAdminManager$.MODULE$.containsDuplicates(iterable);
    }

    public static AlterConfigsResponseData reassembleLegacyResponse(AlterConfigsRequestData original, IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> preprocessingResponses, AlterConfigsResponseData persistentResponses) {
        return ConfigAdminManager$.MODULE$.reassembleLegacyResponse(original, preprocessingResponses, persistentResponses);
    }

    public static AlterConfigsRequestData copyWithoutPreprocessed(AlterConfigsRequestData request, IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> processed) {
        return ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed);
    }

    public static Logger log() {
        return ConfigAdminManager$.MODULE$.log();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public com.typesafe.scalalogging.Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> preprocess(IncrementalAlterConfigsRequestData request, Function2<ResourceType, String, Object> authorize, Function0<Object> authorizeMirrorTopicConfigValidation) {
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> results = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        HashMap resourceIds = new HashMap();
        request.resources().forEach(resource -> {
            IncrementalAlterConfigsRequestData.AlterConfigsResource preexisting = resourceIds.put(new Tuple2((Object)BoxesRunTime.boxToByte((byte)resource.resourceType()), (Object)resource.resourceName()), resource);
            if (preexisting != null) {
                new .colon.colon((Object)preexisting, (List)new .colon.colon(resource, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)r -> results.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)r, new ApiError(Errors.INVALID_REQUEST, "Each resource must appear at most once.")));
                return;
            }
        });
        request.resources().forEach(resource -> {
            if (results.containsKey(resource)) return;
            ConfigResource.Type resourceType = ConfigResource.Type.forId((byte)resource.resourceType());
            ConfigResource configResource = new ConfigResource(resourceType, resource.resourceName());
            try {
                if (ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().map((Function1 & Serializable)x$1 -> x$1.name()))) {
                    throw new InvalidRequestException("Error due to duplicate config keys");
                }
                ArrayList nullUpdates = new ArrayList();
                resource.configs().forEach(config -> {
                    if (config.configOperation() != AlterConfigOp.OpType.DELETE.id() && config.value() == null) {
                        nullUpdates.add(config.name());
                        return;
                    }
                });
                if (!nullUpdates.isEmpty()) {
                    throw new InvalidRequestException(new StringBuilder(31).append("Null value not supported for : ").append(String.join((CharSequence)", ", nullUpdates)).toString());
                }
                if (ConfigResource.Type.BROKER_LOGGER.equals(resourceType)) {
                    if (!BoxesRunTime.unboxToBoolean((Object)authorize.apply((Object)ResourceType.CLUSTER, (Object)"kafka-cluster"))) {
                        throw new ClusterAuthorizationException(Errors.CLUSTER_AUTHORIZATION_FAILED.message());
                    }
                    this.validateResourceNameIsCurrentNodeId(resource.resourceName());
                    this.validateLogLevelConfigs((Collection<IncrementalAlterConfigsRequestData.AlterableConfig>)resource.configs());
                    if (!request.validateOnly()) {
                        this.alterLogLevelConfigs((Collection<IncrementalAlterConfigsRequestData.AlterableConfig>)resource.configs());
                    }
                    results.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, ApiError.NONE);
                    return;
                }
                if (ConfigResource.Type.BROKER.equals(resourceType)) {
                    if (!configResource.name().isEmpty()) {
                        this.validateResourceNameIsCurrentNodeId(resource.resourceName());
                    }
                    this.validateBrokerConfigChange((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, configResource);
                    return;
                }
                if (ConfigResource.Type.TOPIC.equals(resourceType)) {
                    if (!request.skipMirrorTopicConfigValidation()) {
                        ClusterLinkUtils$.MODULE$.validateMirrorTopicConfig(resource.resourceName(), (Set<String>)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().map((Function1 & Serializable)cfg -> cfg.name())).toSet(), this.clusterLinkManager(), true);
                        return;
                    }
                    if (!request.skipMirrorTopicConfigValidation()) return;
                    if (authorizeMirrorTopicConfigValidation.apply$mcZ$sp()) return;
                    throw new ClusterAuthorizationException(Errors.CLUSTER_AUTHORIZATION_FAILED.message());
                }
                if (!ConfigResource.Type.CLUSTER_LINK.equals(resourceType)) throw new InvalidRequestException(new StringBuilder(22).append("Unknown resource type ").append(resource.resourceType()).toString());
                ConfigRepository configRepository = $this.configRepository;
                if (configRepository instanceof ZkConfigRepository) return;
                if (!(configRepository instanceof KRaftMetadataCache)) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> "Unsupported config repository type.");
                    resource.resourceName();
                    return;
                }
                Option<ClusterLinkMetadataManager> option = this.clusterLinkManager().clusterLinkMetadataManager();
                if (!(option instanceof Some)) {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    throw ClusterLinkDisabled$.MODULE$.exception(false);
                }
                ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)((Some)option).value();
                Option<ClusterLinkData> linkData = metadataManager.getClusterLinkData(resource.resourceName());
                if (linkData instanceof Some) {
                    ClusterLinkData cld = (ClusterLinkData)((Some)linkData).value();
                    Properties configProps = metadataManager.getClusterLinkConfigProps(cld.linkId());
                    Option<ClusterLinkConfig> currentConfig = this.clusterLinkManager().linkConfigFromPersistentProps(cld.linkName(), configProps, this.clusterLinkManager().linkConfigFromPersistentProps$default$3());
                    scala.collection.immutable.Seq alterConfigOps = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().map((Function1 & Serializable)config -> {
                        AlterConfigOp.OpType opType = AlterConfigOp.OpType.forId((byte)config.configOperation());
                        if (opType == null) {
                            throw new InvalidRequestException(new StringBuilder(24).append("Unknown operations type ").append(config.configOperation()).toString());
                        }
                        return new AlterConfigOp(new ConfigEntry(config.name(), config.value()), opType);
                    })).toSeq();
                    ConfigAdminManager$.MODULE$.prepareIncrementalConfigs((Seq<AlterConfigOp>)alterConfigOps, configProps, (Map<String, ConfigDef.ConfigKey>)ClusterLinkConfig$.MODULE$.configKeys());
                    ClusterLinkConfig newConfig = ClusterLinkConfig$.MODULE$.create(configProps, (Option<KafkaConfig>)new Some((Object)$this.conf), true);
                    currentConfig.foreach((Function1 & Serializable)x$2 -> {
                        x$2.validateReconfiguration(newConfig);
                        return BoxedUnit.UNIT;
                    });
                    if (!newConfig.autoMirroringEnable()) return;
                    this.clusterLinkManager().maybeCheckForOverlappingTopicFilters(newConfig, cld.linkName(), cld.tenantPrefix());
                    return;
                }
                if (!None$.MODULE$.equals(linkData)) throw new MatchError(linkData);
                throw new ClusterLinkNotFoundException(new StringBuilder(37).append("Cluster link with name ").append(resource.resourceName()).append(" wasn't found.").toString());
            }
            catch (Throwable throwable) {
                if (throwable instanceof ConfigException ? true : throwable instanceof IllegalArgumentException) {
                    String message = new StringBuilder(36).append("Invalid config value for resource ").append(resource).append(": ").append(throwable.getMessage()).toString();
                    this.info((Function0<String>)(Function0 & Serializable)() -> message);
                    ApiError err = ApiError.fromThrowable((Throwable)new InvalidConfigurationException(message, throwable));
                    results.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, err);
                    return;
                }
                if (throwable == null) throw null;
                ApiError err = ApiError.fromThrowable((Throwable)throwable);
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Error preprocessing incrementalAlterConfigs request on ").append(configResource).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                results.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, err);
                return;
            }
        });
        return results;
    }

    public void validateBrokerConfigChange(IncrementalAlterConfigsRequestData.AlterConfigsResource resource, ConfigResource configResource) {
        boolean perBrokerConfig = !configResource.name().isEmpty();
        Properties persistentProps = this.configRepository.config(configResource);
        Properties configProps = this.conf.dynamicConfig().fromPersistentProps(persistentProps, perBrokerConfig);
        scala.collection.immutable.Seq alterConfigOps = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().map((Function1 & Serializable)x0$1 -> {
            AlterConfigOp.OpType opType = AlterConfigOp.OpType.forId((byte)x0$1.configOperation());
            if (opType == null) {
                throw new InvalidRequestException(new StringBuilder(24).append("Unknown operations type ").append(x0$1.configOperation()).toString());
            }
            return new AlterConfigOp(new ConfigEntry(x0$1.name(), x0$1.value()), opType);
        })).toSeq();
        ConfigAdminManager$.MODULE$.prepareIncrementalConfigs((Seq<AlterConfigOp>)alterConfigOps, configProps, KafkaConfig$.MODULE$.configKeys());
        try {
            this.validateBrokerConfigChange(configProps, configResource);
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("validation of configProps ").append(configProps).append(" for ").append(configResource).append(" failed with exception").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            throw t;
        }
    }

    public void validateBrokerConfigChange(Properties props, ConfigResource configResource) {
        try {
            this.conf.dynamicConfig().validate(props, !configResource.name().isEmpty());
            return;
        }
        catch (ApiException apiException) {
            throw apiException;
        }
        catch (Throwable e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    public IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> preprocess(AlterConfigsRequestData request) {
        IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> results = new IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError>();
        HashMap resourceIds = new HashMap();
        request.resources().forEach(resource -> {
            AlterConfigsRequestData.AlterConfigsResource preexisting = resourceIds.put(new Tuple2((Object)BoxesRunTime.boxToByte((byte)resource.resourceType()), (Object)resource.resourceName()), resource);
            if (preexisting != null) {
                new .colon.colon((Object)preexisting, (List)new .colon.colon(resource, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)r -> results.put((AlterConfigsRequestData.AlterConfigsResource)r, new ApiError(Errors.INVALID_REQUEST, "Each resource must appear at most once.")));
                return;
            }
        });
        request.resources().forEach(resource -> {
            if (!results.containsKey(resource)) {
                block8: {
                    ConfigResource.Type resourceType = ConfigResource.Type.forId((byte)resource.resourceType());
                    ConfigResource configResource = new ConfigResource(resourceType, resource.resourceName());
                    try {
                        if (ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().map((Function1 & Serializable)x$3 -> x$3.name()))) {
                            throw new InvalidRequestException("Error due to duplicate config keys");
                        }
                        ArrayList nullUpdates = new ArrayList();
                        resource.configs().forEach(config -> {
                            if (config.value() == null) {
                                nullUpdates.add(config.name());
                                return;
                            }
                        });
                        if (!nullUpdates.isEmpty()) {
                            throw new InvalidRequestException(new StringBuilder(31).append("Null value not supported for : ").append(String.join((CharSequence)", ", nullUpdates)).toString());
                        }
                        if (ConfigResource.Type.BROKER.equals(resourceType)) {
                            if (!configResource.name().isEmpty()) {
                                this.validateResourceNameIsCurrentNodeId(resource.resourceName());
                            }
                            this.validateBrokerConfigChange((AlterConfigsRequestData.AlterConfigsResource)resource, configResource);
                            break block8;
                        }
                        if (ConfigResource.Type.TOPIC.equals(resourceType)) {
                            ClusterLinkUtils$.MODULE$.validateMirrorTopicConfig(resource.resourceName(), (Set<String>)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().map((Function1 & Serializable)cfg -> cfg.name())).toSet(), this.clusterLinkManager(), false);
                            break block8;
                        }
                        throw new InvalidRequestException(new StringBuilder(22).append("Unknown resource type ").append(resource.resourceType()).toString());
                    }
                    catch (Throwable throwable) {
                        ApiError err = ApiError.fromThrowable((Throwable)throwable);
                        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Error preprocessing alterConfigs request on ").append(configResource).append(": ").append(err).toString());
                        results.put((AlterConfigsRequestData.AlterConfigsResource)resource, err);
                    }
                }
                return;
            }
        });
        return results;
    }

    public Function0<Object> preprocess$default$3() {
        return (JFunction0.mcZ.sp & Serializable)() -> false;
    }

    public void validateBrokerConfigChange(AlterConfigsRequestData.AlterConfigsResource resource, ConfigResource configResource) {
        Properties props = new Properties();
        resource.configs().forEach(config -> props.setProperty(config.name(), config.value()));
        this.validateBrokerConfigChange(props, configResource);
    }

    public void validateResourceNameIsCurrentNodeId(String name) {
        int n;
        try {
            n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(name));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringBuilder(39).append("Node id must be an integer, but it is: ").append(name).toString());
        }
        if (n != this.nodeId) {
            throw new InvalidRequestException(new StringBuilder(46).append("Unexpected broker id, expected ").append(this.nodeId).append(", but received ").append(name).toString());
        }
    }

    public void validateLogLevelConfigs(Collection<IncrementalAlterConfigsRequestData.AlterableConfig> ops) {
        ops.forEach(op -> {
            AlterConfigOp.OpType opType;
            block9: {
                block12: {
                    block11: {
                        String string;
                        String string2;
                        block10: {
                            String loggerName = op.name();
                            opType = AlterConfigOp.OpType.forId((byte)op.configOperation());
                            if (AlterConfigOp.OpType.SET.equals(opType)) {
                                ConfigAdminManager.validateLoggerNameExists$1(loggerName);
                                String logLevel = op.value();
                                if (!LogLevelConfig.VALID_LOG_LEVELS.contains(logLevel)) {
                                    String validLevelsStr = CollectionConverters$.MODULE$.SetHasAsScala(LogLevelConfig.VALID_LOG_LEVELS).asScala().mkString(", ");
                                    throw new InvalidConfigurationException(new StringBuilder(90).append("Cannot set the log level of ").append(loggerName).append(" to ").append(logLevel).append(" as it is not a supported log level. ").append("Valid log levels are ").append(validLevelsStr).toString());
                                }
                                return;
                            }
                            if (!AlterConfigOp.OpType.DELETE.equals(opType)) break block9;
                            ConfigAdminManager.validateLoggerNameExists$1(loggerName);
                            string2 = loggerName;
                            string = Log4jController$.MODULE$.ROOT_LOGGER();
                            if (string2 != null) break block10;
                            if (string != null) {
                                return;
                            }
                            break block11;
                        }
                        if (!string2.equals(string)) break block12;
                    }
                    throw new InvalidRequestException(new StringBuilder(52).append("Removing the log level of the ").append(Log4jController$.MODULE$.ROOT_LOGGER()).append(" logger is not allowed").toString());
                }
                return;
            }
            if (AlterConfigOp.OpType.APPEND.equals(opType)) {
                throw new InvalidRequestException(new StringBuilder(43).append(AlterConfigOp.OpType.APPEND).append(" ").append("operation is not allowed for the ").append(ConfigResource.Type.BROKER_LOGGER).append(" resource").toString());
            }
            if (AlterConfigOp.OpType.SUBTRACT.equals(opType)) {
                throw new InvalidRequestException(new StringBuilder(43).append(AlterConfigOp.OpType.SUBTRACT).append(" ").append("operation is not allowed for the ").append(ConfigResource.Type.BROKER_LOGGER).append(" resource").toString());
            }
            throw new InvalidRequestException(new StringBuilder(56).append("Unknown operation type ").append(op.configOperation()).append(" ").append("is not allowed for the ").append(ConfigResource.Type.BROKER_LOGGER).append(" resource").toString());
        });
    }

    public void alterLogLevelConfigs(Collection<IncrementalAlterConfigsRequestData.AlterableConfig> ops) {
        ops.forEach(op -> {
            String loggerName = op.name();
            String logLevel = op.value();
            AlterConfigOp.OpType opType = AlterConfigOp.OpType.forId((byte)op.configOperation());
            if (AlterConfigOp.OpType.SET.equals(opType)) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Updating the log level of ").append(loggerName).append(" to ").append(logLevel).toString());
                Log4jController$.MODULE$.logLevel(loggerName, logLevel);
                return;
            }
            if (AlterConfigOp.OpType.DELETE.equals(opType)) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("Unset the log level of ").append(loggerName).toString());
                Log4jController$.MODULE$.unsetLogLevel(loggerName);
                return;
            }
            throw new IllegalArgumentException(new StringBuilder(31).append("Invalid log4j configOperation: ").append(op.configOperation()).toString());
        });
    }

    public IncrementalAlterConfigsRequestData maybeModifyIncrementalAlterConfigRequest(IncrementalAlterConfigsRequestData request, IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> processed) {
        IncrementalAlterConfigsRequestData copy = new IncrementalAlterConfigsRequestData().setValidateOnly(request.validateOnly()).setSkipMirrorTopicConfigValidation(request.skipMirrorTopicConfigValidation());
        request.resources().forEach(resource -> {
            ConfigResource.Type type = ConfigResource.Type.forId((byte)resource.resourceType());
            if (ConfigResource.Type.CLUSTER_LINK.equals(type)) {
                if (!processed.containsKey(resource)) {
                    try {
                        String string;
                        ArrayList newConfigs = new ArrayList();
                        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().foreach((Function1 & Serializable)cfg -> BoxesRunTime.boxToBoolean((boolean)newConfigs.add(new IncrementalAlterConfigsRequestData.AlterableConfig().setName(cfg.name()).setValue(cfg.value()).setConfigOperation(cfg.configOperation()))));
                        ConfigRepository configRepository = $this.configRepository;
                        if (configRepository instanceof ZkConfigRepository) {
                            string = resource.resourceName();
                        } else if (configRepository instanceof KRaftMetadataCache) {
                            string = this.linkIdAsString$1((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource);
                        } else {
                            this.warn((Function0<String>)(Function0 & Serializable)() -> "Unsupported config repository type.");
                            string = resource.resourceName();
                        }
                        String resourceName = string;
                        copy.resources().mustAdd((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName(resourceName).setResourceType(resource.resourceType()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(newConfigs.iterator())));
                        return;
                    }
                    catch (Throwable ex) {
                        ConfigAdminManager$.MODULE$.log().debug(new StringBuilder(96).append("Encountered an error when processing cluster link resource ").append(resource).append(" in IncrementalAlterConfigs request. ").append(ex.getMessage()).toString());
                        return;
                    }
                }
                return;
            }
            if (!processed.containsKey(resource)) {
                copy.resources().mustAdd((ImplicitLinkedHashCollection.Element)resource.duplicate());
                return;
            }
        });
        return copy;
    }

    public IncrementalAlterConfigsResponseData reassembleIncrementalResponse(IncrementalAlterConfigsRequestData original, IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> preprocessingResponses, IncrementalAlterConfigsResponseData persistentResponses) {
        IncrementalAlterConfigsResponseData response = new IncrementalAlterConfigsResponseData();
        scala.collection.immutable.Map responsesByResource = CollectionConverters$.MODULE$.IteratorHasAsScala(persistentResponses.responses().iterator()).asScala().map((Function1 & Serializable)x0$1 -> {
            ConfigResource.Type type = ConfigResource.Type.forId((byte)x0$1.resourceType());
            ConfigResource.Type type2 = ConfigResource.Type.CLUSTER_LINK;
            if (!(type != null ? !type.equals(type2) : type2 != null)) {
                String string;
                ConfigRepository configRepository = $this.configRepository;
                if (configRepository instanceof ZkConfigRepository) {
                    string = x0$1.resourceName();
                } else if (configRepository instanceof KRaftMetadataCache) {
                    KRaftMetadataCache kRaftMetadataCache = (KRaftMetadataCache)configRepository;
                    String linkId = x0$1.resourceName();
                    try {
                        string = ((ClusterLink)kRaftMetadataCache.currentImage().clusterLinks().linksById().get(Uuid.fromString((String)linkId))).linkName();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new IllegalStateException("Found non Kafka link id in KRaft mode.");
                    }
                } else {
                    throw new IllegalStateException("Unsupported config repository type");
                }
                String resourceName = string;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)resourceName, (Object)BoxesRunTime.boxToByte((byte)x0$1.resourceType()))), (Object)new ApiError(x0$1.errorCode(), x0$1.errorMessage()));
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)x0$1.resourceName(), (Object)BoxesRunTime.boxToByte((byte)x0$1.resourceType()))), (Object)new ApiError(x0$1.errorCode(), x0$1.errorMessage()));
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        original.resources().forEach(r -> {
            ApiError apiError;
            Option option = Option$.MODULE$.apply(preprocessingResponses.get(r));
            if (None$.MODULE$.equals(option)) {
                Option option2 = responsesByResource.get((Object)new Tuple2((Object)r.resourceName(), (Object)BoxesRunTime.boxToByte((byte)r.resourceType())));
                if (None$.MODULE$.equals(option2)) {
                    ConfigAdminManager$.MODULE$.log().error(new StringBuilder(79).append("The controller returned fewer results than we ").append("expected. No response found for ").append(r).append(".").toString());
                    apiError = new ApiError(Errors.UNKNOWN_SERVER_ERROR);
                } else {
                    if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                    apiError = (ApiError)((Some)option2).value();
                }
            } else {
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                apiError = (ApiError)((Some)option).value();
            }
            ApiError err = apiError;
            response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName(r.resourceName()).setResourceType(r.resourceType()).setErrorCode(err.error().code()).setErrorMessage(err.message()));
        });
        return response;
    }

    private static final void validateLoggerNameExists$1(String loggerName) {
        if (!Log4jController$.MODULE$.loggerExists(loggerName)) {
            throw new InvalidConfigurationException(new StringBuilder(23).append("Logger ").append(loggerName).append(" does not exist!").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$maybeModifyIncrementalAlterConfigRequest$2(IncrementalAlterConfigsRequestData.AlterConfigsResource resource$1, ClusterLinkData x$4) {
        String string = x$4.linkName();
        String string2 = resource$1.resourceName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final String linkIdAsString$1(IncrementalAlterConfigsRequestData.AlterConfigsResource resource$1) {
        return ((Uuid)this.clusterLinkManager().listClusterLinks().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManager.$anonfun$maybeModifyIncrementalAlterConfigRequest$2(resource$1, x$4))).map((Function1 & Serializable)x$5 -> x$5.linkId()).getOrElse((Function0 & Serializable)() -> {
            throw new InvalidRequestException(new StringBuilder(37).append("Unable to find cluster link resource ").append(resource$1.resourceName()).toString());
        })).toString();
    }

    public ConfigAdminManager(int nodeId, KafkaConfig conf, ConfigRepository configRepository, ClusterLinkFactory.LinkManager clusterLinkManager) {
        this.nodeId = nodeId;
        this.conf = conf;
        this.configRepository = configRepository;
        this.clusterLinkManager = clusterLinkManager;
        this.logIdent_$eq(new StringBuilder(30).append("[ConfigAdminManager[nodeId=").append(nodeId).append("]: ").toString());
    }
}

