/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.utils.Logging;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple7;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class DiskUsageBasedThrottlingConfig$
implements Logging,
Serializable {
    public static final DiskUsageBasedThrottlingConfig$ MODULE$ = new DiskUsageBasedThrottlingConfig$();
    private static final long MinDiskThresholdBytes = 0x40000000L;
    private static final long MinThroughputBytesPerSec = 16384L;
    private static final long DefaultDiskCheckFrequencyMs = TimeUnit.SECONDS.toMillis(60L);
    private static final double MinFreeDiskRecoveryFactor = 1.0;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public long MinDiskThresholdBytes() {
        return MinDiskThresholdBytes;
    }

    public long MinThroughputBytesPerSec() {
        return MinThroughputBytesPerSec;
    }

    public long DefaultDiskCheckFrequencyMs() {
        return DefaultDiskCheckFrequencyMs;
    }

    public double MinFreeDiskRecoveryFactor() {
        return MinFreeDiskRecoveryFactor;
    }

    public DiskUsageBasedThrottlingConfig apply(long freeDiskThresholdBytes, long throttledProduceThroughput, Seq<String> logDirs, boolean enableDiskBasedThrottling, long diskCheckFrequencyMs, double freeDiskThresholdBytesRecoveryFactor, boolean clusterLinkEnabled) {
        if (logDirs.isEmpty() && this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Empty logDirs received! Disk based throttling won't be activated!");
        }
        return new DiskUsageBasedThrottlingConfig(this.getSanitisedConfig("confluent.backpressure.disk.free.threshold.bytes", freeDiskThresholdBytes, this.MinDiskThresholdBytes()), this.getSanitisedConfig("confluent.backpressure.disk.produce.bytes.per.second", throttledProduceThroughput, this.MinThroughputBytesPerSec()), logDirs, logDirs.nonEmpty() && enableDiskBasedThrottling, diskCheckFrequencyMs, this.getSanitisedConfig("confluent.backpressure.disk.threshold.recovery.factor", freeDiskThresholdBytesRecoveryFactor, this.MinFreeDiskRecoveryFactor()), clusterLinkEnabled);
    }

    public long apply$default$1() {
        return 0x500000000L;
    }

    public long apply$default$2() {
        return 131072L;
    }

    public Seq<String> apply$default$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public boolean apply$default$4() {
        return false;
    }

    public long apply$default$5() {
        return this.DefaultDiskCheckFrequencyMs();
    }

    public double apply$default$6() {
        return 1.5;
    }

    public boolean apply$default$7() {
        return false;
    }

    private long getSanitisedConfig(String configName, long suppliedValue, long minimumValue) {
        if (suppliedValue < minimumValue && this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Illegal value for {}: {}. Will be set to: {}", new Object[]{configName, BoxesRunTime.boxToLong((long)suppliedValue), BoxesRunTime.boxToLong((long)minimumValue)});
        }
        return Math.max(suppliedValue, minimumValue);
    }

    private double getSanitisedConfig(String configName, double suppliedValue, double minimumValue) {
        if (suppliedValue < minimumValue && this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Illegal value for {}: {}. Will be set to: {}", new Object[]{configName, BoxesRunTime.boxToDouble((double)suppliedValue), BoxesRunTime.boxToDouble((double)minimumValue)});
        }
        return Math.max(suppliedValue, minimumValue);
    }

    public Option<Tuple7<Object, Object, Seq<String>, Object, Object, Object, Object>> unapply(DiskUsageBasedThrottlingConfig x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple7((Object)BoxesRunTime.boxToLong((long)x$0.freeDiskThresholdBytes()), (Object)BoxesRunTime.boxToLong((long)x$0.throttledProduceThroughput()), x$0.logDirs(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.enableDiskBasedThrottling()), (Object)BoxesRunTime.boxToLong((long)x$0.diskCheckFrequencyMs()), (Object)BoxesRunTime.boxToDouble((double)x$0.freeDiskThresholdBytesRecoveryFactor()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.clusterLinkEnabled())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DiskUsageBasedThrottlingConfig$.class);
    }

    private DiskUsageBasedThrottlingConfig$() {
    }
}

