/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import kafka.log.MergedLog;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.raft.KRaftSnapshotObject;
import kafka.tier.snapshot.TierTopicSnapshotObject;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;
import kafka.tier.state.SegmentState;
import kafka.tier.store.BucketHealthResult;
import kafka.tier.store.TierObjectAttribute;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.VersionInformation;
import kafka.utils.CoreUtils;
import kafka.utils.Interner;
import kafka.utils.checksum.Algorithm;

public interface TierObjectStore {
    public Backend getBackend();

    public BucketHealthResult checkBucketHealth();

    public Map<String, List<VersionInformation>> listObject(String var1, boolean var2);

    public TierObjectStoreResponse getObject(ObjectStoreMetadata var1, FileType var2, Integer var3, Integer var4, VersionInformation var5) throws IOException;

    default public TierObjectStoreResponse getObject(ObjectStoreMetadata objectMetadata, FileType fileType, Integer byteOffsetStart, Integer byteOffsetEnd) throws IOException {
        return this.getObject(objectMetadata, fileType, byteOffsetStart, byteOffsetEnd, null);
    }

    default public TierObjectStoreResponse getObject(ObjectStoreMetadata objectMetadata, FileType fileType, Integer byteOffsetStart) throws IOException {
        return this.getObject(objectMetadata, fileType, byteOffsetStart, null, null);
    }

    default public TierObjectStoreResponse getObject(ObjectStoreMetadata objectMetadata, FileType fileType) throws IOException {
        return this.getObject(objectMetadata, fileType, null);
    }

    public OpaqueData prepPutSegment() throws TierObjectStoreRetriableException, IOException;

    public void putObject(ObjectStoreMetadata var1, File var2, FileType var3) throws TierObjectStoreRetriableException, IOException;

    public void putBuffer(ObjectStoreMetadata var1, ByteBuffer var2, FileType var3) throws TierObjectStoreRetriableException, IOException;

    public void restoreObjectByCopy(ObjectMetadata var1, String var2, VersionInformation var3);

    public void putSegment(ObjectMetadata var1, File var2, File var3, File var4, Optional<File> var5, Optional<ByteBuffer> var6, Optional<ByteBuffer> var7) throws TierObjectStoreRetriableException, IOException;

    public void putInMemorySegment(ObjectMetadata var1, File var2, File var3, File var4, Optional<ByteBuffer> var5, Optional<ByteBuffer> var6, Optional<ByteBuffer> var7) throws TierObjectStoreRetriableException, IOException;

    public void deleteSegment(ObjectMetadata var1) throws IOException;

    public void deleteVersions(List<KeyAndVersion> var1);

    public TierObjectAttribute objectExists(ObjectMetadata var1, FileType var2) throws IOException;

    public void close();

    public static class KRaftSnapshotMetadata
    implements ObjectStoreMetadata {
        private static final int CURRENT_KEY_PATH_VERSION = 0;
        private final int version = 0;
        private final KRaftSnapshotObject snapshotObject;

        public KRaftSnapshotMetadata(KRaftSnapshotObject snapshotObject) {
            this.snapshotObject = snapshotObject;
        }

        @Override
        public String toPath(String keyPrefix, FileType fileType) {
            return this.snapshotObject.encodePath(keyPrefix, 0);
        }

        public static KRaftSnapshotMetadata fromPath(String keyPrefix, String filePath) {
            return new KRaftSnapshotMetadata(KRaftSnapshotObject.decodePath(keyPrefix, filePath));
        }

        @Override
        public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            clusterIdOpt.ifPresent(clusterId -> metadata.put("cluster_id", (String)clusterId));
            brokerIdOpt.ifPresent(brokerId -> metadata.put("node_id", Integer.toString(brokerId)));
            return metadata;
        }

        @Override
        public OpaqueData opaqueData() {
            return OpaqueData.ZEROED;
        }

        public String toString() {
            return "KRaftSnapshotMetadata(version=0, snapshotObject=" + this.snapshotObject + ')';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KRaftSnapshotMetadata that = (KRaftSnapshotMetadata)o;
            return 0 == that.version && this.snapshotObject.equals(that.snapshotObject);
        }

        public int hashCode() {
            return Objects.hash(0, this.snapshotObject);
        }
    }

    public static class DurabilityAuditsOffsetMapMetadata
    implements ObjectStoreMetadata {
        private final int version = 0;
        private final UUID objectId;
        private final TopicIdPartition topicIdPartition;

        public DurabilityAuditsOffsetMapMetadata(TopicIdPartition topicIdPartition, UUID objectId) {
            this.objectId = objectId;
            this.topicIdPartition = topicIdPartition;
        }

        public String objectIdAsBase64() {
            return CoreUtils.uuidToBase64(this.objectId);
        }

        public TopicIdPartition topicIdPartition() {
            return this.topicIdPartition;
        }

        @Override
        public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("metadata_version", Integer.toString(0));
            clusterIdOpt.ifPresent(clusterId -> metadata.put("cluster_id", (String)clusterId));
            brokerIdOpt.ifPresent(brokerId -> metadata.put("broker_id", Integer.toString(brokerId)));
            return metadata;
        }

        @Override
        public OpaqueData opaqueData() {
            return OpaqueData.ZEROED;
        }

        @Override
        public String toPath(String keyPrefix, FileType fileType) {
            return keyPrefix + DataTypePathPrefix.DA_OFFSET_MAP.prefix + "/" + this.objectIdAsBase64() + "/" + this.topicIdPartition.topicIdAsBase64() + "/" + this.topicIdPartition.partition() + "_v" + 0 + "." + fileType.suffix();
        }

        public String toString() {
            return "DurabilityAuditsOffsetMapMetadata{TopicIdPartition=" + this.topicIdPartition + ", objectId=" + this.objectIdAsBase64() + ", version=" + 0 + '}';
        }
    }

    public static class HealthMetadata
    implements ObjectStoreMetadata {
        private final int version = 0;
        private final Optional<String> clusterIdOpt;
        private final Optional<Integer> brokerIdOpt;

        public HealthMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
            this.clusterIdOpt = clusterIdOpt;
            this.brokerIdOpt = brokerIdOpt;
        }

        @Override
        public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("metadata_version", Integer.toString(0));
            clusterIdOpt.ifPresent(clusterId -> metadata.put("cluster_id", (String)clusterId));
            brokerIdOpt.ifPresent(brokerId -> metadata.put("broker_id", Integer.toString(brokerId)));
            return metadata;
        }

        @Override
        public OpaqueData opaqueData() {
            return OpaqueData.ZEROED;
        }

        @Override
        public String toPath(String keyPrefix, FileType fileType) {
            return String.format("%shealth/%s/health-checker.%s", new Object[]{keyPrefix, this.brokerIdOpt.orElse(-1), fileType});
        }
    }

    public static class TierTopicSnapshotMetadata
    implements ObjectStoreMetadata {
        private static final int CURRENT_KEY_PATH_VERSION = 0;
        private final TierTopicSnapshotObject snapshotObject;
        private final int version = 0;

        public TierTopicSnapshotMetadata(TierTopicSnapshotObject snapshotObject) {
            this.snapshotObject = snapshotObject;
        }

        public TierTopicSnapshotObject snapshotObject() {
            return this.snapshotObject;
        }

        public int version() {
            return 0;
        }

        @Override
        public String toPath(String keyPrefix, FileType fileType) {
            return TierTopicSnapshotMetadata.pathPrefix(keyPrefix) + "/" + this.snapshotObject.encodeSnapshotName() + "_v" + 0 + "." + fileType.suffix();
        }

        public static String pathPrefix(String keyPrefix) {
            return keyPrefix + DataTypePathPrefix.TIER_TOPIC_SNAPSHOT.prefix();
        }

        public static TierTopicSnapshotMetadata fromPath(String fileName) {
            String prefixDelimiter = DataTypePathPrefix.TIER_TOPIC_SNAPSHOT.prefix() + "/";
            String[] prefix = fileName.split(prefixDelimiter, 2);
            String suffixDelimiter = "_v";
            String[] suffix = prefix[1].split(suffixDelimiter);
            TierTopicSnapshotObject snapshotObject = TierTopicSnapshotObject.decodeSnapshotName(suffix[0]);
            return new TierTopicSnapshotMetadata(snapshotObject);
        }

        @Override
        public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("metadata_version", Integer.toString(0));
            metadata.put("epoch", Integer.toString(this.snapshotObject.currentEpochAndSeqNumber().epoch()));
            clusterIdOpt.ifPresent(clusterId -> metadata.put("cluster_id", (String)clusterId));
            brokerIdOpt.ifPresent(brokerId -> metadata.put("broker_id", Integer.toString(brokerId)));
            return metadata;
        }

        @Override
        public OpaqueData opaqueData() {
            return OpaqueData.ZEROED;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TierTopicSnapshotMetadata that = (TierTopicSnapshotMetadata)o;
            return 0 == that.version && Objects.equals(this.snapshotObject, that.snapshotObject);
        }

        public int hashCode() {
            return Objects.hash(this.snapshotObject, 0);
        }

        public String toString() {
            return "TierTopicSnapshotMetadata{snapshotObject=" + this.snapshotObject + ", version=" + 0 + '}';
        }
    }

    public static class TierPartitionStateSnapshotMetadata
    implements ObjectStoreMetadata {
        private static final int CURRENT_KEY_PATH_VERSION = 0;
        private final TopicIdPartition topicIdPartition;
        private final FileTierPartitionStateSnapshotObject snapshotObject;
        private final int version = 0;

        public TierPartitionStateSnapshotMetadata(TopicIdPartition topicIdPartition, FileTierPartitionStateSnapshotObject snapshotObject) {
            this.topicIdPartition = topicIdPartition;
            this.snapshotObject = snapshotObject;
        }

        public TopicIdPartition topicIdPartition() {
            return this.topicIdPartition;
        }

        public FileTierPartitionStateSnapshotObject snapshotObject() {
            return this.snapshotObject;
        }

        public int version() {
            return 0;
        }

        @Override
        public String toPath(String keyPrefix, FileType fileType) {
            return TierPartitionStateSnapshotMetadata.pathPrefix(keyPrefix, this.topicIdPartition) + "/" + this.snapshotObject.encodeSnapshotName() + "_v" + 0 + "." + fileType.suffix();
        }

        public static String pathPrefix(String keyPrefix, TopicIdPartition topicIdPartition) {
            return keyPrefix + DataTypePathPrefix.TIER_PARTITION_STATE_METADATA_SNAPSHOT.prefix() + "/" + topicIdPartition.topicIdAsBase64() + "/" + topicIdPartition.partition();
        }

        public static String extractEncodedName(String snapshotPath) {
            String[] tokens = snapshotPath.split("/");
            String snapshotNameWithSuffix = tokens[tokens.length - 1];
            return snapshotNameWithSuffix.split("_v0")[0];
        }

        @Override
        public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("metadata_version", Integer.toString(0));
            metadata.put("topic", this.topicIdPartition().topic());
            clusterIdOpt.ifPresent(clusterId -> metadata.put("cluster_id", (String)clusterId));
            brokerIdOpt.ifPresent(brokerId -> metadata.put("broker_id", Integer.toString(brokerId)));
            return metadata;
        }

        @Override
        public OpaqueData opaqueData() {
            return OpaqueData.ZEROED;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TierPartitionStateSnapshotMetadata that = (TierPartitionStateSnapshotMetadata)o;
            return Objects.equals(this.topicIdPartition, that.topicIdPartition) && this.snapshotObject.equals(that.snapshotObject) && 0 == that.version;
        }

        public int hashCode() {
            return Objects.hash(this.topicIdPartition, this.snapshotObject, 0);
        }

        public String toString() {
            return "TierPartitionStateSnapshotMetadata{topicIdPartition=" + this.topicIdPartition + ", snapshotObject=" + this.snapshotObject + ", version=" + 0 + '}';
        }
    }

    public static class BackupObjectsListMetadata
    implements ObjectStoreMetadata {
        private final String clusterId;
        private final String date;
        private final String name;

        public BackupObjectsListMetadata(String clusterId, String date, String name) {
            this.clusterId = clusterId;
            this.date = date;
            this.name = name;
        }

        public String generateKeyPrefix(String prefix) {
            return prefix + DataTypePathPrefix.LIFECYCLE_MANAGER_STATE.prefix + "/" + this.clusterId;
        }

        public String getDateFromKey(String key) {
            String prefix = this.generateKeyPrefix("");
            if (key.length() <= prefix.length()) {
                return null;
            }
            String[] tokens = key.substring(prefix.length()).split("/");
            return tokens[1];
        }

        public String getListNameFromKey(String key) {
            String prefix = this.generateKeyPrefix("");
            if (key.length() <= prefix.length()) {
                return null;
            }
            String[] tokens = key.substring(prefix.length()).split("/");
            return tokens[2].split("\\.")[0];
        }

        @Override
        public String toPath(String keyPrefix, FileType fileType) {
            return this.generateKeyPrefix(keyPrefix) + "/" + this.date + "/" + this.name + "." + fileType.suffix();
        }

        @Override
        public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("clusterId", this.clusterId());
            return metadata;
        }

        @Override
        public OpaqueData opaqueData() {
            return OpaqueData.ZEROED;
        }

        public String toString() {
            return "BackupObjectsListMetadata(clusterId=" + this.clusterId + ", date=" + this.date + ", name=" + this.name + ')';
        }

        public String clusterId() {
            return this.clusterId;
        }
    }

    public static class LifecycleManagerStateMetadata
    implements ObjectStoreMetadata {
        private String clusterId;

        public LifecycleManagerStateMetadata(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public String toPath(String keyPrefix, FileType fileType) {
            return keyPrefix + DataTypePathPrefix.LIFECYCLE_MANAGER_STATE.prefix + "/" + this.clusterId + "." + fileType.suffix();
        }

        @Override
        public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("clusterId", this.clusterId());
            return metadata;
        }

        @Override
        public OpaqueData opaqueData() {
            return OpaqueData.ZEROED;
        }

        public String toString() {
            return "LifecycleManagerStateMetadata(clusterId=" + this.clusterId + ')';
        }

        public String clusterId() {
            return this.clusterId;
        }
    }

    public static class TierStateRestoreSnapshotMetadata
    implements ObjectStoreMetadata {
        public static final int VERSION_V0 = 0;
        public static final int VERSION_V1 = 1;
        private static final int CURRENT_KEY_PATH_VERSION = 1;
        private final TopicIdPartition topicIdPartition;
        private final long startOffset;
        private final long endOffset;
        private final String contentHash;
        private final Algorithm checksumAlgorithm;
        private final int version;

        public TierStateRestoreSnapshotMetadata(TopicIdPartition topicIdPartition, long startOffset, long endOffset, String contentHash, Algorithm checksumAlgorithm, int metadataVersion) {
            this.topicIdPartition = topicIdPartition;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.contentHash = contentHash;
            this.checksumAlgorithm = checksumAlgorithm;
            this.version = metadataVersion == 0 ? 0 : 1;
        }

        public TierStateRestoreSnapshotMetadata(TierPartitionForceRestore metadata) {
            this(metadata.topicIdPartition(), metadata.startOffset(), metadata.endOffset(), metadata.contentHash(), metadata.checksumAlgorithm(), metadata.version());
        }

        public TierStateRestoreSnapshotMetadata(TopicIdPartition topicIdPartition, long startOffset, long endOffset, String contentHash, Algorithm checksumAlgorithm) {
            this.topicIdPartition = topicIdPartition;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.contentHash = contentHash;
            this.checksumAlgorithm = checksumAlgorithm;
            this.version = 1;
        }

        public int version() {
            return this.version;
        }

        public TopicIdPartition topicIdPartition() {
            return this.topicIdPartition;
        }

        public Algorithm checksumAlgorithm() {
            return this.checksumAlgorithm;
        }

        @Override
        public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("metadata_version", Integer.toString(this.version));
            metadata.put("topic", this.topicIdPartition().topic());
            clusterIdOpt.ifPresent(clusterId -> metadata.put("cluster_id", (String)clusterId));
            brokerIdOpt.ifPresent(brokerId -> metadata.put("broker_id", Integer.toString(brokerId)));
            return metadata;
        }

        @Override
        public OpaqueData opaqueData() {
            return OpaqueData.ZEROED;
        }

        @Override
        public String toPath(String keyPrefix, FileType fileType) {
            if (this.version == 0) {
                return keyPrefix + DataTypePathPrefix.TIER_STATE_RESTORE_SNAPSHOTS.prefix + "/" + this.topicIdPartition().topicIdAsBase64() + "/" + this.topicIdPartition().partition() + "/" + MergedLog.filenamePrefixFromOffset(this.startOffset) + "-" + MergedLog.filenamePrefixFromOffset(this.endOffset) + "_" + this.contentHash + "_v" + this.version + "." + fileType.suffix();
            }
            return keyPrefix + DataTypePathPrefix.TIER_STATE_RESTORE_SNAPSHOTS.prefix + "/" + this.topicIdPartition().topicIdAsBase64() + "/" + this.topicIdPartition().partition() + "/" + MergedLog.filenamePrefixFromOffset(this.startOffset) + "-" + MergedLog.filenamePrefixFromOffset(this.endOffset) + "-" + FileTierPartitionState.recoverPath(MergedLog.tierStateFileName(0L, ""), this.checksumAlgorithm) + "_" + this.contentHash + "_v" + this.version + "." + fileType.suffix();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TierStateRestoreSnapshotMetadata that = (TierStateRestoreSnapshotMetadata)o;
            return this.topicIdPartition.equals(that.topicIdPartition) && this.startOffset == that.startOffset && this.endOffset == that.endOffset && this.contentHash.equals(that.contentHash) && this.version == that.version && this.checksumAlgorithm == that.checksumAlgorithm;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.topicIdPartition, this.startOffset, this.endOffset, this.contentHash, this.version, this.checksumAlgorithm});
        }

        public String toString() {
            return "TierStateRestoreSnapshotMetadata(version=" + this.version + ", topic=" + this.topicIdPartition + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", contentHash=" + this.contentHash + ", checksumAlgorithm=" + (Object)((Object)this.checksumAlgorithm) + ')';
        }
    }

    public static class ObjectMetadata
    implements ObjectStoreMetadata {
        private static final int CURRENT_KEY_PATH_VERSION = 0;
        private final TopicIdPartition topicIdPartition;
        private final UUID objectId;
        private final int tierEpoch;
        private final long baseOffset;
        private final boolean hasAbortedTxns;
        private final boolean hasProducerState;
        private final boolean hasEpochState;
        private final int version = 0;
        private final OpaqueData opaqueData;

        public ObjectMetadata(TopicIdPartition topicIdPartition, UUID objectId, int tierEpoch, long baseOffset, boolean hasAbortedTxns, boolean hasProducerState, boolean hasEpochState, OpaqueData opaqueData) {
            this.topicIdPartition = topicIdPartition;
            this.objectId = objectId;
            this.tierEpoch = tierEpoch;
            this.baseOffset = baseOffset;
            this.hasAbortedTxns = hasAbortedTxns;
            this.hasProducerState = hasProducerState;
            this.hasEpochState = hasEpochState;
            this.opaqueData = opaqueData;
        }

        public ObjectMetadata(TopicIdPartition topicIdPartition, SegmentState metadata) {
            this(topicIdPartition, metadata.objectId(), metadata.tierEpoch(), metadata.keyBaseOffset(), metadata.hasAbortedTxns(), metadata.hasProducerState(), metadata.hasEpochState(), metadata.opaqueData());
        }

        public TopicIdPartition topicIdPartition() {
            return this.topicIdPartition;
        }

        public UUID objectId() {
            return this.objectId;
        }

        public String objectIdAsBase64() {
            return CoreUtils.uuidToBase64(this.objectId());
        }

        public int tierEpoch() {
            return this.tierEpoch;
        }

        public long baseOffset() {
            return this.baseOffset;
        }

        public boolean hasAbortedTxns() {
            return this.hasAbortedTxns;
        }

        public boolean hasProducerState() {
            return this.hasProducerState;
        }

        public boolean hasEpochState() {
            return this.hasEpochState;
        }

        @Override
        public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("metadata_version", Integer.toString(0));
            metadata.put("topic", this.topicIdPartition().topic());
            clusterIdOpt.ifPresent(clusterId -> metadata.put("cluster_id", (String)clusterId));
            brokerIdOpt.ifPresent(brokerId -> metadata.put("broker_id", Integer.toString(brokerId)));
            return metadata;
        }

        @Override
        public OpaqueData opaqueData() {
            return this.opaqueData;
        }

        @Override
        public String toPath(String keyPrefix, FileType fileType) {
            return keyPrefix + DataTypePathPrefix.TOPIC.prefix + "/" + this.objectIdAsBase64() + "/" + this.topicIdPartition().topicIdAsBase64() + "/" + this.topicIdPartition().partition() + "/" + MergedLog.filenamePrefixFromOffset(this.baseOffset()) + "_" + this.tierEpoch() + "_v" + 0 + "." + fileType.suffix();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectMetadata that = (ObjectMetadata)o;
            return this.tierEpoch == that.tierEpoch && this.baseOffset == that.baseOffset && Objects.equals(this.topicIdPartition, that.topicIdPartition) && Objects.equals(this.objectId, that.objectId) && this.hasAbortedTxns == that.hasAbortedTxns && this.hasProducerState == that.hasProducerState && this.hasEpochState == that.hasEpochState && 0 == that.version;
        }

        public int hashCode() {
            return Objects.hash(this.topicIdPartition, this.objectId, this.tierEpoch, this.baseOffset, this.hasAbortedTxns, this.hasProducerState, this.hasEpochState);
        }

        public String toString() {
            return "ObjectMetadata(topic=" + this.topicIdPartition + ", objectIdAsBase64=" + this.objectIdAsBase64() + ", tierEpoch=" + this.tierEpoch + ", baseOffset=" + this.baseOffset + ", hasAbortedTxns=" + this.hasAbortedTxns + ", hasProducerState=" + this.hasProducerState + ", hasEpochState=" + this.hasEpochState + ')';
        }
    }

    public static interface ObjectStoreMetadata {
        public String toPath(String var1, FileType var2);

        public Map<String, String> objectMetadata(Optional<String> var1, Optional<Integer> var2);

        public OpaqueData opaqueData();
    }

    public static class KeyAndVersion {
        private String key;
        private String versionId;

        public KeyAndVersion(String key) {
            this.key = key;
            this.versionId = null;
        }

        public KeyAndVersion(String key, String versionId) {
            this.key = key;
            this.versionId = versionId;
        }

        public String key() {
            return this.key;
        }

        public String versionId() {
            return this.versionId;
        }

        public String toString() {
            String m = "Key: " + this.key();
            if (this.versionId() != null) {
                m = m + " VersionId: " + this.versionId();
            }
            return m;
        }
    }

    public static enum Backend {
        AzureBlockBlob("AzureBlockBlob"),
        GCS("GCS"),
        Mock("Mock"),
        S3("S3"),
        Test("Test");

        private final String name;

        public String getName() {
            return this.name;
        }

        private Backend(String name) {
            this.name = name;
        }
    }

    public static enum DataTypePathPrefix {
        TOPIC("0"),
        TIER_STATE_RESTORE_SNAPSHOTS("1"),
        LAST_ACTIVE_ENCRYPTION_KEY("2"),
        LIFECYCLE_MANAGER_STATE("3"),
        TIER_PARTITION_STATE_METADATA_SNAPSHOT("4"),
        TIER_TOPIC_SNAPSHOT("5"),
        DA_OFFSET_MAP("6"),
        KRAFT_SNAPSHOT("7");

        public final String prefix;

        private DataTypePathPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String prefix() {
            return this.prefix;
        }
    }

    public static final class OpaqueData {
        public static final OpaqueData ZEROED = new OpaqueData(new byte[32]);
        private static final Interner<OpaqueData> INTERNER = new Interner();
        private final byte[] buffer = new byte[32];

        private OpaqueData(byte[] bytes) {
            if (bytes.length > 32) {
                throw new IllegalArgumentException("OpaqueData limited to 32 bytes in length");
            }
            System.arraycopy(bytes, 0, this.buffer, 0, Math.min(this.buffer.length, bytes.length));
        }

        public boolean isEmpty() {
            return this.equals(ZEROED);
        }

        public static OpaqueData fromLongArray(long[] arr) {
            if (arr.length > 4) {
                throw new IllegalArgumentException("Input array must be fit in 32 bytes of space");
            }
            byte[] bytes = new byte[32];
            ByteBuffer bb = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
            int pos = 0;
            for (long elem : arr) {
                bb.putLong(pos, elem);
                pos += 8;
            }
            return INTERNER.intern(new OpaqueData(bytes));
        }

        public static OpaqueData fromByteArray(byte[] arr) {
            if (arr.length > 32) {
                throw new IllegalArgumentException("Input array must be <= 32 bytes");
            }
            byte[] bytes = new byte[32];
            ByteBuffer bb = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
            bb.put(arr);
            return INTERNER.intern(new OpaqueData(bytes));
        }

        public long[] intoLongArray() {
            ByteBuffer bb = ByteBuffer.wrap(this.buffer).order(ByteOrder.LITTLE_ENDIAN);
            long[] ret = new long[]{bb.getLong(0), bb.getLong(8), bb.getLong(16), bb.getLong(24)};
            return ret;
        }

        public byte[] intoByteArray() {
            return (byte[])this.buffer.clone();
        }

        public String toString() {
            return "OpaqueData{len=" + this.buffer.length + ", zeroed=" + this.equals(ZEROED) + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OpaqueData that = (OpaqueData)o;
            return Arrays.equals(this.buffer, that.buffer);
        }

        public int hashCode() {
            return Arrays.hashCode(this.buffer);
        }
    }

    public static enum FileType {
        SEGMENT("segment"),
        OFFSET_INDEX("offset-index"),
        TIMESTAMP_INDEX("timestamp-index"),
        TRANSACTION_INDEX("transaction-index"),
        PRODUCER_STATE("producer-state"),
        EPOCH_STATE("epoch-state"),
        TIER_STATE_SNAPSHOT("tier-state-snapshot"),
        LIFECYCLE_MANAGER_STATE("lifecycle-manager-state"),
        BACKUP_OBJECTS_LIST("bkp-list"),
        HEALTH_CHECK("health"),
        TIER_PARTITION_STATE_METADATA_SNAPSHOT("tier-partition-state-metadata-snapshot"),
        TIER_TOPIC_SNAPSHOT("tier-topic-snapshot"),
        DA_OFFSET_MAP("da-offset-map"),
        KRAFT_SNAPSHOT("kraft-checkpoint");

        private final String suffix;

        public String suffix() {
            return this.suffix;
        }

        private FileType(String suffix) {
            this.suffix = suffix;
        }
    }
}

