/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.authenticators;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.kubernetes.client.util.KubeConfig;
import io.kubernetes.client.util.authenticators.Authenticator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCPAuthenticator
implements Authenticator {
    static final String ACCESS_TOKEN = "access-token";
    static final String EXPIRY = "expiry";
    static final String CMD_ARGS = "cmd-args";
    static final String CMD_PATH = "cmd-path";
    private static final Logger log;
    private final ProcessBuilder pb;

    public GCPAuthenticator() {
        this(new ProcessBuilder(new String[0]));
    }

    public GCPAuthenticator(ProcessBuilder pb) {
        this.pb = pb;
    }

    @Override
    public String getName() {
        return "gcp";
    }

    @Override
    public String getToken(Map<String, Object> config) {
        return (String)config.get(ACCESS_TOKEN);
    }

    @Override
    public boolean isExpired(Map<String, Object> config) {
        Object expiryObj = config.get(EXPIRY);
        Instant expiry = null;
        if (expiryObj instanceof Date) {
            expiry = ((Date)expiryObj).toInstant();
        } else if (expiryObj instanceof Instant) {
            expiry = (Instant)expiryObj;
        } else if (expiryObj instanceof String) {
            expiry = Instant.parse((String)expiryObj);
        } else {
            throw new RuntimeException("Unexpected object type: " + expiryObj.getClass());
        }
        return expiry != null && expiry.compareTo(Instant.now()) <= 0;
    }

    @Override
    public Map<String, Object> refresh(Map<String, Object> config) {
        if (!config.containsKey(CMD_ARGS) || !config.containsKey(CMD_PATH)) {
            throw new RuntimeException("Could not refresh token");
        }
        String cmdPath = (String)config.get(CMD_PATH);
        String cmdArgs = (String)config.get(CMD_ARGS);
        List<String> fullCmd = Arrays.asList(String.join((CharSequence)" ", cmdPath.trim(), cmdArgs.trim()).split(" "));
        try {
            JsonObject credJson;
            Process process = this.pb.command(fullCmd).start();
            process.waitFor(10L, TimeUnit.SECONDS);
            if (process.exitValue() != 0) {
                String stdErr = IOUtils.toString((InputStream)process.getErrorStream(), (Charset)StandardCharsets.UTF_8);
                throw new IllegalStateException("Failed to executing access token command " + fullCmd + ": exitValue: " + process.exitValue() + ", stdErr: " + stdErr);
            }
            String output = IOUtils.toString((InputStream)process.getInputStream(), (Charset)StandardCharsets.UTF_8);
            String credentialJson = output.substring(output.indexOf("{"), output.lastIndexOf("}") + 1);
            JsonObject root = JsonParser.parseString((String)credentialJson).getAsJsonObject();
            if (root.has("credential") && (credJson = root.getAsJsonObject("credential")).has("access_token") && credJson.has("token_expiry")) {
                config.put(ACCESS_TOKEN, credJson.get("access_token").getAsString());
                config.put(EXPIRY, credJson.get("token_expiry").getAsString());
                return config;
            }
            throw new IllegalStateException("Failed to parsing access token output: " + output);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Could not refresh token", e);
        }
    }

    static {
        KubeConfig.registerAuthenticator(new GCPAuthenticator());
        log = LoggerFactory.getLogger(GCPAuthenticator.class);
    }
}

